/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug;

import com.sap.ide.eclipse.rdebug.CSSJcoManager;
import com.sap.ide.eclipse.rdebug.CustomerConnectionEntry;
import com.sap.ide.eclipse.rdebug.ICustomerConnectionManager;
import com.sap.ide.eclipse.rdebug.JrdebugecPlugin;
import com.sap.ide.eclipse.rdebug.RemoteDebugMessages;
import com.sap.ide.eclipse.rdebug.trace.Tracer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

class CustomerConnectionManager
implements ICustomerConnectionManager {
    private static final String FILENAME_1 = System.getProperty("java.io.tmpdir") + "sapdebugdata.txt";
    private static final String FILENAME_2 = System.getProperty("java.io.tmpdir") + "sapdebugdata_v2.txt";
    private static final String CUSNAME_ENTRY = "%_CUSNAME%";
    private static final String DELIMITER = "%_";
    private static final int EXPECTED_CUSTNAME_POSITION = 18;
    private static final String CONNECTIONMANAGER_SETTINGS = "customerConnectionManager";
    private static final String FILE_TIME_STAMP = "fileTimeStamp";
    private static final String ERROR_TITLE = RemoteDebugMessages.THIS.getString("Common.CSS_Remote_Debug_Error_Title");
    private static CustomerConnectionManager instance = null;
    private HashMap connEntries = null;
    private IDialogSettings connectionSettings = null;
    private boolean cssCallbackPerformed = false;
    private long debugDataFileLastModified = 0L;
    static /* synthetic */ Class class$com$sap$ide$eclipse$rdebug$CustomerConnectionManager;

    public static CustomerConnectionManager getInstance() {
        Class clazz = class$com$sap$ide$eclipse$rdebug$CustomerConnectionManager == null ? (class$com$sap$ide$eclipse$rdebug$CustomerConnectionManager = CustomerConnectionManager.class$("com.sap.ide.eclipse.rdebug.CustomerConnectionManager")) : class$com$sap$ide$eclipse$rdebug$CustomerConnectionManager;
        synchronized (clazz) {
            if (instance == null) {
                instance = new CustomerConnectionManager();
            }
            CustomerConnectionManager customerConnectionManager = instance;
            return customerConnectionManager;
        }
    }

    private CustomerConnectionManager() {
        CustomerConnectionManager customerConnectionManager = this;
        synchronized (customerConnectionManager) {
            JrdebugecPlugin plugin = JrdebugecPlugin.getDefault();
            this.connectionSettings = plugin.getDialogSettings().getSection(CONNECTIONMANAGER_SETTINGS);
            if (this.connectionSettings == null) {
                this.connectionSettings = plugin.getDialogSettings().addNewSection(CONNECTIONMANAGER_SETTINGS);
            } else {
                String lastModified = this.connectionSettings.get(FILE_TIME_STAMP);
                if (lastModified != null) {
                    try {
                        this.debugDataFileLastModified = Long.parseLong(lastModified);
                    }
                    catch (NumberFormatException nEx) {
                        this.debugDataFileLastModified = 0L;
                    }
                }
            }
            this.load();
        }
    }

    private CustomerConnectionManager(long timeStamp, IDialogSettings dialogSettings) {
        this.debugDataFileLastModified = timeStamp;
        this.connectionSettings = dialogSettings;
    }

    public void load() {
        if (this.connEntries == null || !this.isInSyncWithFile()) {
            this.connEntries = this.loadtoMap();
            this.cssCallbackPerformed = false;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap loadtoMap() {
        lEntries = null;
        debugDataFile = new File(CustomerConnectionManager.FILENAME_2);
        debugDataFileVersion = 0;
        if (!debugDataFile.exists()) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 4, "File sapdebugdata_v2.txt does not exist in local temp directory");
            debugDataFile = new File(CustomerConnectionManager.FILENAME_1);
            debugDataFileVersion = 1;
        } else {
            debugDataFileVersion = 2;
        }
        if (!debugDataFile.exists()) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 4, "File sapdebugdata.txt does not exist in local temp directory");
            return null;
        }
        try {
            debugDataInputStream = new FileInputStream(debugDataFile);
        }
        catch (FileNotFoundException ex) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
            Tracer.dtTracer.log(2, "JavaRemoteDebug", "JavaRemoteDebug", "Problems with " + debugDataFile.getName(), (Throwable)ex);
            return null;
        }
        this.debugDataFileLastModified = debugDataFile.lastModified();
        this.connectionSettings.put("fileTimeStamp", this.debugDataFileLastModified);
        debugDataReader = new BufferedReader(new InputStreamReader(debugDataInputStream));
        lEntries = new HashMap<String, CustomerConnectionEntry>();
        line = null;
        try {
            while ((line = debugDataReader.readLine()) != null) {
                if (debugDataFileVersion == 1) {
                    cusNameIndex = line.indexOf("%_CUSNAME%");
                    if (cusNameIndex > 0) {
                        this.addCustomerName(line, lEntries);
                        continue;
                    }
                    if (line.trim().equals("")) continue;
                    newCustomerConnection = CustomerConnectionEntry.getEntryFromV1Line(line);
                    lEntries.put(newCustomerConnection.getIdentifier().getIdString(), newCustomerConnection);
                    continue;
                }
                if (debugDataFileVersion != 2 || line.trim().equals("")) continue;
                try {
                    newCustomerConnection = CustomerConnectionEntry.getEntryFromV2Line(line);
                    lEntries.put(newCustomerConnection.getIdentifier().getIdString(), newCustomerConnection);
                }
                catch (Exception ex) {
                    Tracer.dtTracer.userOut(2, "Problems with sapdebugdata_v2.txt: " + ex.getMessage());
                    Tracer.dtTracer.log(2, "Problems with " + debugDataFile.getName(), (Throwable)ex);
                }
            }
        }
        catch (IOException iOE) {
            lEntries = null;
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, iOE.getMessage());
            Tracer.dtTracer.log(2, "Reading problems with sapdebugdata.txt", (Throwable)iOE);
            var8_13 = null;
            var10_15 = null;
            if (debugDataInputStream == null) return var8_13;
            try {
                debugDataInputStream.close();
                return var8_13;
            }
            catch (IOException ex) {
                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
                Tracer.dtTracer.log(2, "Problems with closing sapdebugdata.txt", (Throwable)ex);
            }
            return var8_13;
        }
        var10_14 = null;
        if (debugDataInputStream == null) return lEntries;
        ** GOTO lbl-1000
        {
            catch (Throwable var9_20) {
                var10_16 = null;
                if (debugDataInputStream == null) throw var9_20;
                ** try [egrp 4[TRYBLOCK] [4 : 451->459)] { 
lbl72:
                // 1 sources

                debugDataInputStream.close();
                throw var9_20;
lbl74:
                // 1 sources

                catch (IOException ex) {
                    Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
                    Tracer.dtTracer.log(2, "Problems with closing sapdebugdata.txt", (Throwable)ex);
                }
                throw var9_20;
            }
lbl-1000:
            // 1 sources

            try {}
            catch (IOException ex) {}
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
            Tracer.dtTracer.log(2, "Problems with closing sapdebugdata.txt", (Throwable)ex);
            return lEntries;
            debugDataInputStream.close();
            return lEntries;
        }
    }

    private void addCustomerName(String line, HashMap pEntries) {
        StringTokenizer lineEntries = new StringTokenizer(line, DELIMITER);
        String lineNumber = lineEntries.nextToken();
        String custName = line.substring(18);
        Collection connectionColl = pEntries.values();
        Iterator iter = connectionColl.iterator();
        while (iter.hasNext()) {
            CustomerConnectionEntry custConn = (CustomerConnectionEntry)iter.next();
            if (!custConn.getNumberInFile().equals(lineNumber)) continue;
            custConn.setCustName(custName);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void deleteEntry(Shell parentShell, String connectionIdentifier) {
        block40: {
            block38: {
                if (!this.isPresent(connectionIdentifier)) {
                    MessageDialog.openError((Shell)parentShell, (String)CustomerConnectionManager.ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CustomerConnectionManager.Identifier_not_present", new Object[]{connectionIdentifier}));
                    return;
                }
                if (!this.isInSyncWithFile()) {
                    MessageDialog.openError((Shell)parentShell, (String)CustomerConnectionManager.ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CustomerConnectionManager.sapdebugdata.txt_file_out_of_sync"));
                    return;
                }
                deleteEntry = (CustomerConnectionEntry)this.connEntries.get(connectionIdentifier);
                linenumber = deleteEntry.getNumberInFile();
                debugDataFile = new File(CustomerConnectionManager.FILENAME_2);
                if (!debugDataFile.exists()) {
                    debugDataFile = new File(CustomerConnectionManager.FILENAME_1);
                    Tracer.dtTracer.userOut("JavaRemoteDebug", 4, "File sapdebugdata_v2.txt does not exist in local temp directory");
                }
                if (!debugDataFile.exists()) {
                    MessageDialog.openError((Shell)parentShell, (String)CustomerConnectionManager.ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CustomerConnectionManager.sapdebugdata.txt_file_does_not_exist"));
                    return;
                }
                try {
                    debugDataInputStream = new FileInputStream(debugDataFile);
                }
                catch (FileNotFoundException ex) {
                    MessageDialog.openError((Shell)parentShell, (String)CustomerConnectionManager.ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CustomerConnectionManager.sapdebugdata.txt_file_cannot_be_opened"));
                    return;
                }
                debugDataReader = new BufferedReader(new InputStreamReader(debugDataInputStream));
                lines = new ArrayList<String>();
                try {
                    line = null;
                    while ((line = debugDataReader.readLine()) != null) {
                        if (line.startsWith(linenumber)) continue;
                        lines.add(line);
                    }
                    var12_12 = null;
                    ** if (debugDataInputStream == null) goto lbl-1000
                }
                catch (Throwable var11_22) {
                    var12_14 = null;
                    if (debugDataInputStream != null) {
                        try {
                            debugDataInputStream.close();
                        }
                        catch (IOException ex) {
                            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
                            Tracer.dtTracer.log(2, ex.getMessage(), (Throwable)ex);
                        }
                    }
                    throw var11_22;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        debugDataInputStream.close();
                    }
                    catch (IOException ex) {
                        Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
                        Tracer.dtTracer.log(2, ex.getMessage(), (Throwable)ex);
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block38;
                    catch (IOException iOE) {
                        message = RemoteDebugMessages.THIS.getString("CustomerConnectionManager.sapdebugdata.txt_file_cannot_be_read");
                        MessageDialog.openError((Shell)parentShell, (String)CustomerConnectionManager.ERROR_TITLE, (String)message);
                        Tracer.dtTracer.log(2, message, (Throwable)iOE);
                        var12_13 = null;
                        if (debugDataInputStream != null) {
                            try {
                                debugDataInputStream.close();
                            }
                            catch (IOException ex) {
                                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
                                Tracer.dtTracer.log(2, ex.getMessage(), (Throwable)ex);
                            }
                        }
                        return;
                    }
                }
            }
            try {
                debugDataOutputStream = new FileOutputStream(debugDataFile);
            }
            catch (FileNotFoundException ex) {
                MessageDialog.openError((Shell)parentShell, (String)CustomerConnectionManager.ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CustomerConnectionManager.sapdebugdata.txt_file_cannot_be_opened_for_writing"));
                return;
            }
            debugStreamWriter = new OutputStreamWriter(debugDataOutputStream);
            debugDataWriter = new BufferedWriter(debugStreamWriter);
            i = lines.iterator();
            while (i.hasNext()) {
                line = (String)i.next();
                debugDataWriter.write(line);
                debugDataWriter.newLine();
            }
            var15_24 = null;
            try {
                if (debugDataWriter != null) {
                    debugDataWriter.flush();
                }
                if (debugStreamWriter != null) {
                    debugStreamWriter.flush();
                }
                if (debugDataOutputStream != null) {
                    debugDataOutputStream.flush();
                    debugDataOutputStream.close();
                }
                break block40;
            }
            catch (IOException ex) {
                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
            }
            break block40;
            {
                catch (IOException e) {
                    MessageDialog.openError((Shell)parentShell, (String)CustomerConnectionManager.ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CustomerConnectionManager.sapdebugdata.txt_file_cannot_be_written"));
                    var15_25 = null;
                    try {
                        if (debugDataWriter != null) {
                            debugDataWriter.flush();
                        }
                        if (debugStreamWriter != null) {
                            debugStreamWriter.flush();
                        }
                        if (debugDataOutputStream != null) {
                            debugDataOutputStream.flush();
                            debugDataOutputStream.close();
                        }
                    }
                    catch (IOException ex) {
                        Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
                    }
                    return;
                }
            }
            catch (Throwable var14_30) {
                var15_26 = null;
                try {
                    if (debugDataWriter != null) {
                        debugDataWriter.flush();
                    }
                    if (debugStreamWriter != null) {
                        debugStreamWriter.flush();
                    }
                    if (debugDataOutputStream != null) {
                        debugDataOutputStream.flush();
                        debugDataOutputStream.close();
                    }
                }
                catch (IOException ex) {
                    Tracer.dtTracer.userOut("JavaRemoteDebug", 2, ex.getMessage());
                }
                throw var14_30;
            }
        }
        this.connEntries.remove(connectionIdentifier);
        this.debugDataFileLastModified = debugDataFile.lastModified();
        this.connectionSettings.put("fileTimeStamp", this.debugDataFileLastModified);
    }

    private boolean isInSyncWithFile() {
        File debugDataFile = new File(FILENAME_2);
        if (debugDataFile.exists()) {
            return debugDataFile.lastModified() == this.debugDataFileLastModified;
        }
        debugDataFile = new File(FILENAME_1);
        return debugDataFile.exists() && debugDataFile.lastModified() == this.debugDataFileLastModified;
    }

    private boolean isPresent(String connectionIdentifier) {
        if (this.connEntries == null) {
            return false;
        }
        return this.connEntries.containsKey(connectionIdentifier);
    }

    public CustomerConnectionEntry.CustomerConnectionIdentifier getIdentifier(String connectionIdentifier) {
        if (this.connEntries == null) {
            return null;
        }
        if (this.isPresent(connectionIdentifier)) {
            CustomerConnectionEntry custConn = (CustomerConnectionEntry)this.connEntries.get(connectionIdentifier);
            return custConn.getIdentifier();
        }
        return null;
    }

    public List getConnectionList() {
        ArrayList connsAsList = new ArrayList();
        if (this.connEntries != null) {
            Enumeration connsAsEnum = Collections.enumeration(this.connEntries.values());
            while (connsAsEnum.hasMoreElements()) {
                connsAsList.add(connsAsEnum.nextElement());
            }
            Collections.sort(connsAsList);
        }
        return Collections.unmodifiableList(connsAsList);
    }

    public void checkConnections(Shell parentShell) {
        try {
            CSSJcoManager.getInstance().checkConnections(parentShell, this.getConnectionList());
            this.cssCallbackPerformed = true;
        }
        catch (Throwable t) {
            MessageDialog.openError((Shell)parentShell, (String)ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CustomerConnectionManager.Callback_to_CSS_could_not_be_performed"));
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, t.getMessage());
        }
    }

    public String getRouteString(Shell parentShell, String connectionIdentifier) {
        CustomerConnectionEntry custConnection = (CustomerConnectionEntry)this.connEntries.get(connectionIdentifier);
        if (custConnection == null) {
            MessageDialog.openError((Shell)parentShell, (String)ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CustomerConnectionManager.Invalid_entry"));
            return null;
        }
        try {
            return CSSJcoManager.getInstance().getRouteString(parentShell, custConnection);
        }
        catch (Throwable t) {
            MessageDialog.openError((Shell)parentShell, (String)ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CustomerConnectionManager.Callback_to_CSS_could_not_be_performed"));
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, t.getMessage());
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

