/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug;

import com.sap.ide.eclipse.rdebug.AbstractEnum;
import com.sap.ide.eclipse.rdebug.RemoteDebugMessages;
import com.sap.ide.eclipse.rdebug.trace.Tracer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class CustomerConnectionEntry
implements Comparable {
    private static final String DELIMITER = "%_";
    private static final String ID_OPEN = RemoteDebugMessages.THIS.getString("CustomerConnectionEntry.open");
    private static final String ID_CLOSED = RemoteDebugMessages.THIS.getString("CustomerConnectionEntry.closed");
    private static final String ID_TO_BE_DETERMINED = RemoteDebugMessages.THIS.getString("CustomerConnectionEntry.unknown");
    private String connectionState = null;
    private String numberInFile = null;
    private Property custInfoNo = new Property(Key.access$300(), false);
    private Property custName = new Property(Key.access$500(), true, RemoteDebugMessages.THIS.getString("CustomerConnectionEntry.N/A"));
    private Property custNo = new Property(Key.access$700(), false);
    private Property dataBaseId = new Property(Key.access$800(), false);
    private Property hostName = new Property(Key.access$900(), false);
    private Property sysNo = new Property(Key.access$1000(), false);
    private CustomerConnectionIdentifier identifier = null;
    static /* synthetic */ Class class$com$sap$ide$eclipse$rdebug$CustomerConnectionEntry;
    static /* synthetic */ Class class$com$sap$ide$eclipse$rdebug$CustomerConnectionEntry$Property;

    static CustomerConnectionEntry getEntryFromV1Line(String fileLine) {
        CustomerConnectionEntry newEntry = new CustomerConnectionEntry();
        String[] entries = CustomerConnectionEntry.split(fileLine, DELIMITER, 14);
        newEntry.numberInFile = entries[0];
        newEntry.dataBaseId.value = entries[1];
        newEntry.hostName.value = entries[2];
        newEntry.custInfoNo.value = entries[4];
        newEntry.custNo.value = entries[5];
        newEntry.sysNo.value = entries[7];
        newEntry.init();
        return newEntry;
    }

    static CustomerConnectionEntry getEntryFromV2Line(String fileLine) throws Exception {
        CustomerConnectionEntry newEntry = new CustomerConnectionEntry();
        String[] entries = CustomerConnectionEntry.split(fileLine, DELIMITER, -1);
        if (entries.length < 2) {
            throw new Exception("The line does not contain enough delimiters: %_ : line: " + fileLine);
        }
        newEntry.numberInFile = entries[0];
        try {
            Integer.parseInt(newEntry.numberInFile.trim());
        }
        catch (NumberFormatException nEx) {
            throw new Exception("Line does not start with a number, line: " + fileLine);
        }
        HashMap<String, Property> properties = new HashMap<String, Property>();
        Field[] fields = (class$com$sap$ide$eclipse$rdebug$CustomerConnectionEntry == null ? (class$com$sap$ide$eclipse$rdebug$CustomerConnectionEntry = CustomerConnectionEntry.class$("com.sap.ide.eclipse.rdebug.CustomerConnectionEntry")) : class$com$sap$ide$eclipse$rdebug$CustomerConnectionEntry).getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getType() == (class$com$sap$ide$eclipse$rdebug$CustomerConnectionEntry$Property == null ? CustomerConnectionEntry.class$("com.sap.ide.eclipse.rdebug.CustomerConnectionEntry$Property") : class$com$sap$ide$eclipse$rdebug$CustomerConnectionEntry$Property)) {
                Property field = (Property)fields[i].get(newEntry);
                properties.put(field.key.getName(), field);
            }
            ++i;
        }
        int i2 = 1;
        while (i2 < entries.length) {
            int eqPos = entries[i2].indexOf(61);
            if (eqPos < 1) {
                throw new Exception("An entry in the line did not contain = at a valid place, line: " + fileLine);
            }
            String key = entries[i2].substring(0, eqPos);
            String value = entries[i2].substring(eqPos + 1);
            Property prop = (Property)properties.get(key);
            if (prop == null) {
                Tracer.dtTracer.userOut(3, "sapdebugdata_v2.txt contains unknown key: " + key + " in line: " + fileLine);
            } else {
                prop.value = value;
            }
            ++i2;
        }
        newEntry.init();
        Iterator i3 = properties.values().iterator();
        while (i3.hasNext()) {
            Property prop = (Property)i3.next();
            if (prop.isOptional || prop.value != null) continue;
            throw new Exception("The obligatory property: " + prop.key + " is not contained in one line of sapdebugdata_v2.txt, line: " + fileLine);
        }
        return newEntry;
    }

    private static String[] split(String content, String delimiter, int times) {
        String splitString = content;
        ArrayList<String> result = null;
        result = times > -1 ? new ArrayList(times) : new ArrayList<String>();
        int lastDelimiterPos = 0;
        int i = 0;
        while (i < times || times < 0) {
            int nextDelimiterPos = splitString.indexOf(delimiter, lastDelimiterPos);
            if (nextDelimiterPos < 0) {
                result.add(splitString.substring(lastDelimiterPos, splitString.length() - 1));
                break;
            }
            String token = splitString.substring(lastDelimiterPos, nextDelimiterPos);
            lastDelimiterPos = nextDelimiterPos + delimiter.length();
            result.add(token);
            if (lastDelimiterPos > splitString.length() - 1) break;
            ++i;
        }
        if (times > -1) {
            return result.toArray(new String[times]);
        }
        return result.toArray(new String[result.size()]);
    }

    private CustomerConnectionEntry() {
    }

    private void init() {
        this.connectionState = ID_TO_BE_DETERMINED;
        this.identifier = new CustomerConnectionIdentifier();
    }

    public String getConnectionState() {
        return this.connectionState;
    }

    public String getCustInfoNo() {
        return this.custInfoNo.value;
    }

    public String getCustName() {
        return this.custName.value;
    }

    public String getCustNo() {
        return this.custNo.value;
    }

    public String getDataBaseId() {
        return this.dataBaseId.value;
    }

    public String getHostName() {
        return this.hostName.value;
    }

    public String getNumberInFile() {
        return this.numberInFile;
    }

    public String getSysNo() {
        return this.sysNo.value;
    }

    public void setConnectionStateClosed() {
        this.connectionState = ID_CLOSED;
    }

    public void setConnectionStateOpen() {
        this.connectionState = ID_OPEN;
    }

    public boolean isConnectionOpen() {
        return this.connectionState.equals(ID_OPEN);
    }

    public boolean isConnectionToBeDetermined() {
        return this.connectionState.equals(ID_TO_BE_DETERMINED);
    }

    void setCustName(String pString) {
        this.custName.value = pString;
    }

    public CustomerConnectionIdentifier getIdentifier() {
        return this.identifier;
    }

    public boolean equals(Object o) {
        if (o != null) {
            return this.identifier.identifier.equals(o);
        }
        return false;
    }

    public int hashCode() {
        return this.identifier.identifier.hashCode();
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        CustomerConnectionEntry comparable = (CustomerConnectionEntry)o;
        int result = this.custName.value.compareTo(comparable.custName.value);
        if (result == 0) {
            result = this.dataBaseId.value.compareTo(comparable.dataBaseId.value);
        }
        if (result == 0) {
            result = this.hostName.value.compareTo(comparable.hostName.value);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Property {
        private final Key key;
        private final boolean isOptional;
        private String value = null;

        private Property(Key key, boolean isOptional) {
            this.key = key;
            this.isOptional = isOptional;
        }

        private Property(Key key, boolean isOptional, String value) {
            this(key, isOptional);
            this.value = value;
        }
    }

    private static class Key
    extends AbstractEnum {
        private static final Key DB_ID = new Key("DBID");
        private static final Key HOST = new Key("HOST");
        private static final Key CUST_INFO_NO = new Key("KDINFONR");
        private static final Key CUST_NO = new Key("KDNR");
        private static final Key CUST_NAME = new Key("DNAME");
        private static final Key SYS_NO = new Key("SYSNR");
        private static final Key SYS_INFO_URL = new Key("URL");
        private static final Key SAPSERV_HOST = new Key("SAPSERV");
        private static final Key CBS_URL = new Key("CBS");
        private static final Key DTR_URL = new Key("DTR");

        private Key(String name) {
            super(name);
        }

        static /* synthetic */ Key access$300() {
            return CUST_INFO_NO;
        }

        static /* synthetic */ Key access$500() {
            return CUST_NAME;
        }

        static /* synthetic */ Key access$700() {
            return CUST_NO;
        }

        static /* synthetic */ Key access$800() {
            return DB_ID;
        }

        static /* synthetic */ Key access$900() {
            return HOST;
        }

        static /* synthetic */ Key access$1000() {
            return SYS_NO;
        }
    }

    public class CustomerConnectionIdentifier {
        private String identifier = null;

        private CustomerConnectionIdentifier() {
            StringBuffer identifierBuffer = new StringBuffer();
            identifierBuffer.append(CustomerConnectionEntry.this.numberInFile);
            identifierBuffer.append(CustomerConnectionEntry.this.dataBaseId.value);
            identifierBuffer.append(CustomerConnectionEntry.this.hostName.value);
            identifierBuffer.append(CustomerConnectionEntry.this.sysNo.value);
            identifierBuffer.append(CustomerConnectionEntry.this.custNo.value);
            this.identifier = identifierBuffer.toString();
        }

        public String getDescription() {
            StringBuffer descriptionBuffer = new StringBuffer();
            descriptionBuffer.append(CustomerConnectionEntry.this.custName.value);
            descriptionBuffer.append(RemoteDebugMessages.THIS.getString("CustomerConnectionEntry.|"));
            descriptionBuffer.append(CustomerConnectionEntry.this.connectionState);
            descriptionBuffer.append(RemoteDebugMessages.THIS.getString("CustomerConnectionEntry.|"));
            descriptionBuffer.append(CustomerConnectionEntry.this.dataBaseId.value);
            descriptionBuffer.append(RemoteDebugMessages.THIS.getString("CustomerConnectionEntry.|"));
            descriptionBuffer.append(CustomerConnectionEntry.this.hostName.value);
            return descriptionBuffer.toString();
        }

        public String getIdString() {
            return this.identifier;
        }
    }
}

