/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug;

import com.sap.ide.eclipse.rdebug.CustomerConnectionEntry;
import com.sap.ide.eclipse.rdebug.JrdebugecPlugin;
import com.sap.ide.eclipse.rdebug.RemoteDebugMessages;
import com.sap.ide.eclipse.rdebug.trace.Tracer;
import com.sap.ide.eclipse.rdebug.views.UserPasswordDialog;
import com.sap.mw.jco.IRepository;
import com.sap.mw.jco.JCO;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

class CSSJcoManager {
    public static final CSSJcoManager INSTANCE = new CSSJcoManager();
    public static final String REPOSITORY_NAME = "com.sap.ide.eclipse.rdebug.CSSREpository";
    public static final String ERROR_TITLE = RemoteDebugMessages.THIS.getString("Common.CSS_Remote_Debug_Error_Title");
    private IRepository cssRepository = null;

    public static CSSJcoManager getInstance() {
        return INSTANCE;
    }

    private CSSJcoManager() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkConnections(Shell parentShell, List customerConnectionEntries) {
        JCO.Client rfcClient;
        boolean sapGuiInvisible = false;
        if (this.cssRepository == null) {
            JCO.Client repositoryClient = this.createCSSClient(parentShell, false);
            if (repositoryClient == null) {
                return;
            }
            this.cssRepository = JCO.createRepository((String)REPOSITORY_NAME, (JCO.Client)repositoryClient);
        }
        if ((rfcClient = this.createCSSClient(parentShell, false)) == null) {
            return;
        }
        JCO.Function function = this.cssRepository.getFunctionTemplate("CHECK_CONNECTIONS_OPEN").getFunction();
        JCO.Table customerConnTable = function.getTableParameterList().getTable("CUSTOMERCONNECTIONS");
        Iterator i = customerConnectionEntries.iterator();
        while (i.hasNext()) {
            CustomerConnectionEntry custConnection = (CustomerConnectionEntry)i.next();
            customerConnTable.appendRow();
            customerConnTable.setValue(custConnection.getSysNo(), "SYSNR");
            customerConnTable.setValue(custConnection.getCustNo(), "KDNR");
            customerConnTable.setValue(custConnection.getCustInfoNo(), "KDINFONR");
            customerConnTable.setValue(custConnection.getDataBaseId().trim(), "DBID");
            customerConnTable.setValue(570, "SERVTYPE");
        }
        try {
            try {
                rfcClient.execute(function);
            }
            catch (JCO.AbapException jAbEx) {
                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, jAbEx.getMessage());
                MessageDialog.openError((Shell)parentShell, (String)ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CSSJcoManager.Abap_execution_error_in_CSS._The_connections_cannot_be_checked."));
                Object var11_11 = null;
                if (rfcClient == null) return;
                rfcClient.disconnect();
                return;
            }
            catch (JCO.Exception jEx) {
                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, jEx.getMessage());
                MessageDialog.openError((Shell)parentShell, (String)ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CSSJcoManager.Communication_error_with_CSS._The_connections_cannot_be_checked."));
                Object var11_12 = null;
                if (rfcClient == null) return;
                rfcClient.disconnect();
                return;
            }
            Object var11_10 = null;
            if (rfcClient != null) {
                rfcClient.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (rfcClient != null) {
                rfcClient.disconnect();
            }
            throw throwable;
        }
        customerConnTable.firstRow();
        Iterator i2 = customerConnectionEntries.iterator();
        while (i2.hasNext()) {
            CustomerConnectionEntry custConnection = (CustomerConnectionEntry)i2.next();
            if (customerConnTable.getInt("COPEN") != 0) {
                custConnection.setConnectionStateClosed();
            } else {
                custConnection.setConnectionStateOpen();
            }
            customerConnTable.nextRow();
        }
    }

    private JCO.Client createCSSClient(final Shell parentShell, boolean setSapGuiVisible) {
        StringBuffer sncPartnername = new StringBuffer();
        Properties sncProps = new Properties();
        IPreferenceStore store = JrdebugecPlugin.getDefault().getPreferenceStore();
        ((Hashtable)sncProps).put("jco.client.snc_mode", "1");
        sncPartnername.append("p:CN=" + store.getString("com.sap.ide.eclipse.rdebug.css_r3name") + ", O=SAP-AG, C=DE");
        ((Hashtable)sncProps).put("jco.client.snc_partnername", sncPartnername.toString());
        ((Hashtable)sncProps).put("jco.client.r3name", store.getString("com.sap.ide.eclipse.rdebug.css_r3name"));
        ((Hashtable)sncProps).put("jco.client.group", store.getString("com.sap.ide.eclipse.rdebug.css_group"));
        ((Hashtable)sncProps).put("jco.client.mshost", store.getString("com.sap.ide.eclipse.rdebug.css_mshost"));
        ((Hashtable)sncProps).put("jco.client.sysnr", store.getString("com.sap.ide.eclipse.rdebug.css_sysno"));
        ((Hashtable)sncProps).put("jco.client.client", store.getString("com.sap.ide.eclipse.rdebug.css_client"));
        ((Hashtable)sncProps).put("jco.client.lang", store.getString("com.sap.ide.eclipse.rdebug.css_lang"));
        ((Hashtable)sncProps).put("jco.client.user", store.getString("com.sap.ide.eclipse.rdebug.css_user"));
        ((Hashtable)sncProps).put("jco.client.passwd", "?");
        JCO.Client client = JCO.createClient((Properties)sncProps);
        if (setSapGuiVisible) {
            client.setSapGui(1);
        }
        try {
            client.connect();
        }
        catch (JCO.Exception jEx) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, jEx.getMessage());
            client = null;
        }
        if (client != null) {
            return client;
        }
        Tracer.dtTracer.userOut("JavaRemoteDebug", 4, "Attempting to connect by direct logon");
        final Properties noSncProps = new Properties();
        ((Hashtable)noSncProps).put("jco.client.r3name", store.getString("com.sap.ide.eclipse.rdebug.css_r3name"));
        ((Hashtable)noSncProps).put("jco.client.group", store.getString("com.sap.ide.eclipse.rdebug.css_group"));
        ((Hashtable)noSncProps).put("jco.client.mshost", store.getString("com.sap.ide.eclipse.rdebug.css_mshost"));
        ((Hashtable)noSncProps).put("jco.client.sysnr", store.getString("com.sap.ide.eclipse.rdebug.css_sysno"));
        ((Hashtable)noSncProps).put("jco.client.client", store.getString("com.sap.ide.eclipse.rdebug.css_client"));
        ((Hashtable)noSncProps).put("jco.client.lang", store.getString("com.sap.ide.eclipse.rdebug.css_lang"));
        final String lUser = store.getString("com.sap.ide.eclipse.rdebug.css_user");
        final String lPassword = JrdebugecPlugin.getDefault().getPassword();
        if (lUser.equals("") || lPassword.equals("")) {
            Runnable dialogWrapper = new Runnable(){

                public void run() {
                    UserPasswordDialog dialog = new UserPasswordDialog(parentShell, RemoteDebugMessages.THIS.getString("CSSJcoManager.CSS_Logon_Popup_Title"), null, RemoteDebugMessages.THIS.getString("CSSJcoManager.Enter_user_and_password_for_CSS_logon"), lUser, lPassword);
                    dialog.open();
                    ((Hashtable)noSncProps).put("jco.client.user", dialog.getUser());
                    String password = dialog.getPassword();
                    ((Hashtable)noSncProps).put("jco.client.passwd", password);
                    JrdebugecPlugin.getDefault().setPassword(password);
                }
            };
            Display.getDefault().syncExec(dialogWrapper);
        } else {
            ((Hashtable)noSncProps).put("jco.client.user", lUser);
            ((Hashtable)noSncProps).put("jco.client.passwd", lPassword);
        }
        client = JCO.createClient((Properties)noSncProps);
        if (setSapGuiVisible) {
            client.setSapGui(1);
        }
        try {
            client.connect();
        }
        catch (JCO.Exception jEx) {
            Tracer.dtTracer.userOut("JavaRemoteDebug", 2, jEx.getMessage());
            if (jEx.getGroup() == 103) {
                MessageDialog.openError((Shell)parentShell, (String)ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CSSJcoManager.Logon_failure"));
            } else {
                MessageDialog.openError((Shell)parentShell, (String)ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CSSJcoManager.A_connection_to_CSS_cannot_be_opened"));
            }
            JrdebugecPlugin.getDefault().setPassword(null);
            return null;
        }
        return client;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getRouteString(Shell parentShell, CustomerConnectionEntry customerConnection) {
        boolean sapGuiVisible = true;
        if (customerConnection.isConnectionToBeDetermined()) {
            this.checkConnections(parentShell, JrdebugecPlugin.getDefault().getConnectionManager().getConnectionList());
        }
        if (!customerConnection.isConnectionOpen()) {
            MessageDialog.openError((Shell)parentShell, (String)ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CSSJcoManager.Connection_is_not_open_or_not_determined."));
            return null;
        }
        JCO.Client rfcClient = this.createCSSClient(parentShell, true);
        if (rfcClient == null) {
            return null;
        }
        JCO.Function getRouteString = this.cssRepository.getFunctionTemplate("EWO_GET_ROUTESTRING").getFunction();
        JCO.ParameterList importParameterList = getRouteString.getImportParameterList();
        importParameterList.setValue(customerConnection.getDataBaseId(), "DBID");
        importParameterList.setValue(customerConnection.getHostName(), "HOSTNAME");
        importParameterList.setValue("  ", "INSTANCE");
        importParameterList.setValue(customerConnection.getCustInfoNo(), "KDINFONR");
        importParameterList.setValue(customerConnection.getCustNo(), "KDNR");
        importParameterList.setValue(570, "SERVICE");
        importParameterList.setValue(customerConnection.getSysNo(), "SYSNR");
        try {
            try {
                rfcClient.execute(getRouteString);
            }
            catch (JCO.AbapException jAbEx) {
                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, jAbEx.getMessage());
                MessageDialog.openError((Shell)parentShell, (String)ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CSSJcoManager.Abap_execution_error_in_CSS._The_routestring_cannot_be_evaluated."));
                String string = null;
                Object var11_8 = null;
                if (rfcClient == null) return string;
                rfcClient.disconnect();
                return string;
            }
            catch (JCO.Exception jEx) {
                jEx.printStackTrace();
                Tracer.dtTracer.userOut("JavaRemoteDebug", 2, jEx.getMessage());
                MessageDialog.openError((Shell)parentShell, (String)ERROR_TITLE, (String)RemoteDebugMessages.THIS.getString("CSSJcoManager.Communication_error_with_CSS._The_routestring_cannot_be_evaluated."));
                String string = null;
                Object var11_9 = null;
                if (rfcClient == null) return string;
                rfcClient.disconnect();
                return string;
            }
            Object var11_7 = null;
            if (rfcClient == null) return getRouteString.getExportParameterList().getString("ROUTESTRING");
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            if (rfcClient == null) throw throwable;
            rfcClient.disconnect();
            throw throwable;
        }
        rfcClient.disconnect();
        return getRouteString.getExportParameterList().getString("ROUTESTRING");
    }
}

