/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.eclipse.rdebug;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.SocketAttachConnector;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

class CSSAttachConnector
extends SocketAttachConnector {
    CSSAttachConnector() {
    }

    public void connect(Map arguments, IProgressMonitor monitor, ILaunch launch) throws CoreException {
        String host;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask(LaunchingMessages.getString((String)"SocketAttachConnector.Connecting..._1"), 2);
        subMonitor.subTask(LaunchingMessages.getString((String)"SocketAttachConnector.Configuring_connection..._1"));
        AttachingConnector connector = SocketAttachConnector.getAttachingConnector();
        String portNumberString = (String)arguments.get("port");
        if (portNumberString == null) {
            SocketAttachConnector.abort((String)LaunchingMessages.getString((String)"SocketAttachConnector.Port_unspecified_for_remote_connection._2"), null, (int)111);
        }
        if ((host = (String)arguments.get("hostname")) == null) {
            SocketAttachConnector.abort((String)LaunchingMessages.getString((String)"SocketAttachConnector.Hostname_unspecified_for_remote_connection._4"), null, (int)109);
        }
        Map<String, Connector.Argument> map = connector.defaultArguments();
        Connector.Argument param = map.get("hostname");
        param.setValue(host);
        param = map.get("port");
        param.setValue(portNumberString);
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        boolean allowTerminate = false;
        if (configuration != null) {
            allowTerminate = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        }
        subMonitor.worked(1);
        subMonitor.subTask(LaunchingMessages.getString((String)"SocketAttachConnector.Establishing_connection..._2"));
        VirtualMachine vm = null;
        try {
            vm = connector.attach(map);
            String vmLabel = this.constructVMLabel(vm, host, portNumberString, configuration);
            IDebugTarget debugTarget = JDIDebugModel.newDebugTarget((ILaunch)launch, (VirtualMachine)vm, (String)vmLabel, null, (boolean)allowTerminate, (boolean)true);
            launch.addDebugTarget(debugTarget);
            subMonitor.worked(1);
            subMonitor.done();
        }
        catch (UnknownHostException e) {
            if (vm != null) {
                vm.eventRequestManager().deleteAllBreakpoints();
                vm.dispose();
            }
            SocketAttachConnector.abort((String)MessageFormat.format(LaunchingMessages.getString((String)"SocketAttachConnector.Failed_to_connect_to_remote_VM_because_of_unknown_host___{0}__1"), host), (Throwable)e, (int)113);
        }
        catch (ConnectException e) {
            if (vm != null) {
                vm.dispose();
            }
            SocketAttachConnector.abort((String)LaunchingMessages.getString((String)"SocketAttachConnector.Failed_to_connect_to_remote_VM_as_connection_was_refused_2"), (Throwable)e, (int)113);
        }
        catch (IOException e) {
            if (vm != null) {
                vm.dispose();
            }
            SocketAttachConnector.abort((String)LaunchingMessages.getString((String)"SocketAttachConnector.Failed_to_connect_to_remote_VM_1"), (Throwable)e, (int)113);
        }
        catch (IllegalConnectorArgumentsException e) {
            if (vm != null) {
                vm.dispose();
            }
            SocketAttachConnector.abort((String)LaunchingMessages.getString((String)"SocketAttachConnector.Failed_to_connect_to_remote_VM_1"), (Throwable)e, (int)113);
        }
        catch (RuntimeException rEx) {
            if (vm != null) {
                vm.eventRequestManager().deleteAllBreakpoints();
                vm.dispose();
            }
            throw rEx;
        }
        catch (Error err) {
            if (vm != null) {
                vm.dispose();
            }
            throw err;
        }
    }
}

