/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.Sync;
import com.sap.engine.lib.util.concurrent.TimeoutException;

public class TimeoutSync
implements Sync {
    protected final Sync syncGuard;
    protected final long timeout;

    public TimeoutSync(Sync sync, long time) {
        this.syncGuard = sync;
        this.timeout = time;
    }

    public void acquire() throws InterruptedException {
        if (!this.syncGuard.attempt(this.timeout)) {
            throw new TimeoutException(this.timeout);
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        return this.syncGuard.attempt(msecs);
    }

    public void release() {
        this.syncGuard.release();
    }
}

