/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.FIFOSemaphore;
import com.sap.engine.lib.util.concurrent.QueuedSemaphore;

public class PrioritySemaphore
extends QueuedSemaphore {
    public PrioritySemaphore(long initialPermits) {
        super(new PriorityWaitQueue(), initialPermits);
    }

    protected static class PriorityWaitQueue
    extends QueuedSemaphore.WaitQueue {
        protected final FIFOSemaphore.FIFOWaitQueue[] cells = new FIFOSemaphore.FIFOWaitQueue[10];
        protected int maxIndex_ = -1;

        protected PriorityWaitQueue() {
            int i = 0;
            while (i < this.cells.length) {
                this.cells[i] = new FIFOSemaphore.FIFOWaitQueue();
                ++i;
            }
        }

        protected void insert(QueuedSemaphore.WaitQueue.WaitNode w) {
            int idx = Thread.currentThread().getPriority() - 1;
            this.cells[idx].insert(w);
            if (idx > this.maxIndex_) {
                this.maxIndex_ = idx;
            }
        }

        protected QueuedSemaphore.WaitQueue.WaitNode extract() {
            int idx;
            while ((idx = this.maxIndex_--) >= 0) {
                QueuedSemaphore.WaitQueue.WaitNode w = this.cells[idx].extract();
                if (w == null) continue;
                return w;
            }
            return null;
        }
    }
}

