/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.Sync;

public class Mutex
implements Sync {
    protected boolean isInUse = false;

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Mutex mutex = this;
        synchronized (mutex) {
            try {
                while (this.isInUse) {
                    this.wait();
                }
                this.isInUse = true;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public synchronized void release() {
        this.isInUse = false;
        this.notify();
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Mutex mutex = this;
        synchronized (mutex) {
            if (!this.isInUse) {
                this.isInUse = true;
                boolean bl = true;
                return bl;
            }
            if (msecs <= 0L) {
                boolean bl = false;
                return bl;
            }
            long waitTime = msecs;
            long start = System.currentTimeMillis();
            try {
                do {
                    this.wait(waitTime);
                    if (this.isInUse) continue;
                    this.isInUse = true;
                    boolean bl = true;
                    return bl;
                } while ((waitTime = msecs - (System.currentTimeMillis() - start)) > 0L);
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }
}

