/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.concurrent;

import com.sap.engine.lib.util.concurrent.Barrier;
import com.sap.engine.lib.util.concurrent.BrokenBarrierException;
import com.sap.engine.lib.util.concurrent.TimeoutException;

public class CyclicBarrier
implements Barrier {
    protected final int initialParties;
    protected boolean isBroken = false;
    protected Runnable barrierRunnableCommand = null;
    protected int partiesCount;
    protected int resetsCount = 0;

    public CyclicBarrier(int parties) {
        this(parties, null);
    }

    public CyclicBarrier(int parties, Runnable command) {
        if (parties <= 0) {
            throw new IllegalArgumentException();
        }
        this.initialParties = parties;
        this.partiesCount = parties;
        this.barrierRunnableCommand = command;
    }

    public synchronized Runnable setBarrierCommand(Runnable command) {
        Runnable old = this.barrierRunnableCommand;
        this.barrierRunnableCommand = command;
        return old;
    }

    public synchronized boolean broken() {
        return this.isBroken;
    }

    public synchronized void restart() {
        this.isBroken = false;
        ++this.resetsCount;
        this.partiesCount = this.initialParties;
        this.notifyAll();
    }

    public int parties() {
        return this.initialParties;
    }

    public int barrier() throws InterruptedException, BrokenBarrierException {
        return this.doBarrier(false, 0L);
    }

    public int attemptBarrier(long msecs) throws InterruptedException, TimeoutException, BrokenBarrierException {
        return this.doBarrier(true, msecs);
    }

    protected synchronized int doBarrier(boolean timed, long msecs) throws InterruptedException, TimeoutException, BrokenBarrierException {
        int index = --this.partiesCount;
        if (this.isBroken) {
            throw new BrokenBarrierException(index);
        }
        if (Thread.interrupted()) {
            this.isBroken = true;
            this.notifyAll();
            throw new InterruptedException();
        }
        if (index == 0) {
            this.partiesCount = this.initialParties;
            ++this.resetsCount;
            this.notifyAll();
            try {
                if (this.barrierRunnableCommand != null) {
                    this.barrierRunnableCommand.run();
                }
                return 0;
            }
            catch (RuntimeException ex) {
                this.isBroken = true;
                return 0;
            }
        }
        if (timed && msecs <= 0L) {
            this.isBroken = true;
            this.notifyAll();
            throw new TimeoutException(msecs);
        }
        int r = this.resetsCount;
        long startTime = timed ? System.currentTimeMillis() : 0L;
        long waitTime = msecs;
        do {
            try {
                this.wait(waitTime);
            }
            catch (InterruptedException ex) {
                if (this.resetsCount == r) {
                    this.isBroken = true;
                    this.notifyAll();
                    throw ex;
                }
                Thread.currentThread().interrupt();
            }
            if (this.isBroken) {
                throw new BrokenBarrierException(index);
            }
            if (r == this.resetsCount) continue;
            return index;
        } while (!timed || (waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
        this.isBroken = true;
        this.notifyAll();
        throw new TimeoutException(msecs);
    }
}

