/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.base;

import com.sap.engine.lib.util.base.BaseLinkedList;
import com.sap.engine.lib.util.base.ListPoolInstanceCreator;
import com.sap.engine.lib.util.base.NextItem;

public abstract class ListPool
extends BaseLinkedList
implements ListPoolInstanceCreator {
    public ListPool() {
    }

    public ListPool(int initialSize) {
        this(initialSize, 0);
    }

    public ListPool(int initialSize, int limit) {
        super(limit);
        int i = 0;
        while (i < initialSize) {
            this.addFirstItem(this.newInstance());
            ++i;
        }
    }

    public NextItem getObject() {
        NextItem temp;
        ListPool listPool = this;
        synchronized (listPool) {
            temp = this.removeFirstItem();
        }
        return temp == null ? this.newInstance() : temp;
    }

    public synchronized void releaseObject(NextItem item) {
        this.addFirstItem(item);
    }

    public synchronized void freeMemory() {
        this.clear();
    }

    public synchronized void freeMemory(int count) {
        this.removeSublist(count);
    }

    public synchronized void setLimit(int limit) {
        super.setLimit(limit);
    }

    public abstract NextItem newInstance();
}

