/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util.base;

import com.sap.engine.lib.util.AbstractDataStructure;
import com.sap.engine.lib.util.NotSupportedException;
import com.sap.engine.lib.util.RootDataStructure;
import com.sap.engine.lib.util.Stack;
import com.sap.engine.lib.util.TreePerformer;
import com.sap.engine.lib.util.base.BinTreeItem;
import com.sap.engine.lib.util.base.Pointer;
import com.sap.engine.lib.util.iterators.ArrayEnumeration;
import com.sap.engine.lib.util.iterators.ForwardIterator;
import com.sap.engine.lib.util.iterators.IteratorException;
import com.sap.engine.lib.util.iterators.RootIterator;
import com.sap.engine.lib.util.iterators.SnapShotEnumeration;

public class BaseBinaryTree
extends AbstractDataStructure {
    protected BinTreeItem root;
    protected transient BinTreeItem resultValue;
    protected transient BinTreeItem recValue;
    protected transient Comparable searchKey;

    public void clear() {
        this.count = 0;
        this.root = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BaseBinaryTree)) {
            return false;
        }
        BaseBinaryTree tmp = (BaseBinaryTree)o;
        if (tmp.count != this.count) {
            return false;
        }
        return this.equals(tmp.itemsIterator(), this.root);
    }

    public boolean equals(Object o, Stack stack) {
        if (!(o instanceof BaseBinaryTree)) {
            return false;
        }
        BaseBinaryTree tmp = (BaseBinaryTree)o;
        if (tmp.count != this.count) {
            return false;
        }
        return this.equals(tmp.itemsIterator(stack), this.root);
    }

    public Object clone() {
        BaseBinaryTree tree = (BaseBinaryTree)this.getNewInstance();
        this.clone(tree, this.root);
        return tree;
    }

    public boolean contains(Comparable item) {
        return this.getItem(item) != null;
    }

    public ForwardIterator itemsIterator() {
        return new TreeIterator();
    }

    public ForwardIterator itemsIterator(Stack stack) {
        return new TreeIterator(stack);
    }

    public ForwardIterator itemsIterator(boolean ascending) {
        return ascending ? new TreeIterator() : new TreeIteratorDown();
    }

    public ForwardIterator itemsIterator(boolean ascending, Stack stack) {
        return ascending ? new TreeIterator(stack) : new TreeIteratorDown(stack);
    }

    public BinTreeItem[] toItemArray() {
        BinTreeItem[] result = new BinTreeItem[this.count];
        this.getAllNodesUp(result, this.root, 0);
        return result;
    }

    public BinTreeItem[] toItemArray(boolean ascending) {
        BinTreeItem[] result = new BinTreeItem[this.count];
        if (ascending) {
            this.getAllNodesUp(result, this.root, 0);
        } else {
            this.getAllNodesDown(result, this.root, 0);
        }
        return result;
    }

    public SnapShotEnumeration itemsEnumeration() {
        return new ArrayEnumeration(this.toItemArray());
    }

    public SnapShotEnumeration itemsEnumeration(boolean ascending) {
        return new ArrayEnumeration(this.toItemArray(ascending));
    }

    public void perform(TreePerformer performer) {
        this.performUp(performer, this.root);
    }

    public void perform(TreePerformer performer, boolean ascending) {
        if (ascending) {
            this.performUp(performer, this.root);
        } else {
            this.performDown(performer, this.root);
        }
    }

    public BinTreeItem putItem(BinTreeItem item) {
        this.recValue = item;
        this.searchKey = item.getKey();
        this.recValue.clearItem();
        this.root = this.insert(this.root);
        this.recValue = null;
        this.searchKey = null;
        if (this.resultValue != null) {
            this.resultValue.clearItem();
            BinTreeItem result = this.resultValue;
            this.resultValue = null;
            return result;
        }
        ++this.count;
        return null;
    }

    public BinTreeItem getItem(Comparable key) {
        BinTreeItem tmp = this.root;
        while (true) {
            if (tmp == null) {
                return null;
            }
            int cmp = tmp.getKey().compareTo(key);
            if (cmp > 0) {
                tmp = tmp.getLeft();
                continue;
            }
            if (cmp >= 0) break;
            tmp = tmp.getRight();
        }
        return tmp;
    }

    public BinTreeItem removeItem(Comparable key) {
        this.searchKey = key;
        this.root = this.delete(this.root);
        this.searchKey = null;
        if (this.resultValue != null) {
            --this.count;
            this.resultValue.clearItem();
            BinTreeItem result = this.resultValue;
            this.resultValue = null;
            return result;
        }
        return null;
    }

    public BinTreeItem minItem() {
        if (this.root == null) {
            return null;
        }
        BinTreeItem tmp = this.root;
        while (tmp.getLeft() != null) {
            tmp = tmp.getLeft();
        }
        return tmp;
    }

    public BinTreeItem maxItem() {
        if (this.root == null) {
            return null;
        }
        BinTreeItem tmp = this.root;
        while (tmp.getRight() != null) {
            tmp = tmp.getRight();
        }
        return tmp;
    }

    public BinTreeItem removeMinItem() {
        if (this.root == null) {
            return null;
        }
        BinTreeItem parent = null;
        BinTreeItem tmp = this.root;
        while (tmp.getLeft() != null) {
            parent = tmp;
            tmp = tmp.getLeft();
        }
        if (parent == null) {
            this.root = this.root.getRight();
        } else {
            parent.setLeft(tmp.getRight());
        }
        --this.count;
        tmp.clearItem();
        return tmp;
    }

    public BinTreeItem removeMaxItem() {
        if (this.root == null) {
            return null;
        }
        BinTreeItem parent = null;
        BinTreeItem tmp = this.root;
        while (tmp.getRight() != null) {
            parent = tmp;
            tmp = tmp.getRight();
        }
        if (parent == null) {
            this.root = this.root.getLeft();
        } else {
            parent.setRight(tmp.getLeft());
        }
        --this.count;
        tmp.clearItem();
        return tmp;
    }

    public Object deepClone() {
        throw new NotSupportedException("In base structures all clone operation are deep clone.");
    }

    public SnapShotEnumeration elementsEnumeration() {
        return new ArrayEnumeration(this.toItemArray());
    }

    public RootIterator elementsIterator() {
        return new TreeIterator();
    }

    public Pointer[] toPointerArray() {
        throw new NotSupportedException("In base structures there is no wrappers.");
    }

    public Object[] toArray() {
        return this.toItemArray();
    }

    protected Object getNewInstance() {
        BaseBinaryTree tree = (BaseBinaryTree)super.clone();
        tree.root = null;
        tree.count = 0;
        return tree;
    }

    protected boolean equals(ForwardIterator e, BinTreeItem current) {
        if (current == null) {
            return true;
        }
        if (!this.equals(e, current.getLeft())) {
            return false;
        }
        if (!current.equals(e.next())) {
            return false;
        }
        return this.equals(e, current.getRight());
    }

    protected int getAllNodesDown(BinTreeItem[] result, BinTreeItem current, int deep) {
        if (current == null) {
            return deep;
        }
        deep = this.getAllNodesDown(result, current.getRight(), deep);
        result[deep++] = current;
        deep = this.getAllNodesDown(result, current.getLeft(), deep);
        return deep;
    }

    protected int getAllNodesUp(BinTreeItem[] result, BinTreeItem current, int deep) {
        if (current == null) {
            return deep;
        }
        deep = this.getAllNodesUp(result, current.getLeft(), deep);
        result[deep++] = current;
        deep = this.getAllNodesUp(result, current.getRight(), deep);
        return deep;
    }

    protected boolean performUp(TreePerformer performer, BinTreeItem current) {
        if (current == null) {
            return false;
        }
        if (this.performUp(performer, current.getLeft())) {
            return true;
        }
        if (performer.perform(current)) {
            return true;
        }
        return this.performUp(performer, current.getRight());
    }

    protected boolean performDown(TreePerformer performer, BinTreeItem current) {
        if (current == null) {
            return false;
        }
        if (this.performDown(performer, current.getRight())) {
            return true;
        }
        if (performer.perform(current)) {
            return true;
        }
        return this.performDown(performer, current.getLeft());
    }

    protected BinTreeItem insert(BinTreeItem root) {
        if (root == null) {
            return this.recValue;
        }
        int cmp = root.getKey().compareTo(this.searchKey);
        if (cmp > 0) {
            root.setLeft(this.insert(root.getLeft()));
        } else if (cmp < 0) {
            root.setRight(this.insert(root.getRight()));
        } else {
            this.resultValue = root;
            this.recValue.setLeft(root.getLeft());
            this.recValue.setRight(root.getRight());
            return this.recValue;
        }
        return root;
    }

    protected BinTreeItem delete(BinTreeItem root) {
        if (root == null) {
            return null;
        }
        int cmp = this.searchKey.compareTo(root.getKey());
        if (cmp < 0) {
            root.setLeft(this.delete(root.getLeft()));
        } else if (cmp > 0) {
            root.setRight(this.delete(root.getRight()));
        } else {
            this.resultValue = root;
            if (root.getLeft() == null) {
                return root.getRight();
            }
            if (root.getRight() == null) {
                return root.getLeft();
            }
            BinTreeItem parent = null;
            BinTreeItem tmp = root.getRight();
            while (tmp.getLeft() != null) {
                parent = tmp;
                tmp = tmp.getLeft();
            }
            tmp.setLeft(root.getLeft());
            if (parent != null) {
                parent.setLeft(tmp.getRight());
                tmp.setRight(root.getRight());
            }
            root = tmp;
        }
        return root;
    }

    protected void clone(BaseBinaryTree tree, BinTreeItem current) {
        if (current == null) {
            return;
        }
        tree.putItem((BinTreeItem)current.clone());
        this.clone(tree, current.getLeft());
        this.clone(tree, current.getRight());
    }

    public String toString() {
        return this.getNode("", this.root, true);
    }

    protected String getNode(String depth, BinTreeItem current, boolean isLeft) {
        String t;
        String string = t = isLeft ? "--- " : "R--- ";
        if (current == null) {
            return depth + t + null + "\n";
        }
        return depth + t + current + "\n" + this.getNode(depth + "    |", current.getLeft(), true) + this.getNode(depth + "    ", current.getRight(), false);
    }

    public int height() {
        return this.height(this.root);
    }

    protected int height(BinTreeItem current) {
        int hr;
        if (current == null) {
            return 0;
        }
        int hl = this.height(current.getLeft()) + 1;
        return hl > (hr = this.height(current.getRight()) + 1) ? hl : hr;
    }

    public int size_() {
        return this.size_(this.root);
    }

    protected int size_(BinTreeItem current) {
        if (current == null) {
            return 0;
        }
        return this.size_(current.getLeft()) + this.size_(current.getRight()) + 1;
    }

    public boolean check() {
        if (this.root == null) {
            return true;
        }
        return this.check(this.root);
    }

    protected boolean check(BinTreeItem current) {
        if (current.getLeft() != null) {
            if (current.getKey().compareTo(current.getLeft().getKey()) <= 0) {
                return false;
            }
            if (!this.check(current.getLeft())) {
                return false;
            }
        }
        if (current.getRight() != null) {
            if (current.getKey().compareTo(current.getRight().getKey()) >= 0) {
                return false;
            }
            if (!this.check(current.getRight())) {
                return false;
            }
        }
        return true;
    }

    protected class TreeIteratorDown
    implements ForwardIterator {
        protected Stack stack;
        protected BinTreeItem end;

        public TreeIteratorDown() {
            this(new Stack());
        }

        public TreeIteratorDown(Stack stack) {
            this.stack = stack;
            BinTreeItem tmp = BaseBinaryTree.this.root;
            while (tmp != null) {
                stack.push(tmp);
                tmp = tmp.getRight();
            }
        }

        protected TreeIteratorDown(boolean e) {
        }

        public Object add(Object o) {
            throw new IteratorException("Operation is not supported!");
        }

        public Object change(Object o) {
            throw new IteratorException("Operation is not supported!");
        }

        public Object remove() {
            throw new IteratorException("Operation is not supported!");
        }

        public Object insert(Object object) {
            throw new IteratorException("Operation is not supported!");
        }

        public Object get() {
            return this.stack.top();
        }

        public int size() {
            throw new IteratorException("Operation is not supported!");
        }

        public boolean isInsertable() {
            return false;
        }

        public boolean isRemoveable() {
            return false;
        }

        public boolean isChangeable() {
            return false;
        }

        public boolean isAddable() {
            return false;
        }

        public boolean isAtBegin() {
            return true;
        }

        public boolean isAtEnd() {
            return this.stack.top() == this.end;
        }

        public RootDataStructure getDataStructure() {
            return BaseBinaryTree.this;
        }

        public Object next() {
            BinTreeItem node = (BinTreeItem)this.stack.pop();
            BinTreeItem t = node.getLeft();
            while (t != null) {
                this.stack.push(t);
                t = t.getRight();
            }
            return node;
        }

        public Object next(int n) {
            int i = 0;
            while (i < n) {
                this.next();
                ++i;
            }
            return this.next();
        }

        public void setStartFromIterator(RootIterator iterator) {
            this.stack = (Stack)((TreeIteratorDown)iterator).stack.clone();
        }

        public void setEndFromIterator(RootIterator iterator) {
            this.end = (BinTreeItem)iterator.get();
        }
    }

    protected class TreeIterator
    extends TreeIteratorDown {
        public TreeIterator() {
            this(new Stack());
        }

        public TreeIterator(Stack stack) {
            super(true);
            this.stack = stack;
            BinTreeItem tmp = BaseBinaryTree.this.root;
            while (tmp != null) {
                stack.push(tmp);
                tmp = tmp.getLeft();
            }
        }

        public Object next() {
            BinTreeItem node = (BinTreeItem)this.stack.pop();
            BinTreeItem t = node.getRight();
            while (t != null) {
                this.stack.push(t);
                t = t.getLeft();
            }
            return node;
        }
    }
}

