/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.util;

import com.sap.engine.lib.util.Set;
import com.sap.engine.lib.util.base.LinearItemAdapter;
import com.sap.engine.lib.util.base.ListPool;
import com.sap.engine.lib.util.base.NextItem;

public class ConcurrentReadLRUSet
extends Set {
    private WrapperPool wrapperPool = null;
    private Wrapper[] LRUArray = null;
    private int LRUindex = 0;

    public ConcurrentReadLRUSet(int initialCapacity, int maxSize) {
        super(initialCapacity);
        this.wrapperPool = new WrapperPool(initialCapacity, maxSize);
        this.LRUArray = new Wrapper[maxSize];
        this.LRUindex = 0;
    }

    private Wrapper replaceMinimalWrapper(Wrapper newOne) {
        Wrapper min = this.LRUArray[0];
        int minIndex = 0;
        int i = 1;
        while (i < this.LRUindex) {
            if (this.LRUArray[i] != null && this.LRUArray[i].lastAccess < min.lastAccess) {
                min = this.LRUArray[i];
                minIndex = i;
            }
            ++i;
        }
        this.LRUArray[minIndex] = this.LRUArray[0];
        this.LRUArray[0] = newOne;
        return min;
    }

    public synchronized boolean add(Object obj) {
        Wrapper work = this.wrapperPool.getFreeObject();
        work.data = obj;
        work.setLastAccess();
        if (this.LRUindex < this.LRUArray.length) {
            this.LRUArray[this.LRUindex++] = work;
        } else {
            Wrapper victim = this.replaceMinimalWrapper(work);
            super.remove(victim);
            this.wrapperPool.releaseObject(victim);
        }
        return super.add(work);
    }

    public boolean contains(Object obj) {
        Wrapper work = (Wrapper)this.get(obj);
        if (work != null) {
            work.setLastAccess();
            return true;
        }
        return false;
    }

    private Object get(Object obj) {
        int pos = this.nextPtr[this.hasher.hash(obj.hashCode()) % this.capacity];
        while (pos != -1) {
            if (this.keys[pos - this.capacity].equals(obj)) {
                return this.keys[pos - this.capacity];
            }
            pos = this.nextPtr[pos];
        }
        return null;
    }

    private class WrapperPool
    extends ListPool {
        public WrapperPool(int initialSize) {
            super(initialSize);
        }

        public WrapperPool(int initialSize, int limit) {
            super(initialSize, limit);
        }

        public synchronized Wrapper getFreeObject() {
            return (Wrapper)this.getObject();
        }

        public NextItem newInstance() {
            return new Wrapper();
        }

        public synchronized void releaseObject(NextItem item) {
            item.clearItem();
            this.addFirstItem(item);
        }
    }

    private class Wrapper
    extends LinearItemAdapter {
        public Object data;
        public long lastAccess = 0L;

        private Wrapper() {
        }

        public boolean equals(Object obj) {
            if (obj instanceof Wrapper) {
                return this.data.equals(((Wrapper)obj).data);
            }
            if (obj != null) {
                return obj.equals(this.data);
            }
            return false;
        }

        public int hashCode() {
            return this.data.hashCode();
        }

        public void setLastAccess() {
            this.lastAccess = System.currentTimeMillis();
        }

        public void clearItem() {
            this.data = null;
            this.lastAccess = 0L;
            super.clearItem();
        }
    }
}

