/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.dictionary.implementation;

import com.sap.ide.metamodel.common.implementation.CommonDevelopmentObjectState;
import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;

class DtPrimaryKeyState
extends CommonDevelopmentObjectState {
    private Vector mKeyElementRefs = new Vector();

    DtPrimaryKeyState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        DtPrimaryKeyState lState = (DtPrimaryKeyState)object;
        return true;
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        DtPrimaryKeyState lState = (DtPrimaryKeyState)object;
    }

    public Object clone() throws CloneNotSupportedException {
        DtPrimaryKeyState lState = (DtPrimaryKeyState)((Object)super.clone());
        lState.mKeyElementRefs = (Vector)this.mKeyElementRefs.clone();
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Vector<Reference> lVector = new Vector<Reference>();
        Iterator it = ((AbstractList)this.mKeyElementRefs).iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (clipboardService.isExcluded(lReference)) continue;
            if (innerObjectKeys.contains(lReference.toReferenceString())) {
                lReference = clipboardService.refactor(lReference);
            }
            lVector.add(lReference);
        }
        this.mKeyElementRefs = lVector;
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        Iterator it = ((AbstractList)this.mKeyElementRefs).iterator();
        while (it.hasNext()) {
            Reference lReference = (Reference)it.next();
            if (!lReference.toReferenceString().startsWith(oldReference.toReferenceString())) continue;
            return true;
        }
        return false;
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        Vector<Reference> lList = new Vector<Reference>();
        Iterator it = ((AbstractList)this.mKeyElementRefs).iterator();
        while (it.hasNext()) {
            lList.add(refactoringService.refactor((Reference)it.next()));
        }
        this.mKeyElementRefs = lList;
    }

    void moveKeyElement(int fromPosition, int toPosition) {
        this.mKeyElementRefs.add(toPosition, this.mKeyElementRefs.remove(fromPosition));
    }

    void addKeyElement(Reference reference) {
        this.mKeyElementRefs.add(reference);
    }

    void addKeyElement(Reference reference, int position) {
        this.mKeyElementRefs.add(position, reference);
    }

    int getKeyElementCount() {
        return this.mKeyElementRefs.size();
    }

    Reference getKeyElement(Reference reference) {
        int i = 0;
        while (i < this.mKeyElementRefs.size()) {
            Reference lReference = (Reference)this.mKeyElementRefs.get(i);
            if (lReference.equals(reference)) {
                return lReference;
            }
            ++i;
        }
        return null;
    }

    Vector getKeyElements() {
        return this.mKeyElementRefs;
    }

    void removeKeyElement(Reference reference) {
        Reference lReference = this.getKeyElement(reference);
        if (lReference != null) {
            this.mKeyElementRefs.remove(lReference);
        }
    }

    void removeAllKeyElements() {
        this.mKeyElementRefs.clear();
    }

    void replaceKeyElement(Reference oldReference, Reference newReference) {
        int lPos = this.mKeyElementRefs.indexOf(oldReference);
        this.mKeyElementRefs.remove(lPos);
        this.mKeyElementRefs.add(lPos, newReference);
    }

    void reorderKeyElements(Vector orderedReferences) {
        this.mKeyElementRefs = orderedReferences;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("name")) {
            this.setName((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("KeyElements")) {
            this.addKeyElement((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

