/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.dictionary.implementation;

import com.sap.ide.metamodel.core.DevelopmentObjectProxy;
import com.sap.ide.metamodel.core.DevelopmentObjectState;
import com.sap.ide.metamodel.core.Reference;
import com.sap.ide.metamodel.core.UnrecognizedState;
import com.sap.ide.metamodel.core.clipboard.ClipboardService;
import com.sap.ide.metamodel.core.compare.CompareContext;
import com.sap.ide.metamodel.core.refactoring.RefactoringService;
import com.sap.ide.metamodel.dictionary.implementation.DtExclusiveFieldState;
import com.sap.ide.metamodel.dictionary.implementation.DtInclusiveFieldState;
import com.sap.ide.metamodel.dictionary.implementation.DtRenamedFieldState;
import com.sap.ide.metamodel.dictionary.implementation.DtStructureElementState;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

class DtImportFromOtherStructureState
extends DtStructureElementState {
    private String mGroup = null;
    private boolean mHasGroup = false;
    private Vector mExclusiveFields = new Vector();
    private HashMap mInclusiveFields = new HashMap();
    private Vector mRenamedFields = new Vector();
    private Reference mBelongingToJoinLeftRef = null;
    private Reference mBelongingToJoinRightRef = null;
    private Reference mUsedStructureRef = null;

    DtImportFromOtherStructureState() {
    }

    public boolean isEqualTo(DevelopmentObjectState object, boolean isRootObject) {
        if (!super.isEqualTo(object, isRootObject)) {
            return false;
        }
        DtImportFromOtherStructureState lState = (DtImportFromOtherStructureState)object;
        return String.valueOf(this.mGroup).equals(String.valueOf(lState.mGroup));
    }

    public void compareTo(DevelopmentObjectProxy sourceObject, DevelopmentObjectState object, CompareContext compareContext, boolean isRootObject) {
        super.compareTo(sourceObject, object, compareContext, isRootObject);
        DtImportFromOtherStructureState lState = (DtImportFromOtherStructureState)object;
        if (!String.valueOf(this.mGroup).equals(String.valueOf(lState.mGroup))) {
            compareContext.addPropertyDelta(sourceObject, "group", (Object)lState.mGroup);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DtImportFromOtherStructureState lState = (DtImportFromOtherStructureState)((Object)super.clone());
        lState.mExclusiveFields = new Vector();
        int i = 0;
        while (i < this.mExclusiveFields.size()) {
            lState.mExclusiveFields.add(((DtExclusiveFieldState)((Object)this.mExclusiveFields.get(i))).clone());
            ++i;
        }
        lState.mInclusiveFields = new HashMap();
        Iterator it = this.mInclusiveFields.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lState.mInclusiveFields.put(lKey, ((DtInclusiveFieldState)((Object)this.mInclusiveFields.get(lKey))).clone());
        }
        lState.mRenamedFields = new Vector();
        int i2 = 0;
        while (i2 < this.mRenamedFields.size()) {
            lState.mRenamedFields.add(((DtRenamedFieldState)((Object)this.mRenamedFields.get(i2))).clone());
            ++i2;
        }
        return lState;
    }

    public void removeExternalReferences(ArrayList innerObjectKeys) {
        super.removeExternalReferences(innerObjectKeys);
        Iterator it = ((AbstractList)this.mExclusiveFields).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it2 = this.mInclusiveFields.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).removeExternalReferences(innerObjectKeys);
        }
        Iterator it3 = ((AbstractList)this.mRenamedFields).iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).removeExternalReferences(innerObjectKeys);
        }
    }

    public void refactor(ClipboardService clipboardService) {
        if (((DevelopmentObjectState)this).mProxyRef != null) {
            this.setName(clipboardService.getNewName(((DevelopmentObjectState)this).mProxyRef));
            ((DevelopmentObjectState)this).mProxyRef = null;
        }
        super.refactor(clipboardService);
        Iterator it = ((AbstractList)this.mExclusiveFields).iterator();
        while (it.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it2 = this.mInclusiveFields.values().iterator();
        while (it2.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it2.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it2.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
        Iterator it3 = ((AbstractList)this.mRenamedFields).iterator();
        while (it3.hasNext()) {
            DevelopmentObjectState lState = (DevelopmentObjectState)it3.next();
            if (clipboardService.isExcluded((Reference)lState.getProxyReference())) {
                it3.remove();
                continue;
            }
            lState.refactor(clipboardService);
        }
    }

    public void refactorInnerReferences(ArrayList innerObjectKeys, ClipboardService clipboardService) {
        super.refactorInnerReferences(innerObjectKeys, clipboardService);
        Iterator it = ((AbstractList)this.mExclusiveFields).iterator();
        while (it.hasNext()) {
            ((DevelopmentObjectState)it.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it2 = this.mInclusiveFields.values().iterator();
        while (it2.hasNext()) {
            ((DevelopmentObjectState)it2.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        Iterator it3 = ((AbstractList)this.mRenamedFields).iterator();
        while (it3.hasNext()) {
            ((DevelopmentObjectState)it3.next()).refactorInnerReferences(innerObjectKeys, clipboardService);
        }
        if (this.mBelongingToJoinLeftRef != null) {
            if (clipboardService.isExcluded(this.mBelongingToJoinLeftRef)) {
                this.mBelongingToJoinLeftRef = null;
            } else if (innerObjectKeys.contains(this.mBelongingToJoinLeftRef.toReferenceString())) {
                this.mBelongingToJoinLeftRef = clipboardService.refactor(this.mBelongingToJoinLeftRef);
            }
        }
        if (this.mBelongingToJoinRightRef != null) {
            if (clipboardService.isExcluded(this.mBelongingToJoinRightRef)) {
                this.mBelongingToJoinRightRef = null;
            } else if (innerObjectKeys.contains(this.mBelongingToJoinRightRef.toReferenceString())) {
                this.mBelongingToJoinRightRef = clipboardService.refactor(this.mBelongingToJoinRightRef);
            }
        }
        if (this.mUsedStructureRef != null) {
            if (clipboardService.isExcluded(this.mUsedStructureRef)) {
                this.mUsedStructureRef = null;
            } else if (innerObjectKeys.contains(this.mUsedStructureRef.toReferenceString())) {
                this.mUsedStructureRef = clipboardService.refactor(this.mUsedStructureRef);
            }
        }
    }

    public boolean _hasReferencesToRefactor(Reference oldReference) {
        if (super._hasReferencesToRefactor(oldReference)) {
            return true;
        }
        if (this.mBelongingToJoinLeftRef != null && this.mBelongingToJoinLeftRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        if (this.mBelongingToJoinRightRef != null && this.mBelongingToJoinRightRef.toReferenceString().startsWith(oldReference.toReferenceString())) {
            return true;
        }
        return this.mUsedStructureRef != null && this.mUsedStructureRef.toReferenceString().startsWith(oldReference.toReferenceString());
    }

    public void refactorReferences(RefactoringService refactoringService) {
        super.refactorReferences(refactoringService);
        if (this.mBelongingToJoinLeftRef != null) {
            this.mBelongingToJoinLeftRef = refactoringService.refactor(this.mBelongingToJoinLeftRef);
        }
        if (this.mBelongingToJoinRightRef != null) {
            this.mBelongingToJoinRightRef = refactoringService.refactor(this.mBelongingToJoinRightRef);
        }
        if (this.mUsedStructureRef != null) {
            this.mUsedStructureRef = refactoringService.refactor(this.mUsedStructureRef);
        }
    }

    void setGroup(String value) {
        if (value == null) {
            this.unsetGroup();
            return;
        }
        this.mGroup = value;
        this.mHasGroup = true;
    }

    String getGroup() {
        return this.mGroup;
    }

    boolean hasGroup() {
        return this.mHasGroup;
    }

    void unsetGroup() {
        this.mGroup = null;
        this.mHasGroup = false;
    }

    void addExclusiveField(DtExclusiveFieldState state) {
        this.mExclusiveFields.add(state);
    }

    void addExclusiveField(DtExclusiveFieldState state, int position) {
        this.mExclusiveFields.add(position, state);
    }

    int getExclusiveFieldCount() {
        return this.mExclusiveFields.size();
    }

    DtExclusiveFieldState getExclusiveField(String name) {
        int i = 0;
        while (i < this.mExclusiveFields.size()) {
            DtExclusiveFieldState lState = (DtExclusiveFieldState)((Object)this.mExclusiveFields.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getExclusiveFields() {
        return this.mExclusiveFields;
    }

    void removeExclusiveField(DtExclusiveFieldState state) {
        this.mExclusiveFields.remove((Object)state);
    }

    void removeAllExclusiveFields() {
        this.mExclusiveFields.clear();
    }

    void addInclusiveField(DtInclusiveFieldState state) {
        this.mInclusiveFields.put(state.getName().toLowerCase(), state);
    }

    int getInclusiveFieldCount() {
        return this.mInclusiveFields.size();
    }

    DtInclusiveFieldState getInclusiveField(String name) {
        return (DtInclusiveFieldState)((Object)this.mInclusiveFields.get(name.toLowerCase()));
    }

    Vector getInclusiveFields() {
        return new Vector(this.mInclusiveFields.values());
    }

    void removeInclusiveField(String aggregationKey) {
        this.mInclusiveFields.remove(aggregationKey.toLowerCase());
    }

    void removeInclusiveField(DtInclusiveFieldState state) {
        this.mInclusiveFields.remove(state.getName().toLowerCase());
    }

    void removeAllInclusiveFields() {
        this.mInclusiveFields.clear();
    }

    void addRenamedField(DtRenamedFieldState state) {
        this.mRenamedFields.add(state);
    }

    void addRenamedField(DtRenamedFieldState state, int position) {
        this.mRenamedFields.add(position, state);
    }

    int getRenamedFieldCount() {
        return this.mRenamedFields.size();
    }

    DtRenamedFieldState getRenamedField(String name) {
        int i = 0;
        while (i < this.mRenamedFields.size()) {
            DtRenamedFieldState lState = (DtRenamedFieldState)((Object)this.mRenamedFields.get(i));
            if (lState.getName().equalsIgnoreCase(name)) {
                return lState;
            }
            ++i;
        }
        return null;
    }

    Vector getRenamedFields() {
        return this.mRenamedFields;
    }

    void removeRenamedField(DtRenamedFieldState state) {
        this.mRenamedFields.remove((Object)state);
    }

    void removeAllRenamedFields() {
        this.mRenamedFields.clear();
    }

    void moveExclusiveField(int fromPosition, int toPosition) {
        this.mExclusiveFields.add(toPosition, this.mExclusiveFields.remove(fromPosition));
    }

    void moveRenamedField(int fromPosition, int toPosition) {
        this.mRenamedFields.add(toPosition, this.mRenamedFields.remove(fromPosition));
    }

    Reference getBelongingToJoinLeft() {
        return this.mBelongingToJoinLeftRef;
    }

    void setBelongingToJoinLeft(Reference reference) {
        this.mBelongingToJoinLeftRef = reference;
    }

    Reference getBelongingToJoinRight() {
        return this.mBelongingToJoinRightRef;
    }

    void setBelongingToJoinRight(Reference reference) {
        this.mBelongingToJoinRightRef = reference;
    }

    Reference getUsedStructure() {
        return this.mUsedStructureRef;
    }

    void setUsedStructure(Reference reference) {
        this.mUsedStructureRef = reference;
    }

    void reorderExclusiveFields(Vector orderedStates) {
        this.mExclusiveFields = orderedStates;
    }

    void reorderRenamedFields(Vector orderedStates) {
        this.mRenamedFields = orderedStates;
    }

    public void setProperty(String propertyName, Object value) {
        if (propertyName.equals("group")) {
            this.setGroup((String)value);
        } else {
            super.setProperty(propertyName, value);
        }
    }

    public void addData(String roleName, Object data) {
        if (data instanceof UnrecognizedState) {
            this.addUnrecognizedData(roleName, data);
        } else if (roleName.equals("ExclusiveFields")) {
            this.addExclusiveField((DtExclusiveFieldState)((Object)data));
        } else if (roleName.equals("InclusiveFields")) {
            this.addInclusiveField((DtInclusiveFieldState)((Object)data));
        } else if (roleName.equals("RenamedFields")) {
            this.addRenamedField((DtRenamedFieldState)((Object)data));
        } else if (roleName.equals("BelongingToJoinLeft")) {
            this.setBelongingToJoinLeft((Reference)data);
        } else if (roleName.equals("BelongingToJoinRight")) {
            this.setBelongingToJoinRight((Reference)data);
        } else if (roleName.equals("UsedStructure")) {
            this.setUsedStructure((Reference)data);
        } else {
            super.addData(roleName, data);
        }
    }
}

