/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.draw2d.layouts;

import com.tssap.selena.draw2d.layouts.PileLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class ShrinkablePileLayout
extends PileLayout {
    protected Set myShrinkedChildren = new HashSet();
    protected int myShrinkHeight;

    public void layout(IFigure container) {
        this.calculateShrinkables(container);
        super.layout(container);
    }

    protected void calculateShrinkables(IFigure container) {
        this.myShrinkHeight = Integer.MAX_VALUE;
        this.myShrinkedChildren.clear();
        ArrayList<IFigure> shrinkables = new ArrayList<IFigure>();
        int shrinkablesHeight = 0;
        int unshrinkablesHeight = 0;
        Iterator children = container.getChildren().iterator();
        while (children.hasNext()) {
            IFigure child = (IFigure)children.next();
            int childHeight = child.getPreferredSize().height;
            Object constraint = this.getConstraint(child);
            if (constraint instanceof ShrinkableConstraint && ((ShrinkableConstraint)constraint).canShrink()) {
                shrinkablesHeight += childHeight;
                shrinkables.add(child);
            } else {
                unshrinkablesHeight += childHeight;
            }
            unshrinkablesHeight += this.getGap();
        }
        unshrinkablesHeight -= this.getGap();
        if (shrinkables.isEmpty()) {
            return;
        }
        int freeHeight = container.getClientArea().height - unshrinkablesHeight;
        if (freeHeight >= shrinkablesHeight) {
            return;
        }
        Collections.sort(shrinkables, new Comparator(){

            public int compare(Object o1, Object o2) {
                IFigure f1 = (IFigure)o1;
                IFigure f2 = (IFigure)o2;
                int h1 = f1.getPreferredSize().height;
                int h2 = f2.getPreferredSize().height;
                return h2 - h1;
            }
        });
        while (!shrinkables.isEmpty()) {
            IFigure child = (IFigure)shrinkables.get(shrinkables.size() - 1);
            int childHeight = child.getPreferredSize().height;
            if (childHeight * shrinkables.size() > freeHeight) break;
            shrinkables.remove(shrinkables.size() - 1);
            freeHeight -= childHeight;
        }
        this.myShrinkedChildren.addAll(shrinkables);
        this.myShrinkHeight = freeHeight / shrinkables.size();
    }

    protected PileLayout.PileConstraint getPileConstraint(IFigure figure) {
        if (this.myShrinkedChildren.contains(figure)) {
            return new PileLayout.PileConstraint(){

                public void setChildBounds(Dimension preferred, Rectangle bounds, int hGap) {
                    bounds.height = Math.min(bounds.height, ShrinkablePileLayout.this.myShrinkHeight);
                }
            };
        }
        return super.getPileConstraint(figure);
    }

    public static interface ShrinkableConstraint {
        public boolean canShrink();
    }
}

