/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.draw2d.layouts;

import java.text.Collator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class PileLayout
extends AbstractLayout {
    private static Comparator COMPARATOR = new LabelComparator();
    private int myGap;
    private int myHGap;
    private int myTopSpacing;
    private Map myConstraints = new HashMap();
    public static final PileConstraint FILL = new PileConstraint(){

        public void setChildBounds(Dimension preferred, Rectangle bounds, int hGap) {
        }
    };
    public static final PileConstraint ALIGN_LEFT = new PileConstraint(){

        public void setChildBounds(Dimension preferred, Rectangle bounds, int hGap) {
            bounds.width = Math.min(preferred.width, bounds.width);
        }
    };
    public static final PileConstraint ALIGN_CENTER = new PileConstraint(){

        public void setChildBounds(Dimension preferred, Rectangle bounds, int hGap) {
            if (bounds.width > preferred.width) {
                int offset = (bounds.width - preferred.width) / 2;
                bounds.x += offset;
                bounds.width = preferred.width;
            }
        }
    };
    public static final PileConstraint ALIGN_RIGHT = new PileConstraint(){

        public void setChildBounds(Dimension preferred, Rectangle bounds, int hGap) {
            if (bounds.width > preferred.width) {
                bounds.x += bounds.width - preferred.width - hGap / 2;
                bounds.width = preferred.width;
            }
        }
    };
    private boolean myIsSorted;

    public PileLayout() {
        this(0);
    }

    public PileLayout(int spacing) {
        this.setTopSpacing(spacing);
        this.setSorted(false);
    }

    public int getGap() {
        return this.myGap;
    }

    public void setHorizontalGap(int hGap) {
        this.myHGap = hGap;
    }

    public void setSorted(boolean isSorted) {
        this.myIsSorted = isSorted;
    }

    public int getHorizontalGap() {
        return this.myHGap;
    }

    public void setTopSpacing(int spacing) {
        this.myTopSpacing = spacing;
    }

    public void setGap(int gap) {
        this.myGap = gap > 0 ? gap : 0;
    }

    public void remove(IFigure figure) {
        this.myConstraints.remove(figure);
    }

    public void setConstraint(IFigure figure, Object constraint) {
        if (constraint == null) {
            this.remove(figure);
        } else {
            this.myConstraints.put(figure, constraint);
        }
    }

    public Object getConstraint(IFigure figure) {
        return this.myConstraints.get(figure);
    }

    protected PileConstraint getPileConstraint(IFigure figure) {
        Object constraint = this.getConstraint(figure);
        return constraint instanceof PileConstraint ? (PileConstraint)constraint : FILL;
    }

    protected Dimension calculatePreferredSize(IFigure container) {
        int totalWidth = 0;
        int totalHeight = this.getTopSpacing();
        Iterator children = container.getChildren().iterator();
        while (children.hasNext()) {
            Dimension preferred = ((IFigure)children.next()).getPreferredSize();
            if (totalWidth < preferred.width) {
                totalWidth = preferred.width;
            }
            totalHeight += preferred.height + this.getGap();
        }
        totalHeight -= this.getGap();
        Insets insets = container.getInsets();
        totalWidth += insets.getWidth();
        return new Dimension(totalWidth += this.getHorizontalGap(), totalHeight += insets.getHeight());
    }

    public void layout(IFigure container) {
        Rectangle clientArea = container.getClientArea();
        int y = clientArea.y + this.getTopSpacing();
        int maxY = clientArea.y + clientArea.height;
        ArrayList copy = new ArrayList(container.getChildren());
        if (this.myIsSorted) {
            Collections.sort(copy, COMPARATOR);
        }
        Iterator children = ((AbstractList)copy).iterator();
        while (children.hasNext()) {
            IFigure child = (IFigure)children.next();
            Dimension preferred = child.getPreferredSize();
            int height = preferred.height;
            if (y >= maxY) break;
            if (y + height >= maxY && y + (height = child.getMinimumSize().height) >= maxY) {
                height = maxY - y;
            }
            Rectangle bounds = new Rectangle(clientArea.x + this.getHorizontalGap() / 2, y, clientArea.width - this.getHorizontalGap() / 2, height);
            this.getPileConstraint(child).setChildBounds(preferred, bounds, this.getHorizontalGap());
            child.setBounds(bounds);
            y += bounds.height + this.getGap();
        }
    }

    private int getTopSpacing() {
        return this.myTopSpacing;
    }

    public static interface PileConstraint {
        public void setChildBounds(Dimension var1, Rectangle var2, int var3);
    }

    private static class LabelComparator
    implements Comparator {
        private Comparator myTextComparator = Collator.getInstance();

        private LabelComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Label && o2 instanceof Label) {
                String t1 = ((Label)o1).getText();
                String t2 = ((Label)o2).getText();
                t1 = this.prepareString(t1);
                t2 = this.prepareString(t2);
                return this.myTextComparator.compare(t1, t2);
            }
            return 0;
        }

        private String prepareString(String t) {
            return t.replace('+', '1').replace('#', '2').replace(' ', '3').replace('-', '4');
        }
    }
}

