/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.draw2d;

import com.tssap.selena.draw2d.GDEFigure;
import com.tssap.selena.draw2d.InvisibleRectangle;
import com.tssap.selena.draw2d.layouts.FittingLayout;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class ShadowPlate
extends GDEFigure {
    private static final Color SHADOW_COLOR = new Color(null, 150, 150, 150);
    private static final int SHADOW_SIZE = 3;
    private static final Insets SHADOW_INSETS = new Insets(0, 0, 3, 3);
    private boolean myShadowVisible = true;

    public ShadowPlate() {
        super.setLayoutManager((LayoutManager)new FittingLayout());
    }

    public void setLayoutManager(LayoutManager lm) {
        throw new UnsupportedOperationException();
    }

    public boolean isShadowVisible() {
        return this.myShadowVisible;
    }

    public void setShadowVisible(boolean visible) {
        if (this.myShadowVisible == visible) {
            return;
        }
        this.myShadowVisible = visible;
        this.invalidate();
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (!(figure instanceof Shape)) {
            throw new IllegalArgumentException();
        }
        if (this.getChildren().size() > 0) {
            throw new IllegalStateException();
        }
        super.add(figure, constraint, index);
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (this.isShadowVisible()) {
            insets = insets.getAdded(SHADOW_INSETS);
        }
        return insets;
    }

    public Shape getChild() {
        List children = this.getChildren();
        if (children.isEmpty()) {
            return null;
        }
        return (Shape)children.get(0);
    }

    protected void paintFigure(Graphics graphics) {
        if (!this.isShadowVisible()) {
            return;
        }
        Shape shape = this.getChild();
        if (shape == null) {
            return;
        }
        graphics.pushState();
        graphics.translate(3, 3);
        graphics.setForegroundColor(SHADOW_COLOR);
        graphics.setBackgroundColor(SHADOW_COLOR);
        if (shape instanceof InvisibleRectangle) {
            InvisibleRectangle ir = (InvisibleRectangle)shape;
            this.paintChildren((IFigure)ir, graphics);
            Border border = ir.getBorder();
            if (border != null) {
                border.paint((IFigure)ir, graphics, IFigure.NO_INSETS);
            }
        } else {
            shape.paintFigure(graphics);
        }
        graphics.popState();
    }

    protected void paintChildren(IFigure figure, Graphics graphics) {
        graphics.pushState();
        Rectangle clip = Rectangle.SINGLETON;
        Iterator figures = figure.getChildren().iterator();
        while (figures.hasNext()) {
            Shape shape;
            IFigure child = (IFigure)figures.next();
            if (!(child instanceof Shape) || !(shape = (Shape)child).isVisible() || !shape.intersects(graphics.getClip(clip))) continue;
            graphics.clipRect(shape.getBounds());
            shape.paintFigure(graphics);
            Border border = shape.getBorder();
            if (border != null) {
                border.paint((IFigure)shape, graphics, IFigure.NO_INSETS);
            }
            graphics.restoreState();
        }
        graphics.popState();
    }
}

