/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.draw2d;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class GroupLabel
extends Label {
    private boolean myDecorationsVisible = true;
    protected int myDecorationsOffset = 8;
    protected int myLineDecorationsGap = 1;
    protected int myLineBorderGap = 0;
    protected int myLineWidth = 1;
    protected int myLineStyle = 1;

    public GroupLabel(String s) {
        super(s);
        this.init();
    }

    public GroupLabel(Image i) {
        super(i);
        this.init();
    }

    public GroupLabel(String s, Image i) {
        super(s, i);
        this.init();
    }

    protected void init() {
        this.setOpaque(false);
        super.setLabelAlignment(1);
    }

    protected int getDecorationOffset() {
        return this.myDecorationsOffset + this.myLineBorderGap + this.myLineDecorationsGap;
    }

    public final void add(IFigure figure, Object constraint, int index) {
        throw new UnsupportedOperationException();
    }

    public final void remove(IFigure figure) {
        throw new UnsupportedOperationException();
    }

    public final void removeAll() {
        throw new UnsupportedOperationException();
    }

    public void setLabelAlignment(int aligment) {
    }

    public boolean isDecorationsVisible() {
        return this.myDecorationsVisible;
    }

    public void setDecorationsVisible(boolean v) {
        if (this.myDecorationsVisible == v) {
            return;
        }
        this.myDecorationsVisible = v;
        this.repaint();
    }

    public void setDecorationsOffset(int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException(String.valueOf(offset));
        }
        if (this.myDecorationsOffset == offset) {
            return;
        }
        this.myDecorationsOffset = offset;
        this.repaint();
    }

    public void setLineDecorationsGap(int gap) {
        if (gap < 0) {
            throw new IllegalArgumentException(String.valueOf(gap));
        }
        if (this.myLineDecorationsGap == gap) {
            return;
        }
        this.myLineDecorationsGap = gap;
        this.repaint();
    }

    public void setLineBorderGap(int gap) {
        if (gap < 0) {
            throw new IllegalArgumentException(String.valueOf(gap));
        }
        if (this.myLineBorderGap == gap) {
            return;
        }
        this.myLineBorderGap = gap;
        this.repaint();
    }

    public void setLineWidth(int w) {
        if (w < 0) {
            throw new IllegalArgumentException(String.valueOf(w));
        }
        if (this.myLineWidth == w) {
            return;
        }
        this.myLineWidth = w;
        this.repaint();
    }

    public void setLineStyle(int s) {
        if (this.myLineStyle == s) {
            return;
        }
        this.myLineStyle = s;
        this.repaint();
    }

    public void paintFigure(Graphics graphics) {
        graphics.translate(this.getLocation());
        graphics.setLineWidth(this.myLineWidth);
        graphics.setLineStyle(this.myLineStyle);
        Rectangle bounds = this.getBounds();
        if (bounds.width > 2 * this.myLineBorderGap) {
            int lineY = bounds.height / 2 - this.myLineWidth / 2 + 1;
            graphics.drawLine(this.myLineBorderGap, lineY, bounds.width - this.myLineBorderGap - 1, lineY);
        }
        if (!this.isDecorationsVisible()) {
            graphics.translate(this.getLocation().negate());
            return;
        }
        graphics.translate(this.myDecorationsOffset - this.myLineDecorationsGap, 0);
        int labelZoneWidth = 2 * this.myLineDecorationsGap;
        if (this.getIcon() != null) {
            Dimension iconExtent = this.getIconBounds().getSize();
            labelZoneWidth += iconExtent.width;
        }
        if (this.getText().length() > 0) {
            if (this.getIcon() != null) {
                labelZoneWidth += this.getIconTextGap();
            }
            Dimension textExtent = FigureUtilities.getTextExtents((String)this.getText(), (Font)this.getFont());
            labelZoneWidth += textExtent.width;
        }
        Rectangle labelZone = new Rectangle(0, 0, labelZoneWidth, bounds.height);
        Color color = graphics.getForegroundColor();
        graphics.setForegroundColor(this.getBackgroundColor());
        graphics.fillRectangle(labelZone);
        graphics.setForegroundColor(color);
        graphics.translate(this.myLineDecorationsGap, 0);
        labelZone.width -= 2 * this.myLineDecorationsGap;
        Rectangle clip = graphics.getClip(new Rectangle());
        graphics.setClip(labelZone.intersect(clip));
        graphics.translate(this.getLocation().negate());
        super.paintFigure(graphics);
        graphics.setClip(clip);
        graphics.translate(-this.myDecorationsOffset, 0);
    }

    public Rectangle getIconBounds() {
        Rectangle rect = new Rectangle(super.getIconBounds());
        rect = rect.translate(this.myDecorationsOffset, 0);
        return rect;
    }
}

