/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.draw2d;

import com.tssap.selena.draw2d.InvisibleRectangle;
import com.tssap.selena.draw2d.layouts.FittingLayout;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;

public class EllipseShape
extends Ellipse {
    private InvisibleRectangle myContents = new InvisibleRectangle();
    private boolean myContentsTransform;

    public EllipseShape() {
        super.add((IFigure)this.myContents, null, -1);
        super.setLayoutManager((LayoutManager)new FittingLayout());
    }

    public IFigure getContents() {
        return this.myContents;
    }

    public void setContentsTransform(boolean transform) {
        this.myContentsTransform = transform;
    }

    public void setLayoutManager(LayoutManager lm) {
        throw new UnsupportedOperationException();
    }

    public final void add(IFigure figure, Object constraint, int index) {
        throw new UnsupportedOperationException();
    }

    public final void remove(IFigure figure) {
        throw new UnsupportedOperationException();
    }

    public final void removeAll() {
        throw new UnsupportedOperationException();
    }

    public void setFill(boolean b) {
        super.setFill(b);
        this.myContents.setFill(b);
    }

    public void setFillXOR(boolean b) {
        super.setFillXOR(b);
        this.myContents.setFillXOR(b);
    }

    public void setOutline(boolean b) {
        super.setOutline(b);
        this.myContents.setOutline(b);
    }

    public void setOutlineXOR(boolean b) {
        super.setOutlineXOR(b);
        this.myContents.setOutlineXOR(b);
    }

    public void setXOR(boolean b) {
        super.setXOR(b);
        this.myContents.setXOR(b);
    }

    public void setLineStyle(int lineStyle) {
        super.setLineStyle(lineStyle);
        this.myContents.setLineStyle(lineStyle);
    }

    public void setLineWidth(int lineWidth) {
        super.setLineWidth(lineWidth);
        this.myContents.setLineWidth(lineWidth);
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.getContents().setFont(f);
    }

    public void setBackgroundColor(Color c) {
        super.setBackgroundColor(c);
        this.getContents().setBackgroundColor(c);
    }

    public void setForegroundColor(Color c) {
        super.setForegroundColor(c);
        this.getContents().setForegroundColor(c);
    }

    public void setCursor(Cursor c) {
        super.setCursor(c);
        this.getContents().setCursor(c);
    }

    public void setEnabled(boolean e) {
        super.setEnabled(e);
        this.getContents().setEnabled(e);
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.getInsets();
        this.repaint();
    }

    public Insets getInsets() {
        int voff;
        int hoff;
        Insets insets = new Insets(super.getInsets());
        Rectangle bounds = this.getBounds();
        Dimension contentsSize = this.getContents().getPreferredSize();
        int bx = bounds.width / 2;
        int by = bounds.height / 2;
        int px = contentsSize.width / 2;
        int py = contentsSize.height / 2;
        if (px < bx - bx / 4) {
            hoff = bx - px;
            voff = by - this.getY(px);
        } else if (py < by - by / 4) {
            hoff = bx - this.getX(py);
            voff = by - py;
        } else {
            int x = this.getX(by / 2);
            hoff = bx - x;
            voff = by - this.getY(x);
        }
        insets.left = hoff;
        insets.right = hoff;
        insets.top = voff;
        insets.bottom = voff;
        return insets;
    }

    public Dimension getPreferredSize() {
        Dimension preferred = new Dimension(this.getContents().getPreferredSize());
        double SR = Math.sqrt(2.0);
        preferred.width = (int)((double)preferred.width * SR);
        preferred.height = (int)((double)preferred.height * SR);
        return preferred;
    }

    protected int getY(int x) {
        return this.getY(this.getBounds(), x);
    }

    protected int getY(Rectangle bounds, int x) {
        double a = bounds.width / 2;
        double b = bounds.height / 2;
        double rx = (double)x / a;
        return (int)(b * Math.sqrt(1.0 - rx * rx));
    }

    protected int getX(int y) {
        return this.getX(this.getBounds(), y);
    }

    protected int getX(Rectangle bounds, int y) {
        double a = bounds.width / 2;
        double b = bounds.height / 2;
        double ry = (double)y / b;
        return (int)(a * Math.sqrt(1.0 - ry * ry));
    }
}

