/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.system.naming.provider;

import com.sap.engine.system.naming.provider.Manager;
import com.sap.engine.system.naming.provider.ResolverManager;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.directory.InitialDirContext;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;

public class DefaultInitialContext
extends InitialDirContext {
    private Context defaultInitContext = null;

    public DefaultInitialContext(Hashtable environment) throws NamingException {
        super(environment);
        if (this.myProps.get("java.naming.factory.initial") != null) {
            this._getDefaultInitCtxt();
        }
    }

    private Context _getDefaultInitCtxt() throws NamingException {
        if (this.defaultInitContext == null) {
            InitialContextFactory fac;
            String initCtxtFactoryName = (String)this.myProps.get("java.naming.factory.initial");
            if (initCtxtFactoryName == null) {
                initCtxtFactoryName = "com.sap.engine.services.jndi.InitialContextFactoryImpl";
                this.myProps.put("java.naming.factory.initial", initCtxtFactoryName);
            }
            if ((fac = ((ResolverManager)Manager.getInstance()).findInitialContextFactory(this.myProps)) == null) {
                NoInitialContextException ne = new NoInitialContextException("failed to retrieve initial context factory " + initCtxtFactoryName);
                throw ne;
            }
            this.defaultInitContext = fac.getInitialContext(this.myProps);
        }
        return this.defaultInitContext;
    }

    public static String _getURLScheme(String str) {
        int colon_posn = str.indexOf(58);
        int slash_posn = str.indexOf(47);
        if (colon_posn > 0 && (slash_posn == -1 || colon_posn < slash_posn)) {
            return str.substring(0, colon_posn);
        }
        return null;
    }

    private Context _getURLContext(String scheme, Hashtable env) throws NamingException {
        ObjectFactory fac = null;
        fac = this._findURLContextFactory(scheme, env);
        if (fac == null) {
            return null;
        }
        try {
            return (Context)fac.getObjectInstance(null, null, null, env);
        }
        catch (ClassCastException cce) {
            NamingException ne = new NamingException("URL context factory for scheme " + scheme + " did not return implementation of javax.naming.Context: " + cce);
            ne.setRootCause(cce);
            throw ne;
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Error in URL context factory for scheme " + scheme);
            ne.setRootCause(e);
            throw ne;
        }
    }

    private ObjectFactory _findURLContextFactory(String scheme, Hashtable env) throws NamingException {
        return ((ResolverManager)Manager.getInstance()).findURLContextFactory(scheme, env);
    }

    protected Context getURLOrDefaultInitCtx(String name) throws NamingException {
        String scheme = DefaultInitialContext._getURLScheme(name);
        Context ctx = null;
        if (scheme != null) {
            ctx = this._getURLContext(scheme, this.myProps);
            if (ctx != null) {
                return ctx;
            }
            ctx = NamingManager.getURLContext(scheme, this.myProps);
            if (ctx != null) {
                return ctx;
            }
        }
        return this._getDefaultInitCtxt();
    }

    protected Context getDefaultInitCtx() throws NamingException {
        return this;
    }

    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        if (name.size() > 0) {
            String first = name.get(0);
            return this.getURLOrDefaultInitCtx(first);
        }
        return this._getDefaultInitCtxt();
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        this.myProps.put(propName, propVal);
        return this._getDefaultInitCtxt().addToEnvironment(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        this.myProps.remove(propName);
        return this._getDefaultInitCtxt().removeFromEnvironment(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this._getDefaultInitCtxt().getEnvironment();
    }

    public void close() throws NamingException {
        this.myProps = null;
        this._getDefaultInitCtxt().close();
        this.defaultInitCtx = null;
        this.gotDefault = false;
    }

    public String getNameInNamespace() throws NamingException {
        return this._getDefaultInitCtxt().getNameInNamespace();
    }
}

