/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.ant;

import com.sap.lcr.api.cimclient.CIMClient;
import com.sap.lcr.api.cimclient.CIMClientHandle;
import com.sap.lcr.api.cimclient.ClientFactory;
import com.sap.lcr.api.sapmodel.CIMInstancepathJavacimobject;
import com.sap.lcr.api.sapmodel.JavaCIMObject;
import com.sap.lcr.api.sapmodel.SAP_BuiltSoftwareDeliveryFile;
import com.sap.lcr.api.sapmodel.SAP_BuiltSoftwareDeliveryFileAccessor;
import com.sap.lcr.api.sapmodel.SAP_BuiltSoftwareDeliveryFileType;
import com.sap.lcr.api.sapmodel.SAP_BuiltSoftwareDeliveryFileTypeAccessor;
import com.sap.lcr.api.sapmodel.SAP_DevCompPatch;
import com.sap.lcr.api.sapmodel.SAP_DevCompPatchAccessor;
import com.sap.lcr.api.sapmodel.SAP_DevelopmentComponent;
import com.sap.lcr.api.sapmodel.SAP_DevelopmentComponentAccessor;
import com.sap.lcr.api.sapmodel.SAP_SoftwareComponent;
import com.sap.lcr.api.sapmodel.SAP_SoftwareComponentAccessor;
import com.sap.lcr.api.sapmodel.SAP_SoftwareDeliveryArchive;
import com.sap.lcr.api.sapmodel.SAP_SupportPackage;
import com.sap.sdm.ant.Component;
import com.sap.sdm.ant.FileSpec;
import com.sap.sdm.ant.JarSAPProcessing;
import com.sap.sdm.ant.LCREntryIF;
import com.sap.sdm.ant.ProcessingException;
import com.sap.sdm.ant.Property;
import com.sap.sdm.ant.SoftwareComponent;
import com.sap.sdm.ant.SupportPackage;
import com.sap.sdm.util.jarsl.ConstantsIF;
import com.sap.sdm.util.jarsl.Conv;
import com.sap.sdm.util.jarsl.FingerPrint;
import com.sap.sdm.util.jarsl.JarSL;
import com.sap.sdm.util.sduread.SdaFile;
import com.sap.sdm.util.sduread.SduFile;
import com.sap.sdm.util.sduread.SduReader;
import com.sap.security.core.server.secstorefs.SecStoreFS;
import java.io.File;
import java.net.URL;
import java.util.Vector;

public class LCREntry
implements LCREntryIF,
Runnable,
ConstantsIF {
    private static String LCRSUCCESSFUL = "LCR access successful finished";
    private Property property = null;
    private Component component = null;
    private SoftwareComponent softwarecomponent = null;
    private String archivename = null;
    private Vector logcontent = null;
    private String _processingexception = null;
    private String _processingstatus = null;
    private boolean performscreader = false;
    private boolean performpathentry = false;
    private CIMClientHandle clienthandle = null;
    private String lcruser = "jarsap";
    private String lcrpassword = "jarsappass";

    LCREntry(JarSAPProcessing processing, Vector logcontent) {
        this.property = processing.getProperty();
        this.component = processing.getComponent();
        this.archivename = processing.getArchiveName();
        this.logcontent = logcontent;
    }

    LCREntry(SoftwareComponent softwarecomponent, String lcrurl, String attrelease, String makelcrrel, String attscacreationwithoutsdaexistencecheck, String attscacreationwithoutidcheck, String secstoredatafilename, String secstorekeyfilename, Vector logcontent) {
        this.property = new Property();
        this.property.setProperty("lcrurl", lcrurl);
        this.property.setProperty("release", attrelease);
        this.property.setProperty("makelcr.rel", makelcrrel);
        this.property.setProperty("scacreationwithoutsdaexistencecheck", attscacreationwithoutsdaexistencecheck);
        this.property.setProperty("scacreationwithoutidcheck", attscacreationwithoutidcheck);
        this.property.setProperty("secstore.datafilename", secstoredatafilename);
        this.property.setProperty("secstore.keyfilename", secstorekeyfilename);
        this.softwarecomponent = softwarecomponent;
        this.logcontent = logcontent;
    }

    void log(String text) {
        this.logcontent.addElement(text);
    }

    public void run() {
        try {
            this._makeEntryIntoLCR();
            this._processingexception = LCRSUCCESSFUL;
        }
        catch (ProcessingException pex) {
            this._processingexception = pex.getMessage();
        }
    }

    public void makeEntryIntoLCR(boolean performpathentry, boolean performscreader) throws ProcessingException {
        int MAXCOUNTER = 3;
        int checklcrentry = 0;
        this.performpathentry = performpathentry;
        this.performscreader = performscreader;
        if (this.property.getProperty("checklcrentry") != null) {
            checklcrentry = new Integer(this.property.getProperty("checklcrentry"));
        }
        this.readLCRPassword();
        int counter = 0;
        while (counter < 3) {
            Thread t = new Thread(this);
            this._processingexception = null;
            this._processingstatus = "START";
            t.start();
            try {
                t.join(5000L);
                if (!this._processingstatus.equals("START")) {
                    t.join(40000L);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this._processingexception == null) {
                t.interrupt();
                t.stop();
                if (checklcrentry == 2) {
                    this.log("ERROR during LCR access: Cannot communicate with the LCR, no answer received.");
                    throw new ProcessingException("ERROR during LCR access: Cannot communicate with the LCR, no answer received.");
                }
                this.log("ERROR during LCR access: Cannot communicate with the LCR, no answer received.");
                break;
            }
            if (!this._processingexception.equals(LCRSUCCESSFUL) && checklcrentry != 2 && !this._processingstatus.equals("START")) {
                this.log("WARNING during LCR access: Received error during LCR access (" + this._processingexception + "), action will be repeated in 2 seconds.");
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception e) {}
            } else {
                if (this._processingexception.equals(LCRSUCCESSFUL)) break;
                throw new ProcessingException(this._processingexception);
            }
            ++counter;
        }
    }

    private void createSecStore() {
        SecStoreFS.setSID((String)"JARSAP");
        SecStoreFS secstore = new SecStoreFS();
        try {
            secstore.setFilenames("c:/secdata.txt", "c:/seckey.txt");
            secstore.createStoreWithEncryption("hter64ghe654", true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void fillSecStrore() {
        SecStoreFS.setSID((String)"JARSAP");
        SecStoreFS secstore = new SecStoreFS();
        try {
            secstore.setFilenames("c:/secdata.txt", "c:/seckey.txt");
            secstore.openExistingStore();
            secstore.insertPair("jarsap/lcruser", this.lcruser);
            secstore.insertPair("jarsap/lcrpassword", this.lcrpassword);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readLCRPassword() throws ProcessingException {
        if (this.property.getProperty("secstore.datafilename") != null && this.property.getProperty("secstore.keyfilename") != null) {
            SecStoreFS.setSID((String)"JARSAP");
            SecStoreFS secstore = new SecStoreFS();
            try {
                secstore.setFilenames(this.property.getProperty("secstore.datafilename"), this.property.getProperty("secstore.keyfilename"));
                secstore.openExistingStore();
                this.lcruser = secstore.getStringValue("jarsap/lcruser");
                this.lcrpassword = secstore.getStringValue("jarsap/lcrpassword");
            }
            catch (Exception e) {
                this.lcruser = null;
                this.lcrpassword = null;
                throw new ProcessingException("ERROR: Cannot communicate with SecStore " + e.getMessage());
            }
        }
    }

    private void _makeEntryIntoLCR() throws ProcessingException {
        int checklcrentry = 0;
        boolean makelcrentry = false;
        CIMClient client = null;
        if (this.property.getProperty("makelcrentry") != null) {
            makelcrentry = true;
        }
        if (this.property.getProperty("checklcrentry") != null && ((checklcrentry = new Integer(this.property.getProperty("checklcrentry")).intValue()) < 1 || checklcrentry > 2)) {
            throw new ProcessingException("ERROR in ANT call: The value of the given property checklcrentry must be between 1 and 2");
        }
        if (this.property.getProperty("lcrurl") == null) {
            this.log("ERROR during LCR access: missing lcrurl property in ant call");
            throw new ProcessingException("ERROR during LCR access: missing lcrurl property in ant call");
        }
        if (this.property.getProperty("dcrelease") == null) {
            this.log("ERROR during LCR access: missing dcrelease property in ant call");
            throw new ProcessingException("ERROR during LCR access: missing dcrelease property in ant call");
        }
        if (this.property.getProperty("makelcr.rel") == null) {
            this.log("ERROR during LCR access: missing makelcr.rel property in ant call");
            throw new ProcessingException("ERROR during LCR access: missing makelcr.rel property in ant call");
        }
        if (this.component == null) {
            return;
        }
        try {
            CIMInstancepathJavacimobject[] associatorarray;
            String _lcrurl = this.property.getProperty("lcrurl");
            _lcrurl = _lcrurl.replace('\\', '/');
            if (_lcrurl.toLowerCase().endsWith("/sld")) {
                _lcrurl = _lcrurl.substring(0, _lcrurl.length() - "/sld".length());
            }
            _lcrurl = _lcrurl.replace('\\', '/');
            String makerelease = this.property.getProperty("makelcr.rel");
            makerelease = makerelease.replace(']', '>');
            this.log("INFO during LCR access: ==>connection to URL " + _lcrurl + " with makelcrentry = " + (makelcrentry ? "true and checklcrentry = " : "false and checklcrentry = ") + checklcrentry);
            ClientFactory clientfactory = ClientFactory.newInstance();
            client = new CIMClient(clientfactory.createClient(new URL(_lcrurl), this.lcruser, this.lcrpassword));
            String dcrelease = this.property.getProperty("dcrelease");
            SAP_DevelopmentComponent devcomp = new SAP_DevelopmentComponent("0", this.component.getImpltitle(), this.component.getImplvendorid(), dcrelease);
            SAP_BuiltSoftwareDeliveryFile bsdf = new SAP_BuiltSoftwareDeliveryFile("]" + dcrelease + "]" + this.component.getImplvendorid() + "]" + this.component.getImpltitle(), "0", 0, 0, "]" + makerelease + "]" + this.component.getImplversion());
            SAP_BuiltSoftwareDeliveryFileAccessor bsdfacc = new SAP_BuiltSoftwareDeliveryFileAccessor((CIMClientHandle)client);
            SAP_DevelopmentComponentAccessor devcompacc = new SAP_DevelopmentComponentAccessor((CIMClientHandle)client);
            SAP_BuiltSoftwareDeliveryFileTypeAccessor assocacc = new SAP_BuiltSoftwareDeliveryFileTypeAccessor((CIMClientHandle)client);
            this._processingstatus = "RUNNING";
            try {
                if (new SAP_DevelopmentComponentAccessor((CIMClientHandle)client).getInstance(devcomp.toCIMInstancename()) == null) {
                    throw new Exception("CIM_ERR_NOT_FOUND");
                }
            }
            catch (Exception e) {
                if (e.getMessage().substring(0, "CIM_ERR_NOT_FOUND".length()).equals("CIM_ERR_NOT_FOUND")) {
                    if (checklcrentry == 2) {
                        this.log("ERROR during LCR access: The following DC is not maintained in the LCR: (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ")");
                        throw new ProcessingException("ERROR during LCR access: The following DC is not maintained in the LCR: (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ")");
                    }
                    this.log("WARNING during LCR access: The following DC is not maintained in the LCR: (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ")");
                    client.disconnect();
                    client = null;
                    return;
                }
                if (checklcrentry == 2 || makelcrentry) {
                    throw e;
                }
                this.log("WARNING during LCR access: " + e.getMessage());
                client.disconnect();
                client = null;
                return;
            }
            if (this.performpathentry) {
                CIMInstancepathJavacimobject[] associatorarray2;
                this.log("INFO during LCR access: look for associated SAP_DevCompPatches and linked SAP_BuiltSoftwareDeliveryFiles");
                associatorarray = devcompacc.associators((JavaCIMObject)devcomp, "SAP_PatchedDevComp", "SAP_DevCompPatch", null, null, null);
                if (associatorarray == null || associatorarray.length == 0) {
                    if (checklcrentry == 2) {
                        this.log("ERROR during LCR access: No patch is maintained for the DC: (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ")");
                        throw new ProcessingException("ERROR during LCR access: No patch is maintained for the DC: (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ")");
                    }
                    this.log("WARNING during LCR access: No patch is maintained for the DC: (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ")");
                    client.disconnect();
                    client = null;
                    return;
                }
                SAP_DevCompPatch devcompp = (SAP_DevCompPatch)associatorarray[0].getJavaCIMObject();
                if (makelcrentry && (associatorarray2 = assocacc.associators(devcompp.toCIMInstancename(), "SAP_BuiltSoftwareDeliveryFileType", "SAP_BuiltSoftwareDeliveryFile", null, null, null)) != null) {
                    int ii = 0;
                    while (ii < associatorarray2.length) {
                        SAP_BuiltSoftwareDeliveryFile bsdf_d = (SAP_BuiltSoftwareDeliveryFile)associatorarray2[ii].getJavaCIMObject();
                        if (bsdf_d.getVersion().startsWith(makerelease + "]")) {
                            client.deleteInstance(bsdf_d.toCIMInstancename(), true);
                            this.log("INFO during LCR access: BuiltSoftwareDeliveryFile LCR object incl. association deleted for the DC (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ") in makerelease " + makerelease);
                        } else if (bsdf_d.getVersion().startsWith("]" + makerelease + "]") && bsdf_d.getName().startsWith("]" + dcrelease + "]" + this.component.getImplvendorid() + "]") && !bsdf_d.toCIMInstancename().equals((Object)bsdf.toCIMInstancename())) {
                            client.deleteInstance(bsdf_d.toCIMInstancename(), true);
                            this.log("INFO during LCR access: BuiltSoftwareDeliveryFile LCR object incl. association deleted for the DC (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ") in makerelease " + makerelease);
                        }
                        ++ii;
                    }
                }
                if (makelcrentry) {
                    bsdf.setBuildPath(this.archivename);
                    bsdf.setCaption(new File(this.archivename).getName());
                    bsdf.setIdentificationCode(new FingerPrint(Conv.pathConv((String)this.archivename)).calcMD5());
                    try {
                        if (bsdfacc.getInstance(bsdf.toCIMInstancename()) == null) {
                            throw new Exception("CIM_ERR_NOT_FOUND");
                        }
                        bsdfacc.modifyInstance((JavaCIMObject)bsdf);
                        this.log("INFO during LCR access: BuiltSoftwareDeliveryFile LCR object modified for the DC (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ") in makerelease " + makerelease);
                    }
                    catch (Exception e) {
                        if (e.getMessage().substring(0, "CIM_ERR_NOT_FOUND".length()).equals("CIM_ERR_NOT_FOUND")) {
                            bsdfacc.createInstance((JavaCIMObject)bsdf);
                            this.log("INFO during LCR access: BuiltSoftwareDeliveryFile LCR object created for the DC (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ") in makerelease " + makerelease);
                        }
                        throw e;
                    }
                }
                if (makelcrentry) {
                    SAP_BuiltSoftwareDeliveryFileType assoc = new SAP_BuiltSoftwareDeliveryFileType(devcompp.toCIMInstancename().toCIMObjectReference(), bsdf.toCIMInstancename().toCIMObjectReference());
                    try {
                        if (assocacc.getInstance(assoc.toCIMInstancename()) == null) {
                            throw new Exception("CIM_ERR_NOT_FOUND");
                        }
                    }
                    catch (Exception e) {
                        if (e.getMessage().substring(0, "CIM_ERR_NOT_FOUND".length()).equals("CIM_ERR_NOT_FOUND")) {
                            assocacc.createInstance((JavaCIMObject)assoc);
                            this.log("INFO during LCR access: BuiltSoftwareDeliveryFileType LCR association created for the DC (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ") in makerelease " + makerelease);
                        }
                        throw e;
                    }
                }
            }
            if (this.performscreader) {
                this.log("INFO during LCR access: look for the associated SAP_SoftwareComponent");
                associatorarray = devcompacc.associators((JavaCIMObject)devcomp, "SAP_SoftwareComponentDevComp", "SAP_SoftwareComponent", null, null, null);
                if (associatorarray == null || associatorarray.length != 1) {
                    if (checklcrentry == 2) {
                        this.log("ERROR during LCR access: No or more than one softwarecomponent is associated with the DC: (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ")");
                        throw new ProcessingException("ERROR during LCR access: No or more than one softwarecomponent is associated with the DC: (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ")");
                    }
                    this.log("WARNING during LCR access: No or more than one softwarecomponent is associated with the DC: (0," + this.component.getImpltitle() + "," + this.component.getImplvendorid() + "," + dcrelease + ")");
                    client.disconnect();
                    client = null;
                    return;
                }
                SAP_SoftwareComponent soco = (SAP_SoftwareComponent)associatorarray[0].getJavaCIMObject();
                this.property.setProperty("Softwarecomponent-Name", soco.getName());
                this.property.setProperty("Softwarecomponent-Vendor", soco.getVendor());
                this.property.setProperty("release", soco.getVersion());
                this.property.setProperty("Softwarecomponent-Ppmsnumber", soco.getElementTypeID());
            }
        }
        catch (Exception e) {
            this._processingstatus = "ERROR";
            if (client != null) {
                client.disconnect();
                client = null;
            }
            if (e instanceof ProcessingException) {
                throw (ProcessingException)e;
            }
            if (checklcrentry == 2 || makelcrentry) {
                this.log("ERROR during LCR access: " + e.getMessage());
                throw new ProcessingException("ERROR during LCR access: " + e.getMessage());
            }
            this.log("WARNING during LCR access: " + e.getMessage());
            return;
        }
    }

    public void performLCRConnect() throws Exception {
        try {
            String _lcrurl = this.property.getProperty("lcrurl");
            _lcrurl = _lcrurl.replace('\\', '/');
            if (_lcrurl.toLowerCase().endsWith("/sld")) {
                _lcrurl = _lcrurl.substring(0, _lcrurl.length() - "/sld".length());
            }
            this.log("INFO during LCR access: ==>connection to URL " + _lcrurl);
            this.readLCRPassword();
            ClientFactory clientfactory = ClientFactory.newInstance();
            CIMClient client = new CIMClient(clientfactory.createClient(new URL(_lcrurl), this.lcruser, this.lcrpassword));
            this.clienthandle = client;
        }
        catch (Exception e) {
            this.log("ERROR during LCR access: " + e.getMessage());
            throw new Exception("ERROR during LCR access: " + e.getMessage());
        }
    }

    public void performLCRDisconnect() {
        if (this.clienthandle != null) {
            this.clienthandle.disconnect();
        }
    }

    public void getSupportPackageInfoFromLCR(SupportPackage supportpackage) throws Exception {
        SAP_SoftwareComponent softcomp = new SAP_SoftwareComponent(this.softwarecomponent.getPpmsnumber(), this.softwarecomponent.getName(), this.softwarecomponent.getVendor(), this.property.getProperty("release"));
        SAP_SupportPackage supa = null;
        SAP_SoftwareComponentAccessor softcompacc = new SAP_SoftwareComponentAccessor(this.clienthandle);
        try {
            CIMInstancepathJavacimobject[] associatorarray = softcompacc.associators((JavaCIMObject)softcomp, "SAP_SupportPackageSoftwareComponent", "SAP_SupportPackage", null, null, null);
            if (associatorarray != null) {
                if (supportpackage.getServicelevel() == null) {
                    int _spversion = -1;
                    int _place = -1;
                    int i = 0;
                    while (i < associatorarray.length) {
                        supa = (SAP_SupportPackage)associatorarray[i].getJavaCIMObject();
                        if (new Integer(supa.getVersion()) > _spversion) {
                            _spversion = new Integer(supa.getVersion());
                            _place = i;
                        }
                        ++i;
                    }
                    if (_spversion != -1) {
                        supa = (SAP_SupportPackage)associatorarray[_place].getJavaCIMObject();
                        supportpackage.setServicelevel(new Integer(supa.getVersion()).toString());
                        supportpackage.setName(supa.getName());
                        supportpackage.setVersion(supa.getVersion());
                        supportpackage.setPpmsnumber(supa.getElementTypeID());
                    } else {
                        this.log("WARNING during LCR access: no association between given softwarecomponent (" + softcomp.getName() + ") and related supportpackages");
                    }
                } else {
                    boolean found = false;
                    int i = 0;
                    while (i < associatorarray.length) {
                        supa = (SAP_SupportPackage)associatorarray[i].getJavaCIMObject();
                        if (new Integer(supa.getVersion()).toString().equals(supportpackage.getServicelevel())) {
                            supportpackage.setName(supa.getName());
                            supportpackage.setVersion(supa.getVersion());
                            supportpackage.setPpmsnumber(supa.getElementTypeID());
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (!found) {
                        this.log("WARNING during LCR access: no association between given softwarecomponent (" + softcomp.getName() + ") and supportpackage with spversion=" + supportpackage.getServicelevel());
                    }
                }
            } else {
                this.log("WARNING during LCR access: no association between given softwarecomponent (" + softcomp.getName() + ") and related supportpackages");
            }
        }
        catch (Exception e) {
            this.log("ERROR during LCR access: " + e.getMessage());
            throw new Exception("ERROR during LCR access: " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int addDevelopmentComponentsToArchive(Vector sdafiles, Vector tldccomp, boolean printonlyscacontent) throws Exception, ProcessingException {
        int numberofnotfoundarchives = 0;
        String pathname = null;
        try {
            String makerelease = this.property.getProperty("makelcr.rel");
            makerelease = makerelease.replace(']', '>');
            SAP_SoftwareComponentAccessor softcompacc = new SAP_SoftwareComponentAccessor(this.clienthandle);
            SAP_DevelopmentComponentAccessor devcompacc = new SAP_DevelopmentComponentAccessor(this.clienthandle);
            SAP_DevCompPatchAccessor devcomppatchacc = new SAP_DevCompPatchAccessor(this.clienthandle);
            SAP_SoftwareComponent softcomp = new SAP_SoftwareComponent(this.softwarecomponent.getPpmsnumber(), this.softwarecomponent.getName(), this.softwarecomponent.getVendor(), this.property.getProperty("release"));
            CIMInstancepathJavacimobject[] associatorarray = softcompacc.associators((JavaCIMObject)softcomp, "SAP_SoftwareComponentDevComp", "SAP_DevelopmentComponent", null, null, null);
            if (associatorarray == null || associatorarray.length == 0) {
                throw new ProcessingException("ERROR during LCR access: no association between given softwarecomponent (" + softcomp.getName() + ") and related developmentcomponents");
            }
            int i = 0;
            while (i < associatorarray.length) {
                CIMInstancepathJavacimobject[] associatorarraydc = devcompacc.associators((JavaCIMObject)((SAP_DevelopmentComponent)associatorarray[i].getJavaCIMObject()), "SAP_PatchedDevComp", "SAP_DevCompPatch", null, null, null);
                if (associatorarraydc == null || associatorarraydc.length == 0) {
                    if (!printonlyscacontent) throw new ProcessingException("ERROR during LCR access: no association between developmentcomponent (" + ((SAP_DevelopmentComponent)associatorarray[i].getJavaCIMObject()).getName() + ") and related devcomppatch");
                    this.log("ERROR during LCR access: no association between developmentcomponent (" + ((SAP_DevelopmentComponent)associatorarray[i].getJavaCIMObject()).getName() + ") and related devcomppatch");
                } else {
                    String _dcrelease = ((SAP_DevelopmentComponent)associatorarray[i].getJavaCIMObject()).getVersion();
                    String _vendor = ((SAP_DevelopmentComponent)associatorarray[i].getJavaCIMObject()).getVendor();
                    SAP_DevCompPatch devcompp = (SAP_DevCompPatch)associatorarraydc[0].getJavaCIMObject();
                    CIMInstancepathJavacimobject[] associatorarraypa = devcomppatchacc.associators((JavaCIMObject)devcompp, "SAP_BuiltSoftwareDeliveryFileType", "SAP_BuiltSoftwareDeliveryFile", null, null, null);
                    SAP_BuiltSoftwareDeliveryFile bsdf = null;
                    int k = 0;
                    while (associatorarraypa != null && k < associatorarraypa.length) {
                        SAP_BuiltSoftwareDeliveryFile _bsdf = (SAP_BuiltSoftwareDeliveryFile)associatorarraypa[k].getJavaCIMObject();
                        if (_bsdf.getVersion().startsWith(makerelease + "]") || _bsdf.getVersion().startsWith("]" + makerelease + "]") && _bsdf.getName().startsWith("]" + _dcrelease + "]" + _vendor + "]")) {
                            if (bsdf != null) {
                                if (!printonlyscacontent) throw new ProcessingException("ERROR during LCR access: more than one association between devcomppatch (" + devcompp.getName() + ") and related builtsoftwaredeliveryfile in makerelease " + makerelease);
                                this.log("ERROR during LCR access: more than one association between devcomppatch (" + devcompp.getName() + ") and related builtsoftwaredeliveryfile in makerelease " + makerelease);
                                bsdf = null;
                                break;
                            }
                            bsdf = _bsdf;
                        }
                        ++k;
                    }
                    if (bsdf == null) {
                        if (!printonlyscacontent) throw new ProcessingException("ERROR during LCR access: no association between devcomppatch (" + devcompp.getName() + ") and related builtsoftwaredeliveryfile in makerelease " + makerelease);
                        this.log("ERROR during LCR access: no or more than one association between devcomppatch (" + devcompp.getName() + ") and related builtsoftwaredeliveryfile in makerelease " + makerelease);
                    } else {
                        pathname = bsdf.getBuildPath();
                        if (pathname == null) {
                            if (!printonlyscacontent) throw new ProcessingException("ERROR during LCR access: no archive path defined for softwaredeliveryarchive (" + ((SAP_SoftwareDeliveryArchive)associatorarraydc[0].getJavaCIMObject()).getName() + ")");
                            this.log("ERROR during LCR access: no archive path defined for softwaredeliveryarchive (" + ((SAP_SoftwareDeliveryArchive)associatorarraydc[0].getJavaCIMObject()).getName() + ")");
                        } else if (printonlyscacontent) {
                            this.log("INFO during LCR access: " + pathname + " is associated to the given software component");
                        } else if (!JarSL.checkFileExistence((String)pathname)) {
                            ++numberofnotfoundarchives;
                            if (this.property.getProperty("scacreationwithoutsdaexistencecheck") == null || !this.property.getProperty("scacreationwithoutsdaexistencecheck").equalsIgnoreCase("true")) throw new ProcessingException("Error: file " + pathname + " does not exist on filesystem");
                            this.log("Warning: file " + pathname + " does not exist on filesystem");
                        } else {
                            SduFile sdufile;
                            if (this.property.getProperty("scacreationwithoutidcheck") != null && this.property.getProperty("scacreationwithoutidcheck").equalsIgnoreCase("true")) {
                                this.log("INFO during LCR access: SCA creation without ID-check");
                            } else if (!bsdf.getIdentificationCode().equals(new FingerPrint(Conv.pathConv((String)pathname)).calcMD5())) {
                                throw new ProcessingException("ERROR during LCR access: archive (" + pathname + ") has a wrong identificationcode or is not present on filesystem");
                            }
                            try {
                                sdufile = SduReader.getInstance().readFile(pathname, false);
                                if (!(sdufile instanceof SdaFile)) {
                                    throw new Exception();
                                }
                            }
                            catch (Exception e) {
                                throw new ProcessingException("Error: the builtsoftwaredeliveryfile is refering the file " + pathname + " which is not a correct SDA " + e.getMessage());
                            }
                            if (((SdaFile)sdufile).getSoftwareType() == null) {
                                this.log("Info: file " + pathname + " is not a deployable archive, it will not be added to the sca");
                            } else {
                                sdafiles.addElement(new FileSpec(new File(pathname).getParent(), new File(pathname).getName()));
                                tldccomp.addElement((SdaFile)sdufile);
                            }
                        }
                    }
                }
                ++i;
            }
            return numberofnotfoundarchives;
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            this.log("ERROR during LCR access: " + e.getMessage());
            throw new Exception("ERROR during LCR access: " + e.getMessage());
        }
    }
}

