/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.ant;

import com.sap.sdm.ant.Attribute;
import com.sap.sdm.ant.Component;
import com.sap.sdm.ant.DBFileContent;
import com.sap.sdm.ant.DBSelect;
import com.sap.sdm.ant.Dependency;
import com.sap.sdm.ant.FileSpec;
import com.sap.sdm.ant.LCREntryFactoryIF;
import com.sap.sdm.ant.LCREntryIF;
import com.sap.sdm.ant.MFEntry;
import com.sap.sdm.ant.Manifest;
import com.sap.sdm.ant.PlattformConstants;
import com.sap.sdm.ant.ProcessingException;
import com.sap.sdm.ant.ProjectInfo;
import com.sap.sdm.ant.Property;
import com.sap.sdm.ant.SharedLibraries;
import com.sap.sdm.ant.SoftwareTypeReader;
import com.sap.sdm.util.dbaccess.DBTask;
import com.sap.sdm.util.dbaccess.Selection;
import com.sap.sdm.util.init.UtilInitializer;
import com.sap.sdm.util.jarsl.ConstantsIF;
import com.sap.sdm.util.jarsl.Conv;
import com.sap.sdm.util.jarsl.JarSL;
import com.sap.sl.util.components.api.ComponentElementIF;
import com.sap.sl.util.components.api.ComponentFactoryIF;
import com.sap.sl.util.components.xml.api.ComponentElementXMLizerFactoryIF;
import com.sap.sl.util.components.xml.api.ComponentElementXMLizerIF;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;

public final class JarSAPProcessing
implements ConstantsIF {
    public static String DEF_jarsapprocessingversion = "20041217.1600";
    static String DEF_specificationvendor = "SAP AG";
    static String DEF_sapinternal = "false";
    private File jarfile = null;
    private File basedir = null;
    private boolean compress = true;
    private File deployfile = null;
    private String softwaresubtype = null;
    private File docfile = null;
    private String mainclass;
    private String softwaretype;
    private FileSpec[] filelist = null;
    private FileSpec[] publicfilelist = null;
    private Component component = null;
    private Vector subdependencies = new Vector();
    private Vector submfentries = new Vector();
    private Vector submanifests = new Vector();
    private Vector subsharedlibraries = new Vector();
    private Vector dbselects = new Vector();
    private Vector dbfilecontents = new Vector();
    private String sapinternal = DEF_sapinternal;
    private boolean nodbcontent = false;
    private boolean jumparchive = false;
    private boolean checkiscurrentarchiveisuptodate = false;
    private Property property = null;
    private Vector logcontent = new Vector();
    private String jarsapmode = "jarsapmode";
    private ProjectInfo projectInfo = null;
    private boolean lcrconnectionfailed = false;
    private String updateversion = null;

    JarSAPProcessing() {
    }

    void setProperty(Property property) {
        this.property = property;
    }

    Property getProperty() {
        return this.property;
    }

    void log(String text) {
        this.logcontent.addElement(text);
    }

    String[] getLogs() {
        String[] result = new String[this.logcontent.size()];
        int i = 0;
        while (i < this.logcontent.size()) {
            result[i] = (String)this.logcontent.elementAt(i);
            ++i;
        }
        return result;
    }

    public static String getVersionInfo() {
        return DEF_jarsapprocessingversion;
    }

    void setFilelist(FileSpec[] filelist) {
        this.filelist = filelist;
    }

    void setPublicFilelist(FileSpec[] publicfilelist) {
        this.publicfilelist = publicfilelist;
    }

    void setSharedLibraries(Vector subsharedlibraries) {
        this.subsharedlibraries = subsharedlibraries;
    }

    void setDBSelects(Vector dbselects) {
        this.dbselects = dbselects;
    }

    void setDBFileContents(Vector dbfilecontents) {
        this.dbfilecontents = dbfilecontents;
    }

    void setComponent(Component component) {
        this.component = component;
    }

    Component getComponent() {
        return this.component;
    }

    void setDependency(Vector subdependencies) {
        this.subdependencies = subdependencies;
    }

    void setMFEntry(Vector submfentries) {
        this.submfentries = submfentries;
    }

    void setManifest(Vector submanifests) {
        this.submanifests = submanifests;
    }

    void setJarSAPMode(String mode) {
        this.jarsapmode = mode;
    }

    void setJarfile(File jarfile) {
        this.jarfile = jarfile;
    }

    String getArchiveName() {
        return this.jarfile.getPath();
    }

    void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    File getBasedir() {
        return this.basedir;
    }

    void setCompress(String compress) {
        this.compress = compress.trim().toLowerCase().equals("true") || compress.trim().toLowerCase().equals("yes");
    }

    void setManifest(String manifest) {
    }

    void setDeployfile(File deployfile) {
        this.deployfile = deployfile;
    }

    void setSoftwaresubtype(String softwaresubtype) {
        this.softwaresubtype = softwaresubtype;
    }

    void setDocfile(File docfile) {
        this.docfile = docfile;
    }

    void setMainclass(String mainclass) {
        this.mainclass = mainclass;
    }

    void setSapinternal(String sapinternal) {
        this.sapinternal = sapinternal.toLowerCase();
    }

    void setSoftwaretype(String softwaretype) {
        this.softwaretype = softwaretype;
    }

    void setOnlybuildifnew(String onlybuildifnew) {
        if (onlybuildifnew.trim().toLowerCase().equals("true") || onlybuildifnew.trim().toLowerCase().equals("yes")) {
            this.checkiscurrentarchiveisuptodate = true;
        }
    }

    boolean preevaluation() {
        String dbc;
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Date currTime = new Date();
        int i = 0;
        while (i < this.subdependencies.size()) {
            Dependency dep = (Dependency)this.subdependencies.elementAt(i);
            if (dep.getComponent() != null) {
                dep.getComponent().setVendor(dep.getVendor());
                dep.getComponent().setCounter(dep.getCounter());
                dep.getComponent().setImplvendor(dep.getImplvendor());
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.submanifests.size()) {
            Attribute att;
            Manifest man = (Manifest)this.submanifests.elementAt(i2);
            int j = 0;
            while (j < man.getAttributes().length) {
                att = man.getAttributes()[j];
                MFEntry mfe = new MFEntry();
                mfe.setEntry(att.getEntry());
                mfe.setAttribute(att.getName());
                mfe.setValue(att.getValue());
                this.submfentries.addElement(mfe);
                ++j;
            }
            int j2 = 0;
            while (j2 < man.getEntries().length) {
                int k = 0;
                while (k < man.getEntries()[j2].getAttributes().length) {
                    att = man.getEntries()[j2].getAttributes()[k];
                    MFEntry mfe = new MFEntry();
                    mfe.setEntry(att.getEntry());
                    mfe.setAttribute(att.getName());
                    mfe.setValue(att.getValue());
                    this.submfentries.addElement(mfe);
                    ++k;
                }
                ++j2;
            }
            ++i2;
        }
        if (this.component != null) {
            if (this.component.getSpecificationvendor() == null) {
                this.component.setSpecificationvendor(DEF_specificationvendor);
            }
            if (this.component.getCounter() != null && this.component.getCounter().equals("AUTO")) {
                this.component.setCounter(null);
            }
            if (this.property.getProperty("localmake") != null) {
                this.component.setVendor("sap.com");
                this.component.setLocation("LOCAL");
                this.component.setImplvendor("SAP AG");
                this.component.setCounter("AUTO");
            } else {
                if (this.component.getVendor() == null) {
                    this.component.setVendor(this.property.getProperty("keyvendor"));
                }
                if (this.component.getCounter() == null) {
                    this.component.setCounter(this.property.getProperty("keycounter"));
                }
                if (this.component.getLocation() == null) {
                    this.component.setLocation(this.property.getProperty("keylocation"));
                }
                if (this.component.getLocation() == null) {
                    this.component.setLocation("SAP AG");
                }
                if (this.component.getImplvendor() == null) {
                    this.component.setImplvendor(this.property.getProperty("Implementation-Vendor"));
                }
            }
            if (this.component.getCounter() != null && this.component.getCounter().equals("AUTO")) {
                this.component.setCounter("999." + df.format(currTime));
            }
        }
        if (this.property.getProperty("docfile") != null) {
            this.docfile = new File(this.property.getProperty("docfile"));
        }
        if (this.property.getProperty("connectparameters") != null) {
            int i3 = 0;
            while (i3 < this.dbselects.size()) {
                DBSelect dbs = (DBSelect)this.dbselects.elementAt(i3);
                if (dbs.getConnectParams() == null) {
                    dbs.setConnectParams(this.property.getProperty("connectparameters"));
                }
                ++i3;
            }
        }
        if (this.property.getProperty("nodbcontent") != null && ((dbc = this.property.getProperty("nodbcontent")).toLowerCase() == "yes" || dbc.toLowerCase() == "true")) {
            this.nodbcontent = true;
        }
        this.updateversion = this.property.getProperty("finalversion") != null && this.property.getProperty("finalversion").equalsIgnoreCase("true") ? "FB-" + df.format(currTime) : "LB-" + df.format(currTime);
        return true;
    }

    private boolean consistencyCheck() {
        int i;
        boolean failed = false;
        if (this.jarfile == null) {
            failed = true;
            this.log("Error consistencyCheck: missing jarfile name for jarsap element");
        }
        if (this.nodbcontent && (this.dbselects.size() > 0 || this.dbfilecontents.size() > 0)) {
            this.log("INFO: the archive contains database content or schemata and will not be created because property nodbcontent is set");
            this.jumparchive = true;
            return true;
        }
        if (this.component != null && (this.component.getName() == null || this.component.getVendor() == null || this.component.getLocation() == null || this.component.getCounter() == null)) {
            failed = true;
            if (this.component.getName() == null) {
                this.log("Error consistencyCheck: missing name/implementationtitle for component element");
            }
            if (this.component.getVendor() == null) {
                this.log("Error consistencyCheck: Property vendor/Implementation-Vendor-Id not supplied in ant call");
            }
            if (this.component.getLocation() == null) {
                this.log("Error consistencyCheck: Property location not supplied in ant call");
            }
            if (this.component.getCounter() == null) {
                this.log("Error consistencyCheck: Property counter/Implementation-Version not supplied in ant call");
            }
        } else if (this.component != null && (this.component.getName().equals("") || this.component.getVendor().equals("") || this.component.getLocation().equals("") || this.component.getCounter().equals(""))) {
            failed = true;
            if (this.component.getName().equals("")) {
                this.log("Error consistencyCheck: empty name/implementationtitle in component element");
            }
            if (this.component.getVendor().equals("")) {
                this.log("Error consistencyCheck: empty vendor/Implementation-Vendor-Id");
            }
            if (this.component.getLocation().equals("")) {
                this.log("Error consistencyCheck: empty location");
            }
            if (this.component.getCounter().equals("")) {
                this.log("Error consistencyCheck: empty counter/Implementation-Version");
            }
        } else if (this.component != null) {
            String allowedcharacters = "0123456789.";
            char[] _counter = this.component.getCounter().toCharArray();
            i = 0;
            while (i < _counter.length) {
                if (allowedcharacters.indexOf(_counter[i]) == -1) {
                    failed = true;
                    this.log("Error consistencyCheck: wrong counter/Implementation-Version format");
                    break;
                }
                ++i;
            }
        }
        if (this.dbselects.size() > 0) {
            boolean _rc = true;
            if (this.filelist != null && this.filelist.length > 0) {
                this.log("Error consistencyCheck: the element fileset is not allowed in combination with the element dbselect");
                _rc = false;
            }
            if (this.publicfilelist != null && this.publicfilelist.length > 0) {
                this.log("Error consistencyCheck: the element publicfileset is not allowed in combination with the element dbselect");
                _rc = false;
            }
            if (this.subsharedlibraries.size() > 0) {
                this.log("Error consistencyCheck: the element sharedlibraries is not allowed in combination with the element dbselect");
                _rc = false;
            }
            if (this.basedir != null) {
                this.log("Error consistencyCheck: the attribute basedir of the jarsap element is not allowed in combination with the element dbselect");
                _rc = false;
            }
            if (this.dbfilecontents.size() > 0) {
                this.log("Error consistencyCheck: the element dbfilecontents is not allowed in combination with the element dbselect");
                _rc = false;
            }
            if (!_rc) {
                return false;
            }
        }
        if (this.dbfilecontents.size() > 0) {
            boolean _rc = true;
            if (this.filelist != null && this.filelist.length > 0) {
                this.log("Error consistencyCheck: the element fileset is not allowed in combination with the element dbfilecontent");
                _rc = false;
            }
            if (this.publicfilelist != null && this.publicfilelist.length > 0) {
                this.log("Error consistencyCheck: the element publicfileset is not allowed in combination with the element dbfilecontent");
                _rc = false;
            }
            if (this.subsharedlibraries.size() > 0) {
                this.log("Error consistencyCheck: the element sharedlibraries is not allowed in combination with the element dbfilecontent");
                _rc = false;
            }
            if (this.basedir != null) {
                this.log("Error consistencyCheck: the attribute basedir of the jarsap element is not allowed in combination with the element dbfilecontent");
                _rc = false;
            }
            if (this.dbselects.size() > 0) {
                this.log("Error consistencyCheck: the element dbselect is not allowed in combination with the element dbfilecontent");
                _rc = false;
            }
            if (!_rc) {
                return false;
            }
        }
        int i2 = 0;
        while (i2 < this.dbselects.size()) {
            DBSelect dbs = (DBSelect)this.dbselects.elementAt(i2);
            if (dbs.getSelectfile() == null || dbs.getConnectParams() == null) {
                failed = true;
                if (dbs.getSelectfile() == null) {
                    this.log("Error consistencyCheck: missing selectfile for dbselect element");
                }
                if (dbs.getConnectParams() == null) {
                    this.log("Error consistencyCheck: missing connectparams for dbselect element");
                }
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.dbfilecontents.size()) {
            DBFileContent dbfc = (DBFileContent)this.dbfilecontents.elementAt(i3);
            if (dbfc.getTableName() == null) {
                failed = true;
                this.log("Error consistencyCheck: missing tablename for dbfilecontent element");
            }
            ++i3;
        }
        i = 0;
        while (i < this.subdependencies.size()) {
            Dependency dep = (Dependency)this.subdependencies.elementAt(i);
            if (dep.getComponent() == null) {
                failed = true;
                this.log("Error consistencyCheck: missing component for dependency element");
            } else if (dep.getComponent().getName() == null || dep.getComponent().getVendor() == null) {
                failed = true;
                if (dep.getComponent().getName() == null) {
                    this.log("Error consistencyCheck: missing name/implementationtitle for dependency element");
                }
                if (dep.getComponent().getVendor() == null) {
                    this.log("Error consistencyCheck: missing vendor/Implementation-Vendor-Id for dependency element");
                }
            } else if (dep.getComponent().getName().equals("") || dep.getComponent().getVendor().equals("")) {
                failed = true;
                if (dep.getComponent().getName().equals("")) {
                    this.log("Error consistencyCheck: empty name/implementationtitle for dependency element");
                }
                if (dep.getComponent().getVendor().equals("")) {
                    this.log("Error consistencyCheck: empty vendor/Implementation-Vendor-Id for dependency element");
                }
            }
            ++i;
        }
        int i4 = 0;
        while (i4 < this.submfentries.size()) {
            MFEntry mfe = (MFEntry)this.submfentries.elementAt(i4);
            if (mfe.getAttribute() == null || mfe.getValue() == null) {
                failed = true;
                if (mfe.getAttribute() == null) {
                    this.log("Error consistencyCheck: missing attribute for mfentry element");
                }
                if (mfe.getValue() == null) {
                    this.log("Error consistencyCheck: missing value for mfentry element");
                }
            }
            ++i4;
        }
        return !failed;
    }

    private boolean makeMFAPIEntries(JarSL jarsl, JarSL apijarsl) {
        boolean failed = false;
        String[] filelist = apijarsl.getJarFileList();
        int i = 0;
        while (i < filelist.length) {
            failed |= jarsl.writeAttribute(filelist[i], "public", "true");
            ++i;
        }
        return failed;
    }

    private void readCversEntry() throws ProcessingException {
        if (this.component != null) {
            Vector lcrlog = new Vector();
            if (this.lcrconnectionfailed) {
                return;
            }
            LCREntryIF lcrentry = LCREntryFactoryIF.getInstance().createLCREntry(this, lcrlog);
            lcrentry.makeEntryIntoLCR(false, true);
            int i = 0;
            while (i < lcrlog.size()) {
                String result = (String)lcrlog.elementAt(i);
                if (result.equals("ERROR during LCR access: Cannot communicate with the LCR, no answer received.")) {
                    this.lcrconnectionfailed = true;
                }
                this.log((String)lcrlog.elementAt(i));
                ++i;
            }
        }
    }

    private boolean makeMFEntries(JarSL jarsl, boolean libsadded) throws ProcessingException {
        boolean failed = false;
        String servertype = null;
        String sourceserver = null;
        String changenumber = null;
        if (this.mainclass != null) {
            failed |= !jarsl.writeAttribute("", "Main-Class", this.mainclass);
        }
        if (this.component != null && this.component.getSpecificationname() != null && this.component.getSpecificationversion() != null && this.component.getSpecificationvendor() != null && this.component.getImplvendor() != null) {
            failed |= !jarsl.writeAttribute("", "SDM-SDA-Comp-Version", new Integer(1).toString());
        }
        failed |= !jarsl.writeAttribute("", "Ext-SDM-SDA-Comp-Version", new Integer(1).toString());
        if (this.deployfile != null && this.deployfile.getName().compareTo("empty") != 0) {
            if (this.softwaretype == null) {
                SoftwareTypeReader str = new SoftwareTypeReader(this.deployfile.getPath());
                try {
                    str.readSoftwareType();
                    this.softwaretype = str.getSoftwareType();
                }
                catch (Exception de) {
                    throw new ProcessingException("ERROR: " + de.getMessage());
                }
            }
            if (this.softwaretype != null) {
                failed |= !jarsl.writeAttribute("", "softwaretype", this.softwaretype);
            } else {
                throw new ProcessingException("ERROR: Software type could not be determined from the deployment descriptor");
            }
        }
        if (this.property.getProperty("jarsapversion_i") != null) {
            failed |= !jarsl.writeAttribute("", "JarSAP-Version", this.property.getProperty("jarsapversion_i"));
        }
        failed |= !jarsl.writeAttribute("", "JarSAPProcessing-Version", DEF_jarsapprocessingversion);
        if (this.property.getProperty("changelistnumber") != null) {
            servertype = "P4";
            changenumber = this.property.getProperty("changelistnumber");
            failed |= !jarsl.writeAttribute("", "changelistnumber", this.property.getProperty("changelistnumber"));
        }
        if (this.property.getProperty("perforceserver") != null) {
            servertype = "P4";
            sourceserver = this.property.getProperty("perforceserver");
            failed |= !jarsl.writeAttribute("", "perforceserver", this.property.getProperty("perforceserver"));
        }
        if (this.property.getProperty("dtr-integration-sequence-no") != null) {
            servertype = "DTR";
            changenumber = this.property.getProperty("dtr-integration-sequence-no");
            failed |= !jarsl.writeAttribute("", "dtr-integration-sequence-no", this.property.getProperty("dtr-integration-sequence-no"));
        }
        if (this.property.getProperty("dtr-workspace") != null) {
            servertype = "DTR";
            sourceserver = this.property.getProperty("dtr-workspace");
            failed |= !jarsl.writeAttribute("", "dtr-workspace", this.property.getProperty("dtr-workspace"));
        }
        if (this.property.getProperty("projectname") != null) {
            failed |= !jarsl.writeAttribute("", "projectname", this.property.getProperty("projectname"));
        }
        if (this.property.getProperty("perforceversioning") != null && this.property.getProperty("perforceversioning").toLowerCase().equals("yes")) {
            if (this.property.getProperty("changelistnumber") != null) {
                failed |= !jarsl.writeAttribute("", "sap-changelistnumber", this.property.getProperty("changelistnumber"));
            }
            if (this.property.getProperty("perforceserver") != null) {
                failed |= !jarsl.writeAttribute("", "sap-perforceserver", this.property.getProperty("perforceserver"));
            }
        }
        if (libsadded) {
            failed |= !jarsl.writeAttribute("", "platform", PlattformConstants.getPlatform());
        }
        if (this.sapinternal.compareTo("true") == 0) {
            failed |= !jarsl.writeAttribute("", "sapinternal", "true");
            this.log("Info: the created archive is only for internal use");
        }
        if (this.deployfile != null) {
            failed |= !jarsl.writeAttribute("", "deployfile", this.deployfile.getName());
        }
        if (this.softwaresubtype != null) {
            failed |= !jarsl.writeAttribute("", "softwaresubtype", this.softwaresubtype);
        }
        if (this.docfile != null) {
            failed |= !jarsl.writeAttribute("", "docfile", this.docfile.getName());
        }
        int i = 0;
        while (i < this.submfentries.size()) {
            MFEntry mfe = (MFEntry)this.submfentries.elementAt(i);
            failed = mfe.getEntry() == null ? (failed |= !jarsl.writeAttribute("", mfe.getAttribute(), mfe.getValue())) : (failed |= !jarsl.writeAttribute(mfe.getEntry(), mfe.getAttribute(), mfe.getValue()));
            ++i;
        }
        if (this.component != null) {
            if (this.component.getSpecificationname() != null) {
                failed |= !jarsl.writeAttribute("", "Specification-Title", this.component.getSpecificationname());
            }
            if (this.component.getSpecificationversion() != null) {
                failed |= !jarsl.writeAttribute("", "Specification-Version", this.component.getSpecificationversion());
            }
            if (this.component.getSpecificationvendor() != null) {
                failed |= !jarsl.writeAttribute("", "Specification-Vendor", this.component.getSpecificationvendor());
            }
            if (this.component.getName() != null) {
                failed |= !jarsl.writeAttribute("", "Implementation-Title", this.component.getName());
            }
            if (this.component.getCounter() != null) {
                failed |= !jarsl.writeAttribute("", "Implementation-Version", this.component.getCounter());
            }
            if (this.component.getImplvendor() != null) {
                failed |= !jarsl.writeAttribute("", "Implementation-Vendor", this.component.getImplvendor());
            }
            if (this.component.getVendor() != null) {
                failed |= !jarsl.writeAttribute("", "Implementation-Vendor-Id", this.component.getVendor());
            }
            failed |= !jarsl.writeAttribute("", "keyname", this.component.getName());
            failed |= !jarsl.writeAttribute("", "keyvendor", this.component.getVendor());
            failed |= !jarsl.writeAttribute("", "keylocation", this.component.getLocation());
            failed |= !jarsl.writeAttribute("", "keycounter", this.component.getCounter());
            String scname = this.component.getScname();
            String scvendor = this.component.getScvendor();
            if (this.property.getProperty("Softwarecomponent-Name") != null) {
                scname = this.property.getProperty("Softwarecomponent-Name");
            }
            if (this.property.getProperty("Softwarecomponent-Vendor") != null) {
                scvendor = this.property.getProperty("Softwarecomponent-Vendor");
            }
            ComponentElementIF componentelement = ComponentFactoryIF.getInstance().createComponentElement(this.component.getVendor(), this.component.getName(), "DC", "NO_SUBSYS", this.component.getLocation(), this.component.getCounter(), scvendor, scname, this.property.getProperty("release"), null, null, "F", this.updateversion, null, this.property.getProperty("Softwarecomponent-Ppmsnumber"), null, null, null, servertype, sourceserver, changenumber, this.property.getProperty("projectname"));
            ComponentElementXMLizerIF cex = ComponentElementXMLizerFactoryIF.getInstance().createComponentXMLizerElement(componentelement);
            String cversentry = cex.getXML();
            if (cversentry != null) {
                failed |= !jarsl.writeAttribute("", "componentelement", cversentry);
            }
        } else {
            this.log("Warning: No component is specified in build.xml, so the created archive will not be deliverd (no SDA) and no SAP_MANIFEST will be written.");
        }
        if (this.subdependencies.size() > 0) {
            Dependency[] deps = new Dependency[this.subdependencies.size()];
            int i2 = 0;
            while (i2 < this.subdependencies.size()) {
                deps[i2] = (Dependency)this.subdependencies.elementAt(i2);
                ++i2;
            }
            failed |= !jarsl.writeAttribute("", "dependencies", Dependency.createDependenciesAttribute620(deps));
            failed |= !jarsl.writeAttribute("", "dependencylist", Dependency.createDependenciesAttribute(deps));
        }
        return !failed;
    }

    private boolean addDBSelectsToArchive(JarSL jarsl, boolean senderror) throws ProcessingException {
        boolean fileadded = false;
        int i = 0;
        while (i < this.dbselects.size()) {
            boolean rc;
            fileadded = true;
            DBSelect dbselect = (DBSelect)this.dbselects.elementAt(i);
            if (dbselect.getSelectfile() != null) {
                dbselect.setSelectfile(this.resolveFile(dbselect.getSelectfile()).getPath());
            }
            try {
                rc = dbselect.createDatafile(jarsl);
            }
            catch (Exception e) {
                throw new ProcessingException("ERROR: the following exception occurred during the creation of the archive: " + e.getMessage());
            }
            if (!rc) {
                throw new ProcessingException("Error: cannot put database content-file created from the selectfile " + dbselect.getSelectfile() + " into the archive");
            }
            ++i;
        }
        if (fileadded) {
            String _deployfile = DBTask.addDeployFile((String)this.getArchiveName());
            if (_deployfile == null) {
                throw new ProcessingException("Error: cannot add deployfile to the archive");
            }
            this.setDeployfile(new File(_deployfile));
            this.checkiscurrentarchiveisuptodate = false;
        }
        return fileadded;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private boolean addDBFileContentsToArchive(JarSL jarsl, boolean senderror) throws ProcessingException {
        boolean fileadded;
        block30: {
            IOException e22;
            BufferedWriter outsel;
            BufferedInputStream bis;
            block29: {
                block28: {
                    byte[] buff = new byte[65536];
                    fileadded = false;
                    int selcounter = 0;
                    String archivedirname = jarsl.getArchiveName().getParent() + File.separator + "tempdbtask";
                    bis = null;
                    outsel = null;
                    if (this.dbfilecontents.size() > 0) {
                        new File(Conv.pathConv((String)archivedirname)).mkdirs();
                        outsel = new BufferedWriter(new FileWriter(Conv.pathConv((String)(archivedirname + "/select.xml"))));
                        outsel.write("<?xml version=\"1.0\" ?>");
                        outsel.newLine();
                        outsel.write("<selections>");
                        outsel.newLine();
                    }
                    int i = 0;
                    while (i < this.dbfilecontents.size()) {
                        DBFileContent dbfilecontent = (DBFileContent)this.dbfilecontents.elementAt(i);
                        String tabdescstring = dbfilecontent.getTableName() + " " + 2;
                        tabdescstring = tabdescstring.concat(" filename 2005");
                        tabdescstring = tabdescstring.concat(" filecontent 2004");
                        if (dbfilecontent.getTFilelist().size() > 0) {
                            outsel.write("<table name=\"" + dbfilecontent.getTableName() + "\">");
                            outsel.newLine();
                            int j = 0;
                            while (j < dbfilecontent.getTFilelist().size()) {
                                int len;
                                FileSpec filespec = (FileSpec)dbfilecontent.getTFilelist().elementAt(j);
                                outsel.write("<wc text=\"filename = '" + filespec.fname() + "'\" />");
                                outsel.newLine();
                                fileadded = true;
                                Selection selection = new Selection(new Integer(selcounter).toString(), dbfilecontent.getTableName());
                                ++selcounter;
                                if (!jarsl.createFile(archivedirname + File.separator + selection.getJarEntryName(false), selection.getJarEntryName(false), null)) {
                                    throw new ProcessingException("Error during the creation of " + selection.getJarEntryName(false) + " in " + archivedirname + ".");
                                }
                                jarsl.putIntData(tabdescstring.getBytes().length);
                                jarsl.putData(tabdescstring.getBytes(), 0, tabdescstring.getBytes().length);
                                if (!jarsl.closeFile(true, null)) {
                                    throw new ProcessingException("Error during the finalization of " + selection.getJarEntryName(false) + ".");
                                }
                                if (!jarsl.createFile(archivedirname + File.separator + selection.getJarEntryName(true), selection.getJarEntryName(true), null)) {
                                    throw new ProcessingException("Error during the creation of " + selection.getJarEntryName(true) + " in " + archivedirname + ".");
                                }
                                jarsl.putLongData((long)filespec.fname().length());
                                jarsl.putCharsData(filespec.fname());
                                bis = new BufferedInputStream(new FileInputStream(Conv.pathConv((String)(filespec.base() + "/" + filespec.fname()))));
                                long bloblen = 0L;
                                while ((len = bis.read(buff)) >= 0) {
                                    void var17_18;
                                    bloblen += (long)var17_18;
                                }
                                if (bloblen > Integer.MAX_VALUE) {
                                    throw new ProcessingException("Length " + bloblen + " too large, file " + Conv.pathConv((String)(filespec.base() + "/" + filespec.fname())));
                                }
                                jarsl.putLongData(bloblen);
                                bis.close();
                                bis = null;
                                bis = new BufferedInputStream(new FileInputStream(Conv.pathConv((String)(filespec.base() + "/" + filespec.fname()))));
                                while ((len = bis.read(buff)) >= 0) {
                                    jarsl.putData(buff, 0, len);
                                }
                                bis.close();
                                bis = null;
                                if (!jarsl.closeFile(true, null)) {
                                    throw new ProcessingException("Error during the finalization of " + selection.getJarEntryName(true) + ".");
                                }
                                ++j;
                            }
                            outsel.write("</table>");
                            outsel.newLine();
                        }
                        ++i;
                    }
                    if (this.dbfilecontents.size() > 0) {
                        outsel.write("</selections>");
                        outsel.newLine();
                        outsel.close();
                        outsel = null;
                    }
                    if (!fileadded) break block28;
                    this.projectInfo.writeArchiveToArchiveLinkFile("select.xml");
                    if (!jarsl.addFile("", Conv.pathConv((String)(archivedirname + "/select.xml")), "select.xml", null, true)) {
                        throw new ProcessingException("ERROR: Cannot add the selectfile to the archive.");
                    }
                    String _deployfile = DBTask.addDeployFile((String)this.getArchiveName());
                    if (_deployfile == null) {
                        throw new ProcessingException("Error: cannot add deployfile to the archive");
                    }
                    this.setDeployfile(new File(_deployfile));
                    this.checkiscurrentarchiveisuptodate = false;
                }
                Object var19_19 = null;
                if (bis == null) break block29;
                try {
                    bis.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (outsel != null) {
                try {
                    outsel.close();
                }
                catch (IOException e22) {}
            }
            break block30;
            {
                catch (Exception e3) {
                    if (e3 instanceof ProcessingException) {
                        throw (ProcessingException)e3;
                    }
                    throw new ProcessingException("Error in addDBFileContentsToArchive: " + e3.getMessage());
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var19_20 = null;
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (outsel != null) {
                    try {
                        outsel.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return fileadded;
    }

    private boolean addSharedLibrariesToArchive(Hashtable addeddirs, JarSL jarsl, boolean senderror) throws ProcessingException {
        boolean fileadded = false;
        int i = 0;
        while (i < this.subsharedlibraries.size()) {
            SharedLibraries shlibs = (SharedLibraries)this.subsharedlibraries.elementAt(i);
            if (shlibs.getPlatform() != null) {
                if (!PlattformConstants.setPlatform(shlibs.getPlatform())) {
                    throw new ProcessingException("the element sharedLibraries has a wrong platform attribut: " + shlibs.getPlatform());
                }
            } else {
                PlattformConstants.setPlatform(null);
            }
            if (i == 0 && !PlattformConstants.plattformSupported()) {
                throw new ProcessingException("archive contains shared libraries for a not supported plattform");
            }
            int j = 0;
            while (j < shlibs.getLibnames().length) {
                File fname = new File(shlibs.getLibnames()[j].getName().replace('\\', '/'));
                String sname = fname.getParent() != null ? fname.getParent() + "/" + PlattformConstants.getLibraryPostFix() + fname.getName() + PlattformConstants.getLibraryPreFix() : PlattformConstants.getLibraryPostFix() + fname.getName() + PlattformConstants.getLibraryPreFix();
                this.addParentDirs(this.resolveFile(shlibs.getDir()), sname, "", addeddirs, jarsl);
                Vector errorTexts = new Vector();
                this.projectInfo.writeArchiveToArchiveLinkFile(sname);
                if (!jarsl.addFile(this.resolveFile(shlibs.getDir()).getPath(), sname, errorTexts)) {
                    if (senderror) {
                        StringBuffer tmpB = new StringBuffer();
                        if (null != errorTexts) {
                            Iterator errIter = ((AbstractList)errorTexts).iterator();
                            while (errIter.hasNext()) {
                                tmpB.append((String)errIter.next());
                            }
                        }
                        throw new ProcessingException("error in adding shared library " + sname + " to archive (" + tmpB.toString() + ")");
                    }
                } else {
                    fileadded = true;
                }
                ++j;
            }
            ++i;
        }
        return fileadded;
    }

    private void addParentDirs(File basedir, String entry, String prefix, Hashtable addeddirs, JarSL jarsl) throws ProcessingException {
        String dir;
        Stack<String> directories = new Stack<String>();
        int slashpos = entry.length();
        while ((slashpos = entry.lastIndexOf(47, slashpos - 1)) != -1) {
            dir = entry.substring(0, slashpos + 1);
            if (addeddirs.get(prefix + dir) != null) break;
            directories.push(dir);
        }
        while (!directories.isEmpty()) {
            dir = (String)directories.pop();
            if (addeddirs.get(prefix + dir) != null) continue;
            addeddirs.put(prefix + dir, prefix + dir);
            Vector errorTexts = new Vector();
            if (jarsl.addDir(basedir.getPath(), prefix + dir, errorTexts)) continue;
            StringBuffer tmpB = new StringBuffer();
            if (null != errorTexts) {
                Iterator errIter = ((AbstractList)errorTexts).iterator();
                while (errIter.hasNext()) {
                    tmpB.append((String)errIter.next());
                }
            }
            throw new ProcessingException("error in adding directory " + prefix + dir + " to archive (" + tmpB.toString() + ")");
        }
    }

    private boolean addFilesToArchive(FileSpec[] files, Hashtable addeddirs, JarSL jarsl, boolean senderror) throws ProcessingException {
        boolean fileadded = false;
        if (files == null) {
            return fileadded;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].fname().endsWith("/")) {
                this.addParentDirs(new File(files[i].base()), files[i].fname(), "", addeddirs, jarsl);
                fileadded = true;
            } else {
                this.addParentDirs(new File(files[i].base()), files[i].fname(), "", addeddirs, jarsl);
                Vector errorTexts = new Vector();
                this.projectInfo.writeArchiveToArchiveLinkFile(files[i].fname());
                if (!jarsl.addFile(files[i].base(), files[i].fname(), errorTexts)) {
                    if (senderror) {
                        StringBuffer tmpB = new StringBuffer();
                        if (null != errorTexts) {
                            Iterator errIter = ((AbstractList)errorTexts).iterator();
                            while (errIter.hasNext()) {
                                tmpB.append((String)errIter.next());
                            }
                        }
                        throw new ProcessingException("error in adding file " + files[i].fname() + " to archive (" + tmpB.toString() + ")");
                    }
                } else {
                    fileadded = true;
                }
            }
            ++i;
        }
        return fileadded;
    }

    private File resolveFile(String file) {
        String tfile = Conv.pathConvJar((String)file);
        if (tfile.startsWith("/")) {
            if (File.separator.compareTo("/") != 0) {
                tfile = this.property.getProperty("projectbasedir").substring(0, 2) + tfile;
            }
        } else if (tfile.indexOf(":") != 1) {
            tfile = this.property.getProperty("projectbasedir").endsWith("/") ? this.property.getProperty("projectbasedir") + tfile : this.property.getProperty("projectbasedir") + "/" + tfile;
        }
        return new File(Conv.pathConv((String)tfile));
    }

    private boolean lookForSapinternalInManifest(JarSL jarsl) {
        String[] result = jarsl.getEntryListOfGivenAttributeValuePair("sapinternal", "true");
        return result.length > 0;
    }

    void makeArchivePathEntryIntoLCR() throws ProcessingException {
        Vector lcrlog = new Vector();
        if (this.subsharedlibraries.size() != 0) {
            return;
        }
        if (this.lcrconnectionfailed) {
            return;
        }
        LCREntryIF lcrentry = LCREntryFactoryIF.getInstance().createLCREntry(this, lcrlog);
        lcrentry.makeEntryIntoLCR(true, false);
        int i = 0;
        while (i < lcrlog.size()) {
            String result = (String)lcrlog.elementAt(i);
            if (result.equals("ERROR during LCR access: Cannot communicate with the LCR, no answer received.")) {
                this.lcrconnectionfailed = true;
            }
            this.log((String)lcrlog.elementAt(i));
            ++i;
        }
    }

    void executeOnlyConsistencyCheck() throws ProcessingException {
        this.execute(true);
    }

    void execute() throws ProcessingException {
        this.execute(false);
    }

    private void execute(boolean onlyconsistencycheck) throws ProcessingException {
        Vector errorTexts;
        this.log("Info: JarSAPProcessing version " + DEF_jarsapprocessingversion + " / JarSL version " + JarSL.DEF_jarslversion);
        if (onlyconsistencycheck) {
            this.log("Info: only the consistency check if performed");
        }
        try {
            UtilInitializer.initializeWithSimpleLog();
        }
        catch (Exception e) {
            throw new ProcessingException("could not read all necessary SDM property files!");
        }
        this.preevaluation();
        if (!this.consistencyCheck()) {
            throw new ProcessingException("wrong attribute combination!");
        }
        if (this.jumparchive || onlyconsistencycheck) {
            return;
        }
        if (this.basedir == null && (this.filelist == null || this.filelist.length == 0) && this.subsharedlibraries.size() == 0 && this.dbselects.size() == 0 && this.dbfilecontents.size() == 0) {
            throw new ProcessingException("basedir attribute must be set, or at least one fileset must be given!");
        }
        boolean fileadded = false;
        boolean libsadded = false;
        JarSL jarsl = this.basedir == null ? new JarSL(this.jarfile.getPath(), "") : new JarSL(this.jarfile.getPath(), this.basedir.getPath());
        JarSL apijarsl = null;
        String apifilename = null;
        if (this.publicfilelist != null && this.publicfilelist.length > 0) {
            apifilename = this.jarfile.getPath();
            int dot = apifilename.lastIndexOf(".");
            apifilename = dot == -1 ? apifilename + "_API" : apifilename.substring(0, dot) + "_API" + apifilename.substring(dot);
            apijarsl = this.basedir == null ? new JarSL(apifilename, "") : new JarSL(apifilename, this.basedir.getPath());
        }
        if (this.property.getProperty("jarsap.info.dir") != null) {
            this.log("Found jarsap.info.dir property. I will write structure information to directory " + this.property.getProperty("jarsap.info.dir") + ".");
            this.projectInfo = null != this.component ? new ProjectInfo(this.component, this.property.getProperty("jarsap.info.project"), this.property.getProperty("jarsap.info.rel"), this.property.getProperty("jarsap.info.configuration"), this.property.getProperty("jarsap.info.dir"), this.jarfile.getName()) : new ProjectInfo();
        } else {
            this.log("Property jarsap.info.dir is not set.");
            this.projectInfo = new ProjectInfo();
        }
        this.projectInfo.writeComponentToArchiveLinkFile();
        this.log("Building: " + this.jarfile.getPath() + (this.compress ? " with compression" : " without compression"));
        Hashtable addeddirs = new Hashtable();
        fileadded |= this.addFilesToArchive(this.filelist, addeddirs, jarsl, true);
        libsadded = this.addSharedLibrariesToArchive(addeddirs, jarsl, true);
        fileadded |= this.addDBSelectsToArchive(jarsl, false);
        fileadded |= this.addDBFileContentsToArchive(jarsl, false);
        fileadded |= this.addFilesToArchive(this.publicfilelist, addeddirs, jarsl, false);
        if (!(fileadded |= libsadded)) {
            this.log("Warning: creating empty JAR file");
        }
        if (this.deployfile != null && this.deployfile.getName().compareTo("empty") != 0) {
            errorTexts = new Vector();
            jarsl.removeFile("META-INF/" + this.deployfile.getName());
            this.projectInfo.writeArchiveToArchiveLinkFile("META-INF/" + this.deployfile.getName());
            if (!jarsl.addFile(this.deployfile.getParent(), this.deployfile.getName(), "META-INF/" + this.deployfile.getName(), 0, errorTexts, false)) {
                StringBuffer tmpB = new StringBuffer();
                if (null != errorTexts) {
                    Iterator errIter = ((AbstractList)errorTexts).iterator();
                    while (errIter.hasNext()) {
                        tmpB.append((String)errIter.next());
                    }
                }
                throw new ProcessingException("error in adding the deployfile to the archive (" + tmpB.toString() + ")");
            }
        }
        if (this.docfile != null) {
            errorTexts = new Vector();
            jarsl.removeFile("META-INF/" + this.docfile.getName());
            this.projectInfo.writeArchiveToArchiveLinkFile("META-INF/" + this.docfile.getName());
            if (!jarsl.addFile(this.docfile.getParent(), this.docfile.getName(), "META-INF/" + this.docfile.getName(), errorTexts)) {
                StringBuffer tmpB = new StringBuffer();
                if (null != errorTexts) {
                    Iterator errIter = ((AbstractList)errorTexts).iterator();
                    while (errIter.hasNext()) {
                        tmpB.append((String)errIter.next());
                    }
                }
                throw new ProcessingException("error in adding the docfile to the archive (" + tmpB.toString() + ")");
            }
        }
        if (apijarsl != null) {
            Hashtable publicaddeddirs = new Hashtable();
            if (!this.addFilesToArchive(this.publicfilelist, publicaddeddirs, apijarsl, true)) {
                apijarsl.create(null);
                apijarsl = null;
            } else {
                this.log("Building: " + apifilename);
            }
        }
        if (this.checkiscurrentarchiveisuptodate && jarsl.isCurrentArchiveUpToDate(new File(this.property.getProperty("ant.file")).lastModified())) {
            this.log("Info: The current archive is up to date, so it is not built again.");
            return;
        }
        errorTexts = new Vector();
        if (this.sapinternal.compareTo("false") == 0 && this.lookForSapinternalInManifest(jarsl)) {
            this.sapinternal = "true";
        }
        if (this.property.getProperty("localmake") == null && (this.property.getProperty("makelcrentry") != null || this.property.getProperty("checklcrentry") != null)) {
            this.readCversEntry();
        }
        if (!this.makeMFEntries(jarsl, libsadded)) {
            throw new ProcessingException("error in creating the manifest");
        }
        if (apijarsl != null && !this.makeMFAPIEntries(jarsl, apijarsl)) {
            throw new ProcessingException("error in creating the manifest (public attributes)");
        }
        if (apijarsl != null && !this.makeMFEntries(apijarsl, libsadded)) {
            throw new ProcessingException("error in creating the api manifest");
        }
        if (apijarsl != null && !apijarsl.create(this.compress, false, this.component != null, errorTexts = new Vector())) {
            StringBuffer tmpB = new StringBuffer();
            if (null != errorTexts) {
                Iterator errIter = ((AbstractList)errorTexts).iterator();
                while (errIter.hasNext()) {
                    tmpB.append((String)errIter.next());
                }
            }
            throw new ProcessingException("error in creating the api archive (" + tmpB.toString() + ")");
        }
        if (!jarsl.create(this.compress, false, this.component != null, errorTexts = new Vector())) {
            StringBuffer tmpB = new StringBuffer();
            if (null != errorTexts) {
                Iterator errIter = ((AbstractList)errorTexts).iterator();
                while (errIter.hasNext()) {
                    tmpB.append((String)errIter.next());
                }
            }
            throw new ProcessingException("error in creating the archive (" + tmpB.toString() + ")");
        }
    }
}

