/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.ant;

import com.sap.sdm.ant.Component;
import com.sap.sdm.ant.FileSpec;
import com.sap.sdm.ant.LCREntryFactoryIF;
import com.sap.sdm.ant.ProcessingException;
import com.sap.sdm.ant.ProjectInfo;
import com.sap.sdm.ant.SoftwareComponent;
import com.sap.sdm.ant.SupportPackage;
import com.sap.sdm.util.init.UtilInitializer;
import com.sap.sdm.util.jarsl.ConstantsIF;
import com.sap.sdm.util.jarsl.Conv;
import com.sap.sdm.util.jarsl.JarSL;
import com.sap.sdm.util.sduread.DevelopmentComponentVersion;
import com.sap.sdm.util.sduread.SdaFile;
import com.sap.sdm.util.sduread.SduFile;
import com.sap.sdm.util.sduread.SduReader;
import com.sap.sl.util.components.api.ComponentElementIF;
import com.sap.sl.util.components.api.ComponentFactoryIF;
import com.sap.sl.util.components.xml.api.ComponentElementXMLizerFactoryIF;
import com.sap.sl.util.components.xml.api.ComponentElementXMLizerIF;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import java.util.jar.JarInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.MatchingTask;

public final class ExportSC
extends MatchingTask
implements ConstantsIF {
    public static String DEF_exportscversion = "20041208.1700";
    private static String _SERVICELEVEL = "servicelevel";
    private static String _PATCHLEVEL = "patchlevel";
    private static String _SPNAME = "spname";
    private static String _SPVERSION = "spversion";
    private static String _SPELEMENTTYPEID = "spelementtypeid";
    private SoftwareComponent softwarecomponent = null;
    private String archivedir = null;
    private Vector tldccomp = null;
    private String timestamp = null;
    private String directory = null;
    private String filelist = null;
    private String scacreationmode = "LCR";
    private String scacontentpath = null;
    private String actualscacreationmode = "LCR";
    private String servicelevel = null;
    private String patchlevel = null;
    private String spname = null;
    private String spversion = null;
    private String spelementtypeid = null;
    private int numberofnotfoundarchives = 0;
    private boolean printonlyscacontent = false;
    private ProjectInfo projectInfo = null;

    public static void main(String[] arg) {
        if (arg.length == 0) {
            System.out.println("This is ExportSC version " + DEF_exportscversion);
        }
    }

    public SoftwareComponent createSoftwarecomponent() {
        this.softwarecomponent = new SoftwareComponent();
        return this.softwarecomponent;
    }

    public void setDir(String directory) {
        this.directory = directory;
    }

    public void setFileList(String filelist) {
        this.filelist = filelist;
    }

    public void setArchiveDir(String archivedir) {
        this.archivedir = ((ProjectComponent)this).project.resolveFile(archivedir).getPath();
    }

    private boolean preevaluation() {
        if (this.archivedir == null) {
            this.archivedir = ((ProjectComponent)this).project.getProperty("archive.dir");
        }
        if (((ProjectComponent)this).project.getProperty("scacontentpath") != null) {
            this.scacontentpath = ((ProjectComponent)this).project.getProperty("scacontentpath");
        }
        if (((ProjectComponent)this).project.getProperty("scacreationmode") != null) {
            this.scacreationmode = ((ProjectComponent)this).project.getProperty("scacreationmode").toUpperCase();
            this.actualscacreationmode = this.scacreationmode.equals("AUTO") ? "LCR" : this.scacreationmode;
        }
        if (this.softwarecomponent == null) {
            this.softwarecomponent = new SoftwareComponent();
        }
        if (((ProjectComponent)this).project.getProperty("printonlyscacontent") != null && ((ProjectComponent)this).project.getProperty("printonlyscacontent").equalsIgnoreCase("true")) {
            this.printonlyscacontent = true;
        }
        if (((ProjectComponent)this).project.getProperty("Softwarecomponent-Ppmsnumber") != null || ((ProjectComponent)this).project.getProperty("keylocation") != null || ((ProjectComponent)this).project.getProperty("keyvendor") != null || ((ProjectComponent)this).project.getProperty("keyname") != null || ((ProjectComponent)this).project.getProperty("keycounter") != null || ((ProjectComponent)this).project.getProperty("location") != null || ((ProjectComponent)this).project.getProperty("vendor") != null || ((ProjectComponent)this).project.getProperty("name") != null || ((ProjectComponent)this).project.getProperty("counter") != null) {
            if (this.softwarecomponent == null) {
                this.softwarecomponent = new SoftwareComponent();
            }
            if (this.softwarecomponent.getPpmsnumber() == null) {
                this.softwarecomponent.setPpmsnumber(((ProjectComponent)this).project.getProperty("Softwarecomponent-Ppmsnumber"));
            }
            if (this.softwarecomponent.getName() == null) {
                this.softwarecomponent.setName(((ProjectComponent)this).project.getProperty("keyname"));
            }
            if (this.softwarecomponent.getVendor() == null) {
                this.softwarecomponent.setVendor(((ProjectComponent)this).project.getProperty("keyvendor"));
            }
            if (this.softwarecomponent.getCounter() == null) {
                this.softwarecomponent.setCounter(((ProjectComponent)this).project.getProperty("keycounter"));
            }
            if (this.softwarecomponent.getLocation() == null) {
                this.softwarecomponent.setLocation(((ProjectComponent)this).project.getProperty("keylocation"));
            }
            if (this.softwarecomponent.getName() == null) {
                this.softwarecomponent.setName(((ProjectComponent)this).project.getProperty("name"));
            }
            if (this.softwarecomponent.getVendor() == null) {
                this.softwarecomponent.setVendor(((ProjectComponent)this).project.getProperty("vendor"));
            }
            if (this.softwarecomponent.getCounter() == null) {
                this.softwarecomponent.setCounter(((ProjectComponent)this).project.getProperty("counter"));
            }
            if (this.softwarecomponent.getLocation() == null) {
                this.softwarecomponent.setLocation(((ProjectComponent)this).project.getProperty("location"));
            }
        }
        if (this.softwarecomponent.getLocation() == null) {
            this.softwarecomponent.setLocation("SAP AG");
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Date currTime = new Date();
        this.timestamp = df.format(currTime);
        this.servicelevel = ((ProjectComponent)this).project.getProperty("SP-Number");
        if (this.servicelevel != null && this.servicelevel.length() > 1 && this.servicelevel.startsWith("0")) {
            this.servicelevel = this.servicelevel.substring(1);
        }
        if (((ProjectComponent)this).project.getProperty("SP-Patchlevel") != null) {
            this.patchlevel = ((ProjectComponent)this).project.getProperty("SP-Patchlevel");
        }
        return true;
    }

    private boolean consistencyCheck() {
        boolean failed = false;
        if (!(this.scacreationmode.equals("LCR") || this.scacreationmode.equals("FILE") || this.scacreationmode.equals("AUTO"))) {
            failed = true;
            this.log("Error consistencyCheck: wrong scacreationmode");
        } else if (!this.scacreationmode.equals("LCR") && this.scacontentpath == null) {
            failed = true;
            this.log("Error consistencyCheck: missing scacontentpath property in ant call");
        }
        if (this.softwarecomponent == null) {
            failed = true;
            this.log("Error consistencyCheck: missing SoftwareComponent specification");
        }
        if (this.softwarecomponent != null && this.softwarecomponent.getCounter() != null) {
            this.log("Error consistencyCheck: the counter is generated by the exportsc task, do not define it in the softwarecomponent element or by property in ant call");
            failed = true;
        }
        if (this.softwarecomponent != null && (this.softwarecomponent.getPpmsnumber() == null || this.softwarecomponent.getVendor() == null || this.softwarecomponent.getName() == null || this.softwarecomponent.getLocation() == null)) {
            failed = true;
            if (this.softwarecomponent.getPpmsnumber() == null) {
                this.log("Error consistencyCheck: missing pppmsnumber for softwarecomponent element");
            }
            if (this.softwarecomponent.getVendor() == null) {
                this.log("Error consistencyCheck: missing vendor for softwarecomponent element");
            }
            if (this.softwarecomponent.getName() == null) {
                this.log("Error consistencyCheck: missing name for softwarecomponent element");
            }
            if (this.softwarecomponent.getLocation() == null) {
                this.log("Error consistencyCheck: missing location property in ant call");
            }
        }
        if (((ProjectComponent)this).project.getProperty("release") == null) {
            failed = true;
            this.log("Error consistencyCheck: missing release property in ant call");
        }
        if (this.directory == null && this.filelist == null && (this.scacreationmode.equals("LCR") || this.scacreationmode.equals("AUTO")) && ((ProjectComponent)this).project.getProperty("lcrurl") == null) {
            failed = true;
            this.log("Error consistencyCheck: missing lcrurl property in ant call");
        }
        if (this.directory == null && this.filelist == null && ((ProjectComponent)this).project.getProperty("makelcr.rel") == null) {
            failed = true;
            this.log("Error consistencyCheck: missing makelcr.rel property in ant call");
        }
        return !failed;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addDevelopmentComponentsToArchive(JarSL jarsl, String[] archives, boolean senderror) throws BuildException {
        Vector<FileSpec> sdafiles = new Vector<FileSpec>();
        String pathname = null;
        boolean fileadded = false;
        this.numberofnotfoundarchives = 0;
        int i = 0;
        while (i < archives.length) {
            pathname = archives[i];
            if (this.printonlyscacontent) {
                this.log("Info: file " + pathname + " is associated to the given software component");
            } else if (!JarSL.checkFileExistence((String)pathname)) {
                ++this.numberofnotfoundarchives;
                if (((ProjectComponent)this).project.getProperty("scacreationwithoutsdaexistencecheck") == null) throw new BuildException("Error: file " + pathname + " does not exist on filesystem");
                if (!((ProjectComponent)this).project.getProperty("scacreationwithoutsdaexistencecheck").equalsIgnoreCase("true")) throw new BuildException("Error: file " + pathname + " does not exist on filesystem");
                this.log("Warning: file " + pathname + " does not exist on filesystem");
            } else {
                SduFile sdufile;
                try {
                    sdufile = SduReader.getInstance().readFile(pathname, false);
                    if (!(sdufile instanceof SdaFile)) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    throw new BuildException("Error: the file " + pathname + " is not a correct SDA " + e.getMessage());
                }
                if (((SdaFile)sdufile).getSoftwareType() == null) {
                    this.log("Info: file " + pathname + " is not a deployable archive, it will not be added to the sca");
                } else {
                    sdafiles.addElement(new FileSpec(new File(pathname).getParent(), new File(pathname).getName()));
                    this.tldccomp.addElement((SdaFile)sdufile);
                }
            }
            ++i;
        }
        FileSpec[] sdaFileSpecArr = new FileSpec[sdafiles.size()];
        sdaFileSpecArr = sdafiles.toArray(sdaFileSpecArr);
        return this.addSdasToArchive(sdaFileSpecArr, jarsl, senderror);
    }

    private boolean addSdasToArchive(FileSpec[] sdaFileSpecs, JarSL jarsl, boolean senderror) throws BuildException {
        if (null == sdaFileSpecs) {
            return false;
        }
        Vector errorTexts = new Vector();
        boolean fileadded = false;
        int i = 0;
        while (sdaFileSpecs != null && i < sdaFileSpecs.length) {
            String fname = sdaFileSpecs[i].fname();
            String base = sdaFileSpecs[i].base();
            String path = null;
            if (base == null || base.compareTo("") == 0) {
                base = "";
                path = fname = fname.replace('\\', '/');
            } else {
                fname = fname.replace('\\', '/');
                base = base.replace('\\', '/');
                path = base + "/" + fname;
            }
            if (!jarsl.addFile(base, fname, errorTexts)) {
                if (senderror) {
                    StringBuffer tmpB = new StringBuffer();
                    if (null != errorTexts) {
                        Iterator errIter = ((AbstractList)errorTexts).iterator();
                        while (errIter.hasNext()) {
                            tmpB.append((String)errIter.next());
                        }
                    }
                    throw new BuildException("Error: error in adding file " + path + " to archive (" + tmpB.toString() + ")");
                }
            } else {
                this.log("Info: file " + path + " was added to the archive");
                fileadded = true;
            }
            ++i;
        }
        return fileadded;
    }

    private boolean makeMFEntries(JarSL jarsl) {
        boolean failed = false;
        failed |= !jarsl.writeAttribute("", "ExportSC-Version", DEF_exportscversion);
        if (this.softwarecomponent != null) {
            failed |= !jarsl.writeAttribute("", "Softwarecomponent-Ppmsnumber", this.softwarecomponent.getPpmsnumber());
            failed |= !jarsl.writeAttribute("", "keyvendor", this.softwarecomponent.getVendor());
            failed |= !jarsl.writeAttribute("", "keyname", this.softwarecomponent.getName());
            failed |= !jarsl.writeAttribute("", "keycounter", this.softwarecomponent.getCounter());
            failed |= !jarsl.writeAttribute("", "keylocation", this.softwarecomponent.getLocation());
            failed = ((ProjectComponent)this).project.getProperty("release") != null ? (failed |= !jarsl.writeAttribute("", "release", ((ProjectComponent)this).project.getProperty("release"))) : (failed |= !jarsl.writeAttribute("", "release", "0"));
            failed |= !jarsl.writeAttribute("", "SP-Number", this.servicelevel);
            failed |= !jarsl.writeAttribute("", "SP-Patchlevel", this.patchlevel);
            failed |= !jarsl.writeAttribute("", "Softwarecomponent-Vendor", this.softwarecomponent.getVendor());
            failed |= !jarsl.writeAttribute("", "Softwarecomponent-Name", this.softwarecomponent.getName());
            failed |= !jarsl.writeAttribute("", "scacreationmode", this.actualscacreationmode);
            failed = ((ProjectComponent)this).project.getProperty("release") != null ? (failed |= !jarsl.writeAttribute("", "Softwarecomponent-Version", ((ProjectComponent)this).project.getProperty("release"))) : (failed |= !jarsl.writeAttribute("", "Softwarecomponent-Version", "0"));
            if (this.directory != null) {
                failed |= !jarsl.writeAttribute("", "directory-sca", "true");
            }
            if (this.filelist != null) {
                failed |= !jarsl.writeAttribute("", "list-sca", "true");
            }
            if (((ProjectComponent)this).project.getProperty("scacreationwithoutidcheck") != null && ((ProjectComponent)this).project.getProperty("scacreationwithoutidcheck").equalsIgnoreCase("true")) {
                failed |= !jarsl.writeAttribute("", "scacreationwithoutidcheck", "true");
            }
            if (((ProjectComponent)this).project.getProperty("scacreationwithoutsdaexistencecheck") != null && ((ProjectComponent)this).project.getProperty("scacreationwithoutsdaexistencecheck").equalsIgnoreCase("true")) {
                failed |= !jarsl.writeAttribute("", "scacreationwithoutsdaexistencecheck", "true (" + this.numberofnotfoundarchives + " archives not found)");
            }
        } else {
            this.log("Warning: No softwarecomponent is specified in build.xml");
            failed = true;
        }
        int i = 0;
        while (i < this.tldccomp.size()) {
            SdaFile sdafile = (SdaFile)this.tldccomp.elementAt(i);
            Component comp = new Component();
            DevelopmentComponentVersion dcv = sdafile.getDevelopmentComponentVersion();
            comp.setName(dcv.getName());
            comp.setVendor(dcv.getVendor());
            comp.setCounter(dcv.getCount().toString());
            comp.setLocation(dcv.getLocation());
            failed |= !jarsl.writeAttribute(new File(sdafile.getPathName()).getName() + "/", "keyname", dcv.getName());
            failed |= !jarsl.writeAttribute(new File(sdafile.getPathName()).getName() + "/", "keyvendor", dcv.getVendor());
            failed |= !jarsl.writeAttribute(new File(sdafile.getPathName()).getName() + "/", "keylocation", dcv.getLocation());
            failed |= !jarsl.writeAttribute(new File(sdafile.getPathName()).getName() + "/", "keycounter", dcv.getCount().toString());
            failed |= !jarsl.writeAttribute(new File(sdafile.getPathName()).getName() + "/", "Implementation-Title", dcv.getName());
            failed |= !jarsl.writeAttribute(new File(sdafile.getPathName()).getName() + "/", "Implementation-Vendor-Id", dcv.getVendor());
            failed |= !jarsl.writeAttribute(new File(sdafile.getPathName()).getName() + "/", "Implementation-Version", dcv.getCount().toString());
            JarSL jar = new JarSL(sdafile.getPathName(), "");
            if (jar.readAttribute("", "Specification-Title") != null) {
                failed |= !jarsl.writeAttribute(new File(sdafile.getPathName()).getName() + "/", "Specification-Title", jar.readAttribute("", "Specification-Title"));
            }
            if (jar.readAttribute("", "Specification-Vendor") != null) {
                failed |= !jarsl.writeAttribute(new File(sdafile.getPathName()).getName() + "/", "Specification-Vendor", jar.readAttribute("", "Specification-Vendor"));
            }
            if (jar.readAttribute("", "Specification-Version") != null) {
                failed |= !jarsl.writeAttribute(new File(sdafile.getPathName()).getName() + "/", "Specification-Version", jar.readAttribute("", "Specification-Version"));
            }
            if (jar.readAttribute("", "Implementation-Vendor") != null) {
                failed |= !jarsl.writeAttribute(new File(sdafile.getPathName()).getName() + "/", "Implementation-Vendor", jar.readAttribute("", "Implementation-Vendor"));
            }
            if (jar.readAttribute("", "componentelement") != null) {
                failed |= !jarsl.writeAttribute(new File(sdafile.getPathName()).getName() + "/", "componentelement", jar.readAttribute("", "componentelement"));
            }
            String fname = new File(sdafile.getPathName()).getName();
            fname = fname.replace('\\', '/');
            this.projectInfo.writeArchiveToArchiveLinkFile(fname);
            this.projectInfo.writeScToDcLinkFile(comp);
            ++i;
        }
        ComponentElementIF componentelement = ComponentFactoryIF.getInstance().createComponentElement(this.softwarecomponent.getVendor(), this.softwarecomponent.getName(), "SC", "NO_SUBSYS", this.softwarecomponent.getLocation(), this.softwarecomponent.getCounter(), this.softwarecomponent.getVendor(), this.softwarecomponent.getName(), ((ProjectComponent)this).project.getProperty("release"), this.servicelevel, this.patchlevel, "F", null, null, this.softwarecomponent.getPpmsnumber(), this.spelementtypeid, this.spname, this.spversion, null, null, null, null);
        ComponentElementXMLizerIF cex = ComponentElementXMLizerFactoryIF.getInstance().createComponentXMLizerElement(componentelement);
        String cversentry = cex.getXML();
        if (cversentry != null) {
            failed |= !jarsl.writeAttribute("", "componentelement", cversentry);
        }
        return !failed;
    }

    /*
     * Unable to fully structure code
     */
    private String[] getArchivesFromDirectory(String directory) {
        temp = new Vector<String>();
        df = new File(Conv.pathConv((String)directory));
        if (!df.isDirectory()) {
            return null;
        }
        dflist = df.list();
        i = 0;
        while (i < dflist.length) {
            dflist[i] = Conv.pathConvJar((String)(df.getPath() + File.separator + dflist[i]));
            if (!new File(Conv.pathConv((String)dflist[i])).isDirectory()) {
                block18: {
                    isarchive = false;
                    jis = null;
                    try {
                        jis = new JarInputStream(new BufferedInputStream(new FileInputStream(Conv.pathConv((String)dflist[i]))));
                        if (jis.getManifest() != null || jis.getNextJarEntry() != null) {
                            isarchive = true;
                        }
                        jis.close();
                        jis = null;
                        var10_11 = null;
                        ** if (jis == null) goto lbl-1000
                    }
                    catch (Throwable var9_13) {
                        var10_11 = null;
                        if (jis != null) {
                            try {
                                jis.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        throw var9_13;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            jis.close();
                        }
                        catch (IOException e) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block18;
                        catch (Exception e) {
                            var10_11 = null;
                            if (jis != null) {
                                try {
                                    jis.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                }
                if (isarchive) {
                    temp.addElement(dflist[i]);
                }
            }
            ++i;
        }
        if (temp.size() > 0) {
            result = new String[temp.size()];
            i = 0;
            while (i < temp.size()) {
                result[i] = (String)temp.elementAt(i);
                ++i;
            }
            return result;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean writeArchiveList(String listfilename) {
        boolean rc = true;
        BufferedWriter out = null;
        try {
            try {
                out = new BufferedWriter(new FileWriter(listfilename, false));
                int i = 0;
                while (i < this.tldccomp.size()) {
                    SdaFile sdafile = (SdaFile)this.tldccomp.elementAt(i);
                    out.write(sdafile.getPathName());
                    out.newLine();
                    ++i;
                }
                if (this.servicelevel != null) {
                    out.write("::" + _SERVICELEVEL + ":" + this.servicelevel);
                    out.newLine();
                }
                if (this.patchlevel != null) {
                    out.write("::" + _PATCHLEVEL + ":" + this.patchlevel);
                    out.newLine();
                }
                if (this.spname != null) {
                    out.write("::" + _SPNAME + ":" + this.spname);
                    out.newLine();
                }
                if (this.spversion != null) {
                    out.write("::" + _SPVERSION + ":" + this.spversion);
                    out.newLine();
                }
                if (this.spelementtypeid != null) {
                    out.write("::" + _SPELEMENTTYPEID + ":" + this.spelementtypeid);
                    out.newLine();
                }
                out.close();
                return rc;
            }
            catch (Exception e) {
                rc = false;
                Object var7_8 = null;
                if (out == null) return rc;
                try {
                    out.close();
                    return rc;
                }
                catch (IOException e2) {}
                return rc;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String[] getArchivesFromList(String listfilename) throws BuildException {
        String[] result;
        Vector<String> lines;
        block27: {
            String line = null;
            lines = new Vector<String>();
            result = null;
            this.servicelevel = null;
            this.patchlevel = null;
            File list = new File(Conv.pathConv((String)listfilename));
            if (!list.exists()) {
                throw new BuildException("Error during list reading: the file " + list.getPath() + " does not exist");
            }
            if (!list.canRead()) {
                throw new BuildException("Error during list reading: the file " + list.getPath() + " cannot be read");
            }
            BufferedReader bufferedreader = null;
            try {
                try {
                    bufferedreader = new BufferedReader(new FileReader(list));
                    line = bufferedreader.readLine();
                    while (true) {
                        if (line == null) {
                            bufferedreader.close();
                            bufferedreader = null;
                            break;
                        }
                        if ((line = line.trim()).length() > 0) {
                            if (line.startsWith("::" + _SERVICELEVEL + ":")) {
                                this.servicelevel = line.substring(("::" + _SERVICELEVEL + ":").length());
                            } else if (line.startsWith("::" + _PATCHLEVEL + ":")) {
                                this.patchlevel = line.substring(("::" + _PATCHLEVEL + ":").length());
                            } else if (line.startsWith("::" + _SPNAME + ":")) {
                                this.spname = line.substring(("::" + _SPNAME + ":").length());
                            } else if (line.startsWith("::" + _SPVERSION + ":")) {
                                this.spversion = line.substring(("::" + _SPVERSION + ":").length());
                            } else if (line.startsWith("::" + _SPELEMENTTYPEID + ":")) {
                                this.spelementtypeid = line.substring(("::" + _SPELEMENTTYPEID + ":").length());
                            } else {
                                lines.addElement(line);
                            }
                        }
                        try {
                            line = bufferedreader.readLine();
                        }
                        catch (IOException e) {
                            line = null;
                        }
                    }
                }
                catch (Exception e) {
                    throw new BuildException("Error during list reading: " + e);
                }
                Object var9_10 = null;
                if (bufferedreader == null) break block27;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (bufferedreader == null) throw throwable;
                try {
                    bufferedreader.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            bufferedreader.close();
        }
        if (lines.size() <= 0) return null;
        result = new String[lines.size()];
        int i = 0;
        while (i < lines.size()) {
            result[i] = (String)lines.elementAt(i);
            ++i;
        }
        return result;
    }

    private String transformSoftwareComponentName(String scname) {
        StringBuffer stbu = new StringBuffer(scname);
        String _scname = null;
        int xplace = 0;
        while (xplace < stbu.length()) {
            if (!(stbu.charAt(xplace) >= 'A' && stbu.charAt(xplace) <= 'Z' || stbu.charAt(xplace) >= 'a' && stbu.charAt(xplace) <= 'z' || stbu.charAt(xplace) >= '0' && stbu.charAt(xplace) <= '9')) {
                stbu.deleteCharAt(xplace);
                continue;
            }
            ++xplace;
        }
        _scname = stbu.length() > 10 ? stbu.substring(0, 10) : stbu.toString();
        return _scname;
    }

    private JarSL openSCAArchive() {
        JarSL jarsl = null;
        if (!this.printonlyscacontent) {
            File jarfile = null;
            String st = this.transformSoftwareComponentName(this.softwarecomponent.getName());
            st = this.servicelevel.length() < 2 ? st + "0" + this.servicelevel + "_" + this.patchlevel + ".sca" : st + this.servicelevel + "_" + this.patchlevel + ".sca";
            jarfile = this.archivedir != null ? new File(this.archivedir, st) : new File(st);
            jarsl = new JarSL(jarfile.getPath(), "");
        }
        return jarsl;
    }

    /*
     * Unable to fully structure code
     */
    public void execute() throws BuildException {
        errorTexts = null;
        jarsl = null;
        _servicelevel = null;
        _patchlevel = null;
        fileadded = false;
        this.log("Info: ExportSC version " + ExportSC.DEF_exportscversion);
        try {
            UtilInitializer.initializeWithSimpleLog();
        }
        catch (Exception e) {
            throw new BuildException("Error: could not read all necessary SDM property files!");
        }
        this.preevaluation();
        if (!this.consistencyCheck()) {
            throw new BuildException("Error: wrong attribute combination!");
        }
        _servicelevel = this.servicelevel;
        _patchlevel = this.patchlevel;
        this.log("Info: the scacreationmode is " + this.actualscacreationmode);
        while (true) {
            this.tldccomp = new Vector<E>();
            this.servicelevel = _servicelevel;
            this.patchlevel = _patchlevel;
            this.spname = null;
            this.spversion = null;
            this.spelementtypeid = null;
            try {
                if (this.directory != null) {
                    archives = this.getArchivesFromDirectory(this.directory);
                    if (this.servicelevel == null) {
                        this.servicelevel = _servicelevel;
                    }
                    if (this.patchlevel == null) {
                        this.patchlevel = _patchlevel;
                    }
                    if (archives == null || archives.length == 0) {
                        throw new BuildException("Error during SCA creation: no archive is present in given directory (" + this.directory + ")");
                    }
                    if (this.servicelevel == null) {
                        throw new BuildException("Error: missing servicellevel (SP-Number)");
                    }
                    if (this.patchlevel == null) {
                        this.patchlevel = "0";
                    }
                    jarsl = this.openSCAArchive();
                    fileadded |= this.addDevelopmentComponentsToArchive(jarsl, archives, true);
                    break;
                }
                if (this.filelist != null) {
                    archives = this.getArchivesFromList(this.filelist);
                    if (this.servicelevel == null) {
                        this.servicelevel = _servicelevel;
                    } else if (_servicelevel != null && !this.servicelevel.equals(_servicelevel)) {
                        throw new BuildException("Error: different servicellevel (SP-Number) in filelist");
                    }
                    if (this.patchlevel == null) {
                        this.patchlevel = _patchlevel;
                    } else if (_patchlevel != null && !this.patchlevel.equals(_patchlevel)) {
                        throw new BuildException("Error: different patchlevel in filelist");
                    }
                    if (archives == null || archives.length == 0) {
                        throw new BuildException("Error during SCA creation: no archive is present in given list (" + this.filelist + ")");
                    }
                    if (this.servicelevel == null) {
                        throw new BuildException("Error: missing servicellevel (SP-Number)");
                    }
                    if (this.patchlevel == null) {
                        this.patchlevel = "0";
                    }
                    jarsl = this.openSCAArchive();
                    fileadded |= this.addDevelopmentComponentsToArchive(jarsl, archives, true);
                    break;
                }
                if (this.actualscacreationmode.equals("FILE")) {
                    filename = this.transformSoftwareComponentName(this.softwarecomponent.getName());
                    filename = filename + "_" + this.softwarecomponent.getPpmsnumber() + "_" + this.project.getProperty("makelcr.rel").replace('.', '_') + ".sci";
                    filename = this.scacontentpath + "/" + filename;
                    archives = this.getArchivesFromList(filename);
                    if (archives == null || archives.length == 0) {
                        throw new BuildException("Error during SCA creation: no archive is present in given list (" + this.filelist + ")");
                    }
                    if (this.servicelevel == null) {
                        throw new BuildException("Error: missing servicellevel (SP-Number)");
                    }
                    if (_servicelevel != null && !this.servicelevel.equals(_servicelevel)) {
                        throw new BuildException("Error: different servicellevel (SP-Number) in filelist");
                    }
                    if (this.patchlevel == null) {
                        this.patchlevel = _patchlevel;
                    } else if (_patchlevel != null && !this.patchlevel.equals(_patchlevel)) {
                        throw new BuildException("Error: different patchlevel in filelist");
                    }
                    if (this.patchlevel == null) {
                        this.patchlevel = "0";
                    }
                    jarsl = this.openSCAArchive();
                    fileadded |= this.addDevelopmentComponentsToArchive(jarsl, archives, true);
                    break;
                }
                if (!this.actualscacreationmode.equals("LCR")) break;
                lcrlog = new Vector<E>();
                lcrentry = LCREntryFactoryIF.getInstance().createLCREntry(this.softwarecomponent, this.project.getProperty("lcrurl"), this.project.getProperty("release"), this.project.getProperty("makelcr.rel"), this.project.getProperty("scacreationwithoutsdaexistencecheck"), this.project.getProperty("scacreationwithoutidcheck"), this.project.getProperty("secstore.datafilename"), this.project.getProperty("secstore.keyfilename"), lcrlog);
                try {
                    sdafiles = new Vector<E>();
                    supportpackage = new SupportPackage();
                    supportpackage.setServicelevel(this.servicelevel);
                    lcrentry.performLCRConnect();
                    lcrentry.getSupportPackageInfoFromLCR(supportpackage);
                    this.servicelevel = supportpackage.getServicelevel();
                    if (this.servicelevel != null && this.servicelevel.length() > 1 && this.servicelevel.startsWith("0")) {
                        this.servicelevel = this.servicelevel.substring(1);
                    }
                    this.spelementtypeid = supportpackage.getPpmsnumber();
                    this.spname = supportpackage.getName();
                    this.spversion = supportpackage.getVersion();
                    if (this.servicelevel == null) {
                        throw new ProcessingException("Error: missing servicellevel (SP-Number)");
                    }
                    if (this.patchlevel == null) {
                        this.patchlevel = "0";
                    }
                    jarsl = this.openSCAArchive();
                    this.numberofnotfoundarchives = lcrentry.addDevelopmentComponentsToArchive(sdafiles, this.tldccomp, this.printonlyscacontent);
                    sdafilespecarr = new FileSpec[sdafiles.size()];
                    sdafilespecarr = sdafiles.toArray(sdafilespecarr);
                    fileadded = this.addSdasToArchive(sdafilespecarr, jarsl, true);
                    lcrentry.performLCRDisconnect();
                    i = 0;
                    while (i < lcrlog.size()) {
                        this.log((String)lcrlog.elementAt(i));
                        ++i;
                    }
                    break;
                }
                catch (ProcessingException e) {
                    i = 0;
                    ** while (i < lcrlog.size())
                }
lbl-1000:
                // 1 sources

                {
                    this.log((String)lcrlog.elementAt(i));
                    ++i;
                    continue;
                }
lbl121:
                // 1 sources

                lcrentry.performLCRDisconnect();
                throw new BuildException(e.getMessage());
                catch (Exception e) {
                    i = 0;
                    ** while (i < lcrlog.size())
                }
lbl-1000:
                // 1 sources

                {
                    this.log((String)lcrlog.elementAt(i));
                    ++i;
                    continue;
                }
lbl129:
                // 1 sources

                lcrentry.performLCRDisconnect();
                throw e;
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                if (this.directory != null || this.filelist != null || this.actualscacreationmode.equals("FILE") || !this.scacreationmode.equals("AUTO")) {
                    throw new BuildException(e.getMessage());
                }
                this.log("Info: the scacreationmode is switched to FILE");
                this.actualscacreationmode = "FILE";
                continue;
            }
            break;
        }
        if (this.printonlyscacontent) {
            return;
        }
        if (this.softwarecomponent.getCounter() == null) {
            _release = this.project.getProperty("release");
            if (_release.indexOf(".") == -1) {
                _release = _release + ".0";
            }
            this.softwarecomponent.setCounter("1000." + _release + "." + this.servicelevel + "." + this.patchlevel + "." + this.timestamp);
        }
        this.log("Building: " + jarsl.getArchiveName().getPath());
        if (this.project.getProperty("jarsap.info.dir") != null) {
            this.log("Info: found jarsap.info.dir property, I will write structure information to directory " + this.project.getProperty("jarsap.info.dir"));
            this.projectInfo = null != this.softwarecomponent ? new ProjectInfo(this.softwarecomponent, this.project.getProperty("jarsap.info.project"), this.project.getProperty("jarsap.info.rel"), this.project.getProperty("jarsap.info.configuration"), this.project.getProperty("jarsap.info.dir"), jarsl.getArchiveName().getName()) : new ProjectInfo();
        } else {
            this.log("Info: property jarsap.info.dir is not set");
            this.projectInfo = new ProjectInfo();
        }
        this.projectInfo.writeComponentToArchiveLinkFile();
        if (!fileadded) {
            this.log("Warning: creating empty JAR file");
        }
        if (!this.makeMFEntries(jarsl)) {
            throw new BuildException("Error: error in creating the manifest");
        }
        errorTexts = new Vector<E>();
        if (!jarsl.create(false, false, true, errorTexts)) {
            tmpB = new StringBuffer();
            if (null != errorTexts) {
                errIter = errorTexts.iterator();
                while (errIter.hasNext()) {
                    tmpB.append((String)errIter.next());
                }
            }
            throw new BuildException("Error: error in creating the archive (" + tmpB.toString() + ")");
        }
        if (this.scacontentpath != null && this.actualscacreationmode.equals("LCR")) {
            this.log("Info: attribute scacontentpath is set, the SCA content list is written to " + this.scacontentpath);
            filename = this.transformSoftwareComponentName(this.softwarecomponent.getName());
            filename = filename + "_" + this.softwarecomponent.getPpmsnumber() + "_" + this.project.getProperty("makelcr.rel").replace('.', '_') + ".sci";
            filename = this.scacontentpath + "/" + filename;
            this.writeArchiveList(filename);
        }
    }
}

