/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdm.ant;

import com.sap.sdm.ant.Component;
import com.sap.sdm.ant.JarSAP;
import com.sap.sdm.util.jarsl.ConstantsIF;
import com.sap.sdm.util.jarsl.JarSL;
import java.io.File;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.MatchingTask;

public final class DCA
extends MatchingTask
implements ConstantsIF {
    public static String DEF_dcaversion = "20020910.1400";
    static String DEF_specificationvendor = "SAP AG";
    private File jarfile = null;
    private Vector jarsaps = new Vector();
    private Component component = null;

    private boolean preevaluation() {
        if (this.component != null) {
            if (this.component.getSpecificationvendor() == null) {
                this.component.setSpecificationvendor(DEF_specificationvendor);
            }
            if (((ProjectComponent)this).project.getProperty("localmake") != null || ((ProjectComponent)this).project.getProperty("Implementation-Vendor") == null && ((ProjectComponent)this).project.getProperty("Implementation-Vendor-Id") == null && ((ProjectComponent)this).project.getProperty("Implementation-Version") == null) {
                this.component.setImplvendor("localmake");
                this.component.setImplvendorid("000");
                this.component.setImplversion("0.0.0");
            } else {
                if (this.component.getImplvendor() == null) {
                    this.component.setImplvendor(((ProjectComponent)this).project.getProperty("Implementation-Vendor"));
                }
                if (this.component.getImplvendorid() == null) {
                    this.component.setImplvendorid(((ProjectComponent)this).project.getProperty("Implementation-Vendor-Id"));
                }
                if (this.component.getImplversion() == null) {
                    this.component.setImplversion(((ProjectComponent)this).project.getProperty("Implementation-Version"));
                }
            }
            int i = 0;
            while (i < this.jarsaps.size()) {
                JarSAP jarsap = (JarSAP)((Object)this.jarsaps.elementAt(i));
                if (jarsap.getComponent() != null) {
                    jarsap.getComponent().setImplementationtitle(this.component.getImpltitle());
                    jarsap.getComponent().setImplementationversion(this.component.getImplversion());
                    jarsap.getComponent().setImplvendor(this.component.getImplvendor());
                    jarsap.getComponent().setImplvendorid(this.component.getImplvendorid());
                    jarsap.getComponent().setSpecificationname(this.component.getSpecificationname() + "##");
                    jarsap.getComponent().setSpecificationvendor(this.component.getSpecificationvendor());
                    jarsap.getComponent().setSpecificationversion(this.component.getSpecificationversion());
                }
                ++i;
            }
        }
        return true;
    }

    private boolean consistencyCheck() {
        boolean failed = false;
        if (this.jarfile == null) {
            failed = true;
            this.log("Error consistencyCheck: missing jarfile name for dca element");
        }
        if (this.component == null) {
            failed = true;
            this.log("Error consistencyCheck: missing component subelement in the dca element");
        }
        if (this.component != null && (this.component.getSpecificationname() == null || this.component.getSpecificationversion() == null || this.component.getImpltitle() == null || this.component.getImplversion() == null || this.component.getImplvendorid() == null || this.component.getImplvendor() == null)) {
            failed = true;
            if (this.component.getSpecificationname() == null) {
                this.log("Error consistencyCheck: missing specificationname for component element");
            }
            if (this.component.getSpecificationversion() == null) {
                this.log("Error consistencyCheck: missing specificationversion for component element");
            }
            if (this.component.getImpltitle() == null) {
                this.log("Error consistencyCheck: missing implementationtitle for component element");
            }
            if (this.component.getImplversion() == null) {
                this.log("Error consistencyCheck: Property Implementation-Version not supplied in ant call");
            }
            if (this.component.getImplvendorid() == null) {
                this.log("Error consistencyCheck: Property Implementation-Vendor-Id not supplied in ant call");
            }
            if (this.component.getImplvendor() == null) {
                this.log("Error consistencyCheck: Property Implementation-Vendor not supplied in ant call");
            }
        }
        if (((ProjectComponent)this).project.getProperty("dcalocation") == null) {
            failed = true;
            this.log("Error consistencyCheck: Property location not supplied in ant call");
        }
        if (((ProjectComponent)this).project.getProperty("dcacounter") == null) {
            failed = true;
            this.log("Error consistencyCheck: Property counter not supplied in ant call");
        }
        return !failed;
    }

    private boolean makeMFEntries(JarSL jarsl) {
        boolean failed = false;
        failed |= !jarsl.writeAttribute("", "DCA-Version", DEF_dcaversion);
        if (this.component != null) {
            failed |= !jarsl.writeAttribute("", "Specification-Title", this.component.getSpecificationname());
            failed |= !jarsl.writeAttribute("", "Specification-Version", this.component.getSpecificationversion());
            failed |= !jarsl.writeAttribute("", "Specification-Vendor", this.component.getSpecificationvendor());
            failed |= !jarsl.writeAttribute("", "Implementation-Title", this.component.getImpltitle());
            failed |= !jarsl.writeAttribute("", "Implementation-Version", this.component.getImplversion());
            failed |= !jarsl.writeAttribute("", "Implementation-Vendor", this.component.getImplvendor());
            failed |= !jarsl.writeAttribute("", "Implementation-Vendor-Id", this.component.getImplvendorid());
        } else {
            this.log("Warning: No component is specified in build.xml, so the created archive will not be deliverd (no SCA) and no SAP_MANIFEST will be written.");
        }
        int i = 0;
        while (i < this.jarsaps.size()) {
            JarSAP jarsap = (JarSAP)((Object)this.jarsaps.elementAt(i));
            String name = new File(jarsap.getArchiveName()).getName();
            failed |= !jarsl.writeAttribute(name + "/", "Specification-Title", jarsap.getComponent().getSpecificationname());
            failed |= !jarsl.writeAttribute(name + "/", "Specification-Vendor", jarsap.getComponent().getSpecificationvendor());
            failed |= !jarsl.writeAttribute(name + "/", "Specification-Version", jarsap.getComponent().getImplversion());
            failed |= !jarsl.writeAttribute(name + "/", "Implementation-Title", jarsap.getComponent().getImpltitle());
            failed |= !jarsl.writeAttribute(name + "/", "Implementation-Vendor", jarsap.getComponent().getImplvendor());
            failed |= !jarsl.writeAttribute(name + "/", "Implementation-Vendor-Id", jarsap.getComponent().getImplvendorid());
            failed |= !jarsl.writeAttribute(name + "/", "Implementation-Version", jarsap.getComponent().getImplversion());
            ++i;
        }
        failed |= !jarsl.writeAttribute("", "dcacounter", ((ProjectComponent)this).project.getProperty("dcacounter"));
        return !(failed |= !jarsl.writeAttribute("", "dcalocation", ((ProjectComponent)this).project.getProperty("dcalocation")));
    }

    public static void main(String[] arg) {
        if (arg.length == 0) {
            System.out.println("This is DCA version " + DEF_dcaversion);
        }
    }

    public void setJarfile(File jarfile) {
        this.jarfile = jarfile;
    }

    public Component createComponent() throws BuildException {
        this.component = new Component();
        return this.component;
    }

    public JarSAP createJarSAP() {
        JarSAP jarsap = new JarSAP(((ProjectComponent)this).project, "dcamode");
        this.jarsaps.addElement(jarsap);
        return jarsap;
    }

    public void execute() throws BuildException {
        Vector errorTexts = new Vector();
        boolean fileadded = false;
        this.log("Info: DCA version " + DEF_dcaversion);
        this.preevaluation();
        if (!this.consistencyCheck()) {
            throw new BuildException("wrong attribute combination!");
        }
        JarSL jarsl = new JarSL(this.jarfile.getPath(), "");
        boolean rc = true;
        int i = 0;
        while (i < this.jarsaps.size()) {
            JarSAP jarsap = (JarSAP)((Object)this.jarsaps.elementAt(i));
            jarsap.execute();
            if (!jarsl.addFile("", jarsap.getArchiveName(), new File(jarsap.getArchiveName()).getName(), errorTexts, true)) {
                rc = false;
            } else {
                fileadded = true;
            }
            if (!rc) {
                StringBuffer tmpB = new StringBuffer();
                if (null != errorTexts) {
                    Iterator errIter = ((AbstractList)errorTexts).iterator();
                    while (errIter.hasNext()) {
                        tmpB.append((String)errIter.next());
                    }
                }
                throw new BuildException("error in creating the archive (" + tmpB.toString() + ")");
            }
            ++i;
        }
        this.log("Building: " + this.jarfile.getPath());
        if (!fileadded) {
            this.log("Warning: creating empty DCA file");
        }
        if (!this.makeMFEntries(jarsl)) {
            throw new BuildException("error in creating the manifest");
        }
        errorTexts = new Vector();
        if (!jarsl.create(false, false, true, errorTexts)) {
            StringBuffer tmpB = new StringBuffer();
            if (null != errorTexts) {
                Iterator errIter = ((AbstractList)errorTexts).iterator();
                while (errIter.hasNext()) {
                    tmpB.append((String)errIter.next());
                }
            }
            throw new BuildException("error in creating the archive (" + tmpB.toString() + ")");
        }
    }
}

