/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.modeleditor.modelclass;

import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;

public class ModelRelationInfo
implements Comparable {
    public static final int DIRECTION_UNKNOWN = 0;
    public static final int DIRECTION_OUTGOING = 1;
    public static final int DIRECTION_INCOMING = 2;
    public static final int DIRECTION_BIDIRECTIONAL = 3;
    private ModelRelation mModelRelation;
    private ModelClass mSource;
    private int mDirection = -1;

    public ModelRelationInfo(ModelRelation modelRelation, ModelClass source) {
        this.mModelRelation = modelRelation;
        this.mSource = source;
    }

    public String getName() {
        return this.mModelRelation.getName();
    }

    public int getDirection() {
        if (this.mDirection == -1) {
            ModelRelationRole sourceRole = this.getSourceRole();
            ModelRelationRole targetRole = this.getTargetRole();
            this.mDirection = sourceRole == null || targetRole == null ? 0 : (sourceRole.getNavigable() && targetRole.getNavigable() ? 3 : (!sourceRole.getNavigable() ? 1 : 2));
        }
        return this.mDirection;
    }

    public String getDirectionLabel() {
        int direction = this.getDirection();
        switch (direction) {
            case 1: {
                return TextPool.getInstance().getText(427);
            }
            case 2: {
                return TextPool.getInstance().getText(428);
            }
            case 3: {
                return TextPool.getInstance().getText(429);
            }
        }
        return TextPool.getInstance().getText(426);
    }

    public String getSourceRoleInfo() {
        ModelRelationRole sourceRole = this.getSourceRole();
        if (sourceRole != null) {
            return sourceRole.getName() + this.getCardinality(sourceRole);
        }
        return "";
    }

    public String getTargetRoleInfo() {
        ModelRelationRole targetRole = this.getTargetRole();
        if (targetRole != null) {
            return targetRole.getName() + this.getCardinality(targetRole);
        }
        return "";
    }

    public String getTargetClassName() {
        ModelRelationRole targetRole = this.getTargetRole();
        if (targetRole != null && targetRole.getModelClass() != null) {
            return targetRole.getModelClass().getName();
        }
        return "";
    }

    public ModelClass getSourceModelClass() {
        return this.mSource;
    }

    public ModelClass getTargetModelClass() {
        ModelRelationRole targetRole = this.getTargetRole();
        if (targetRole != null) {
            return targetRole.getModelClass();
        }
        return null;
    }

    public ModelRelation getModelRelation() {
        return this.mModelRelation;
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof ModelRelationInfo)) {
            return -1;
        }
        return this.mModelRelation.getName().compareTo(((ModelRelationInfo)o).getName());
    }

    public String toString() {
        return this.mModelRelation.getName();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ModelRelationInfo)) {
            return false;
        }
        return this.mModelRelation.equals(((ModelRelationInfo)obj).getModelRelation()) && this.mSource.equals(((ModelRelationInfo)obj).getSourceModelClass());
    }

    public ModelRelationRole getSourceRole() {
        ModelRelationRole[] roles = this.mModelRelation.getModelRelationRoles();
        if (roles.length == 2) {
            if (this.mSource.equals(roles[0].getModelClass()) && !this.mSource.equals(roles[1].getModelClass()) || this.mSource.equals(roles[0].getModelClass()) && this.mSource.equals(roles[1].getModelClass()) && roles[1].getNavigable()) {
                return roles[0];
            }
            return roles[1];
        }
        ServiceModelEditorPlugin.internalError(this.getClass(), "getSourceRole", "Invalid metadata for model relation " + this.mModelRelation.getName(), null, true);
        if (roles.length == 1 && this.mSource.equals(roles[0].getModelClass())) {
            return roles[0];
        }
        return null;
    }

    public ModelRelationRole getTargetRole() {
        ModelRelationRole[] roles = this.mModelRelation.getModelRelationRoles();
        if (roles.length == 2) {
            if (this.mSource.equals(roles[0].getModelClass()) && !this.mSource.equals(roles[1].getModelClass()) || this.mSource.equals(roles[0].getModelClass()) && this.mSource.equals(roles[1].getModelClass()) && roles[1].getNavigable()) {
                return roles[1];
            }
            return roles[0];
        }
        ServiceModelEditorPlugin.internalError(this.getClass(), "getTargetRole", "Invalid metadata for model relation " + this.mModelRelation.getName(), null, true);
        if (roles.length == 1 && !this.mSource.equals(roles[0].getModelClass())) {
            return roles[0];
        }
        return null;
    }

    public String getCardinality(ModelRelationRole role) {
        CardinalityEnum cardinality = role.getCardinality();
        if (cardinality.equals(CardinalityEnum._0_1)) {
            return " (0..1)";
        }
        if (cardinality.equals(CardinalityEnum._1_1)) {
            return " (1..1)";
        }
        if (cardinality.equals(CardinalityEnum._0_N)) {
            return " (0..n)";
        }
        if (cardinality.equals(CardinalityEnum._1_N)) {
            return " (1..n)";
        }
        return " (None)";
    }
}

