/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.modeleditor.modelclass;

import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproMDOEnum;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.base.AppClass;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.ide.webdynpro.generation.dependency.ModelClassDependency;
import com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse;
import com.sap.ide.webdynpro.service.core.BrowseHelper;
import com.sap.ide.webdynpro.service.core.CheckServices;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectNameComparator;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelRelationInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.ui.IFileEditorInput;

public final class ModelClassService {
    public static final String NAME_VOID = "void";
    public static final String SETTING_PROXY_CLASS_NAME = "proxyClassName";
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelClassService;

    public static boolean generateModelClass(ModelClass modelClass, IProject project, IProgressMonitor monitor) {
        String projectPath = project.getLocation().toFile().getAbsolutePath();
        GenerationEclipse generator = new GenerationEclipse(monitor);
        generator.setTargetPath(projectPath);
        generator.setIncremental(true);
        generator.refreshConfiguration();
        String[] generatedFiles = generator.generatePersistentModelClass(modelClass, true, true, true, true);
        generator.cleanup();
        return generatedFiles != null && generatedFiles.length > 0;
    }

    public static String isValidMethodName(String methodName, AppClass appClass) {
        if (!CheckServices.isValidIdentifier((String)methodName)) {
            return CoreTextPool.getInstance().getText(1, (Object)methodName);
        }
        if (ModelClassService.methodExists(appClass, methodName)) {
            return TextPool.getInstance().getText(15, TextPool.getInstance().getText(411), methodName);
        }
        return null;
    }

    public static boolean methodExists(AppClass appClass, String name) {
        return appClass.hasEventHandler(name) || appClass.hasErrorHandler(name) || appClass.hasMethod(name) || appClass.hasValidator(name);
    }

    public static boolean isImplementationFile(IFileEditorInput fileEditorInput) {
        if (fileEditorInput != null) {
            return ModelClassService.isImplementationFile(fileEditorInput.getFile());
        }
        return false;
    }

    public static boolean isImplementationFile(IFile file) {
        ModelClass modelClass = ModelClassService.getModelClassFromImplementationFile(file);
        return modelClass != null;
    }

    public static ModelClass getModelClassFromImplementationFile(IFileEditorInput fileEditorInput) {
        if (fileEditorInput != null) {
            return ModelClassService.getModelClassFromImplementationFile(fileEditorInput.getFile());
        }
        return null;
    }

    public static ModelClass getModelClassFromImplementationFile(IFile file) {
        ModelClass modelClass = null;
        if (file == null || !file.exists() || !file.getName().endsWith(".java")) {
            return null;
        }
        try {
            String packageName = BrowseHelper.getPackageName((IResource)file, (IJavaProject)ServicesEclipse.getJavaProject((String)file.getProject().getName()));
            Model[] models = MetamodelServices.getWebDynproRoot((String)file.getProject().getName()).getModels();
            modelClass = ModelClassDependency.getModelClassFromModelClassFile((String)packageName, (String)file.getName().substring(0, file.getName().lastIndexOf(".")), (String)file.getFileExtension(), (Model[])models);
        }
        catch (JavaModelException e) {
            ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelClassService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelClassService = ModelClassService.class$("com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelClassService")) : class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelClassService, "getModelClassFromImplementationFile", "Failed to read the package name of the java class", e, false);
        }
        catch (LoadException e) {
            ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelClassService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelClassService = ModelClassService.class$("com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelClassService")) : class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelClassService, "getModelClassFromImplementationFile", "Failed to read components from metamodel", e, false);
        }
        return modelClass;
    }

    public static ModelClass getModelClassFromMetadataFile(IFileEditorInput fileEditorInput) throws LoadException {
        IFile file = null;
        if (fileEditorInput != null && (file = fileEditorInput.getFile()) != null && file.exists() && file.getName().endsWith(".java")) {
            return null;
        }
        IJavaProject javaProject = ServicesEclipse.getJavaProject((String)file.getProject().getName());
        if (javaProject == null) {
            ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelClassService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelClassService = ModelClassService.class$("com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelClassService")) : class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelClassService, "getModelClassFromMetadataFile", "Failed to retrieve java project reference for project name " + file.getProject().getName(), null, false);
            return null;
        }
        String packageName = null;
        try {
            packageName = javaProject.findPackageFragment(file.getParent().getFullPath()).getElementName();
        }
        catch (JavaModelException e) {
            ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelClassService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelClassService = ModelClassService.class$("com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelClassService")) : class$com$sap$ide$webdynpro$service$modeleditor$modelclass$ModelClassService, "getModelClassFromMetadataFile", "Failed to read package name from model class implementation file, project: " + file.getProject().getName(), null, false);
            return null;
        }
        String modelClassName = file.getName();
        modelClassName = modelClassName.substring(0, modelClassName.lastIndexOf("."));
        String extension = file.getFileExtension();
        if (extension.equals(WebDynproMDOEnum.MODELCLASS.getFileExtension())) {
            WebDynproRoot root = MetamodelServices.getWebDynproRoot((String)file.getProject().getName());
            Model[] models = root.getModels();
            int i = 0;
            while (i < models.length) {
                if (models[i].hasModelClass(packageName, modelClassName)) {
                    return models[i].getModelClass(packageName, modelClassName);
                }
                ++i;
            }
        }
        return null;
    }

    public static ModelRelationInfo[] convertToModelRelationInfos(ModelRelationRole[] sourceRoles, ModelClass modelClass) {
        ModelRelationInfo[] infoObjects = new ModelRelationInfo[sourceRoles.length];
        int i = 0;
        while (i < sourceRoles.length) {
            ModelRelationRole sourceRole = sourceRoles[i];
            infoObjects[i] = new ModelRelationInfo(sourceRole.getModelRelation(), sourceRole.getModelClass());
            ++i;
        }
        return infoObjects;
    }

    public static ModelRelationInfo[] getModelRelationInfos(ModelClass modelClass, boolean querySuperClass) {
        HashMap modelRelations = new HashMap();
        ModelClassService.addModelRelationInfos(modelClass, querySuperClass, modelRelations);
        return modelRelations.values().toArray(new ModelRelationInfo[modelRelations.size()]);
    }

    public static void removeInterface(ModelClass modelClass, ModelClass interfaceToRemove) {
        if (modelClass.hasInterface(interfaceToRemove)) {
            modelClass.removeInterface(interfaceToRemove);
        }
    }

    public static void sort(ModelClass modelClass, ModelRelationInfo[] relations) {
        ArrayList<ModelRelationInfo> sortedMembers = new ArrayList<ModelRelationInfo>(relations.length);
        DevelopmentObjectNameComparator comparator = new DevelopmentObjectNameComparator();
        Arrays.sort(relations);
        ModelClassService.sort(modelClass, relations, sortedMembers, comparator);
        int i = 0;
        while (i < relations.length) {
            if (relations[i] != null) {
                sortedMembers.add(relations[i]);
            }
            ++i;
        }
        sortedMembers.toArray(relations);
    }

    public static String getTypeName(DevelopmentObject type) {
        if (type instanceof DtSimpleType) {
            if ("com.sap.dictionary".equals(((DtSimpleType)type).getPackage())) {
                return type.getName();
            }
            return type.getName() + "     (" + ((DtSimpleType)type).getPackage() + ')';
        }
        if (type instanceof DtGeneralStructure) {
            return type.getName() + "     (" + ((DtGeneralStructure)type).getPackage() + ')';
        }
        String name = type.getName();
        int packageLen = name.lastIndexOf(46);
        if (packageLen > 0) {
            String packageName = name.substring(0, packageLen - 1);
            name = name.substring(packageLen + 1) + "    (" + packageName + ")";
        }
        return name;
    }

    private static void addModelRelationInfos(ModelClass modelClass, boolean querySuperClass, Map modelRelations) {
        if (modelClass != null) {
            ModelClass curClass = modelClass;
            do {
                ModelRelationInfo[] curModelRelations = ModelClassService.getModelRelationInfos(curClass);
                int i = 0;
                while (i < curModelRelations.length) {
                    String name = curModelRelations[i].getName();
                    if (modelRelations.get(name) == null) {
                        modelRelations.put(name, curModelRelations[i]);
                    }
                    ++i;
                }
                if (curClass.getInterfaceCount() <= 0) continue;
                ModelClass[] curInterfaces = curClass.getInterfaces();
                int i2 = 0;
                while (i2 < curInterfaces.length) {
                    ModelClassService.addModelRelationInfos(curInterfaces[i2], true, modelRelations);
                    ++i2;
                }
            } while ((curClass = (ModelClass)curClass.getSuperClass()) != null && querySuperClass);
        }
    }

    private static ModelRelationInfo[] getModelRelationInfos(ModelClass modelClass) {
        ModelRelationRole[] sourceRoles = ModelClassHelper.getSourceRoles((ModelClass)modelClass);
        ArrayList<ModelRelationInfo> infos = new ArrayList<ModelRelationInfo>(sourceRoles.length);
        int i = 0;
        while (i < sourceRoles.length) {
            infos.add(new ModelRelationInfo(sourceRoles[i].getModelRelation(), modelClass));
            ++i;
        }
        return infos.toArray(new ModelRelationInfo[infos.size()]);
    }

    private static void sort(ModelClass modelClass, ModelRelationInfo[] relations, List sortedMembers, DevelopmentObjectNameComparator comparator) {
        if (!modelClass.getIsInterface() && modelClass.getSuperClass() != null) {
            ModelClassService.sort((ModelClass)modelClass.getSuperClass(), relations, sortedMembers, comparator);
        }
        if (modelClass.getInterfaceCount() > 0) {
            ModelClass[] interfaces = modelClass.getInterfaces();
            Arrays.sort(interfaces, comparator);
            int i = 0;
            while (i < interfaces.length) {
                ModelClassService.sort(interfaces[i], relations, sortedMembers, comparator);
                ++i;
            }
        }
        int i = 0;
        while (i < relations.length) {
            if (relations[i] != null && relations[i].getSourceModelClass().equals(modelClass)) {
                sortedMembers.add(relations[i]);
                relations[i] = null;
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

