/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.modeleditor;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.webdynpro.checklayer.model.ModelClassHelper;
import com.sap.ide.webdynpro.generation.eclipse.deletion.DeletionService;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.ModelRepositoryService;
import com.sap.ide.webdynpro.service.modeleditor.ModelService;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import com.sap.ide.webdynpro.service.modeleditor.ServiceWithUI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public class ServiceDeletion {
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$modeleditor$ModelService;

    public static void deleteModel(Model model) {
        if (model != null) {
            IProject project = ServicesEclipse.getEclipseProject((DevelopmentObject)model);
            ModelClass[] modelClasses = model.getModelClasses();
            IPath sourcePath = ModelService.getSourcePath((MainDevelopmentObject)model);
            try {
                if (model.hasLogicalDictionary()) {
                    DtLogicalDictionary dictionary = (DtLogicalDictionary)model.getLogicalDictionary();
                    DtDictionaryRoot dictionaryRoot = MetamodelServices.getDictionaryRoot((String)model.getRoot().getMetamodel().getName());
                    DtSimpleType[] simpleTypes = dictionaryRoot.getSimpleTypes(dictionary.getPackage());
                    int i = 0;
                    while (i < simpleTypes.length) {
                        simpleTypes[i].delete();
                        ++i;
                    }
                    DtGeneralStructure[] structures = dictionaryRoot.getStructures(dictionary.getPackage());
                    int i2 = 0;
                    while (i2 < structures.length) {
                        structures[i2].delete();
                        ++i2;
                    }
                    dictionary.delete();
                }
                ServiceWithUI.closeOpenEditors(model);
                model.delete();
            }
            catch (DeleteException e) {
                ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$ModelService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$ModelService = ServiceDeletion.class$("com.sap.ide.webdynpro.service.modeleditor.ModelService")) : class$com$sap$ide$webdynpro$service$modeleditor$ModelService, "deleteModel", "Failed to delete metadata for model " + model.getName(), e, false);
            }
            catch (LoadException e) {
                String dictionaryName = model.hasLogicalDictionary() ? model.getLogicalDictionary().getName() : "<null>";
                ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$ModelService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$ModelService = ServiceDeletion.class$("com.sap.ide.webdynpro.service.modeleditor.ModelService")) : class$com$sap$ide$webdynpro$service$modeleditor$ModelService, "deleteModel", "Failed to load dictionary types of logical dictionary " + dictionaryName, e, false);
            }
        }
    }

    public static void deleteModelClass(ModelClass modelClass) {
        if (modelClass != null) {
            MMRepositoryObject[] repositoryObjects = ModelRepositoryService.getRepositoryObjectsAffectedByModelClassDeletion(modelClass);
            MainDevelopmentObject[] mdos = ModelRepositoryService.getMDOsFromRepositoryObjects(repositoryObjects);
            int i = 0;
            while (i < mdos.length) {
                if (mdos[i] instanceof ModelClass && !mdos[i].equals(modelClass)) {
                    ModelClass mc = (ModelClass)mdos[i];
                    if (modelClass.getIsInterface()) {
                        mc.removeInterface(modelClass);
                    } else {
                        mc.setSuperClass(null);
                    }
                }
                ++i;
            }
            ModelRelationRole[] sourceRoles = ModelClassHelper.getSourceRoles((ModelClass)modelClass, (boolean)false);
            int i2 = 0;
            while (i2 < sourceRoles.length) {
                ModelRelation relation = sourceRoles[i2].getModelRelation();
                if (relation != null) {
                    try {
                        relation.delete();
                    }
                    catch (DeleteException e) {
                        ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$ModelService == null ? ServiceDeletion.class$("com.sap.ide.webdynpro.service.modeleditor.ModelService") : class$com$sap$ide$webdynpro$service$modeleditor$ModelService, "deleteModelClass", "Failed to delete model relation " + relation.getName(), e, false);
                    }
                }
                ++i2;
            }
            try {
                modelClass.delete();
            }
            catch (DeleteException e) {
                ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$ModelService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$ModelService = ServiceDeletion.class$("com.sap.ide.webdynpro.service.modeleditor.ModelService")) : class$com$sap$ide$webdynpro$service$modeleditor$ModelService, "deleteModelClass", "Failed to delete model class " + modelClass.getName(), e, false);
            }
            IProject project = ServicesEclipse.getEclipseProject((DevelopmentObject)modelClass);
            if (project != null) {
                DeletionService deletionService = new DeletionService(project);
                deletionService.deleteModelClass(modelClass, true);
            }
        }
    }

    public static void deleteModelRelation(ModelRelation modelRelation) {
        try {
            modelRelation.delete();
        }
        catch (DeleteException e) {
            ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$ModelService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$ModelService = ServiceDeletion.class$("com.sap.ide.webdynpro.service.modeleditor.ModelService")) : class$com$sap$ide$webdynpro$service$modeleditor$ModelService, "deleteModelRelation", "Failed to delete model relation " + modelRelation.getName(), e, false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

