/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.modeleditor;

import com.sap.ide.jcb.core.service.generation.IGenerationData;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.importers.rfcmodel.RFCModelImporter;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.service.core.BrowseHelper;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.PlatformUI;

public final class RfcModelImportService {
    private static final String PORTTYPE_SUFFIX = "_PortType";
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService;

    public static Model doImport(WebDynproRoot webDynproRoot, DtDictionaryRoot dictionaryRoot, String modelPackage, String modelName, SourcePathIdentifier sourcePathIdentifier, IResource portType, IGenerationData generationData, IProgressMonitor monitor) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(webDynproRoot.getMetamodel().getName());
        Model model = null;
        if (project != null) {
            try {
                String fullyQualifiedProxyName = generationData.getPackageName() + '.' + generationData.getClassName() + PORTTYPE_SUFFIX;
                String outputLocation = BrowseHelper.getOutputLocation((IProject)project);
                if (outputLocation == null) {
                    ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService = RfcModelImportService.class$("com.sap.ide.webdynpro.service.modeleditor.RfcModelImportService")) : class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService, "doImport", "Failed to read output location for project " + project.getName(), null, false);
                    return null;
                }
                IPath proxyPath = portType.getLocation();
                proxyPath = proxyPath.removeLastSegments(1);
                MetamodelManager.refresh((IProject)project, (IPath)proxyPath, (boolean)true, (IProgressMonitor)monitor);
                project.build(10, monitor);
                URL urlProxyClasses = new URL("file:///" + outputLocation + File.separatorChar);
                IPluginDescriptor descriptor = ServiceModelEditorPlugin.getDefault().getDescriptor();
                if (descriptor != null) {
                    URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{urlProxyClasses}, descriptor.getPluginClassLoader());
                    Class<?> proxyClass = Class.forName(fullyQualifiedProxyName, true, urlClassLoader);
                    RFCModelImporter importer = new RFCModelImporter(dictionaryRoot, webDynproRoot);
                    model = importer.doImport(modelPackage, modelName, sourcePathIdentifier, proxyClass);
                } else {
                    ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService = RfcModelImportService.class$("com.sap.ide.webdynpro.service.modeleditor.RfcModelImportService")) : class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService, "doImport", "Cannot get plugin descriptor from runtime plugin", null, false);
                }
            }
            catch (ClassNotFoundException e) {
                ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService = RfcModelImportService.class$("com.sap.ide.webdynpro.service.modeleditor.RfcModelImportService")) : class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService, "doImport", "Cannot load proxy class " + generationData.getClassName() + ", detail: " + e.getMessage() + ".\nCheck for make errors in the task list which might prevent the build of the generated java proxies.", e, false);
            }
            catch (MalformedURLException e) {
                ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService = RfcModelImportService.class$("com.sap.ide.webdynpro.service.modeleditor.RfcModelImportService")) : class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService, "doImport", "Project path cannot be located" + generationData.getClassName() + ", detail: " + e.getMessage(), e, false);
            }
            catch (CoreException e) {
                ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService = RfcModelImportService.class$("com.sap.ide.webdynpro.service.modeleditor.RfcModelImportService")) : class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService, "doImport", "Failed to build project " + project.getName() + " , detail: " + e.getMessage(), e, false);
            }
            catch (Exception e) {
                ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService = RfcModelImportService.class$("com.sap.ide.webdynpro.service.modeleditor.RfcModelImportService")) : class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService, "doImport", "Failed to import model, detail: " + e.getMessage(), e, false);
            }
        }
        return model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String extractJavaFilesFromJar(String jarFileName, String javaSourceDir) {
        File jarFileObj = new File(jarFileName);
        String proxyClassName = null;
        if (javaSourceDir.length() > 0 && javaSourceDir.charAt(javaSourceDir.length() - 1) != File.separatorChar) {
            javaSourceDir = javaSourceDir + File.separatorChar;
        }
        if (jarFileObj.canRead()) {
            try {
                JarFile jar = new JarFile(jarFileObj, false, 1);
                boolean overwriteAll = false;
                Enumeration<JarEntry> jarEntries = jar.entries();
                ZipEntry entry = null;
                while (jarEntries.hasMoreElements() && entry == null) {
                    entry = jarEntries.nextElement();
                }
                if (entry != null) {
                    RfcModelImportService.createJavaSourceDir(javaSourceDir, entry.getName());
                }
                jarEntries = jar.entries();
                while (jarEntries.hasMoreElements()) {
                    entry = jarEntries.nextElement();
                    boolean overwriteFile = true;
                    if (entry == null || entry.getName().lastIndexOf(".java") == -1) continue;
                    InputStream iStream = jar.getInputStream(entry);
                    if (iStream != null) {
                        File javaFile;
                        if (entry.getName().lastIndexOf("_PortType.java") != -1) {
                            proxyClassName = entry.getName();
                            proxyClassName = proxyClassName.substring(0, proxyClassName.lastIndexOf(".java"));
                            proxyClassName = proxyClassName.replace(File.separatorChar, '.');
                        }
                        if ((javaFile = new File(javaSourceDir + entry.getName())).exists()) {
                            if (!overwriteAll) {
                                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), TextPool.getInstance().getText(301), null, TextPool.getInstance().getText(207, javaFile.getAbsolutePath()), 3, new String[]{IDialogConstants.YES_LABEL, CoreTextPool.getInstance().getText(212), IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
                                int status = dialog.open();
                                if (status == 0) {
                                    overwriteFile = true;
                                } else if (status == 1) {
                                    overwriteAll = true;
                                } else {
                                    if (status != 2) return null;
                                    overwriteFile = false;
                                }
                            }
                        } else if (!javaFile.createNewFile()) {
                            ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService = RfcModelImportService.class$("com.sap.ide.webdynpro.service.modeleditor.RfcModelImportService")) : class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService, "extractJavaFilesFromJar", "Failed to extract Java source files from JAR", null, false);
                            return null;
                        }
                        if (!overwriteFile && !overwriteAll) continue;
                        FileOutputStream oStream = new FileOutputStream(javaFile);
                        byte[] data = new byte[iStream.available()];
                        int readSize = 0;
                        while (readSize < iStream.available()) {
                            readSize += iStream.read(data, readSize, iStream.available() - readSize);
                        }
                        oStream.write(data);
                        oStream.flush();
                        continue;
                    }
                    ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService == null ? RfcModelImportService.class$("com.sap.ide.webdynpro.service.modeleditor.RfcModelImportService") : class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService, "extractJavaFilesFromJar", "Failed to retrieve entry " + entry.getName() + " from JAR file " + jarFileName, null, false);
                }
                return proxyClassName;
            }
            catch (IOException e) {
                ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService = RfcModelImportService.class$("com.sap.ide.webdynpro.service.modeleditor.RfcModelImportService")) : class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService, "extractJavaFilesFromJar", "Failed to retrieve jar file entries. Detail: " + e.getMessage(), e, false);
            }
            return proxyClassName;
        }
        ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService = RfcModelImportService.class$("com.sap.ide.webdynpro.service.modeleditor.RfcModelImportService")) : class$com$sap$ide$webdynpro$service$modeleditor$RfcModelImportService, "extractJavaFilesFromJar", "Access denied. Jar file " + jarFileName, null, false);
        return proxyClassName;
    }

    private static void createJavaSourceDir(String javaSourceDir, String javaFileName) {
        File packageDir;
        String packageDirName = javaSourceDir + javaFileName;
        int length = packageDirName.lastIndexOf(File.separatorChar) + 1;
        if (length != -1) {
            packageDirName = packageDirName.substring(0, length);
        }
        if (!(packageDir = new File(packageDirName)).exists()) {
            packageDir.mkdirs();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

