/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.modeleditor;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.core.services.ServicesEclipse;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.event.MetamodelUserEvent;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.webdynpro.generation.eclipse.GenerationEclipse;
import com.sap.ide.webdynpro.generation.naming.NamingService;
import com.sap.ide.webdynpro.service.core.CallbackException;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.EditorService;
import com.sap.ide.webdynpro.service.core.PreRemoveReferencedObjectEvent;
import com.sap.ide.webdynpro.service.core.UIHelper;
import com.sap.ide.webdynpro.service.modeleditor.DeleteModelDialog;
import com.sap.ide.webdynpro.service.modeleditor.IModelEditorCallback;
import com.sap.ide.webdynpro.service.modeleditor.ModelRepositoryService;
import com.sap.ide.webdynpro.service.modeleditor.ServiceDeletion;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public final class ModelService {
    private static IModelEditorCallback mModelEditorCallback;
    static /* synthetic */ Class class$com$sap$ide$webdynpro$service$modeleditor$ModelService;

    public static void initialize(IModelEditorCallback callback) {
        if (mModelEditorCallback != null) {
            System.out.println("Warning: Context callback already set");
            return;
        }
        mModelEditorCallback = callback;
    }

    public static Model createModelWithUI(WebDynproRoot webDynproRoot, DtDictionaryRoot dictionaryRoot) {
        return ModelService.getModelEditorCallback().createModel(webDynproRoot, dictionaryRoot);
    }

    public static ModelClass createModelClassWithUI(Model model) {
        MMRepositoryObject[] repositoryObjects = ModelRepositoryService.getRepositoryObjectsAffectedByModelClassCreation(model);
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return null;
        }
        return ModelService.getModelEditorCallback().createModelClass(model);
    }

    public static ModelRelation createModelRelationWithUI(ModelClass modelClass) {
        MMRepositoryObject[] repositoryObjects = ModelRepositoryService.getRepositoryObjectsAffectedByRelationCreation(modelClass.getModel());
        if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
            return null;
        }
        return ModelService.getModelEditorCallback().createModelRelation(modelClass);
    }

    public static void deleteModelWithUI(Model model) {
        DeleteModelDialog dialog = new DeleteModelDialog(model);
        if (dialog.open() == 0) {
            MMRepositoryObject[] repositoryObjects;
            try {
                repositoryObjects = ModelRepositoryService.getRepositoryObjectsAffectedByModelDeletion(model);
            }
            catch (LoadException e) {
                ServiceModelEditorPlugin.internalError(class$com$sap$ide$webdynpro$service$modeleditor$ModelService == null ? (class$com$sap$ide$webdynpro$service$modeleditor$ModelService = ModelService.class$("com.sap.ide.webdynpro.service.modeleditor.ModelService")) : class$com$sap$ide$webdynpro$service$modeleditor$ModelService, "deleteModelWithUI", "Model deletion failed. Description: Cannot retrieve corresponding repository objects.", e, false);
                return;
            }
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            ServiceDeletion.deleteModel(model);
        }
    }

    public static void deleteModelClassWithUI(ModelClass modelClass) {
        if (UIHelper.askUserToDelete((String)modelClass.getName(), (String)CoreTextPool.getInstance().getText(127))) {
            MMRepositoryObject[] repositoryObjects = ModelRepositoryService.getRepositoryObjectsAffectedByModelClassDeletion(modelClass);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            IEditorPart editor = EditorService.findDevelopmentObjectEditor((DevelopmentObject)modelClass);
            if (editor != null) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(editor, false);
            }
            ServiceDeletion.deleteModelClass(modelClass);
        }
    }

    public static void deleteModelRelationWithUI(ModelRelation modelRelation) {
        if (UIHelper.askUserToDelete((String)modelRelation.getName(), (String)CoreTextPool.getInstance().getText(127))) {
            MMRepositoryObject[] repositoryObjects = ModelRepositoryService.getRepositoryObjectsAffectedByRelationDeletion(modelRelation);
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects)) {
                return;
            }
            ServiceDeletion.deleteModelRelation(modelRelation);
        }
    }

    public static void addUsedModelWithUI(Model model) {
        ModelService.getModelEditorCallback().addUsedModel(model);
    }

    public static IPath getSourcePath(MainDevelopmentObject mdo) {
        Path path = new Path(mdo.getAbsolutePath());
        Path packageName = new Path(mdo.getPackage());
        return path.removeLastSegments(packageName.segmentCount() + 1);
    }

    public static void generateModel(Model model, IProgressMonitor monitor) {
        IProject project = ServicesEclipse.getEclipseProject((DevelopmentObject)model);
        GenerationEclipse generator = new GenerationEclipse(monitor);
        generator.setTargetPath(project.getLocation().toFile().getAbsolutePath());
        generator.setIncremental(true);
        generator.refreshConfiguration();
        generator.generatePersistentModel(model, false, false, true, true);
        generator.cleanup();
    }

    public static void removeUsedModel(Model model, Model usedModel) {
        if (model.hasUsedModel(usedModel)) {
            PreRemoveReferencedObjectEvent event = new PreRemoveReferencedObjectEvent((DevelopmentObject)usedModel);
            model.fireUserEvent((MetamodelUserEvent)event);
            model.removeUsedModel(usedModel);
        }
    }

    private static IFolder getParentFolder(ModelClass modelClass, String projectPath) {
        NamingService namingService = new NamingService(projectPath + GenerationEclipse.getGenerationOutputPathInfix());
        Path path = new Path(namingService.getModelClassNaming(modelClass).getAbsoluteFilePath());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
        IFolder folder = null;
        if (file != null) {
            folder = (IFolder)file.getParent();
        }
        return folder;
    }

    private static IModelEditorCallback getModelEditorCallback() throws CallbackException {
        if (mModelEditorCallback == null) {
            throw new CallbackException("No context callback registered");
        }
        return mModelEditorCallback;
    }

    public static int renameModelClassWithUI(ModelClass modelClass) {
        return ModelService.getModelEditorCallback().renameModelClass(modelClass);
    }

    public static Model reImportModel(Model model) {
        return ModelService.getModelEditorCallback().reimportModel(model);
    }

    public static Model upgradeRFCModel(Model model) {
        return ModelService.getModelEditorCallback().upgradeRFCModel(model);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

