/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.modeleditor;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.plugin.WebDynproRootManager;
import com.sap.ide.webdynpro.service.core.DevelopmentObjectElementFactory;
import com.sap.ide.webdynpro.service.modeleditor.modelclass.ModelClassEditorInput;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IMemento;

public class ModelElementFactory
extends DevelopmentObjectElementFactory {
    public static final String FACTORY_ID = "com.sap.ide.webdynpro.service.modeleditor.ModelElementFactory";
    public static final String KEY_MODEL = "model";
    public static final String KEY_MODEL_PACKAGE = "modelPackage";

    public IAdaptable createElement(IMemento memento) {
        String projectName = memento.getString("project");
        if (projectName == null) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.isAccessible()) {
            return null;
        }
        String packageName = memento.getString("package");
        if (packageName == null) {
            return null;
        }
        String objectName = memento.getString("developmentObject");
        if (objectName == null) {
            return null;
        }
        String modelName = memento.getString(KEY_MODEL);
        if (modelName == null) {
            return null;
        }
        String modelPackage = memento.getString(KEY_MODEL_PACKAGE);
        if (modelPackage == null) {
            return null;
        }
        Metamodel metamodel = MetamodelManager.getMetamodel((String)projectName);
        WebDynproRoot root = WebDynproRootManager.getWebDynproRoot((Metamodel)metamodel);
        Model model = null;
        try {
            model = root.getModel(modelPackage, modelName);
        }
        catch (LoadException e) {
            return null;
        }
        if (model == null) {
            return null;
        }
        ModelClass modelClass = model.getModelClass(packageName, objectName);
        if (modelClass == null) {
            return null;
        }
        return new ModelClassEditorInput(modelClass);
    }
}

