/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.webdynpro.service.modeleditor;

import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.webdynpro.checklayer.model.ModelHelper;
import com.sap.ide.webdynpro.service.core.CoreTextPool;
import com.sap.ide.webdynpro.service.core.MetamodelServices;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import com.sap.ide.webdynpro.ui.image.WebDynproImage;
import com.tssap.util.ui.image.ISapImage;
import com.tssap.util.ui.image.SapIdeUtilImages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class DeleteModelDialog
extends MessageDialog {
    private Model mModel;
    private boolean mDeleteProxies = false;

    public DeleteModelDialog(Model model) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Delete Model", SapIdeUtilImages.getSapImage((ISapImage)WebDynproImage.ICON_MODEL), CoreTextPool.getInstance().getText(401, (Object)"Model", (Object)model.getName()), 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        this.mModel = model;
    }

    public boolean shouldDeleteProxies() {
        return this.mDeleteProxies;
    }

    protected Control createCustomArea(Composite parent) {
        String text = "";
        if (MetamodelServices.hasModelTypeRfcAdapter((Model)this.mModel)) {
            String packageName = ModelHelper.getModelSettingDefinitionValue((Model)this.mModel, (String)"proxyClassName");
            if (packageName != null && packageName.length() > 0 && packageName.lastIndexOf(46) != -1) {
                packageName = packageName.substring(0, packageName.lastIndexOf(46) - 1);
            }
            text = text + "Note: Corresponding RFC proxy classes in package '" + packageName + "'\nhave to be deleted by the user.\n";
        } else if (this.mModel.hasLogicalDictionary()) {
            text = text + "Note: The corresponding types contained in the logical dictionary '" + this.mModel.getLogicalDictionary().getName() + "' will be deleted, too.";
        } else if (this.mModel.getModelType() != null && this.mModel.getModelType().getDependenciesAllowed()) {
            String referencingModels = "";
            try {
                WebDynproRoot webDynproRoot = MetamodelServices.getWebDynproRoot((String)this.mModel.getRoot().getMetamodel().getName());
                Model[] models = webDynproRoot.getModels();
                int i = 0;
                while (i < models.length) {
                    if (models[i].hasUsedModel(this.mModel)) {
                        if (i > 0) {
                            referencingModels = referencingModels + ", ";
                        }
                        referencingModels = referencingModels + models[i].getName();
                    }
                    ++i;
                }
            }
            catch (LoadException e) {
                ServiceModelEditorPlugin.internalError(((Object)((Object)this)).getClass(), "createCustomArea", "Failed to load the metamodel for '" + this.mModel.getRoot().getMetamodel().getName() + "'", e, false);
                e.printStackTrace();
            }
            if (referencingModels.length() > 0) {
                text = text + "Note: The model is used by the following other models " + referencingModels + ". All references to this model will be removed.";
            }
        }
        if (text.length() > 0) {
            Label label = new Label(parent, 0);
            label.setText(text);
            Label label2 = new Label(parent, 0);
        }
        return parent;
    }
}

