/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.xmi.parsing;

import com.sap.ide.metamodel.importers.xmi.mom.MetamodelAssociation;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelAssociationEnd;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelAttribute;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelClass;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelOperation;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelParameter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMI11Handler
extends DefaultHandler {
    private Locator mLocator;
    private HashMap mPackages = new HashMap();
    private HashMap mPackageNames = new HashMap();
    private HashMap mClassesById = new HashMap();
    private HashMap mClassesByName = new HashMap();
    private HashMap mAttributes = new HashMap();
    private HashMap mOperations = new HashMap();
    private HashMap mAssociations = new HashMap();
    private HashMap mRoles = new HashMap();
    private HashMap mRoleClasses = new HashMap();
    private HashMap mImplements = new HashMap();
    private HashMap mTypes = new HashMap();
    private Properties mProperties = new Properties();
    private Stack mPackageStack = new Stack();
    private HashMap mGeneralizations = new HashMap();
    private String curPackage = "";
    private boolean mPackage = false;
    private MetamodelClass curClass = null;
    private boolean mClass = false;
    private boolean mGeneralization = false;
    private MetamodelAttribute curAttribute = null;
    private boolean mDefaultValue = false;
    private boolean mAttributeType = false;
    private MetamodelOperation curOperation = null;
    private MetamodelParameter curParameter = null;
    private boolean mParameter = false;
    private boolean isReturnParameter = false;
    private MetamodelAssociation curAssociation = null;
    private MetamodelAssociationEnd curRoleA = null;
    private MetamodelAssociationEnd curRoleB = null;
    private boolean mDocumentation = false;
    private StringBuffer mDocumentationText = null;
    private boolean mSAPProperty = false;
    private String mSAPPropertyName = "";
    private String mSAPPropertyValue = "";
    private boolean mStereotype = false;
    private String mStereotypeName = "";
    private String mStereotypeBaseClass = "";
    private boolean mAbstraction = false;
    private boolean mDepClient = false;
    private boolean mDepSupplier = false;
    private String mDependencyClient = "";
    private String mDependencySupplier = "";
    private static final String ELEMENT_PACKAGE = "UML:Package";
    private static final String ELEMENT_MODEL = "UML:Model";
    private static final String ATTRIBUTE_XMIID = "xmi.id";
    private static final String ATTRIBUTE_XMIIDREF = "xmi.idref";
    private static final String ELEMENT_DATATYPE = "UML:DataType";
    private static final String ATTRIBUTE_DATATYPE_NAME = "name";
    private static final String ELEMENT_CLASS = "UML:Class";
    private static final String ATTRIBUTE_CLASS_NAME = "name";
    private static final String ATTRIBUTE_CLASS_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_CLASS_ISABSTRACT = "isAbstract";
    private static final String ELEMENT_GENERALIZATION = "UML:Generalization";
    private static final String ELEMENT_GENERALIZATION_PARENT = "UML:Generalization.parent";
    private static final String ELEMENT_GENERALIZABLE_ELEMENT = "Foundation.Core.GeneralizableElement";
    private static final String ELEMENT_NAMESPACE = "Foundation.Core.Namespace";
    private static final String ELEMENT_INTERFACE = "UML:Interface";
    private static final String ATTRIBUTE_INTERFACE_NAME = "name";
    private static final String ATTRIBUTE_INTERFACE_VISIBILITY = "visibility";
    private static final String ELEMENT_ABSTRACTION = "UML:Abstraction";
    private static final String ELEMENT_DEPENDENCY_CLIENT = "UML:Dependency.client";
    private static final String ELEMENT_DEPENDENCY_SUPPLIER = "UML:Dependency.supplier";
    private static final String ELEMENT_ATTRIBUTE = "UML:Attribute";
    private static final String ATTRIBUTE_ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_ATTRIBUTE_OWNERSCOPE = "ownerScope";
    private static final String ELEMENT_ATTRIBUTE_INITIALVALUE = "UML:Attribute.initialValue";
    private static final String ELEMENT_ATTRIBUTE_INITIALVALUE_EXPRESSION = "UML:Expression";
    private static final String ATTRIBUTE_ATTRIBUTE_INITIALVALUE_BODY = "body";
    private static final String ELEMENT_ATTRIBUTE_TYPE = "UML:StructuralFeature.type";
    private static final String ELEMENT_TYPE_CLASSIFIER = "Foundation.Core.Classifier";
    private static final String ELEMENT_OPERATION = "UML:Operation";
    private static final String ATTRIBUTE_OPERATION_NAME = "name";
    private static final String ATTRIBUTE_OPERATION_VISIBILITY = "visibility";
    private static final String ELEMENT_PARAMETER = "UML:Parameter";
    private static final String ATTRIBUTE_PARAMETER_NAME = "name";
    private static final String ATTRIBUTE_PARAMETER_KIND = "kind";
    private static final String ELEMENT_ASSOCIATION = "UML:Association";
    private static final String ATTRIBUTE_ASSOCIATION_NAME = "name";
    private static final String ELEMENT_ASSOCIATIONEND = "UML:AssociationEnd";
    private static final String ATTRIBUTE_ASSOCIATIONEND_NAME = "name";
    private static final String ATTRIBUTE_ASSOCIATIONEND_NAVIGABLE = "isNavigable";
    private static final String ATTRIBUTE_ASSOCIATIONEND_AGGREGATION = "aggregation";
    private static final String ELEMENT_ASSOCIATIONEND_MULTIPLICITYRANGE = "UML:MultiplicityRange";
    private static final String ATTRIBUTE_ASSOCIATIONEND_MULTIPLICITYRANGE_LOWER = "lower";
    private static final String ATTRIBUTE_ASSOCIATIONEND_MULTIPLICITYRANGE_UPPER = "upper";
    private static final String ELEMENT_TAGGED_VALUE = "UML:TaggedValue";
    private static final String ATTRIBUTE_TAGGED_VALUE_TAG = "tag";
    private static final String ATTRIBUTE_TAGGED_VALUE_VALUE = "value";
    private static final String ELEMENT_TAGGED_VALUE_VALUE = "UML:TaggedValue.value";
    private static final String ELEMENT_STEREOTYPE = "UML:Stereotype";
    private static final String ATTRIBUTE_STEREOTYPE_NAME = "name";
    private static final String ATTRIBUTE_STEREOTYPE_BASECLASS = "baseClass";
    private static final String ELEMENT_MODELELEMENT = "Foundation.Core.ModelElement";

    public XMI11Handler() {
        this.mPackageStack.push("");
    }

    public void setDocumentLocator(Locator locator) {
        this.mLocator = locator;
    }

    public void startElement(String parm1, String parm2, String name, Attributes atts) throws SAXException {
        if (name.equals(ELEMENT_PACKAGE)) {
            if (this.mPackageStack.size() == 1) {
                this.mPackageStack.push(atts.getValue("name"));
            } else {
                this.mPackageStack.push((String)this.mPackageStack.peek() + "." + atts.getValue("name"));
            }
            return;
        }
        if (name.equals(ELEMENT_DATATYPE)) {
            this.mTypes.put(atts.getValue(ATTRIBUTE_XMIID), atts.getValue("name"));
            return;
        }
        if (name.equals(ELEMENT_CLASS)) {
            this.curClass = new MetamodelClass();
            this.curClass.setName(atts.getValue("name"));
            String lPackage = (String)this.mPackageStack.peek();
            this.curClass.setPackage(lPackage);
            this.curClass.setVisibility(atts.getValue("visibility"));
            this.curClass.setIsAbstract(new Boolean(atts.getValue(ATTRIBUTE_CLASS_ISABSTRACT)));
            this.mClassesById.put(atts.getValue(ATTRIBUTE_XMIID), this.curClass);
            if (lPackage.equals("")) {
                this.mClassesByName.put(atts.getValue("name"), this.curClass);
            } else {
                this.mClassesByName.put(lPackage + "." + atts.getValue("name"), this.curClass);
            }
            this.mTypes.put(atts.getValue(ATTRIBUTE_XMIID), atts.getValue("name"));
            this.mClass = true;
            return;
        }
        if (name.equals(ELEMENT_INTERFACE)) {
            this.curClass = new MetamodelClass();
            this.curClass.setName(atts.getValue("name"));
            String lPackage = (String)this.mPackageStack.peek();
            this.curClass.setPackage(lPackage);
            this.curClass.setVisibility(atts.getValue("visibility"));
            this.curClass.setIsInterface(true);
            this.mClassesById.put(atts.getValue(ATTRIBUTE_XMIID), this.curClass);
            if (lPackage.equals("")) {
                this.mClassesByName.put(atts.getValue("name"), this.curClass);
            } else {
                this.mClassesByName.put(lPackage + "." + atts.getValue("name"), this.curClass);
            }
            this.mTypes.put(atts.getValue(ATTRIBUTE_XMIID), atts.getValue("name"));
            this.mClass = true;
            return;
        }
        if (name.equals(ELEMENT_GENERALIZATION_PARENT)) {
            this.mGeneralization = true;
            return;
        }
        if (name.equals(ELEMENT_GENERALIZABLE_ELEMENT)) {
            if (!this.mGeneralization) {
                return;
            }
            ArrayList<String> lList = (ArrayList<String>)this.mGeneralizations.get(this.curClass);
            if (lList == null) {
                lList = new ArrayList<String>();
                this.mGeneralizations.put(this.curClass, lList);
            }
            lList.add(atts.getValue(ATTRIBUTE_XMIIDREF));
            this.mGeneralization = false;
            return;
        }
        if (name.equals(ELEMENT_ABSTRACTION)) {
            this.mAbstraction = true;
            return;
        }
        if (name.equals(ELEMENT_DEPENDENCY_CLIENT)) {
            if (this.mAbstraction) {
                this.mDepClient = true;
            }
            return;
        }
        if (name.equals(ELEMENT_DEPENDENCY_SUPPLIER)) {
            if (this.mAbstraction) {
                this.mDepSupplier = true;
            }
            return;
        }
        if (name.equals(ELEMENT_ATTRIBUTE)) {
            if (atts.getValue(ATTRIBUTE_XMIID) != null) {
                this.curAttribute = new MetamodelAttribute();
                this.curAttribute.setName(atts.getValue("name"));
                this.curAttribute.setVisibility(atts.getValue("visibility"));
                this.mAttributes.put(atts.getValue(ATTRIBUTE_XMIID), this.curAttribute);
                this.curClass.addAttribute(this.curAttribute);
            }
            return;
        }
        if (name.equals(ELEMENT_ATTRIBUTE_INITIALVALUE)) {
            this.mDefaultValue = true;
            return;
        }
        if (name.equals(ELEMENT_ATTRIBUTE_INITIALVALUE_EXPRESSION)) {
            if (!this.mDefaultValue) {
                return;
            }
            this.mDefaultValue = false;
            String lDefaultValue = atts.getValue(ATTRIBUTE_ATTRIBUTE_INITIALVALUE_BODY);
            if (!lDefaultValue.equals("")) {
                this.curAttribute.setDefaultValue(lDefaultValue);
            }
            return;
        }
        if (name.equals(ELEMENT_ATTRIBUTE_TYPE)) {
            this.mAttributeType = true;
            return;
        }
        if (name.equals(ELEMENT_TYPE_CLASSIFIER)) {
            if (this.mAttributeType) {
                this.mAttributeType = false;
                this.curAttribute.setType(atts.getValue(ATTRIBUTE_XMIIDREF));
                return;
            }
            if (this.mParameter) {
                this.mParameter = false;
                if (this.isReturnParameter) {
                    this.curOperation.setReturnType(atts.getValue(ATTRIBUTE_XMIIDREF));
                } else {
                    this.curParameter.setType(atts.getValue(ATTRIBUTE_XMIIDREF));
                }
                return;
            }
            if (this.curRoleB != null) {
                this.mRoleClasses.put(this.curRoleB, atts.getValue(ATTRIBUTE_XMIIDREF));
                return;
            }
            if (this.curRoleA != null) {
                this.mRoleClasses.put(this.curRoleA, atts.getValue(ATTRIBUTE_XMIIDREF));
                return;
            }
        }
        if (name.equals(ELEMENT_OPERATION)) {
            this.curOperation = new MetamodelOperation();
            this.curOperation.setName(atts.getValue("name"));
            this.curOperation.setVisibility(atts.getValue("visibility"));
            this.mOperations.put(atts.getValue(ATTRIBUTE_XMIID), this.curOperation);
            this.curClass.addOperation(this.curOperation);
            return;
        }
        if (name.equals(ELEMENT_PARAMETER)) {
            this.curParameter = new MetamodelParameter();
            if (atts.getValue(ATTRIBUTE_PARAMETER_KIND).equals("return")) {
                this.isReturnParameter = true;
            }
            this.curParameter.setName(atts.getValue("name"));
            this.mParameter = true;
            return;
        }
        if (name.equals(ELEMENT_ASSOCIATION)) {
            this.curAssociation = new MetamodelAssociation();
            this.curAssociation.setName(atts.getValue("name"));
            this.mAssociations.put(atts.getValue(ATTRIBUTE_XMIID), this.curAssociation);
            this.curRoleA = null;
            this.curRoleB = null;
            return;
        }
        if (name.equals(ELEMENT_ASSOCIATIONEND)) {
            if (this.curRoleA == null) {
                this.curRoleA = new MetamodelAssociationEnd();
                this.curRoleA.setName(atts.getValue("name"));
                this.curRoleA.setNavigable(new Boolean(atts.getValue(ATTRIBUTE_ASSOCIATIONEND_NAVIGABLE)));
                if (!atts.getValue(ATTRIBUTE_ASSOCIATIONEND_AGGREGATION).equals("none")) {
                    this.curRoleA.setAggregation(true);
                }
                this.mRoles.put(atts.getValue(ATTRIBUTE_XMIID), this.curRoleA);
                this.curAssociation.setRoleA(this.curRoleA);
            } else {
                this.curRoleB = new MetamodelAssociationEnd();
                this.curRoleB.setName(atts.getValue("name"));
                this.curRoleB.setNavigable(new Boolean(atts.getValue(ATTRIBUTE_ASSOCIATIONEND_NAVIGABLE)));
                if (!atts.getValue(ATTRIBUTE_ASSOCIATIONEND_AGGREGATION).equals("none")) {
                    this.curRoleB.setAggregation(true);
                }
                this.mRoles.put(atts.getValue(ATTRIBUTE_XMIID), this.curRoleB);
                this.curAssociation.setRoleB(this.curRoleB);
            }
            return;
        }
        if (name.equals(ELEMENT_ASSOCIATIONEND_MULTIPLICITYRANGE)) {
            String lLower = atts.getValue(ATTRIBUTE_ASSOCIATIONEND_MULTIPLICITYRANGE_LOWER);
            String lUpper = atts.getValue(ATTRIBUTE_ASSOCIATIONEND_MULTIPLICITYRANGE_UPPER);
            if (this.curRoleB != null) {
                this.curRoleB.setCardinalityLower(lLower);
                this.curRoleB.setCardinalityUpper(lUpper);
            } else if (this.curRoleA != null) {
                this.curRoleA.setCardinalityLower(lLower);
                this.curRoleA.setCardinalityUpper(lUpper);
            }
            return;
        }
        if (name.equals(ELEMENT_STEREOTYPE)) {
            this.mStereotype = true;
            this.mStereotypeName = atts.getValue("name");
            this.mStereotypeBaseClass = atts.getValue(ATTRIBUTE_STEREOTYPE_BASECLASS);
            return;
        }
        if (name.equals(ELEMENT_TAGGED_VALUE)) {
            String lTag = atts.getValue(ATTRIBUTE_TAGGED_VALUE_TAG);
            if (lTag.indexOf("$SAP Properties:") != -1) {
                this.mSAPPropertyName = lTag.substring(lTag.indexOf(58) + 1, lTag.length());
            } else if (lTag.startsWith("Together_SAP_Properties_")) {
                this.mSAPPropertyName = lTag.substring(24).replace('_', ' ');
            } else if (lTag.equals("@Web_Dynpro_Import")) {
                this.mSAPPropertyName = "Web Dynpro Import";
            } else if (lTag.equals("@No_Web_Dynpro_Import")) {
                this.mSAPPropertyName = "No Web Dynpro Import";
            } else {
                return;
            }
            this.mSAPProperty = true;
            this.mSAPPropertyValue = atts.getValue(ATTRIBUTE_TAGGED_VALUE_VALUE);
            return;
        }
        if (name.equals(ELEMENT_MODELELEMENT)) {
            if (!(this.mStereotype || this.mSAPProperty || this.mDocumentation || this.mAbstraction)) {
                return;
            }
            String lId = atts.getValue(ATTRIBUTE_XMIIDREF);
            if (this.mStereotype) {
                if (this.mStereotypeBaseClass.equals("Class")) {
                    MetamodelClass lClass = (MetamodelClass)this.mClassesById.get(lId);
                    lClass.setStereoType(this.mStereotypeName);
                    return;
                }
                if (this.mStereotypeBaseClass.equals("Attribute")) {
                    MetamodelAttribute lAttribute = (MetamodelAttribute)this.mAttributes.get(lId);
                    lAttribute.setStereoType(this.mStereotypeName);
                    return;
                }
                if (this.mStereotypeBaseClass.equals("Operation")) {
                    MetamodelOperation lOperation = (MetamodelOperation)this.mOperations.get(lId);
                    lOperation.setStereoType(this.mStereotypeName);
                    return;
                }
                if (this.mStereotypeBaseClass.equals("Association")) {
                    MetamodelAssociation lAssociation = (MetamodelAssociation)this.mAssociations.get(lId);
                    lAssociation.setStereoType(this.mStereotypeName);
                    return;
                }
            } else {
                if (this.mAbstraction) {
                    if (this.mDepClient) {
                        this.mDependencyClient = lId;
                    } else if (this.mDepSupplier) {
                        this.mDependencySupplier = lId;
                    }
                    return;
                }
                if (this.mSAPProperty) {
                    this.mSAPProperty = false;
                    if (this.mSAPPropertyName.equals("Web Dynpro Import")) {
                        MetamodelClass lClass = (MetamodelClass)this.mClassesById.get(lId);
                        if (lClass != null && (this.mSAPPropertyValue.equals("") || this.mSAPPropertyValue.equalsIgnoreCase("true"))) {
                            lClass.setImport(true);
                        }
                        return;
                    }
                    if (this.mSAPPropertyName.equals("No Web Dynpro Import")) {
                        MetamodelOperation lOperation = (MetamodelOperation)this.mOperations.get(lId);
                        if (lOperation != null) {
                            if (this.mSAPPropertyValue.equals("") || this.mSAPPropertyValue.equalsIgnoreCase("true")) {
                                lOperation.setNoImport(true);
                            }
                        } else {
                            MetamodelAttribute lAttribute = (MetamodelAttribute)this.mAttributes.get(lId);
                            if (lAttribute != null) {
                                if (this.mSAPPropertyValue.equals("") || this.mSAPPropertyValue.equalsIgnoreCase("true")) {
                                    lAttribute.setNoImport(true);
                                }
                            } else {
                                MetamodelAssociation lAssociation = (MetamodelAssociation)this.mAssociations.get(lId);
                                if (lAssociation != null) {
                                    if (this.mSAPPropertyValue.equals("") || this.mSAPPropertyValue.equalsIgnoreCase("true")) {
                                        lAssociation.setNoImport(true);
                                    }
                                } else {
                                    MetamodelAssociationEnd lRole = (MetamodelAssociationEnd)this.mRoles.get(lId);
                                    if (lRole != null && (this.mSAPPropertyValue.equals("") || this.mSAPPropertyValue.equalsIgnoreCase("true"))) {
                                        lRole.setNoImport(true);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    public void endElement(String parm1, String parm2, String name) throws SAXException {
        if (name.equals(ELEMENT_PACKAGE)) {
            this.mPackageStack.pop();
            return;
        }
        if (name.equals(ELEMENT_CLASS)) {
            this.mClass = false;
            return;
        }
        if (name.equals(ELEMENT_ASSOCIATIONEND)) {
            if (this.curRoleA != null && this.curRoleB != null) {
                this.curRoleB = null;
                this.curRoleA = null;
            }
            return;
        }
        if (name.equals(ELEMENT_PARAMETER)) {
            if (this.isReturnParameter) {
                this.isReturnParameter = false;
            } else {
                this.curOperation.addParameter(this.curParameter);
            }
            return;
        }
        if (name.equals(ELEMENT_MODEL)) {
            this.mStereotype = false;
            return;
        }
        if (name.equals(ELEMENT_ABSTRACTION)) {
            this.mAbstraction = false;
            ArrayList<String> lList = (ArrayList<String>)this.mImplements.get(this.mDependencyClient);
            if (lList == null) {
                lList = new ArrayList<String>();
                this.mImplements.put(this.mDependencyClient, lList);
            }
            lList.add(this.mDependencySupplier);
            this.mDependencyClient = "";
            this.mDependencySupplier = "";
            return;
        }
        if (name.equals(ELEMENT_DEPENDENCY_CLIENT)) {
            this.mDepClient = false;
            return;
        }
        if (name.equals(ELEMENT_DEPENDENCY_SUPPLIER)) {
            this.mDepSupplier = false;
        }
    }

    public void endDocument() throws SAXException {
        MetamodelClass lClass;
        Iterator it = this.mImplements.keySet().iterator();
        while (it.hasNext()) {
            String lKey = (String)it.next();
            lClass = (MetamodelClass)this.mClassesById.get(lKey);
            ArrayList lInterfaces = (ArrayList)this.mImplements.get(lKey);
            ArrayList lList = (ArrayList)this.mGeneralizations.get(lClass);
            if (lList == null) {
                lList = new ArrayList();
                this.mGeneralizations.put(lClass, lList);
            }
            lList.addAll(lInterfaces);
        }
        Iterator it2 = this.mGeneralizations.keySet().iterator();
        while (it2.hasNext()) {
            lClass = (MetamodelClass)it2.next();
            ArrayList lGeneralizations = (ArrayList)this.mGeneralizations.get(lClass);
            int i = 0;
            while (i < lGeneralizations.size()) {
                MetamodelClass lGeneralization = (MetamodelClass)this.mClassesById.get(lGeneralizations.get(i));
                if (lClass.getIsInterface() && lGeneralization.getIsInterface()) {
                    lClass.addExtendedInterface(lGeneralization);
                } else if (!lClass.getIsInterface()) {
                    if (lGeneralization.getIsInterface()) {
                        lClass.addImplementedInterface(lGeneralization);
                    } else {
                        lClass.setSuperClass(lGeneralization);
                        lGeneralization.addSubClass(lClass);
                    }
                }
                ++i;
            }
        }
        Iterator it3 = this.mClassesById.values().iterator();
        while (it3.hasNext()) {
            MetamodelClass lClass2 = (MetamodelClass)it3.next();
            Iterator it22 = lClass2.getAttributes().iterator();
            while (it22.hasNext()) {
                MetamodelAttribute lAttribute = (MetamodelAttribute)it22.next();
                lAttribute.setType((String)this.mTypes.get(lAttribute.getType()));
            }
            Iterator it23 = lClass2.getOperations().iterator();
            while (it23.hasNext()) {
                MetamodelOperation lOperation = (MetamodelOperation)it23.next();
                if (!lOperation.getReturnType().equals("")) {
                    lOperation.setReturnType((String)this.mTypes.get(lOperation.getReturnType()));
                }
                Iterator it32 = ((AbstractList)lOperation.getParameters()).iterator();
                while (it32.hasNext()) {
                    MetamodelParameter lParameter = (MetamodelParameter)it32.next();
                    lParameter.setType((String)this.mTypes.get(lParameter.getType()));
                }
            }
        }
        int count = 1;
        Iterator it4 = this.mAssociations.values().iterator();
        while (it4.hasNext()) {
            MetamodelAssociation lAssociation = (MetamodelAssociation)it4.next();
            MetamodelAssociationEnd lRoleA = lAssociation.getRoleA();
            MetamodelAssociationEnd lRoleB = lAssociation.getRoleB();
            if (lRoleA.getNavigable() && lRoleA.getName().equals("")) {
                lRoleA.setName("untitled" + count++);
            }
            if (lRoleB.getNavigable() && lRoleB.getName().equals("")) {
                lRoleB.setName("untitled" + count++);
            }
            MetamodelClass lClassA = (MetamodelClass)this.mClassesById.get(this.mRoleClasses.get(lRoleA));
            lRoleA.setRoleClass(lClassA);
            MetamodelClass lClassB = (MetamodelClass)this.mClassesById.get(this.mRoleClasses.get(lRoleB));
            lRoleB.setRoleClass(lClassB);
            if (lRoleA.getNavigable()) {
                lClassB.addAssociation(lAssociation);
                continue;
            }
            lClassA.addAssociation(lAssociation);
        }
    }

    public HashMap getClasses() {
        return this.mClassesByName;
    }
}

