/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.xmi.mom;

import com.sap.ide.metamodel.importers.xmi.mom.MetamodelAssociation;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelAssociationEnd;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelAttribute;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelOperation;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;

public class MetamodelClass
implements Comparable {
    private String mName = "";
    private String mPackage = "";
    private String mVisibility = "";
    private boolean mIsAbstract = false;
    private boolean mIsInterface = false;
    private MetamodelClass mSuperClass = null;
    private TreeSet mAttributes = new TreeSet();
    private TreeSet mOperations = new TreeSet();
    private TreeSet mAssociations = new TreeSet();
    private TreeSet mImplementedInterfaces = new TreeSet();
    private TreeSet mExtendedInterfaces = new TreeSet();
    private Vector mSubClasses = new Vector();
    private String mStereoType = "";
    private boolean mImport = false;

    public void setStereoType(String stereoType) {
        this.mStereoType = stereoType;
    }

    public String getStereoType() {
        return this.mStereoType;
    }

    public boolean getImport() {
        return this.mImport;
    }

    public void setImport(boolean value) {
        this.mImport = value;
    }

    public MetamodelOperation getGetter(MetamodelAttribute attribute) {
        String lGetterName = "get" + attribute.getName().substring(0, 1).toUpperCase() + attribute.getName().substring(1);
        Iterator it = this.mOperations.iterator();
        while (it.hasNext()) {
            MetamodelOperation lOperation = (MetamodelOperation)it.next();
            if (!lOperation.getName().equals(lGetterName) || !lOperation.getParameters().isEmpty() || !lOperation.getReturnType().equals(attribute.getType())) continue;
            return lOperation;
        }
        return null;
    }

    public ArrayList getAllPublicGetters() {
        ArrayList<MetamodelOperation> lResult = new ArrayList<MetamodelOperation>();
        Iterator it = this.mOperations.iterator();
        while (it.hasNext()) {
            MetamodelOperation lOperation = (MetamodelOperation)it.next();
            if (!lOperation.getName().startsWith("get") || !lOperation.getVisibility().equals("public") || !lOperation.getParameters().isEmpty() || lOperation.getReturnType().equals("") || lOperation.getReturnType().equals("void")) continue;
            lResult.add(lOperation);
        }
        return lResult;
    }

    public MetamodelOperation getSetter(MetamodelAttribute attribute) {
        String lGetterName = "set" + attribute.getName().substring(0, 1).toUpperCase() + attribute.getName().substring(1);
        Iterator it = this.mOperations.iterator();
        while (it.hasNext()) {
            MetamodelOperation lOperation = (MetamodelOperation)it.next();
            if (!lOperation.getName().equals(lGetterName) || lOperation.getParameters().size() != 1 || !((MetamodelParameter)lOperation.getParameters().get(0)).getType().equals(attribute.getType()) || !lOperation.getReturnType().equals("") && !lOperation.getReturnType().equals("void")) continue;
            return lOperation;
        }
        return null;
    }

    public int compareTo(Object o) {
        String lName = ((MetamodelClass)o).getName();
        return this.mName.compareTo(lName);
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String value) {
        this.mName = value;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String value) {
        this.mPackage = value == null ? "" : value;
    }

    public String getVisibility() {
        return this.mVisibility;
    }

    public void setVisibility(String value) {
        this.mVisibility = value;
    }

    public boolean getIsAbstract() {
        return this.mIsAbstract;
    }

    public void setIsAbstract(boolean value) {
        this.mIsAbstract = value;
    }

    public boolean getIsInterface() {
        return this.mIsInterface;
    }

    public void setIsInterface(boolean value) {
        this.mIsInterface = value;
    }

    public MetamodelClass getSuperClass() {
        return this.mSuperClass;
    }

    public boolean hasSuperClass() {
        return this.mSuperClass != null;
    }

    public void setSuperClass(MetamodelClass value) {
        this.mSuperClass = value;
    }

    public void addSubClass(MetamodelClass value) {
        this.mSubClasses.add(value);
        Collections.sort(this.mSubClasses);
    }

    public Vector getSubClasses() {
        return this.mSubClasses;
    }

    public Vector getAllSubClasses() {
        Vector<MetamodelClass> lResult = new Vector<MetamodelClass>();
        int i = 0;
        while (i < this.mSubClasses.size()) {
            MetamodelClass lClass = (MetamodelClass)this.mSubClasses.get(i);
            lResult.add(lClass);
            lResult.addAll(lClass.getAllSubClasses());
            ++i;
        }
        Collections.sort(lResult);
        return lResult;
    }

    public void addAttribute(MetamodelAttribute attribute) {
        this.mAttributes.add(attribute);
    }

    public void addOperation(MetamodelOperation operation) {
        this.mOperations.add(operation);
    }

    public TreeSet getAttributes() {
        return this.mAttributes;
    }

    public Vector getAllAttributes() {
        Vector lResult = new Vector();
        lResult.addAll(this.mAttributes);
        if (this.mSuperClass != null) {
            lResult.addAll(this.mSuperClass.getAllAttributes());
        }
        return lResult;
    }

    public void addAssociation(MetamodelAssociation association) {
        if (association.getName().equals("")) {
            association.createUniqueName();
        }
        this.mAssociations.add(association);
    }

    public TreeSet getAssociations() {
        return this.mAssociations;
    }

    public MetamodelAssociationEnd otherRole(MetamodelAssociation association) {
        if (this == association.getRoleA().getRoleClass()) {
            return association.getRoleB();
        }
        return association.getRoleA();
    }

    public MetamodelAssociationEnd ownRole(MetamodelAssociation association) {
        if (this == association.getRoleA().getRoleClass()) {
            return association.getRoleA();
        }
        return association.getRoleB();
    }

    public TreeSet getOperations() {
        return this.mOperations;
    }

    public void addImplementedInterface(MetamodelClass clazz) {
        this.mImplementedInterfaces.add(clazz);
    }

    public TreeSet getImplementedInterfaces() {
        return this.mImplementedInterfaces;
    }

    public void addExtendedInterface(MetamodelClass clazz) {
        this.mExtendedInterfaces.add(clazz);
    }

    public TreeSet getExtendedInterfaces() {
        return this.mExtendedInterfaces;
    }

    public String toString() {
        Iterator lIterator;
        String lText = "Name: " + this.mName + ", Package: " + this.mPackage + ", Visibility: " + this.mVisibility + ", isAbstract: " + this.mIsAbstract;
        if (this.mSuperClass != null) {
            lText = lText + ", SuperClass: " + this.mSuperClass.getName();
        }
        if (!this.mAttributes.isEmpty()) {
            lText = lText + "\n  Attributes:";
            lIterator = this.mAttributes.iterator();
            while (lIterator.hasNext()) {
                lText = lText + "\n    ->" + (MetamodelAttribute)lIterator.next();
            }
        }
        if (!this.mAssociations.isEmpty()) {
            lText = lText + "\n  Relations:";
            lIterator = this.mAssociations.iterator();
            while (lIterator.hasNext()) {
                lText = lText + "\n    ->" + (MetamodelAssociation)lIterator.next();
            }
        }
        return lText;
    }
}

