/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.xmi;

import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.service.XMLParsingService;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelAssociation;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelAssociationEnd;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelClass;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelOperation;
import com.sap.ide.metamodel.importers.xmi.mom.MetamodelParameter;
import com.sap.ide.metamodel.importers.xmi.parsing.XMI11Handler;
import com.sap.ide.metamodel.importers.xmi.parsing.XMIVersionCheckHandler;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.base.AppClass;
import com.sap.ide.metamodel.webdynpro.base.Parameter;
import com.sap.ide.metamodel.webdynpro.base.Procedure;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.enum.VisibilityEnum;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassMethod;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.metamodel.webdynpro.model.ModelSetting;
import com.sap.ide.metamodel.webdynpro.type.JavaNativeType;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.xml.sax.ContentHandler;

public class XMIImporter {
    private static final String DICTIONARY_PACKAGE = "com.sap.dictionary";
    private static final String MODELTYPE_PACKAGE = "com.sap.ide.webdynpro.modeltypes";
    private static final String MODELTYPE_NAME = "ReverseEngineered";
    private WebDynproRoot mWebDynpro = null;
    private DtDictionaryRoot mDictionary = null;
    private ModelType mModelType = null;
    private String mLanguage = "";
    private String mModelPackage = "";
    private String mModelName = "";
    private Model mModel = null;
    private HashMap mClasses = null;
    private SourcePathIdentifier mSourcePathId = null;
    private XMLParsingService mXMLParsingService = null;
    private ImportLog mLog = new ImportLog();
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$java$util$Map;

    public XMIImporter(DtDictionaryRoot dictionary, WebDynproRoot webdynpro) throws Exception {
        this(dictionary, webdynpro, "en");
    }

    public XMIImporter(DtDictionaryRoot dictionary, WebDynproRoot webdynpro, String language) throws Exception {
        this.mDictionary = dictionary;
        this.mWebDynpro = webdynpro;
        this.mLanguage = language;
        this.mModelType = webdynpro.getModelType(MODELTYPE_PACKAGE, MODELTYPE_NAME);
        this.mXMLParsingService = ((RootImpl)this.mWebDynpro)._getXMLParsingService();
    }

    private XMIImporter() {
    }

    public synchronized Model doImport(String modelPackage, String modelName, SourcePathIdentifier sourcePathId, String xmiPath) {
        this.mLog.clear();
        try {
            this.mSourcePathId = sourcePathId;
            this.mModelPackage = modelPackage;
            if (modelPackage == null) {
                this.mLog.addErrorMessage("\"" + modelPackage + "\" is not a valid model package!");
                return null;
            }
            this.mModelName = modelName;
            if (modelName == null || modelName.length() == 0) {
                this.mLog.addErrorMessage("\"" + modelName + "\" is not a valid model name!");
                return null;
            }
            XMIVersionCheckHandler lXMIVersionHandler = new XMIVersionCheckHandler();
            this.mXMLParsingService.parse(xmiPath, (ContentHandler)lXMIVersionHandler);
            String lXMIVersion = lXMIVersionHandler.getXMIVersion();
            String lUMLVersion = lXMIVersionHandler.getUMLVersion();
            if (!lUMLVersion.equals("1.3") || !lXMIVersion.equals("1.1") && !lXMIVersion.equals("1.2")) {
                this.mLog.addErrorMessage("Only the XMI-1.1 or XMI-1.2 format combined with the UML-1.3 format are supported (found: XMI-" + lXMIVersion + " / UML-" + lUMLVersion + ")");
                return null;
            }
            this.mLog.addInfoMessage("parsing XMI " + lXMIVersion + " / UML " + lUMLVersion + " file \"" + xmiPath + "\"");
            XMI11Handler lHandler = new XMI11Handler();
            this.mXMLParsingService.parse(xmiPath, (ContentHandler)lHandler);
            this.mClasses = lHandler.getClasses();
            return this.renderModel();
        }
        catch (Exception ex) {
            this.mLog.addException(ex);
            if (this.mModel != null) {
                try {
                    this.mModel.delete();
                }
                catch (DeleteException ex2) {
                    this.mLog.addException(ex2);
                }
            }
            return null;
        }
    }

    public ImportLog getImportLog() {
        return this.mLog;
    }

    private ModelClass findModelClass(MetamodelClass momClass) {
        return this.mModel.getModelClass(momClass.getPackage(), momClass.getName());
    }

    private DevelopmentObject builtInType(String typeName) throws LoadException {
        if (typeName.equals("String") || typeName.equals("java.lang.String")) {
            typeName = "string";
        } else if (typeName.equals("Date") || typeName.equals("java.sql.Date")) {
            typeName = "date";
        } else if (typeName.equals("double")) {
            typeName = "double";
        } else if (typeName.equals("Double") || typeName.equals("java.lang.Double")) {
            typeName = "doubleObject";
        } else if (typeName.equals("boolean")) {
            typeName = "boolean";
        } else if (typeName.equals("Boolean") || typeName.equals("java.lang.Boolean")) {
            typeName = "booleanObject";
        } else if (typeName.equals("Time") || typeName.equals("java.sql.Time")) {
            typeName = "time";
        } else if (typeName.equals("Timestamp") || typeName.equals("java.sql.Timestamp")) {
            typeName = "timestamp";
        } else if (typeName.equals("short")) {
            typeName = "short";
        } else if (typeName.equals("Short") || typeName.equals("java.lang.Short")) {
            typeName = "shortObject";
        } else if (typeName.equals("long")) {
            typeName = "long";
        } else if (typeName.equals("Long") || typeName.equals("java.lang.Long")) {
            typeName = "longObject";
        } else if (typeName.equals("float")) {
            typeName = "float";
        } else if (typeName.equals("Float") || typeName.equals("java.lang.Float")) {
            typeName = "floatObject";
        } else if (typeName.equals("int")) {
            typeName = "integer";
        } else if (typeName.equals("Integer") || typeName.equals("java.lang.Integer")) {
            typeName = "integerObject";
        } else if (typeName.equals("BigDecimal") || typeName.equals("java.math.BigDecimal")) {
            typeName = "decimal";
        } else if (typeName.equals("byte[]")) {
            typeName = "binary";
        }
        return this.mDictionary.getSimpleType(DICTIONARY_PACKAGE, typeName);
    }

    private void setType(DevelopmentObject object, String typeName) throws LoadException, CreateException {
        String lNameWithoutPackage = typeName;
        if (lNameWithoutPackage.indexOf(46) != -1) {
            lNameWithoutPackage = lNameWithoutPackage.substring(lNameWithoutPackage.lastIndexOf(46) + 1);
        }
        if (this.mClasses.containsKey(typeName) || this.mClasses.containsKey(lNameWithoutPackage)) {
            MetamodelClass lMOMClass = null;
            lMOMClass = this.mClasses.containsKey(typeName) ? (MetamodelClass)this.mClasses.get(typeName) : (MetamodelClass)this.mClasses.get(lNameWithoutPackage);
            if (object instanceof Property) {
                if (lMOMClass.getImport()) {
                    ((Property)object).setType((DevelopmentObject)this.findModelClass(lMOMClass));
                } else {
                    JavaNativeType lNativeType = ((Property)object).createNativeTypeAsJavaNativeType(lMOMClass.getName());
                    lNativeType.setJavaPackage(lMOMClass.getPackage());
                    ((Property)object).setType((DevelopmentObject)lNativeType);
                }
            } else if (object instanceof Procedure) {
                if (lMOMClass.getImport()) {
                    ((Procedure)object).setReturnType((DevelopmentObject)this.findModelClass(lMOMClass));
                } else {
                    JavaNativeType lNativeType = ((Procedure)object).createNativeTypeAsJavaNativeType(lMOMClass.getName());
                    lNativeType.setJavaPackage(lMOMClass.getPackage());
                    ((Procedure)object).setReturnType((DevelopmentObject)lNativeType);
                }
            } else if (object instanceof Parameter) {
                if (lMOMClass.getImport()) {
                    ((Parameter)object).setType((DevelopmentObject)this.findModelClass(lMOMClass));
                } else {
                    JavaNativeType lNativeType = ((Parameter)object).createNativeTypeAsJavaNativeType(lMOMClass.getName());
                    lNativeType.setJavaPackage(lMOMClass.getPackage());
                    ((Parameter)object).setType((DevelopmentObject)lNativeType);
                }
            }
        } else {
            DevelopmentObject lType = this.builtInType(typeName);
            if (object instanceof Property) {
                if (lType != null) {
                    ((Property)object).setType(lType);
                } else if (typeName.indexOf(46) != -1) {
                    String lName = typeName.substring(typeName.lastIndexOf(46) + 1);
                    String lPackage = typeName.substring(0, typeName.lastIndexOf(46));
                    JavaNativeType lNativeType = ((Property)object).createNativeTypeAsJavaNativeType(lName);
                    lNativeType.setJavaPackage(lPackage);
                    ((Property)object).setType((DevelopmentObject)lNativeType);
                } else {
                    ((Property)object).setType((DevelopmentObject)((Property)object).createNativeTypeAsJavaNativeType(typeName));
                }
            } else if (object instanceof Procedure) {
                if (lType != null) {
                    ((Procedure)object).setReturnType(lType);
                } else if (typeName.indexOf(46) != -1) {
                    String lName = typeName.substring(typeName.lastIndexOf(46) + 1);
                    String lPackage = typeName.substring(0, typeName.lastIndexOf(46));
                    JavaNativeType lNativeType = ((Procedure)object).createNativeTypeAsJavaNativeType(lName);
                    lNativeType.setJavaPackage(lPackage);
                    ((Procedure)object).setReturnType((DevelopmentObject)lNativeType);
                } else {
                    ((Procedure)object).setReturnType((DevelopmentObject)((Procedure)object).createNativeTypeAsJavaNativeType(typeName));
                }
            } else if (object instanceof Parameter) {
                if (lType != null) {
                    ((Parameter)object).setType(lType);
                } else if (typeName.indexOf(46) != -1) {
                    String lName = typeName.substring(typeName.lastIndexOf(46) + 1);
                    String lPackage = typeName.substring(0, typeName.lastIndexOf(46));
                    JavaNativeType lNativeType = ((Parameter)object).createNativeTypeAsJavaNativeType(lName);
                    lNativeType.setJavaPackage(lPackage);
                    ((Parameter)object).setType((DevelopmentObject)lNativeType);
                } else {
                    ((Parameter)object).setType((DevelopmentObject)((Parameter)object).createNativeTypeAsJavaNativeType(typeName));
                }
            }
        }
    }

    private String getTypeName(DevelopmentObject type) {
        if (type == null) {
            return "<none>";
        }
        if (type instanceof DtSimpleType) {
            return type.getName() + " (DDIC Type)";
        }
        if (type instanceof ModelClass) {
            String lPackage = ((ModelClass)type).getPackage();
            if (lPackage.equals("")) {
                return type.getName() + " (ModelClass)";
            }
            return lPackage + "." + type.getName() + " (ModelClass)";
        }
        if (type instanceof JavaNativeType) {
            String lPackage = ((JavaNativeType)type).getJavaPackage();
            if (lPackage == null || lPackage.equals("")) {
                return type.getName() + " (Java Type)";
            }
            return lPackage + "." + type.getName() + " (Java Type)";
        }
        return "<unknown>";
    }

    private boolean isJavaCollection(String typeName) {
        try {
            Class<?> lClass = Class.forName(typeName);
            if ((class$java$util$Collection == null ? (class$java$util$Collection = XMIImporter.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(lClass) || (class$java$util$Map == null ? (class$java$util$Map = XMIImporter.class$("java.util.Map")) : class$java$util$Map).isAssignableFrom(lClass)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private MetamodelOperation findPublicSetter(MetamodelClass clazz, String roleName, String typeName) {
        Iterator it = clazz.getOperations().iterator();
        while (it.hasNext()) {
            MetamodelOperation lOperation = (MetamodelOperation)it.next();
            if (!lOperation.getName().equals("set" + roleName) || !lOperation.getReturnType().equals("") || lOperation.getParameters().size() != 1 || !((MetamodelParameter)lOperation.getParameters().get(0)).getType().equals(typeName)) continue;
            return lOperation;
        }
        return null;
    }

    private MetamodelOperation findPublicAdder(MetamodelClass clazz, String roleName, String typeName) {
        Iterator it = clazz.getOperations().iterator();
        while (it.hasNext()) {
            MetamodelOperation lOperation = (MetamodelOperation)it.next();
            if (!lOperation.getName().equals("addTo" + roleName) || !lOperation.getReturnType().equalsIgnoreCase("boolean") || lOperation.getParameters().size() != 1 || !((MetamodelParameter)lOperation.getParameters().get(0)).getType().equals(typeName)) continue;
            return lOperation;
        }
        return null;
    }

    private MetamodelOperation findPublicRemover(MetamodelClass clazz, String roleName, String typeName) {
        Iterator it = clazz.getOperations().iterator();
        while (it.hasNext()) {
            MetamodelOperation lOperation = (MetamodelOperation)it.next();
            if (!lOperation.getName().equals("removeFrom" + roleName) || !lOperation.getReturnType().equalsIgnoreCase("boolean") || lOperation.getParameters().size() != 1 || !((MetamodelParameter)lOperation.getParameters().get(0)).getType().equals(typeName)) continue;
            return lOperation;
        }
        return null;
    }

    private boolean checkTo1Role(MetamodelAssociationEnd role, String roleName) {
        String lLowerCaseName = roleName.substring(0, 1).toLowerCase() + roleName.substring(1);
        return !(!role.getName().equals(roleName) && !role.getName().equals(lLowerCaseName) || role.getNoImport() || !role.getRoleClass().getImport() || !role.getNavigable() || !role.getCardinality().equals(CardinalityEnum._0_1.toString()) && !role.getCardinality().equals(CardinalityEnum._1_1.toString()));
    }

    private MetamodelAssociation findTo1Relation(MetamodelClass class1, MetamodelClass class2, String roleName) {
        TreeSet lAssociations = class1.getAssociations();
        lAssociations.addAll(class2.getAssociations());
        boolean found = false;
        MetamodelAssociation lAssociation = null;
        Iterator it = lAssociations.iterator();
        while (it.hasNext()) {
            lAssociation = (MetamodelAssociation)it.next();
            if (lAssociation.getNoImport()) continue;
            MetamodelAssociationEnd lRoleA = lAssociation.getRoleA();
            MetamodelAssociationEnd lRoleB = lAssociation.getRoleB();
            if (lRoleA.getRoleClass() == class2 && lRoleB.getRoleClass() == class2) {
                found = this.checkTo1Role(lRoleA, roleName);
                if (!found) {
                    found = this.checkTo1Role(lRoleB, roleName);
                }
                if (!found) continue;
                break;
            }
            if (lRoleA.getRoleClass() != class2 ? lRoleB.getRoleClass() == class2 && (found = this.checkTo1Role(lRoleB, roleName)) : (found = this.checkTo1Role(lRoleA, roleName))) break;
        }
        if (found) {
            return lAssociation;
        }
        return null;
    }

    private boolean checkToNRole(MetamodelAssociationEnd role, String roleName) {
        String lLowerCaseName = roleName.substring(0, 1).toLowerCase() + roleName.substring(1);
        return !(!role.getName().equals(roleName) && !role.getName().equals(lLowerCaseName) || role.getNoImport() || !role.getRoleClass().getImport() || !role.getNavigable() || !role.getCardinality().equals(CardinalityEnum._0_N.toString()) && !role.getCardinality().equals(CardinalityEnum._1_N.toString()));
    }

    private MetamodelAssociation findToNRelation(MetamodelClass clazz, String roleName) {
        boolean found = false;
        MetamodelAssociation lAssociation = null;
        Iterator it3 = clazz.getAssociations().iterator();
        while (it3.hasNext()) {
            lAssociation = (MetamodelAssociation)it3.next();
            if (lAssociation.getNoImport()) continue;
            MetamodelAssociationEnd lRoleA = lAssociation.getRoleA();
            MetamodelAssociationEnd lRoleB = lAssociation.getRoleB();
            found = this.checkToNRole(lRoleA, roleName);
            if (!found) {
                found = this.checkToNRole(lRoleB, roleName);
            }
            if (found) break;
        }
        if (found) {
            return lAssociation;
        }
        return null;
    }

    private void createModelRelation(MetamodelAssociation association) throws CreateException {
        if (this.mModel.hasModelRelation(association.getName())) {
            this.mLog.addInfoMessage("    bidirectional relation \"" + association.getName() + "\" between classes \"" + association.getRoleA().getRoleClass().getName() + "\" and \"" + association.getRoleB().getRoleClass().getName() + "\" already added");
            return;
        }
        ModelRelation lRelation = this.mModel.createModelRelation(association.getName());
        int lUntitled = 0;
        if (association.getRoleA().getName().equals("")) {
            ++lUntitled;
        }
        if (association.getRoleB().getName().equals("")) {
            ++lUntitled;
        }
        if (association.getRoleA().getName().equals("")) {
            if (lUntitled == 2) {
                association.getRoleA().setName(association.getName() + ".Untitled1");
            } else {
                association.getRoleA().setName(association.getName() + ".Untitled");
            }
        } else if (association.getRoleB().getName().equals("")) {
            if (lUntitled == 2) {
                association.getRoleB().setName(association.getName() + ".Untitled2");
            } else {
                association.getRoleB().setName(association.getName() + ".Untitled");
            }
        }
        MetamodelAssociationEnd lMOMRole = association.getRoleA();
        ModelRelationRole lRoleA = lRelation.createModelRelationRole(lMOMRole.getName());
        lRoleA.setAggregate(lMOMRole.getAggregation());
        lRoleA.setCardinality(CardinalityEnum.valueOf((String)lMOMRole.getCardinality()));
        if (lMOMRole.getNoImport()) {
            lRoleA.setNavigable(false);
        } else {
            lRoleA.setNavigable(lMOMRole.getNavigable());
        }
        lRoleA.setModelClass(this.findModelClass(lMOMRole.getRoleClass()));
        lMOMRole = association.getRoleB();
        ModelRelationRole lRoleB = lRelation.createModelRelationRole(lMOMRole.getName());
        lRoleB.setAggregate(lMOMRole.getAggregation());
        lRoleB.setCardinality(CardinalityEnum.valueOf((String)lMOMRole.getCardinality()));
        if (lMOMRole.getNoImport()) {
            lRoleB.setNavigable(false);
        } else {
            lRoleB.setNavigable(lMOMRole.getNavigable());
        }
        lRoleB.setModelClass(this.findModelClass(lMOMRole.getRoleClass()));
        this.mLog.addInfoMessage("    adding relation \"" + lRelation.getName() + "\" between classes \"" + lRoleA.getModelClass().getName() + "\" and \"" + lRoleB.getModelClass().getName() + "\":\n" + "              role \"" + lRoleA.getName() + "\": modelclass=" + lRoleA.getModelClass().getName() + ", aggregate=" + lRoleA.getAggregate() + ", cardinality=" + lRoleA.getCardinality() + ", navigable=" + lRoleA.getNavigable() + "\n" + "              role \"" + lRoleB.getName() + "\": modelclass=" + lRoleB.getModelClass().getName() + ", aggregate=" + lRoleB.getAggregate() + ", cardinality=" + lRoleB.getCardinality() + ", navigable=" + lRoleB.getNavigable());
    }

    private Model renderModel() throws Exception {
        if (this.mClasses.isEmpty()) {
            this.mLog.addWarningMessage("the XMI file contains no classes");
            return null;
        }
        boolean classToImport = false;
        Iterator it = this.mClasses.values().iterator();
        while (it.hasNext()) {
            MetamodelClass lClass = (MetamodelClass)it.next();
            if (!lClass.getImport()) continue;
            classToImport = true;
        }
        if (!classToImport) {
            this.mLog.addWarningMessage("found 0 classes (out of " + this.mClasses.size() + ") flagged for Web Dynpro import");
            return null;
        }
        this.mModel = this.mWebDynpro.createModel(this.mModelPackage, this.mModelName, this.mSourcePathId);
        this.mModel.setModelType(this.mModelType);
        ModelSetting lModelSetting = this.mModel.createSetting("requiresCodeGeneration");
        lModelSetting.setValue("false");
        lModelSetting.setSettingDefinition(this.mModelType.getModelSettingDefinition("requiresCodeGeneration"));
        int classCount = 0;
        int propertyCount = 0;
        int operationCount = 0;
        int relationCount = 0;
        Iterator it2 = this.mClasses.values().iterator();
        while (it2.hasNext()) {
            MetamodelClass lClass = (MetamodelClass)it2.next();
            if (!lClass.getVisibility().equals("public")) {
                this.mLog.addInfoMessage("skipping class \"" + lClass.getName() + "\": not public");
                it2.remove();
                continue;
            }
            if (!lClass.getImport()) {
                this.mLog.addInfoMessage("skipping class \"" + lClass.getName() + "\": not flagged for Web Dynpro import");
                it2.remove();
                continue;
            }
            ModelClass lModelClass = null;
            lModelClass = this.mModel.createModelClass(lClass.getPackage(), lClass.getName(), this.mSourcePathId);
            ++classCount;
        }
        ArrayList<MetamodelOperation> lMethodsToDelete = new ArrayList<MetamodelOperation>();
        Iterator it3 = this.mClasses.values().iterator();
        while (it3.hasNext()) {
            MetamodelClass lClass = (MetamodelClass)it3.next();
            ModelClass lModelClass = this.findModelClass(lClass);
            if (lClass.getIsInterface()) {
                Iterator it22 = lClass.getExtendedInterfaces().iterator();
                while (it22.hasNext()) {
                    MetamodelClass lExtendedInterface = (MetamodelClass)it22.next();
                    if (lExtendedInterface.getImport()) {
                        lModelClass.addInterface(this.findModelClass(lExtendedInterface));
                        continue;
                    }
                    this.mLog.addWarningMessage("skipping inheritance between interface \"" + lClass.getName() + "\" and interface \"" + lExtendedInterface.getName() + "\": \"" + lExtendedInterface.getName() + "\" not flagged for Web Dynpro import");
                }
            } else if (lClass.hasSuperClass()) {
                if (lClass.getSuperClass().getImport()) {
                    lModelClass.setSuperClass((AppClass)this.findModelClass(lClass.getSuperClass()));
                } else {
                    this.mLog.addWarningMessage("skipping inheritance between class \"" + lClass.getName() + "\" and class \"" + lClass.getSuperClass().getName() + "\": \"" + lClass.getSuperClass().getName() + "\" not flagged for Web Dynpro import");
                }
            }
            TreeSet lInterfaces = lClass.getImplementedInterfaces();
            Iterator it23 = lInterfaces.iterator();
            while (it23.hasNext()) {
                MetamodelClass lInterface = (MetamodelClass)it23.next();
                if (!lInterface.getImport()) {
                    this.mLog.addInfoMessage("skipping \"implements\" relationship between \"" + lClass.getName() + "\" and \"" + lInterface.getName() + "\": \"" + lInterface.getName() + "\" not flagged for Web Dynpro import");
                    continue;
                }
                lModelClass.addInterface(this.findModelClass(lInterface));
                this.mLog.addInfoMessage("adding \"implements\" relationship between \"" + lClass.getName() + "\" and \"" + lInterface.getName() + "\"");
            }
            lModelClass.setVisibility(VisibilityEnum.PUBLIC);
            if (lClass.getIsAbstract()) {
                lModelClass.setIsAbstract(true);
            }
            if (lClass.getIsInterface()) {
                lModelClass.setIsInterface(true);
                this.mLog.addInfoMessage("adding interface \"" + lClass.getName() + "\", package: " + (lClass.getPackage().equals("") ? "<default>" : lClass.getPackage()));
            } else {
                this.mLog.addInfoMessage("adding " + (lClass.getIsAbstract() ? "abstract " : "") + "class \"" + lClass.getName() + "\", package: " + (lClass.getPackage().equals("") ? "<default>" : lClass.getPackage()));
            }
            Iterator it24 = lClass.getOperations().iterator();
            while (it24.hasNext()) {
                MetamodelOperation lOperation = (MetamodelOperation)it24.next();
                if (!lOperation.getVisibility().equals("public")) {
                    this.mLog.addInfoMessage("  skipping operation \"" + lOperation.getName() + "\" of class \"" + lClass.getName() + "\": not public");
                    it24.remove();
                    continue;
                }
                if (!lOperation.getNoImport()) continue;
                this.mLog.addInfoMessage("  skipping operation \"" + lOperation.getName() + "\" of class \"" + lClass.getName() + "\": not flagged for Web Dynpro import");
                it24.remove();
            }
            lMethodsToDelete.clear();
            Iterator it25 = lClass.getOperations().iterator();
            while (it25.hasNext()) {
                MetamodelOperation lOper;
                MetamodelOperation lOperation = (MetamodelOperation)it25.next();
                String lReturnType = lOperation.getReturnType();
                String lOpName = lOperation.getName();
                if (lReturnType.equals("") || lOpName.length() <= 3 || !lOpName.startsWith("get") || !Character.isUpperCase(lOpName.charAt(3)) || !lOperation.getParameters().isEmpty()) continue;
                this.mLog.addInfoMessage("  inspecting operation \"" + lReturnType + " " + lOperation.getName() + "()\"");
                String lObjectName = lOpName.substring(3);
                if (this.isJavaCollection(lReturnType)) {
                    MetamodelOperation lOper2;
                    MetamodelAssociation lAssociation = this.findToNRelation(lClass, lObjectName);
                    if (lAssociation != null) {
                        this.createModelRelation(lAssociation);
                        ++relationCount;
                        it25.remove();
                        MetamodelClass lOtherClass = null;
                        lOtherClass = lAssociation.getRoleA().getRoleClass() == lClass ? lAssociation.getRoleB().getRoleClass() : lAssociation.getRoleA().getRoleClass();
                        String lType = lOtherClass.getPackage().equals("") ? lOtherClass.getName() : lOtherClass.getPackage() + "." + lOtherClass.getName();
                        lOper2 = this.findPublicAdder(lClass, lObjectName, lType);
                        if (lOper2 != null) {
                            lMethodsToDelete.add(lOper2);
                        }
                        if ((lOper2 = this.findPublicRemover(lClass, lObjectName, lType)) == null) continue;
                        lMethodsToDelete.add(lOper2);
                        continue;
                    }
                    String lName = lObjectName.substring(0, 1).toLowerCase() + lObjectName.substring(1);
                    ModelClassProperty lProperty = lModelClass.createProperty(lName);
                    lProperty.setVisibility(VisibilityEnum.PUBLIC);
                    this.setType((DevelopmentObject)lProperty, lReturnType);
                    ++propertyCount;
                    it25.remove();
                    lOper2 = this.findPublicSetter(lClass, lObjectName, lReturnType);
                    if (lOper2 != null) {
                        lMethodsToDelete.add(lOper2);
                    } else {
                        lProperty.setReadonly(true);
                    }
                    this.mLog.addInfoMessage("    adding" + (lProperty.getReadonly() ? " read-only " : " ") + "property \"" + lName + "\", type: " + this.getTypeName(lProperty.getType()));
                    continue;
                }
                if (this.mClasses.containsKey(lReturnType)) {
                    MetamodelClass lOtherClass = (MetamodelClass)this.mClasses.get(lReturnType);
                    MetamodelAssociation lAssociation = this.findTo1Relation(lClass, lOtherClass, lObjectName);
                    if (lAssociation == null) continue;
                    this.createModelRelation(lAssociation);
                    ++relationCount;
                    it25.remove();
                    lOper = this.findPublicSetter(lClass, lObjectName, lReturnType);
                    if (lOper == null) continue;
                    lMethodsToDelete.add(lOper);
                    continue;
                }
                String lName = lObjectName.substring(0, 1).toLowerCase() + lObjectName.substring(1);
                ModelClassProperty lProperty = lModelClass.createProperty(lName);
                lProperty.setVisibility(VisibilityEnum.PUBLIC);
                this.setType((DevelopmentObject)lProperty, lReturnType);
                it25.remove();
                lOper = this.findPublicSetter(lClass, lObjectName, lReturnType);
                if (lOper != null) {
                    lMethodsToDelete.add(lOper);
                } else {
                    lProperty.setReadonly(true);
                }
                ++propertyCount;
                this.mLog.addInfoMessage("    adding" + (lProperty.getReadonly() ? " read-only " : " ") + "property \"" + lName + "\", type: " + this.getTypeName(lProperty.getType()));
            }
            Iterator it26 = ((AbstractList)lMethodsToDelete).iterator();
            while (it26.hasNext()) {
                MetamodelOperation lOperation = (MetamodelOperation)it26.next();
                this.mLog.addInfoMessage("  skipping operation \"" + lOperation.getName() + "\" of class \"" + lClass.getName() + "\": public accessor/mutator");
                lClass.getOperations().remove(lOperation);
            }
            Iterator it27 = lClass.getOperations().iterator();
            while (it27.hasNext()) {
                MetamodelOperation lOperation = (MetamodelOperation)it27.next();
                ModelClassMethod lMethod = lModelClass.createMethod(lOperation.getName());
                lMethod.setVisibility(VisibilityEnum.valueOf((String)lOperation.getVisibility()));
                if (!lOperation.getReturnType().equals("")) {
                    this.setType((DevelopmentObject)lMethod, lOperation.getReturnType());
                    this.mLog.addInfoMessage("  adding method \"" + lOperation.getName() + "\", return type: " + this.getTypeName(lMethod.getReturnType()));
                } else {
                    this.mLog.addInfoMessage("  adding method \"" + lOperation.getName() + "\", return type: <none>");
                }
                ++operationCount;
                Iterator it32 = ((AbstractList)lOperation.getParameters()).iterator();
                while (it32.hasNext()) {
                    MetamodelParameter lMOMParameter = (MetamodelParameter)it32.next();
                    Parameter lParameter = lMethod.createParameter(lMOMParameter.getName());
                    this.setType((DevelopmentObject)lParameter, lMOMParameter.getType());
                    this.mLog.addInfoMessage("    adding parameter \"" + lParameter.getName() + "\", type: " + this.getTypeName(lParameter.getType()));
                }
            }
        }
        this.mLog.addInfoMessage("total added: " + classCount + " classes/interfaces, " + propertyCount + " properties, " + operationCount + " operations, " + relationCount + " relations");
        this.mModel.validate();
        return this.mModel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

