/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.webservice.info;

import com.sap.ide.metamodel.importers.webservice.info.ParameterInfo;
import com.sap.ide.metamodel.importers.webservice.info.TypeInfo;
import org.eclipse.jdt.core.IMethod;

public class MethodInfo {
    private String name = null;
    private IMethod iMethod = null;
    private TypeInfo[] exceptions = null;
    private TypeInfo returntype = null;
    private ParameterInfo[] parameters = new ParameterInfo[0];
    private boolean isPublic = false;
    private boolean isPrivate = false;
    private boolean isProtected = false;
    private boolean isStatic = false;
    private boolean isFinal = false;
    private boolean isAbstract = false;

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setIsAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setIsFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public void setIsPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public void setIsProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    public void setIsPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public void setIsStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public TypeInfo[] getExceptions() {
        return this.exceptions;
    }

    public String getName() {
        return this.name;
    }

    public ParameterInfo[] getParameters() {
        return this.parameters;
    }

    public TypeInfo getReturntype() {
        return this.returntype;
    }

    public void setExceptions(TypeInfo[] exceptions) {
        this.exceptions = exceptions;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameters(ParameterInfo[] parameters) {
        this.parameters = parameters;
    }

    public void setReturntype(TypeInfo returntype) {
        this.returntype = returntype;
    }

    public String toString() {
        TypeInfo returntype = this.getReturntype();
        String srettype = null;
        if (returntype != null) {
            srettype = returntype.getClassname();
        }
        return this.getModifierString() + " " + srettype + " " + this.getName() + "(" + this.getParametersString() + ")" + this.getThrowsString();
    }

    public String toSignatureString() {
        TypeInfo returntype = this.getReturntype();
        String srettype = null;
        if (returntype != null) {
            srettype = returntype.getClassname();
        }
        StringBuffer arraybrackets = new StringBuffer("");
        if (returntype.isArray()) {
            int i = 0;
            while (i < returntype.getArrayDimension()) {
                arraybrackets.append("[]");
                ++i;
            }
        }
        return this.getModifierString() + " " + srettype + arraybrackets + " " + this.getName() + "(" + this.getParametersString() + ")" + this.getThrowsString();
    }

    public String getModifierString() {
        StringBuffer buf = new StringBuffer();
        if (this.isAbstract) {
            buf.append("abstract ");
        }
        if (this.isPublic) {
            buf.append("public ");
        }
        if (this.isPrivate) {
            buf.append("private ");
        }
        if (this.isProtected) {
            buf.append("protected ");
        }
        if (this.isFinal) {
            buf.append("final ");
        }
        if (this.isStatic) {
            buf.append("static ");
        }
        return buf.toString();
    }

    public String getParametersString() {
        StringBuffer buf = new StringBuffer();
        if (this.parameters == null) {
            return "";
        }
        int i = 0;
        while (i < this.parameters.length) {
            buf.append(this.parameters[i].getType().getClassname()).append(" ").append(this.parameters[i].getName());
            if (i < this.parameters.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        return buf.toString();
    }

    public String getThrowsString() {
        StringBuffer buf = new StringBuffer();
        if (this.exceptions == null) {
            return "";
        }
        int i = 0;
        while (i < this.exceptions.length) {
            buf.append(this.exceptions[i].getClassname());
            if (i < this.exceptions.length - 1) {
                buf.append(",");
            }
            ++i;
        }
        return buf.toString();
    }

    public IMethod getIMethod() {
        return this.iMethod;
    }

    public void setIMethod(IMethod iMethod) {
        this.iMethod = iMethod;
    }

    public String toDebugString() {
        StringBuffer buf = new StringBuffer();
        buf.append("\n******** DEBUG STRING ***********").append("\n").append(super.toString());
        buf.append("\nname=").append(this.name).append("\n isPrimitiveType=").append(this.parameters).append("\n number of parameters=").append(this.parameters.length).append("\n returntype=").append(this.returntype).append("\n DEBUG STRING returntype=").append(this.returntype.toDebugString()).append("\n iMethod=").append(this.iMethod).append("\n******************************\n");
        return buf.toString();
    }
}

