/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.webservice.info;

import com.sap.ide.metamodel.importers.webservice.WebServiceImporterUtil;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;

public class JDTInfoUtil {
    public static boolean isPublicMethod(IMethod meth) throws JavaModelException {
        int flags = meth.getFlags();
        return Flags.isPublic((int)flags);
    }

    public static boolean isDDICType(String encParam) {
        String typename = JDTInfoUtil.convertFromPrimitiveAbbreviationToName(encParam);
        String result = WebServiceImporterUtil.getDDICBuiltInType(typename);
        return result != null;
    }

    public static boolean isPrimitiveType(String encodedParam) {
        String[][] arOfTypeDefs = new String[][]{{"B", "byte"}, {"C", "char"}, {"D", "double"}, {"F", "float"}, {"I", "int"}, {"J", "long"}, {"S", "short"}, {"V", "void"}, {"Z", "boolean"}};
        String lParamtype = JDTInfoUtil.stripArrayPrefix(encodedParam);
        boolean result = false;
        int i = 0;
        while (i < arOfTypeDefs.length) {
            String name = arOfTypeDefs[i][0];
            String value = arOfTypeDefs[i][1];
            if (lParamtype.equals(name)) {
                return true;
            }
            ++i;
        }
        return result;
    }

    public static String convertFromPrimitiveAbbreviationToName(String encParam) {
        String lParamtype;
        String[][] arOfTypeDefs = new String[][]{{"B", "byte"}, {"C", "char"}, {"D", "double"}, {"F", "float"}, {"I", "int"}, {"J", "long"}, {"S", "short"}, {"V", "void"}, {"Z", "boolean"}};
        String result = lParamtype = JDTInfoUtil.stripArrayPrefix(encParam);
        int i = 0;
        while (i < arOfTypeDefs.length) {
            String name = arOfTypeDefs[i][0];
            String value = arOfTypeDefs[i][1];
            if (lParamtype.equals(name)) {
                result = value;
                break;
            }
            ++i;
        }
        return result;
    }

    public static String stripArrayPrefix(String encParam) {
        int lPos = encParam.lastIndexOf("[");
        String lParamtype = encParam.substring(lPos + 1, encParam.length());
        return lParamtype;
    }

    public static boolean isAJavaClass(String paramtype) {
        String lParamType = JDTInfoUtil.stripArrayPrefix(paramtype);
        return lParamType.startsWith("Q") || lParamType.startsWith("L");
    }

    public static String getJavaClassName(String paramtype) {
        String lParamType = JDTInfoUtil.stripArrayPrefix(paramtype);
        if (lParamType.startsWith("Q") || lParamType.startsWith("L")) {
            return lParamType.substring(1, lParamType.length() - 1);
        }
        throw new RuntimeException("This is no javaclass test it beforehand");
    }

    public static boolean isArray(String paramtype) {
        int lPos = paramtype.lastIndexOf("[");
        return lPos > -1;
    }

    public static int getArrayDimensions(String paramtype) {
        int lPos = paramtype.lastIndexOf("[");
        return lPos + 1;
    }

    public static String getTypeName(String paramtype) {
        String result = null;
        if (JDTInfoUtil.isPrimitiveType(paramtype)) {
            result = JDTInfoUtil.convertFromPrimitiveAbbreviationToName(paramtype);
        } else if (JDTInfoUtil.isAJavaClass(paramtype)) {
            result = JDTInfoUtil.getJavaClassName(paramtype);
        }
        return result;
    }
}

