/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.webservice.info;

import com.sap.ide.metamodel.importers.webservice.info.JDTInfoUtil;
import com.sap.ide.metamodel.importers.webservice.info.MethodInfo;
import com.sap.ide.metamodel.importers.webservice.info.ParameterInfo;
import com.sap.ide.metamodel.importers.webservice.info.TypeInfo;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public class JDTInfoFactory {
    Hashtable classNamesITypes = null;
    Hashtable typeInfoCache = new Hashtable();
    Hashtable typesBeingCreated = new Hashtable();

    public JDTInfoFactory() {
    }

    public JDTInfoFactory(Hashtable classItype) {
        this.classNamesITypes = classItype;
    }

    public TypeInfo createTypeInfo(IType itype) throws JavaModelException {
        TypeInfo typeInfo = (TypeInfo)this.typesBeingCreated.get(itype.getFullyQualifiedName());
        if (typeInfo != null) {
            return typeInfo;
        }
        TypeInfo result = new TypeInfo();
        result.setIType(itype);
        result.setClassname(itype.getFullyQualifiedName());
        result.setIsPrimitiveType(false);
        this.typesBeingCreated.put(itype.getFullyQualifiedName(), result);
        Vector<MethodInfo> vMethInfo = new Vector<MethodInfo>();
        IMethod[] methods = itype.getMethods();
        int i = 0;
        while (i < methods.length) {
            IMethod curIMeth = methods[i];
            MethodInfo curMethInfo = this.createMethodInfo(curIMeth);
            vMethInfo.add(curMethInfo);
            ++i;
        }
        MethodInfo[] arMethinfo = new MethodInfo[vMethInfo.size()];
        vMethInfo.toArray(arMethinfo);
        result.setMethods(arMethinfo);
        this.typesBeingCreated.remove(itype.getFullyQualifiedName());
        return result;
    }

    public MethodInfo createMethodInfo(IMethod curIMeth) throws JavaModelException {
        MethodInfo curMethInfo = new MethodInfo();
        String encRettype = curIMeth.getReturnType();
        curMethInfo.setIsPublic(JDTInfoUtil.isPublicMethod(curIMeth));
        curMethInfo.setName(curIMeth.getElementName());
        curMethInfo.setReturntype(this.createTypeInfo(encRettype));
        curMethInfo.setIMethod(curIMeth);
        Vector<ParameterInfo> params = new Vector<ParameterInfo>();
        String[] sParamNames = curIMeth.getParameterNames();
        String[] sEncParamTypes = curIMeth.getParameterTypes();
        int j = 0;
        while (j < sEncParamTypes.length) {
            ParameterInfo parInfo = new ParameterInfo();
            parInfo.setName(sParamNames[j]);
            parInfo.setType(this.createTypeInfo(sEncParamTypes[j]));
            params.add(parInfo);
            ++j;
        }
        ParameterInfo[] arParams = new ParameterInfo[params.size()];
        params.toArray(arParams);
        curMethInfo.setParameters(arParams);
        return curMethInfo;
    }

    public TypeInfo createTypeInfo(String encodedParam) throws JavaModelException {
        this.traceEnterMethod("createTypeInfo(String encodedParam)");
        boolean isArray = JDTInfoUtil.isArray(encodedParam);
        boolean isPrimitiveType = JDTInfoUtil.isPrimitiveType(encodedParam);
        int arrayDimensions = JDTInfoUtil.getArrayDimensions(encodedParam);
        String classname = JDTInfoUtil.getTypeName(encodedParam);
        this.logTrace("createTypeInfo:encodedParam=" + encodedParam + " becomes " + classname);
        TypeInfo result = null;
        if (isPrimitiveType) {
            result = new TypeInfo();
            result.setClassname(classname);
            result.setIsPrimitiveType(true);
            if (isArray) {
                result.setIsArray(true);
                result.setArrayDimension(arrayDimensions);
            }
        } else {
            IType itype = (IType)this.classNamesITypes.get(classname);
            if (itype != null) {
                result = this.createTypeInfo(itype);
            } else {
                result = new TypeInfo();
                result.setClassname(classname);
                result.setIsPrimitiveType(false);
            }
            if (isArray) {
                result.setIsArray(true);
                result.setArrayDimension(arrayDimensions);
            }
        }
        return result;
    }

    private void logTrace(Object msg) {
    }

    private void logException(Throwable t) {
        System.out.println("EXCEPTION occurred");
        t.printStackTrace(System.out);
    }

    private void logDebug(Object msg) {
        System.out.println("DEBUG " + this + ": " + msg);
    }

    private void logInfo(Object msg) {
        System.out.println("INFO " + this + ": " + msg);
    }

    private void traceEnterMethod(String meth) {
    }

    private void traceExitMethod(String meth) {
    }
}

