/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.webservice;

import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.DevelopmentObjectObserver;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.event.MDODiscardedEvent;
import com.sap.ide.metamodel.general.event.MetamodelEvent;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.importers.webservice.GenerateWS;
import com.sap.ide.metamodel.importers.webservice.WDProjectPropertiesUtil;
import com.sap.ide.metamodel.importers.webservice.WebServiceImporterUtil;
import com.sap.ide.metamodel.importers.webservice.WebServiceMetaModelCreator;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.Model;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;

public class WebServiceModelImporter {
    private WebDynproRoot mWebDynpro;
    private DtDictionaryRoot mDictionary;
    private String mLanguage = "";
    private String mModelPackage = "";
    private String mModelName = "";
    private Model mModel;
    private static final String MODELTYPE_PACKAGE = "com.sap.ide.webdynpro.modeltypes";
    private static final String MODELTYPE_NAME = "WebService";
    private GenerateWS mWebService;
    private IProject mProject;
    private IJavaProject mJavaProject;

    public WebServiceModelImporter(DtDictionaryRoot dictionary, WebDynproRoot webdynpro) throws LoadException {
        this(dictionary, webdynpro, "en");
    }

    public WebServiceModelImporter(DtDictionaryRoot dictionary, WebDynproRoot webdynpro, String language) throws LoadException {
        this.mDictionary = dictionary;
        this.mWebDynpro = webdynpro;
        this.mLanguage = language;
    }

    public Model doImport(String modelPackageName, String modelName, SourcePathIdentifier sourcePathIdentifier, String sourceFolder, String proxyPackageName, String wsdlURL, Properties uriMapping, IProgressMonitor monitor) throws Exception {
        this.mProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mWebDynpro.getMetamodel().getName());
        if (!sourceFolder.endsWith(System.getProperty("file.separator"))) {
            sourceFolder = sourceFolder + System.getProperty("file.separator");
        }
        this.mWebService = new GenerateWS(modelName, wsdlURL, proxyPackageName, this.mProject.getLocation().append(sourceFolder).toString(), sourceFolder, true, true, this.mProject, sourcePathIdentifier, uriMapping);
        try {
            this.mWebService.doGenerate();
        }
        catch (Exception e) {
            WebServiceModelImporter.logException(e);
            throw e;
        }
        this.mJavaProject = JavaCore.create((IProject)this.mProject);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                WDProjectPropertiesUtil.addWebServiceReferences(WebServiceModelImporter.this.mProject);
                WDProjectPropertiesUtil.addWebServiceLibrariesToClassPath(WebServiceModelImporter.this.mProject);
                try {
                    WebServiceModelImporter.this.mProject.refreshLocal(2, null);
                }
                catch (CoreException e) {
                    WebServiceModelImporter.logException(e);
                }
            }
        });
        String serviceInterface = this.mWebService.getServiceInterfaceName();
        String[] lports = this.mWebService.getLPorts();
        String[] lportNames = this.mWebService.getLPortNames();
        Hashtable iTypes = WebServiceImporterUtil.allJavaFiles(this.mProject, this.mProject.getLocation().append(sourceFolder).toString(), proxyPackageName, sourceFolder);
        WebServiceMetaModelCreator creator = new WebServiceMetaModelCreator(this.mWebDynpro, this.mDictionary, sourcePathIdentifier, modelPackageName, modelName, proxyPackageName, iTypes, serviceInterface, lports, lportNames);
        System.out.println("ServiceImpl =" + creator.getServiceImpl());
        try {
            this.mModel = creator.createModel();
        }
        catch (Exception ex) {
            WebServiceModelImporter.logException(ex);
        }
        this.mModel.attachObserver((DevelopmentObjectObserver)new ModelDiscardListener(), 16384);
        System.out.println("model created!" + this.mModel);
        return this.mModel;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String Old_addWSRefsToReference_Txt(String reference_txt_path) {
        block25: {
            breader = null;
            bwriter = null;
            lineseparator = System.getProperty("line.separator");
            try {
                try {
                    librefs = new String[]{"IAIKSecurity", "mail", "activation", "jnet", "jsse"};
                    servicerefs = new String[]{"webservices"};
                    freader = new FileReader(reference_txt_path);
                    breader = new BufferedReader(freader);
                    line = null;
                    serviceRefsCount = false;
                    libRefsCount = false;
                    comments = new StringBuffer();
                    setServiceRefs = new TreeSet<String>();
                    setLibRefs = new TreeSet<String>();
                    i = 0;
                    while (true) {
                        block23: {
                            if (i < servicerefs.length) break block23;
                            i = 0;
                            if (true) ** GOTO lbl66
                        }
                        setServiceRefs.add(servicerefs[i]);
                        ++i;
                    }
                }
                catch (Exception ex) {
                    WebServiceModelImporter.logException(ex);
                    var5_7 = "there was an error updating the references.txt. Please do it manually";
                    var22_29 = null;
                    try {
                        if (breader != null) {
                            breader.close();
                        }
                    }
                    catch (Exception ex) {
                        WebServiceModelImporter.logException(ex);
                    }
                    try {
                        if (bwriter == null) return var5_7;
                        bwriter.close();
                        return var5_7;
                    }
                    catch (Exception ex) {
                        WebServiceModelImporter.logException(ex);
                    }
                    return var5_7;
                }
            }
            catch (Throwable var21_34) {
                block24: {
                    var22_30 = null;
                    ** try [egrp 2[TRYBLOCK] [2 : 566->577)] { 
lbl49:
                    // 1 sources

                    if (breader != null) {
                        breader.close();
                    }
                    break block24;
lbl52:
                    // 1 sources

                    catch (Exception ex) {
                        WebServiceModelImporter.logException(ex);
                    }
                }
                try {}
                catch (Exception ex) {
                    WebServiceModelImporter.logException(ex);
                    throw var21_34;
                }
                if (bwriter == null) throw var21_34;
                bwriter.close();
                throw var21_34;
            }
            do {
                setLibRefs.add(librefs[i]);
                ++i;
lbl66:
                // 2 sources

            } while (i < librefs.length);
            while ((line = breader.readLine()) != null) {
                if (line.trim().startsWith("#")) {
                    comments.append(line).append(lineseparator);
                    continue;
                }
                colonpos = line.lastIndexOf(61);
                if (colonpos == -1) break;
                value = line.substring(colonpos + 1);
                dotpos = line.lastIndexOf(46, colonpos);
                number = line.substring(dotpos + 1, colonpos);
                inumber = Integer.parseInt(number);
                if (line.indexOf("ServicesReference") > -1) {
                    setServiceRefs.add(value);
                    continue;
                }
                if (line.indexOf("LibarariesReference") <= -1) continue;
                setLibRefs.add(value);
            }
            breader.close();
            freader.close();
            filecontent = new StringBuffer();
            filecontent.append((Object)comments);
            i = 1;
            iter = setLibRefs.iterator();
            while (iter.hasNext()) {
                libname = (String)iter.next();
                filecontent.append("LibarariesReference").append(".").append(i).append("=").append(libname).append(lineseparator);
                ++i;
            }
            i = 1;
            iter = setServiceRefs.iterator();
            while (iter.hasNext()) {
                servicename = (String)iter.next();
                filecontent.append("ServicesReference").append(".").append(i).append("=").append(servicename).append(lineseparator);
                ++i;
            }
            System.out.println("reference.txt new content:");
            System.out.println(filecontent);
            System.out.println("------------");
            writer = new FileWriter(reference_txt_path);
            bwriter = new BufferedWriter(writer);
            bwriter.write(filecontent.toString());
            bwriter.close();
            var20_27 = "references.txt was successfully updated";
            var22_28 = null;
            ** try [egrp 2[TRYBLOCK] [2 : 566->577)] { 
lbl118:
            // 1 sources

            if (breader != null) {
                breader.close();
            }
            break block25;
lbl121:
            // 1 sources

            catch (Exception ex) {
                WebServiceModelImporter.logException(ex);
            }
        }
        ** try [egrp 3[TRYBLOCK] [3 : 584->595)] { 
lbl125:
        // 1 sources

        if (bwriter == null) return var20_27;
        bwriter.close();
        return var20_27;
lbl128:
        // 1 sources

        catch (Exception ex) {
            WebServiceModelImporter.logException(ex);
        }
        return var20_27;
    }

    private void logTrace(Object msg) {
        System.out.println("TRACE " + this + ": " + msg);
    }

    private static void logException(Throwable t) {
        System.out.println("EXCEPTION occurred");
        t.printStackTrace(System.out);
    }

    private void logDebug(Object msg) {
        System.out.println("DEBUG " + this + ": " + msg);
    }

    private void logInfo(Object msg) {
        System.out.println("INFO " + this + ": " + msg);
    }

    private void traceEnterMethod(String meth) {
        System.out.println("ENTER " + meth);
    }

    private void traceExitMethod(String meth) {
        System.out.println("EXIT " + meth);
    }

    public class ModelDiscardListener
    implements DevelopmentObjectObserver {
        public void update(MetamodelEvent event) {
            this.handleModelDiscardEvent(event);
        }

        public void update(MetamodelEvent[] events) {
            int i = 0;
            while (i < events.length) {
                this.handleModelDiscardEvent(events[i]);
                ++i;
            }
        }

        private void handleModelDiscardEvent(MetamodelEvent event) {
            MDODiscardedEvent mdoDiscardedEvent;
            if (WebServiceModelImporter.this.mModel == null || WebServiceModelImporter.this.mWebService == null) {
                return;
            }
            if (event instanceof MDODiscardedEvent && (mdoDiscardedEvent = (MDODiscardedEvent)event).getModifiedObject() == WebServiceModelImporter.this.mModel) {
                WebServiceModelImporter.this.mWebService.deleteWS();
            }
        }
    }
}

