/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.webservice;

import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.importers.WebDynproMetamodelUtil;
import com.sap.ide.metamodel.importers.webservice.JavaBeanWrapperCreator;
import com.sap.ide.metamodel.importers.webservice.SimpleTypeWrapperCreator;
import com.sap.ide.metamodel.importers.webservice.WebServiceImporterUtil;
import com.sap.ide.metamodel.importers.webservice.info.JDTInfoFactory;
import com.sap.ide.metamodel.importers.webservice.info.MethodInfo;
import com.sap.ide.metamodel.importers.webservice.info.ParameterInfo;
import com.sap.ide.metamodel.importers.webservice.info.TypeInfo;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelSetting;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class WebServiceMetaModelCreator {
    private static final String RESPONSE_CLASS = "Response";
    private static final String REQUEST_CLASS = "Request";
    private Model mModel = null;
    private ModelType mModelType = null;
    private String mModel_Package = null;
    private String mModel_Name = null;
    private WebDynproRoot mWebDynpro = null;
    private DtDictionaryRoot mDictionary = null;
    private SourcePathIdentifier mSourcePathId = null;
    private static final String DICTIONARY_PACKAGE = "com.sap.dictionary";
    private static final String MODELTYPE_PACKAGE = "com.sap.ide.webdynpro.modeltypes";
    private static final String MODELTYPE_NAME = "WebService";
    private String mProxyPackage = null;
    private Hashtable mClassNameToIType = new Hashtable();
    private JDTInfoFactory mJdtfactory = null;
    private String[] mLogicalPortClassNames = null;
    private String[] mLogicalPortNames = null;
    private ImportLog mGenerationWarnings = new ImportLog();
    private JavaBeanWrapperCreator mJavaBeanCreator = null;
    private SimpleTypeWrapperCreator mSimpleTypeWrapperCreator = null;
    private IType mServiceImpl = null;
    private Hashtable mGeneratedModelClasses = new Hashtable();
    private Hashtable mWSMethodnames = new Hashtable();

    public WebServiceMetaModelCreator() {
    }

    public WebServiceMetaModelCreator(WebDynproRoot wdRoot, DtDictionaryRoot ddicRoot, SourcePathIdentifier sourcePathId, String modelPackage, String modelName, String proxyPackage, Hashtable classNamesToITypes, String rpcService, String[] logicalPorts, String[] logicalPortNames) {
        this.mWebDynpro = wdRoot;
        this.mDictionary = ddicRoot;
        this.mSourcePathId = sourcePathId;
        this.mModel_Package = modelPackage;
        this.mModel_Name = modelName;
        this.mProxyPackage = proxyPackage;
        this.mClassNameToIType = classNamesToITypes;
        this.mLogicalPortClassNames = logicalPorts;
        this.mLogicalPortNames = logicalPortNames;
        IType serviceintf = (IType)classNamesToITypes.get(rpcService);
        this.mJdtfactory = new JDTInfoFactory(classNamesToITypes);
        this.mServiceImpl = WebServiceImporterUtil.findServiceImpl(classNamesToITypes, rpcService);
        if (this.mServiceImpl == null) {
            throw new RuntimeException("ServiceImpl not found!");
        }
    }

    public Model createModel() throws MetamodelException, JavaModelException {
        this.traceEnterMethod("createModel()");
        this.mModel = WebDynproMetamodelUtil.getOrCreateModel(this.mWebDynpro, this.mModel_Package, this.mModel_Name, this.mSourcePathId);
        this.mModelType = WebServiceImporterUtil.getModelType(this.mWebDynpro, MODELTYPE_PACKAGE, MODELTYPE_NAME, this.mSourcePathId);
        this.mModel.setModelType(this.mModelType);
        ModelSetting lModelSetting = WebServiceImporterUtil.createModelSetting(this.mModel, this.mModelType, "requiresCodeGeneration", "true");
        WebServiceImporterUtil.createModelSetting(this.mModel, this.mModelType, "ServiceImpl", this.mServiceImpl.getFullyQualifiedName());
        this.mSimpleTypeWrapperCreator = new SimpleTypeWrapperCreator(this.mModel, this.mModelType, this.mSourcePathId, this.mModel_Package, this.mDictionary, this.mClassNameToIType);
        this.mSimpleTypeWrapperCreator.setWarnings(this.mGenerationWarnings);
        this.mJavaBeanCreator = new JavaBeanWrapperCreator(this.mModel, this.mModelType, this.mSourcePathId, this.mDictionary, this.mClassNameToIType, this.mSimpleTypeWrapperCreator);
        this.mJavaBeanCreator.setWarnings(this.mGenerationWarnings);
        int i = 0;
        while (i < this.mLogicalPortClassNames.length) {
            TypeInfo logicalport = this.mJdtfactory.createTypeInfo((IType)this.mClassNameToIType.get(this.mLogicalPortClassNames[i]));
            this.createModelClassesForWebServiceMethods(logicalport, this.mLogicalPortNames[i]);
            ++i;
        }
        if (!this.mGenerationWarnings.toString().equals("")) {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Warnings", (String)("There were problems generating the model from the given WSDL. \r\n" + this.mGenerationWarnings.toString()));
        }
        this.traceExitMethod("createModel()");
        return this.mModel;
    }

    private void createModelClassesForWebServiceMethods(TypeInfo logicalPort, String logicalPortName) throws JavaModelException, MetamodelException {
        MethodInfo[] wsMethods = logicalPort.getMethods();
        int i = 0;
        while (i < wsMethods.length) {
            if (this.isSupportedWSMethod(wsMethods[i])) {
                this.createModelClassesForWebServiceMethod(logicalPort, wsMethods[i], logicalPortName);
            } else {
                this.mGenerationWarnings.addWarningMessage("The WebService method " + wsMethods[i].toSignatureString() + " is not supported and will be ignored for modelgeneration");
            }
            ++i;
        }
    }

    private boolean isSupportedWSMethod(MethodInfo m) {
        return true;
    }

    private boolean isSupportedWSMethodV2(MethodInfo m) {
        boolean result = true;
        ParameterInfo[] params = m.getParameters();
        TypeInfo retval = m.getReturntype();
        int i = 0;
        while (i < params.length) {
            if (WebServiceImporterUtil.isSimpleDDICTypeOrJavaNativeType(params[i].getType().getClassname(), this.mClassNameToIType) && params[i].getType().isArray()) {
                return false;
            }
            ++i;
        }
        if (WebServiceImporterUtil.isSimpleDDICTypeOrJavaNativeType(retval.getClassname(), this.mClassNameToIType) && retval.isArray()) {
            return false;
        }
        return result;
    }

    private boolean isSupportedWSMethodV1(MethodInfo m) {
        boolean result = true;
        ParameterInfo[] params = m.getParameters();
        TypeInfo retval = m.getReturntype();
        int i = 0;
        while (i < params.length) {
            if (params[i].getType().isArray()) {
                return false;
            }
            if (WebServiceImporterUtil.isSimpleDDICTypeOrJavaNativeType(params[i].getType().getClassname(), this.mClassNameToIType)) {
                result = true;
            }
            if (!WebServiceImporterUtil.isSimpleDDICTypeOrJavaNativeType(params[i].getType().getClassname(), this.mClassNameToIType)) {
                return false;
            }
            if (params[i].getType().isArray()) {
                return false;
            }
            ++i;
        }
        if (retval.isArray()) {
            return false;
        }
        if (!WebServiceImporterUtil.isSimpleDDICTypeOrJavaNativeType(retval.getClassname(), this.mClassNameToIType)) {
            return false;
        }
        return result;
    }

    private void createModelClassesForWebServiceMethod(TypeInfo logicalPort, MethodInfo wsMethod, String logicalPortName) throws JavaModelException, MetamodelException {
        this.traceEnterMethod("createModelClassesForWebServiceMethod(TypeInfo logicalPort, MethodInfo wsMethod) throws JavaModelException,MetamodelException");
        ModelClass ws_request = this.createWS_RequestModelClass(logicalPort, wsMethod, logicalPortName);
        TypeInfo returntype = wsMethod.getReturntype();
        if (!returntype.getClassname().equalsIgnoreCase("void")) {
            ModelClass ws_response = this.createWS_ResponseModelClass(logicalPort, wsMethod);
            WebServiceImporterUtil.createRelationShip(this.mModel, ws_request, ws_response, RESPONSE_CLASS, false);
            WebServiceImporterUtil.createModelClassSetting(ws_request, this.mModelType, "WS_ResponseClass", ws_response.getName());
            WebServiceImporterUtil.createModelClassSetting(ws_request, this.mModelType, "originalBeanClassName", "NONE");
        } else {
            WebServiceImporterUtil.createModelClassSetting(ws_request, this.mModelType, "WS_ResponseClass", "NONE");
            WebServiceImporterUtil.createModelClassSetting(ws_request, this.mModelType, "originalBeanClassName", "NONE");
        }
        this.traceExitMethod("createModelClassesForWebServiceMethod(TypeInfo logicalPort, MethodInfo wsMethod) throws JavaModelException,MetamodelException");
    }

    private ModelClass createWS_RequestModelClass(TypeInfo logicalPort, MethodInfo wsMethod, String logicalPortName) throws JavaModelException, MetamodelException {
        String lpackage = WebServiceImporterUtil.splitClassNameFromPackage(logicalPort.getClassname())[0];
        String lname_request = this.getWS_RequestModelClassName(logicalPort, wsMethod);
        ModelClass ws_request = this.mModel.createModelClass(this.mModel_Package, lname_request, this.mSourcePathId);
        ws_request.setStereotype(REQUEST_CLASS);
        ParameterInfo[] params = wsMethod.getParameters();
        StringBuffer parameternamelist = new StringBuffer();
        int i = 0;
        while (i < params.length) {
            this.processMethodParameter(ws_request, params[i]);
            parameternamelist.append(params[i].getName());
            if (i < params.length - 1) {
                parameternamelist.append(",");
            }
            ++i;
        }
        WebServiceImporterUtil.createModelClassSetting(ws_request, this.mModelType, "ModelClassType", REQUEST_CLASS);
        WebServiceImporterUtil.createModelClassSetting(ws_request, this.mModelType, "LogicalPortClassName", logicalPort.getClassname());
        WebServiceImporterUtil.createModelClassSetting(ws_request, this.mModelType, "LogicalPortName", logicalPortName);
        WebServiceImporterUtil.createModelClassSetting(ws_request, this.mModelType, "WebServiceMethodName", wsMethod.getName());
        WebServiceImporterUtil.createModelClassSetting(ws_request, this.mModelType, "WebServiceMethodOrderedParameterList", parameternamelist.toString());
        return ws_request;
    }

    private ModelClass createWS_ResponseModelClass(TypeInfo logicalPort, MethodInfo wsMethod) throws JavaModelException, MetamodelException {
        String lpackage = WebServiceImporterUtil.splitClassNameFromPackage(logicalPort.getClassname())[0];
        String lname_request = this.getWS_ResponseModelClassName(logicalPort, wsMethod);
        ModelClass ws_response = this.mModel.createModelClass(this.mModel_Package, lname_request, this.mSourcePathId);
        ws_response.setStereotype(RESPONSE_CLASS);
        TypeInfo returntype = wsMethod.getReturntype();
        this.createPropertyInModelClass(ws_response, returntype, "Result");
        WebServiceImporterUtil.createModelClassSetting(ws_response, this.mModelType, "ModelClassType", RESPONSE_CLASS);
        WebServiceImporterUtil.createModelClassSetting(ws_response, this.mModelType, "LogicalPortClassName", logicalPort.getClassname());
        WebServiceImporterUtil.createModelClassSetting(ws_response, this.mModelType, "WebServiceMethodName", "NONE");
        WebServiceImporterUtil.createModelClassSetting(ws_response, this.mModelType, "WebServiceMethodOrderedParameterList", "NONE");
        WebServiceImporterUtil.createModelClassSetting(ws_response, this.mModelType, "WS_ResponseClass", "NONE");
        WebServiceImporterUtil.createModelClassSetting(ws_response, this.mModelType, "originalBeanClassName", "NONE");
        return ws_response;
    }

    private String getUniqueMethodName(TypeInfo type, MethodInfo meth) throws JavaModelException {
        String result = (String)this.mWSMethodnames.get(type + "_" + meth);
        if (result != null) {
            return result;
        }
        Vector<MethodInfo> methodsWithSameName = new Vector<MethodInfo>();
        MethodInfo[] methods = type.getMethods();
        String plainMethName = meth.getName();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().startsWith(plainMethName)) {
                methodsWithSameName.add(methods[i]);
            }
            ++i;
        }
        if (methodsWithSameName.size() > 1) {
            int i2 = 0;
            while (i2 < methodsWithSameName.size()) {
                MethodInfo element = (MethodInfo)methodsWithSameName.get(i2);
                String tmpMethName = plainMethName + i2;
                this.mWSMethodnames.put(type + "_" + meth, tmpMethName);
                if (element.toString().equals(meth.toString())) {
                    result = tmpMethName;
                }
                ++i2;
            }
        } else {
            result = plainMethName;
            this.mWSMethodnames.put(type + "_" + meth, result);
        }
        return result;
    }

    private void processMethodParameter(ModelClass ws_request, ParameterInfo paramInfo) throws MetamodelException, JavaModelException {
        TypeInfo paramtype = paramInfo.getType();
        String paramname = paramInfo.getName();
        this.createPropertyInModelClass(ws_request, paramtype, paramname);
    }

    private void createPropertyInModelClass(ModelClass ws_request, TypeInfo propertyType, String propertyName) throws MetamodelException, JavaModelException {
        this.traceEnterMethod("createPropertyInModelClass");
        if (WebServiceImporterUtil.isSimpleDDICTypeOrJavaNativeType(propertyType.getClassname(), this.mClassNameToIType) && !propertyType.isArray()) {
            ModelClassProperty lModelClassProperty = ws_request.createProperty(propertyName);
            lModelClassProperty.setReadonly(false);
            WebServiceImporterUtil.setTypeOfProperty(this.mDictionary, (Property)lModelClassProperty, propertyType.getClassname());
        } else if (WebServiceImporterUtil.isSimpleDDICTypeOrJavaNativeType(propertyType.getClassname(), this.mClassNameToIType) && propertyType.getArrayDimension() == 1) {
            ModelClass mc_simpleType = this.mSimpleTypeWrapperCreator.createSimpleTypeModelClass(propertyType);
            WebServiceImporterUtil.createRelationShip(this.mModel, ws_request, mc_simpleType, propertyName, true);
        } else if (!WebServiceImporterUtil.isSimpleDDICTypeOrJavaNativeType(propertyType.getClassname(), this.mClassNameToIType)) {
            ModelClass refBean = this.mJavaBeanCreator.createWS_JavaBeanWrapperModelClass(propertyType);
            WebServiceImporterUtil.createRelationShip(this.mModel, ws_request, refBean, propertyName, propertyType.isArray());
        }
        this.traceExitMethod("createPropertyInModelClass");
    }

    public IType getServiceImpl() {
        return this.mServiceImpl;
    }

    public void setServiceImpl(IType mServiceImpl) {
        this.mServiceImpl = mServiceImpl;
    }

    private void logTrace(Object msg) {
        System.out.println("TRACE " + this + ": " + msg);
    }

    private void logException(Throwable t) {
        System.out.println("EXCEPTION occurred");
        t.printStackTrace(System.out);
    }

    private void logDebug(Object msg) {
        System.out.println("DEBUG " + this + ": " + msg);
    }

    private void logInfo(Object msg) {
        System.out.println("INFO " + this + ": " + msg);
    }

    private void traceEnterMethod(String meth) {
        System.out.println("ENTER " + meth);
    }

    private void traceExitMethod(String meth) {
        System.out.println("EXIT " + meth);
    }

    public String getWS_RequestModelClassName(TypeInfo logicalPort, MethodInfo ws_method) throws JavaModelException {
        String unique_Methodname = this.getUniqueMethodName(logicalPort, ws_method);
        String origclassname = logicalPort.getClassname();
        return "Request_" + WebServiceImporterUtil.splitClassNameFromPackage(origclassname)[1] + "_" + unique_Methodname;
    }

    public String getWS_ResponseModelClassName(TypeInfo logicalPort, MethodInfo ws_method) throws JavaModelException {
        String unique_Methodname = this.getUniqueMethodName(logicalPort, ws_method);
        String origclassname = logicalPort.getClassname();
        return "Response_" + WebServiceImporterUtil.splitClassNameFromPackage(origclassname)[1] + "_" + unique_Methodname;
    }
}

