/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.webservice;

import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.Root;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.importers.webservice.FileTreeWalker;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.base.Method;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.metamodel.webdynpro.model.ModelSetting;
import com.sap.ide.metamodel.webdynpro.type.JavaNativeType;
import java.io.File;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public class WebServiceImporterUtil {
    public static final String DICTIONARY_PACKAGE = "com.sap.dictionary";
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$WebDynproRoot;
    static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot;

    public static DevelopmentObject getDDICBuiltInType(DtDictionaryRoot ddicRoot, String typeName) throws LoadException {
        String result = WebServiceImporterUtil.getDDICBuiltInType(typeName);
        return ddicRoot.getSimpleType(DICTIONARY_PACKAGE, result);
    }

    public static boolean isDDICBuiltInType(String typeName) {
        return WebServiceImporterUtil.getDDICBuiltInType(typeName) != null;
    }

    public static String getDDICBuiltInType(String typeName) {
        String result = null;
        if (typeName.equals("String") || typeName.equals("java.lang.String")) {
            result = "string";
        } else if (typeName.equals("Date") || typeName.equals("java.sql.Date")) {
            result = "date";
        } else if (typeName.equals("double")) {
            result = "double";
        } else if (typeName.equals("Double") || typeName.equals("java.lang.Double")) {
            result = "doubleObject";
        } else if (typeName.equals("boolean")) {
            result = "boolean";
        } else if (typeName.equals("Boolean") || typeName.equals("java.lang.Boolean")) {
            result = "booleanObject";
        } else if (typeName.equals("Time") || typeName.equals("java.sql.Time")) {
            result = "time";
        } else if (typeName.equals("Timestamp") || typeName.equals("java.sql.Timestamp")) {
            result = "timestamp";
        } else if (typeName.equals("short")) {
            result = "short";
        } else if (typeName.equals("Short") || typeName.equals("java.lang.Short")) {
            result = "shortObject";
        } else if (typeName.equals("long")) {
            result = "long";
        } else if (typeName.equals("Long") || typeName.equals("java.lang.Long")) {
            result = "longObject";
        } else if (typeName.equals("float")) {
            result = "float";
        } else if (typeName.equals("Float") || typeName.equals("java.lang.Float")) {
            result = "floatObject";
        } else if (typeName.equals("int")) {
            result = "integer";
        } else if (typeName.equals("Integer") || typeName.equals("java.lang.Integer")) {
            result = "integerObject";
        } else if (typeName.equals("BigDecimal") || typeName.equals("java.math.BigDecimal")) {
            result = "decimal";
        } else if (typeName.equals("byte[]")) {
            result = "binary";
        }
        return result;
    }

    public static void setTypeOfProperty(DtDictionaryRoot ddicroot, Property property, String typeName) throws CreateException, LoadException {
        DevelopmentObject lType = WebServiceImporterUtil.getDDICBuiltInType(ddicroot, typeName);
        if (lType == null) {
            if (typeName.indexOf(46) != -1) {
                String lName = typeName.substring(typeName.lastIndexOf(46) + 1);
                String lPackage = typeName.substring(0, typeName.lastIndexOf(46));
                JavaNativeType lNativeType = property.createNativeTypeAsJavaNativeType(lName);
                lNativeType.setJavaPackage(lPackage);
                property.setType((DevelopmentObject)lNativeType);
            } else {
                property.setType((DevelopmentObject)property.createNativeTypeAsJavaNativeType(typeName));
            }
        } else {
            property.setType(lType);
        }
    }

    public static void setReturnTypeOfMethod(DtDictionaryRoot ddicroot, Method method, String typeName) throws CreateException, LoadException {
        DevelopmentObject lType = WebServiceImporterUtil.getDDICBuiltInType(ddicroot, typeName);
        if (lType == null) {
            if (typeName.indexOf(46) != -1) {
                String lName = typeName.substring(typeName.lastIndexOf(46) + 1);
                String lPackage = typeName.substring(0, typeName.lastIndexOf(46));
                JavaNativeType lNativeType = method.createNativeTypeAsJavaNativeType(lName);
                lNativeType.setJavaPackage(lPackage);
                method.setReturnType((DevelopmentObject)lNativeType);
            } else {
                method.setReturnType((DevelopmentObject)method.createNativeTypeAsJavaNativeType(typeName));
            }
        }
    }

    public static String[] splitClassNameFromPackage(String classname) {
        String lPackageName = null;
        String lClassName = null;
        if (classname.lastIndexOf(46) >= 0) {
            lPackageName = classname.substring(0, classname.lastIndexOf(46));
            lClassName = classname.substring(classname.lastIndexOf(46) + 1);
        } else {
            lPackageName = "";
            lClassName = classname;
        }
        return new String[]{lPackageName, lClassName};
    }

    public static String getPackageName(String classname) {
        String lPackageName = null;
        lPackageName = classname.lastIndexOf(46) >= 0 ? classname.substring(0, classname.lastIndexOf(46)) : "";
        return lPackageName;
    }

    public static String getNameOfClassWithoutPackage(String classname) {
        String lClassName = null;
        lClassName = classname.lastIndexOf(46) >= 0 ? classname.substring(classname.lastIndexOf(46) + 1) : classname;
        return lClassName;
    }

    public static Metamodel createMetamodel(String modelname, String projectHomePath, String additionalContentPath) throws MetamodelException {
        String[] addArchives;
        String[] addDirs;
        Metamodel metamodel = null;
        File projectHome = new File(projectHomePath);
        File rootDirectory = new File(projectHome, "src/packages");
        String[] addPaths = WebServiceImporterUtil.divide(additionalContentPath, ';');
        int nArchives = 0;
        int i = 0;
        while (i < addPaths.length) {
            if (addPaths[i].endsWith(".jar") || addPaths[i].endsWith(".zip")) {
                ++nArchives;
            }
            ++i;
        }
        if (nArchives > 0) {
            addDirs = new String[addPaths.length - nArchives];
            addArchives = new String[nArchives];
            nArchives = 0;
            int nDirs = 0;
            int i2 = 0;
            while (i2 < addPaths.length) {
                if (addPaths[i2].endsWith(".jar") || addPaths[i2].endsWith(".zip")) {
                    addArchives[nArchives++] = addPaths[i2];
                } else {
                    addDirs[nDirs++] = addPaths[i2];
                }
                ++i2;
            }
        } else {
            addDirs = addPaths;
            addArchives = new String[]{};
        }
        metamodel = new Metamodel(modelname, rootDirectory.getAbsolutePath(), addDirs);
        int i3 = 0;
        while (i3 < addArchives.length) {
            metamodel.addArchive(new File(addArchives[i3]).getAbsolutePath());
            ++i3;
        }
        return metamodel;
    }

    public static WebDynproRoot getWebDynproRoot(Metamodel metamodel) throws MetamodelException {
        WebDynproRoot result = null;
        Root root = metamodel.getRoot("WebDynpro");
        if (root == null) {
            root = metamodel.createRoot(class$com$sap$ide$metamodel$webdynpro$WebDynproRoot == null ? (class$com$sap$ide$metamodel$webdynpro$WebDynproRoot = WebServiceImporterUtil.class$("com.sap.ide.metamodel.webdynpro.WebDynproRoot")) : class$com$sap$ide$metamodel$webdynpro$WebDynproRoot);
        }
        result = (WebDynproRoot)root;
        result.enableEventing();
        return result;
    }

    public static DtDictionaryRoot getDtDictionaryRoot(Metamodel metamodel) throws MetamodelException {
        DtDictionaryRoot ddicRoot = null;
        Root root = metamodel.getRoot("DtDictionary");
        if (root == null) {
            root = metamodel.createRoot(class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot == null ? (class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot = WebServiceImporterUtil.class$("com.sap.ide.metamodel.dictionary.DtDictionaryRoot")) : class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot);
        }
        ddicRoot = (DtDictionaryRoot)root;
        return ddicRoot;
    }

    public static String[] divide(String text, char separator) {
        if (text == null || text.length() == 0) {
            return new String[0];
        }
        int separators = 0;
        int i = 0;
        while (i < text.length()) {
            if (text.charAt(i) == separator) {
                ++separators;
            }
            ++i;
        }
        String[] array = new String[separators + 1];
        int offset = 0;
        int i2 = 0;
        while (i2 < separators) {
            int index = text.indexOf(separator, offset);
            array[i2] = text.substring(offset, index).trim();
            offset = index + 1;
            ++i2;
        }
        array[separators] = text.substring(offset).trim();
        return array;
    }

    public static ModelType getModelType(WebDynproRoot webdynproRoot, String packageName, String modelTypeName, SourcePathIdentifier sourcePathIdentifier) throws MetamodelException {
        ModelType result = webdynproRoot.getModelType(packageName, modelTypeName);
        return result;
    }

    public static ModelSetting createModelSetting(Model model, ModelType modelType, String name, String value) throws CreateException {
        ModelSetting lModelSetting = model.createSetting(name);
        lModelSetting.setValue(value);
        lModelSetting.setSettingDefinition(modelType.getModelSettingDefinition(name));
        return lModelSetting;
    }

    public static ModelClassSetting createModelClassSetting(ModelClass modelClass, ModelType modelType, String name, String value) throws CreateException {
        ModelClassSetting result = modelClass.createSetting(name);
        result.setValue(value);
        result.setSettingDefinition(modelType.getModelClassSettingDefinition(name));
        return result;
    }

    public static ModelSetting getOrCreateModelSetting(Model model, String name, String value) throws CreateException {
        ModelSetting result = model.getSetting(name);
        if (result == null) {
            result = model.createSetting(name);
        }
        result.setValue(value);
        return result;
    }

    public static IType findServiceImpl(Hashtable classNamesToITypes, String rpcService) throws RuntimeException {
        IType theServiceImpl = null;
        Collection allITypes = classNamesToITypes.values();
        Iterator iter = allITypes.iterator();
        while (iter.hasNext()) {
            IType element = (IType)iter.next();
            try {
                String[] intf = element.getSuperInterfaceNames();
                int i = 0;
                while (i < intf.length) {
                    String serviceintfpackage = WebServiceImporterUtil.splitClassNameFromPackage(rpcService)[0];
                    String serviceintfname = WebServiceImporterUtil.splitClassNameFromPackage(rpcService)[1];
                    if (intf[i].equals(serviceintfname) || intf[i].equals(rpcService)) {
                        theServiceImpl = element;
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Service Impl not found. " + ex);
            }
        }
        return theServiceImpl;
    }

    public static IType getIType(IFolder folder, String className) throws RuntimeException {
        try {
            String[] lService = WebServiceImporterUtil.splitClassNameFromPackage(className);
            String javaFile = lService[1] + ".java";
            IFolder iFolder = folder.getFolder(lService[0].replace('.', '/'));
            IFile iFile = iFolder.getFile(javaFile);
            ICompilationUnit unit = JavaCore.createCompilationUnitFrom((IFile)iFile);
            IType _iType = unit.getType(lService[1]);
            return _iType;
        }
        catch (Exception _e) {
            throw new RuntimeException("IType for " + className + " not generated. " + _e);
        }
    }

    public static Hashtable allJavaFiles(IProject project, String mTargetDir, String mTargetPackage, String sourceFolder) throws RuntimeException {
        try {
            FileTreeWalker walkerTree = new FileTreeWalker();
            Vector walker = (Vector)walkerTree.walkAllElements(new File(mTargetDir + mTargetPackage.replace('.', '/')));
            IFolder iFolder = null;
            Hashtable<String, IType> iTypes = new Hashtable<String, IType>(walker.size());
            File file = null;
            String path = null;
            String className = null;
            Iterator iter = ((AbstractList)walker).iterator();
            while (iter.hasNext()) {
                file = (File)iter.next();
                path = file.getAbsolutePath();
                path = path.substring(mTargetDir.length());
                className = path.replace('/', '.').replace('\\', '.');
                className = className.substring(0, className.length() - 5);
                iFolder = project.getFolder(sourceFolder);
                iTypes.put(className, WebServiceImporterUtil.getIType(iFolder, className));
            }
            return iTypes;
        }
        catch (Exception _e) {
            throw new RuntimeException("Table with ITypes not generated. Hashtable empty. " + _e);
        }
    }

    public static boolean isSimpleDDICTypeOrJavaNativeType(String classname, Hashtable classNames2IType) {
        System.out.println("isSimpleDDICTypeOrJavaNativeType(String classname)");
        System.out.println("classname=" + classname);
        IType itype = (IType)classNames2IType.get(classname);
        boolean isDDICType = WebServiceImporterUtil.isDDICBuiltInType(classname);
        return isDDICType || itype == null;
    }

    public static ModelRelation createRelationShip(Model model, ModelClass source, ModelClass target, String name, boolean isArray) throws CreateException {
        ModelRelation class_class = model.createModelRelation(name + "_" + source.getName() + "_" + target.getName());
        ModelRelationRole role_source = class_class.createModelRelationRole(source.getName());
        role_source.setModelClass(source);
        role_source.setCardinality(CardinalityEnum._0_1);
        role_source.setNavigable(false);
        ModelRelationRole role_target = class_class.createModelRelationRole(name);
        role_target.setModelClass(target);
        if (!isArray) {
            role_target.setCardinality(CardinalityEnum._0_1);
        } else {
            role_target.setCardinality(CardinalityEnum._0_N);
        }
        return class_class;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

