/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.webservice;

import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.importers.webservice.WebServiceImporterUtil;
import com.sap.ide.metamodel.importers.webservice.info.TypeInfo;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import java.util.Hashtable;
import org.eclipse.jdt.core.JavaModelException;

public class SimpleTypeWrapperCreator {
    private Hashtable mClassNameToIType = null;
    private Hashtable alreadyCreatedMc = new Hashtable();
    private ImportLog warnings;
    private Model mModel;
    private ModelType mModelType = null;
    private SourcePathIdentifier mSourcePathId = null;
    private DtDictionaryRoot mDictionary = null;
    private String mPackage = null;

    public SimpleTypeWrapperCreator(Model model, ModelType modelType, SourcePathIdentifier sourcePathId, String aPackage, DtDictionaryRoot dictionary, Hashtable classes) {
        this.mModel = model;
        this.mModelType = modelType;
        this.mPackage = aPackage;
        this.mSourcePathId = sourcePathId;
        this.mClassNameToIType = classes;
        this.mDictionary = dictionary;
    }

    public ModelClass createSimpleTypeModelClass(TypeInfo simpleTypeInfo) throws JavaModelException, MetamodelException {
        ModelClass mc_simpletype = (ModelClass)this.alreadyCreatedMc.get(simpleTypeInfo.getClassname());
        if (mc_simpletype != null) {
            return mc_simpletype;
        }
        String lpackage = this.getPackage();
        String lname_simpletype = this.getSimpleTypeName(simpleTypeInfo);
        mc_simpletype = this.mModel.createModelClass(lpackage, lname_simpletype, this.mSourcePathId);
        ModelClassProperty lModelClassProperty = mc_simpletype.createProperty("value");
        lModelClassProperty.setReadonly(false);
        WebServiceImporterUtil.setTypeOfProperty(this.mDictionary, (Property)lModelClassProperty, simpleTypeInfo.getClassname());
        WebServiceImporterUtil.createModelClassSetting(mc_simpletype, this.mModelType, "ModelClassType", "SimpleType");
        WebServiceImporterUtil.createModelClassSetting(mc_simpletype, this.mModelType, "originalBeanClassName", simpleTypeInfo.getClassname());
        this.alreadyCreatedMc.put(simpleTypeInfo.getClassname(), mc_simpletype);
        return mc_simpletype;
    }

    private void logTrace(Object msg) {
        System.out.println("TRACE " + this + ": " + msg);
    }

    private void logException(Throwable t) {
        System.out.println("EXCEPTION occurred");
        t.printStackTrace(System.out);
    }

    private void logDebug(Object msg) {
        System.out.println("DEBUG " + this + ": " + msg);
    }

    private void logInfo(Object msg) {
        System.out.println("INFO " + this + ": " + msg);
    }

    private void traceEnterMethod(String meth) {
        System.out.println("ENTER " + meth);
    }

    private void traceExitMethod(String meth) {
        System.out.println("EXIT " + meth);
    }

    public ImportLog getWarnings() {
        return this.warnings;
    }

    public void setWarnings(ImportLog warnings) {
        this.warnings = warnings;
    }

    public String getPackage() {
        return this.mPackage;
    }

    public void setPackage(String mPackage) {
        this.mPackage = mPackage;
    }

    private String getSimpleTypeName(TypeInfo typeInfo) {
        if (typeInfo.isPrimitiveType()) {
            return "Array_" + typeInfo.getClassname();
        }
        return "Array_" + WebServiceImporterUtil.getNameOfClassWithoutPackage(typeInfo.getClassname());
    }
}

