/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.webservice;

import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.importers.WebDynproMetamodelUtil;
import com.sap.ide.metamodel.importers.webservice.SimpleTypeWrapperCreator;
import com.sap.ide.metamodel.importers.webservice.WebServiceImporterUtil;
import com.sap.ide.metamodel.importers.webservice.info.MethodInfo;
import com.sap.ide.metamodel.importers.webservice.info.ParameterInfo;
import com.sap.ide.metamodel.importers.webservice.info.TypeInfo;
import com.sap.ide.metamodel.webdynpro.base.Property;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jdt.core.JavaModelException;

public class JavaBeanWrapperCreator {
    private Hashtable mClassNameToIType = null;
    private Hashtable alreadyCreatedMc = new Hashtable();
    private ImportLog warnings;
    private Model mModel;
    private ModelType mModelType = null;
    private SourcePathIdentifier mSourcePathId = null;
    private DtDictionaryRoot mDictionary = null;
    private SimpleTypeWrapperCreator mSimpleTypeWrapperCreator = null;

    public JavaBeanWrapperCreator(Model model, ModelType modelType, SourcePathIdentifier sourcePathId, DtDictionaryRoot dictionary, Hashtable classes) {
        this.mModel = model;
        this.mModelType = modelType;
        this.mSourcePathId = sourcePathId;
        this.mClassNameToIType = classes;
        this.mDictionary = dictionary;
    }

    public JavaBeanWrapperCreator(Model model, ModelType modelType, SourcePathIdentifier sourcePathId, DtDictionaryRoot dictionary, Hashtable classes, SimpleTypeWrapperCreator aSimpleTypeWrapperCreator) {
        this.mModel = model;
        this.mModelType = modelType;
        this.mSourcePathId = sourcePathId;
        this.mClassNameToIType = classes;
        this.mDictionary = dictionary;
        this.mSimpleTypeWrapperCreator = aSimpleTypeWrapperCreator;
    }

    public ModelClass createWS_JavaBeanWrapperModelClass(TypeInfo javaBeanInfo) throws JavaModelException, MetamodelException {
        ModelClass ws_JavaBean = (ModelClass)this.alreadyCreatedMc.get(javaBeanInfo.getClassname());
        if (ws_JavaBean != null) {
            return ws_JavaBean;
        }
        String lpackage = WebServiceImporterUtil.splitClassNameFromPackage(javaBeanInfo.getClassname())[0];
        String lname_JavaBean = JavaBeanWrapperCreator.getJavaBeanWrapperClassName(javaBeanInfo);
        ws_JavaBean = WebDynproMetamodelUtil.getOrCreateModelClass(this.mModel, this.mModel.getPackage(), lname_JavaBean, this.mSourcePathId);
        this.alreadyCreatedMc.put(javaBeanInfo.getClassname(), ws_JavaBean);
        this.addAllPropertiesFromJavaBeanToModelClass(ws_JavaBean, javaBeanInfo);
        WebServiceImporterUtil.createModelClassSetting(ws_JavaBean, this.mModelType, "ModelClassType", "JavaBean");
        WebServiceImporterUtil.createModelClassSetting(ws_JavaBean, this.mModelType, "originalBeanClassName", javaBeanInfo.getClassname());
        return ws_JavaBean;
    }

    protected void addAllPropertiesFromJavaBeanToModelClass(ModelClass ws_JavaBean, TypeInfo javaBeanClass) throws JavaModelException, MetamodelException, CreateException, LoadException {
        MethodInfo[] methods = javaBeanClass.getMethods();
        Hashtable<String, MethodInfo> get_isMethods = new Hashtable<String, MethodInfo>();
        Hashtable<String, MethodInfo> seterMethods = new Hashtable<String, MethodInfo>();
        int i = 0;
        while (i < methods.length) {
            MethodInfo method = methods[i];
            if (method.isPublic()) {
                String methodName = method.getName();
                if ((methodName.startsWith("get") || methodName.startsWith("is")) && method.getParameters().length == 0) {
                    get_isMethods.put(methodName, method);
                } else if (methodName.startsWith("set")) {
                    seterMethods.put(methodName, method);
                }
            }
            ++i;
        }
        Enumeration keys = get_isMethods.keys();
        while (keys.hasMoreElements()) {
            String classname = (String)keys.nextElement();
            MethodInfo method = (MethodInfo)get_isMethods.get(classname);
            TypeInfo returnType = method.getReturntype();
            boolean hasMethodSeter = this.hasSetter(method, seterMethods);
            boolean isArray = returnType.isArray();
            boolean isDDICType = WebServiceImporterUtil.isSimpleDDICTypeOrJavaNativeType(returnType.getClassname(), this.mClassNameToIType);
            String propertyname = this.fieldName(method.getName());
            if (isDDICType && !isArray) {
                ModelClassProperty lModelClassProperty = ws_JavaBean.createProperty(propertyname);
                lModelClassProperty.setReadonly(!hasMethodSeter);
                WebServiceImporterUtil.setTypeOfProperty(this.mDictionary, (Property)lModelClassProperty, returnType.getClassname());
                continue;
            }
            if (!isDDICType) {
                ModelClass refBean = this.createWS_JavaBeanWrapperModelClass(returnType);
                WebServiceImporterUtil.createRelationShip(this.mModel, ws_JavaBean, refBean, propertyname, isArray);
                continue;
            }
            if (!isDDICType || !isArray) continue;
            ModelClass mc_simpleType = this.mSimpleTypeWrapperCreator.createSimpleTypeModelClass(returnType);
            WebServiceImporterUtil.createRelationShip(this.mModel, ws_JavaBean, mc_simpleType, propertyname, true);
        }
    }

    private boolean hasSetter(MethodInfo getmethod, Hashtable seterMethods) {
        String getmethodName = getmethod.getName();
        String getreturnType = getmethod.getReturntype().getClassname();
        String field = null;
        field = getmethodName.startsWith("get") ? getmethodName.substring(3) : getmethodName.substring(2);
        Collection seters = seterMethods.values();
        Iterator iter = seters.iterator();
        while (iter.hasNext()) {
            MethodInfo methodInfo = (MethodInfo)iter.next();
            ParameterInfo[] parameters = methodInfo.getParameters();
            String paramtype = parameters[0].getType().getClassname();
            if (!methodInfo.getName().equals("set" + field) || parameters.length != 1 || !paramtype.equals(getreturnType)) continue;
            return true;
        }
        return false;
    }

    private String fieldName(String methodName) {
        String field = null;
        field = methodName.startsWith("get") ? methodName.substring(3) : methodName.substring(2);
        return Character.toLowerCase(field.charAt(0)) + field.substring(1, field.length());
    }

    private void logTrace(Object msg) {
        System.out.println("TRACE " + this + ": " + msg);
    }

    private void logException(Throwable t) {
        System.out.println("EXCEPTION occurred");
        t.printStackTrace(System.out);
    }

    private void logDebug(Object msg) {
        System.out.println("DEBUG " + this + ": " + msg);
    }

    private void logInfo(Object msg) {
        System.out.println("INFO " + this + ": " + msg);
    }

    private void traceEnterMethod(String meth) {
        System.out.println("ENTER " + meth);
    }

    private void traceExitMethod(String meth) {
        System.out.println("EXIT " + meth);
    }

    public ImportLog getWarnings() {
        return this.warnings;
    }

    public void setWarnings(ImportLog warnings) {
        this.warnings = warnings;
    }

    public static String getJavaBeanWrapperClassName(TypeInfo logicalPort) {
        return "ComplexType_" + WebServiceImporterUtil.splitClassNameFromPackage(logicalPort.getClassname())[1];
    }
}

