/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.webservice;

import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortFactory;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPortType;
import com.sap.engine.services.webservices.jaxrpc.wsdl2java.lpapi.LogicalPorts;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.wsproxy.PRXRoot;
import com.sap.ide.metamodel.wsproxy.ProxyDefinition;
import com.sap.ide.metamodel.wsproxy.plugin.PRXRootManager;
import com.sap.ide.webservices.tsmodel.prx.provider.WsProxyDeletion;
import com.sap.ide.ws.proxygenerator.FileDescriptor;
import com.sap.ide.ws.proxygenerator.ProxyGeneratorWrapper;
import com.sap.ide.wsproxy.core.WsProxyCreation;
import java.util.Properties;
import org.eclipse.core.resources.IProject;

public class GenerateWS {
    private String mWSDL = "";
    private String mTargetPackage = "";
    private String mTargetDir = "";
    private String mSourceFolder = null;
    private boolean mStyle = false;
    private boolean mJaxrpcServiceInterfaces = true;
    private Properties mUriMapping;
    private IProject project = null;
    private String serviceInterfaceName = null;
    private String serviceInterfaceImpl = null;
    private String[] lports = null;
    private String[] lportNames = null;
    private ImportLog mLog = new ImportLog();
    private String mProxyName;
    private SourcePathIdentifier mSourcePathIdentifier;
    private ProxyDefinition mProxyDefinition;

    public GenerateWS() {
    }

    public GenerateWS(String proxyName, String wsdl, String targetPackage, String targetDir, String sourceFolder, boolean style, boolean jaxrpcServiceInterfaces, IProject project, SourcePathIdentifier sourcePathIdentifier, Properties uriMapping) {
        this.mProxyName = proxyName;
        this.mWSDL = wsdl;
        this.mTargetPackage = targetPackage;
        this.mTargetDir = targetDir;
        this.mSourceFolder = sourceFolder;
        this.mStyle = style;
        this.mJaxrpcServiceInterfaces = jaxrpcServiceInterfaces;
        this.project = project;
        this.mSourcePathIdentifier = sourcePathIdentifier;
        this.mUriMapping = uriMapping;
    }

    public void doGenerate() throws Exception {
        Metamodel metamodel = MetamodelManager.getMetamodel((String)this.project.getName());
        PRXRoot modelRoot = PRXRootManager.getPRXRoot((Metamodel)metamodel);
        ProxyGeneratorWrapper proxy = new ProxyGeneratorWrapper();
        FileDescriptor[] fd = proxy.generateStandAlone(this.mWSDL, this.mTargetPackage, this.mTargetDir, this.mSourceFolder, this.mStyle, this.mJaxrpcServiceInterfaces, this.mUriMapping);
        if (fd == null) {
            throw new RuntimeException("WebService proxy not generated. File Descriptor empty. If this error persist contact your local support.");
        }
        int i = 0;
        while (i < fd.length) {
            if (fd[i].name.startsWith("lports")) {
                LogicalPortFactory lpf = new LogicalPortFactory();
                LogicalPorts lps = lpf.loadLogicalPorts(this.mTargetDir + "/" + fd[i].path + "/" + fd[i].name);
                this.serviceInterfaceName = lps.getInterfaceName();
                LogicalPortType[] lpt = lps.getLogicalPort();
                this.lports = new String[lpt.length];
                this.lportNames = new String[lpt.length];
                int j = 0;
                while (j < lpt.length) {
                    this.lportNames[j] = lpt[j].getName();
                    this.lports[j] = lpt[j].getInterfaceName();
                    ++j;
                }
            }
            ++i;
        }
        this.mProxyDefinition = modelRoot.createProxyDefinition(this.mTargetPackage, this.mProxyName, this.mSourcePathIdentifier);
        this.mProxyDefinition.setDeployable(false);
        WsProxyCreation.setFileReferences((ProxyDefinition)this.mProxyDefinition, (FileDescriptor[])fd);
        this.mProxyDefinition.commitChanges();
    }

    public String getServiceInterfaceName() {
        return this.serviceInterfaceName;
    }

    public String[] getLPorts() {
        return this.lports;
    }

    public String[] getLPortNames() {
        return this.lportNames;
    }

    public ImportLog getImportLog() {
        return this.mLog;
    }

    public void deleteWS() {
        if (this.mProxyDefinition == null) {
            return;
        }
        WsProxyDeletion.deletePrxFiles((ProxyDefinition)this.mProxyDefinition);
    }
}

