/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.rfcmodel.upgrade;

import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.importers.rfcmodel.reimport.DynamicRFCModelReimporter;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelClassPropertySetting;
import com.sap.ide.metamodel.webdynpro.model.ModelClassSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRoleSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelSetting;
import com.sap.ide.webdynpro.service.core.projectproperties.WDProjectPropertiesUtil;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class DynamicRFCModelConverter {
    private DynamicRFCModelReimporter mDynamicRFCModelReimporter = null;
    private Model mModel = null;
    private WebDynproRoot mWebDynproRoot = null;
    private DtDictionaryRoot mDictionaryRoot = null;
    private String mLogicalDictionaryName = null;
    private String mModelDefaultLogicalSystem = null;
    private String mMetadataDefaultLogicalSystem = null;
    private static final String MODELTYPE_PACKAGE = "com.sap.ide.webdynpro.modeltypes";
    private static final String MODELTYPE_NAME = "DynamicRFCAdapter";
    private ModelType mModelType = null;
    private ImportLog mLog = new ImportLog();
    public static final String IS_EXECUTABLE = "isExecutable";
    public static final String DEFAULT_SCOPE = "defaultScope";
    public static final String IS_LCOAL = "isLocal";
    public static final String RFC_PART_TYPE_OUTPUT = "output";
    public static final String RFC_PART_TYPE_STRUCTURE = "structure";
    public static final String REMOTE_FUNCTION_MODULES = "Remote Function Modules";
    public static final String RESULT_STRUCTURES = "Result Structures";
    public static final String DICTIONARY_STRUCTURES = "Dictionary Structures";
    private static final String RFC_PART_TYPE = "rfcPartType";
    private static final String RFC_PART_TYPE_INPUT = "input";
    private static final String ABAP_NAME = "abapName";
    private static final String MODEL_INSTANCE_DEFAULT_LOGICAL_SYSTEM = "modelInstance_defaultLogicalSystem";
    private static final String RFC_METADATA_DEFAULT_LOGICAL_SYSTEM = "rfcMetadata_defaultLogicalSystem";

    public DynamicRFCModelConverter(WebDynproRoot webDynproRoot, DtDictionaryRoot dictionaryRoot, Model theModel) {
        this.mModel = theModel;
        this.mWebDynproRoot = webDynproRoot;
        this.mDictionaryRoot = dictionaryRoot;
        this.UpdateModelTypeAndSettings(this.mModel);
        this.mDynamicRFCModelReimporter = new DynamicRFCModelReimporter(webDynproRoot, dictionaryRoot, theModel);
    }

    public Model convertToARFCModel() {
        String proxyClassNamePath = this.mModel.getSetting("proxyClassName").getValue();
        Model newModel = this.mDynamicRFCModelReimporter.reImport();
        String projectName = this.mWebDynproRoot.getMetamodel().getName();
        MetamodelManager metaModelManager = MetamodelManager.getMetamodelManager((String)projectName);
        metaModelManager.saveAllMetaData();
        this.deleteProxyFiles(proxyClassNamePath);
        this.addJCOReference();
        return newModel;
    }

    public void setDictionaryRelatedInfo(String logicalDictionaryName, String modelDefaultLogicalSystem, String metadataDefaultLogicalSystem) {
        this.mDynamicRFCModelReimporter.setDictionaryRelatedInfo(logicalDictionaryName, modelDefaultLogicalSystem, metadataDefaultLogicalSystem);
    }

    public ImportLog getImportLog(String[] rfcNames, IProgressMonitor monitor) {
        return this.mDynamicRFCModelReimporter.getImportLog(rfcNames, monitor);
    }

    private void UpdateModelTypeAndSettings(Model model) {
        try {
            this.mModelType = this.mWebDynproRoot.getModelType(MODELTYPE_PACKAGE, MODELTYPE_NAME);
            this.mModel.setModelType(this.mModelType);
            this.updateSettings(this.mModel);
        }
        catch (Exception e) {
            this.mLog.addException(e);
        }
    }

    private void updateSettings(Model model) {
        int i = 0;
        while (i < model.getSettingCount()) {
            try {
                model.getSettings()[i].delete();
            }
            catch (DeleteException e) {
                this.mLog.addException(e);
            }
            ++i;
        }
        try {
            ModelSetting lModelSetting = null;
            if (!this.mModel.hasSetting(MODEL_INSTANCE_DEFAULT_LOGICAL_SYSTEM)) {
                lModelSetting = this.mModel.createSetting(MODEL_INSTANCE_DEFAULT_LOGICAL_SYSTEM);
                lModelSetting.setValue("DLS");
                lModelSetting.setSettingDefinition(this.mModelType.getModelSettingDefinition(MODEL_INSTANCE_DEFAULT_LOGICAL_SYSTEM));
            }
        }
        catch (CreateException e) {
            this.mLog.addException(e);
        }
        int i2 = 0;
        while (i2 < model.getModelClassCount()) {
            int j = 0;
            while (j < model.getModelClasses()[i2].getSettingCount()) {
                try {
                    model.getModelClasses()[i2].getSettings()[j].delete();
                }
                catch (DeleteException e) {
                    this.mLog.addException(e);
                }
                ++j;
            }
            this.createModelClassSetting(model.getModelClasses()[i2], "", "", "", "", "", "");
            ++i2;
        }
        int i3 = 0;
        while (i3 < model.getModelRelationCount()) {
            ModelRelation relation = model.getModelRelations()[i3];
            ModelRelationRole role1 = relation.getModelRelationRoles()[0];
            ModelRelationRole role2 = relation.getModelRelationRoles()[1];
            this.createModelRelationRoleSetting(role1, "", "");
            this.createModelRelationRoleSetting(role2, "", "");
            ++i3;
        }
    }

    private void createModelClassSetting(ModelClass modelClass, String rfcPartType, String abapName, String isExecutable, String scope, String modelInstanceID, String isLocal) {
        if (null == modelClass) {
            return;
        }
        ModelClassSetting modelClassSetting = null;
        try {
            modelClassSetting = modelClass.getSetting(RFC_PART_TYPE);
            if (null == modelClassSetting) {
                modelClassSetting = modelClass.createSetting(RFC_PART_TYPE);
            }
            modelClassSetting.setValue(rfcPartType);
            modelClassSetting.setSettingDefinition(this.mModelType.getModelClassSettingDefinition(RFC_PART_TYPE));
            modelClassSetting = modelClass.getSetting(ABAP_NAME);
            if (null == modelClassSetting) {
                modelClassSetting = modelClass.createSetting(ABAP_NAME);
            }
            modelClassSetting.setValue(abapName);
            modelClassSetting.setSettingDefinition(this.mModelType.getModelClassSettingDefinition(ABAP_NAME));
            modelClassSetting = modelClass.getSetting(IS_EXECUTABLE);
            if (null == modelClassSetting) {
                modelClassSetting = modelClass.createSetting(IS_EXECUTABLE);
            }
            modelClassSetting.setValue(isExecutable);
            modelClassSetting.setSettingDefinition(this.mModelType.getModelClassSettingDefinition(IS_EXECUTABLE));
            int i = 0;
            while (i < modelClass.getPropertyCount()) {
                ModelClassProperty property = (ModelClassProperty)modelClass.getProperties()[i];
                int j = 0;
                while (j < property.getSettingCount()) {
                    try {
                        property.getSettings()[j].delete();
                    }
                    catch (DeleteException e) {
                        this.mLog.addException(e);
                    }
                    ++j;
                }
                this.createModelClassPropertySetting(property, "", "");
                ++i;
            }
        }
        catch (CreateException e) {
            this.mLog.addException(e);
            return;
        }
    }

    private void createModelClassPropertySetting(ModelClassProperty modelClassProperty, String abapName, String isLocal) {
        if (null == modelClassProperty) {
            return;
        }
        try {
            ModelClassPropertySetting modelClassPropertySetting = null;
            modelClassPropertySetting = modelClassProperty.getSetting(ABAP_NAME);
            if (null == modelClassPropertySetting) {
                modelClassPropertySetting = modelClassProperty.createSetting(ABAP_NAME);
            }
            modelClassPropertySetting.setValue(abapName);
            modelClassPropertySetting.setSettingDefinition(this.mModelType.getModelClassPropertySettingDefinition(ABAP_NAME));
        }
        catch (CreateException e) {
            this.mLog.addException(e);
            return;
        }
    }

    private void createModelRelationRoleSetting(ModelRelationRole modelRelationRole, String abapName, String isLocal) {
        if (null == modelRelationRole) {
            return;
        }
        try {
            ModelRelationRoleSetting modelRelationRoleSetting = null;
            modelRelationRoleSetting = modelRelationRole.getSetting(ABAP_NAME);
            if (null == modelRelationRoleSetting) {
                modelRelationRoleSetting = modelRelationRole.createSetting(ABAP_NAME);
            }
            modelRelationRoleSetting.setValue(abapName);
            modelRelationRoleSetting.setSettingDefinition(this.mModelType.getModelRelationRoleSettingDefinition(ABAP_NAME));
        }
        catch (CreateException e) {
            this.mLog.addException(e);
            return;
        }
    }

    public String getModelName() {
        return this.mModel.getName();
    }

    public String getModelPackageName() {
        return this.mModel.getPackage();
    }

    public String[] getRfcNamesImported() {
        return this.mDynamicRFCModelReimporter.getRfcNamesImported();
    }

    public String[] getRfcNamesImportedFromModel() {
        return this.mDynamicRFCModelReimporter.getRfcNamesImportedFromModel();
    }

    public void deleteProxyFiles(String proxyClassNamePath) {
        try {
            String packageName = proxyClassNamePath.substring(0, proxyClassNamePath.lastIndexOf(46));
            String packagePath = packageName.replace('.', '/');
            String projectName = this.mWebDynproRoot.getMetamodel().getName();
            IProject theProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IFolder theFolder = theProject.getFolder("/src/packages/" + packagePath);
            if (theFolder.exists()) {
                theFolder.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception e) {
            this.mLog.addException(e);
        }
    }

    private void addJCOReference() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mWebDynproRoot.getMetamodel().getName());
        if (project != null) {
            try {
                WDProjectPropertiesUtil.addJcoReference((IProject)project, (String)this.mMetadataDefaultLogicalSystem);
                WDProjectPropertiesUtil.addJcoReference((IProject)project, (String)this.mModelDefaultLogicalSystem);
            }
            catch (CreateException e) {
                ServiceModelEditorPlugin.internalError(this.getClass(), "addJCOReference()", "Failed to create entries in project properties file for logical system names: " + this.mMetadataDefaultLogicalSystem + ", " + this.mModelDefaultLogicalSystem, e, false);
            }
        } else {
            ServiceModelEditorPlugin.internalError(this.getClass(), "addJCOReference()", "Failed to retrieve project reference for project " + this.mWebDynproRoot.getMetamodel().getName(), null, false);
        }
    }

    public ImportLog getImportLog() {
        return this.mLog;
    }
}

