/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.rfcmodel.reimport;

import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.i18n.TextPool;
import com.sap.ide.metamodel.general.i18n.TranslatableText;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.importers.rfcmodel.reimport.DTRIntegrator;
import com.sap.ide.metamodel.webdynpro.repository.RepositoryUtilities;

public class TextPoolReimportHandler {
    public static void reimport(MainDevelopmentObject oldMdo, MainDevelopmentObject newMdo, boolean shouldApply, ImportLog importLog) {
        if (null == oldMdo || null == newMdo) {
            return;
        }
        MainDevelopmentObject[] mDOs = new MainDevelopmentObject[]{oldMdo};
        if (shouldApply && !RepositoryUtilities.checkWriteability((MainDevelopmentObject[])mDOs, (boolean)false)) {
            return;
        }
        TextPool pool = oldMdo.getTextPool();
        TextPool newPool = newMdo.getTextPool();
        if (null == pool || null == newPool) {
            return;
        }
        TranslatableText[] texts = pool.getTexts();
        int i = 0;
        while (i < texts.length) {
            if (!texts[i].getDoNotTranslate()) {
                importLog.addInfoMessage("Translations for " + oldMdo.getName());
                if (shouldApply) {
                    TranslatableText newTranslatableText = pool.getText(texts[i].getKey());
                    texts[i].setDoNotTranslate(true);
                    texts[i].setMaxLength(newTranslatableText.getMaxLength());
                    texts[i].setResourceType(newTranslatableText.getResourceType());
                    texts[i].setText(newTranslatableText.getText());
                    int j = 0;
                    while (j < newTranslatableText.getLanguages().length) {
                        String lang = newTranslatableText.getLanguages()[j];
                        texts[i].setText(lang, newTranslatableText.getText());
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public static void reimport(DevelopmentObject oldDO, DevelopmentObject newDO, boolean shouldApply, ImportLog importLog) {
        if (null == oldDO || null == newDO) {
            return;
        }
        if (shouldApply && (oldDO instanceof DtSimpleType ? !DTRIntegrator.checkWritabilityForSimpleTypes((DtSimpleType)oldDO) : !DTRIntegrator.checkWritabilityForStructures((DtStructure)oldDO))) {
            return;
        }
        TextPool pool = oldDO.getMDO().getTextPool();
        TextPool newPool = newDO.getMDO().getTextPool();
        if (null == pool || null == newPool) {
            return;
        }
        TranslatableText[] texts = pool.getTexts();
        int i = 0;
        while (i < texts.length) {
            if (!texts[i].getDoNotTranslate()) {
                importLog.addInfoMessage("Translations for " + oldDO.getName());
                if (shouldApply) {
                    TranslatableText newTranslatableText = pool.getText(texts[i].getKey());
                    texts[i].setDoNotTranslate(true);
                    texts[i].setMaxLength(newTranslatableText.getMaxLength());
                    texts[i].setResourceType(newTranslatableText.getResourceType());
                    texts[i].setText(newTranslatableText.getText());
                    int j = 0;
                    while (j < newTranslatableText.getLanguages().length) {
                        String lang = newTranslatableText.getLanguages()[j];
                        texts[i].setText(lang, newTranslatableText.getText());
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public static boolean checkTexts(MainDevelopmentObject oldMdo) {
        if (oldMdo == null) {
            return true;
        }
        TextPool pool = oldMdo.getTextPool();
        if (pool == null) {
            return true;
        }
        TranslatableText[] texts = pool.getTexts();
        int i = 0;
        while (i < texts.length) {
            if (!texts[i].getDoNotTranslate()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

