/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.rfcmodel.reimport;

import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDataType;
import com.sap.ide.metamodel.dictionary.datatype.DtField;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.compare.CompareResult;
import com.sap.ide.metamodel.general.compare.MetamodelDelta;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.general.i18n.TranslatableText;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.importers.rfcmodel.reimport.TextPoolReimportHandler;
import java.util.ArrayList;

public class StructureReimportHandler {
    private DtDictionaryRoot mFirstDictionaryRoot;
    private DtDictionaryRoot mSecondDictionaryRoot;
    private String mDictionaryPackage;
    private String mLogicalDicationaryName;
    private ImportLog mImportLog;
    private boolean mShouldApply;
    private ArrayList mDeltas;
    private boolean mGetDeltas;

    public StructureReimportHandler(DtDictionaryRoot firstDictionaryRoot, DtDictionaryRoot secondDictionaryRoot, String dictionaryPackage, String logicalDicationaryName, ImportLog importLog) {
        this.mFirstDictionaryRoot = firstDictionaryRoot;
        this.mSecondDictionaryRoot = secondDictionaryRoot;
        this.mDictionaryPackage = dictionaryPackage;
        this.mLogicalDicationaryName = logicalDicationaryName;
        this.mImportLog = importLog;
    }

    public boolean reImport(boolean shouldApply) {
        this.mShouldApply = shouldApply;
        if (null == this.mFirstDictionaryRoot || null == this.mSecondDictionaryRoot) {
            return false;
        }
        this.HandleTypesFrom1in2();
        this.HandleTypesFrom2in1();
        this.handleTextPoolReimport(this.mShouldApply);
        return true;
    }

    private void HandleTypesFrom2in1() {
        int numberOfTypes = 0;
        try {
            numberOfTypes = this.mSecondDictionaryRoot.getStructures(this.mDictionaryPackage).length;
            int i = 0;
            while (i < numberOfTypes) {
                DtGeneralStructure newStructure = this.mSecondDictionaryRoot.getStructures(this.mDictionaryPackage)[i];
                DtGeneralStructure oldStructure = this.mFirstDictionaryRoot.getStructure(this.mDictionaryPackage, newStructure.getName());
                if (null == oldStructure) {
                    this.createStructure((DtStructure)newStructure);
                } else {
                    this.compareAndUpdateStructure((DtStructure)oldStructure, (DtStructure)newStructure);
                }
                ++i;
            }
        }
        catch (LoadException e) {
            this.mImportLog.addErrorMessage(e.getMessage());
            return;
        }
    }

    private void HandleTypesFrom1in2() {
        int numberOfStructures = 0;
        DtGeneralStructure[] firstStructures = null;
        try {
            numberOfStructures = this.mFirstDictionaryRoot.getStructures(this.mDictionaryPackage).length;
            firstStructures = new DtGeneralStructure[numberOfStructures];
            System.arraycopy(this.mFirstDictionaryRoot.getStructures(this.mDictionaryPackage), 0, firstStructures, 0, numberOfStructures);
        }
        catch (LoadException e) {
            this.mImportLog.addErrorMessage(e.getMessage());
            return;
        }
        int i = 0;
        while (i < numberOfStructures) {
            try {
                DtGeneralStructure oldStructure = firstStructures[i];
                DtGeneralStructure newStructure = this.mSecondDictionaryRoot.getStructure(this.mDictionaryPackage, oldStructure.getName());
                if (null == newStructure) {
                    if (this.mGetDeltas) {
                        this.mDeltas.add(oldStructure);
                    }
                    this.deleteStructure((DtStructure)oldStructure);
                }
            }
            catch (LoadException e) {
                this.mImportLog.addErrorMessage(e.getMessage());
            }
            ++i;
        }
    }

    private DtStructure createStructure(DtStructure referenceStructure) {
        try {
            this.mImportLog.addInfoMessage("[ New ] : [ Structure ] : [ " + referenceStructure.getName() + " ]");
            if (!this.mShouldApply) {
                return null;
            }
            DtGeneralStructure newStructure = this.mFirstDictionaryRoot.createStructure(this.mDictionaryPackage, referenceStructure.getName());
            try {
                newStructure.setLogicalDictionary(this.mFirstDictionaryRoot.getLogicalDictionary(this.mDictionaryPackage, this.mLogicalDicationaryName));
            }
            catch (LoadException e) {
                this.mImportLog.addErrorMessage(e.getMessage());
            }
            newStructure.setDescription(referenceStructure.getDescription());
            this.setDoNotTranslate(newStructure.getDescriptionAsTranslatableText());
            newStructure.setToDeploy(referenceStructure.getToDeploy());
            newStructure.setBackendName(referenceStructure.getBackendName());
            int i = 0;
            while (i < referenceStructure.getStructureElementCount()) {
                DtField referenceField = (DtField)referenceStructure.getStructureElement(i);
                DtField newField = newStructure.createStructureElementAsDtField(referenceStructure.getStructureElement(i).getName());
                newField.setBackendName(referenceField.getBackendName());
                newField.setPosition(referenceField.getPosition());
                newField.setDescription(referenceField.getDescription());
                this.setDoNotTranslate(newField.getDescriptionAsTranslatableText());
                try {
                    DtSimpleType referenceType = (DtSimpleType)referenceField.getReferencedType();
                    newField.setReferencedType((DtDataType)this.mFirstDictionaryRoot.getSimpleType(referenceType.getPackage(), referenceType.getName()));
                }
                catch (LoadException e) {
                    this.mImportLog.addErrorMessage(e.getMessage());
                }
                newField.setBuiltInType(referenceField.getBuiltInType());
                newField.setFieldType(referenceField.getFieldType());
                newField.setTotalDigits(referenceField.getTotalDigits());
                newField.setFractionDigits(referenceField.getFractionDigits());
                newField.setDbDefault(referenceField.getDbDefault());
                newField.setGroup(referenceField.getGroup());
                newField.setJdbcTypeName(referenceField.getJdbcTypeName());
                newField.setLength(referenceField.getLength());
                newField.setNotNull(referenceField.getNotNull());
                newField.setRefField(referenceField.getRefField());
                ++i;
            }
            return newStructure;
        }
        catch (CreateException e) {
            this.mImportLog.addErrorMessage(e.getMessage());
            return null;
        }
    }

    private void setDoNotTranslate(TranslatableText translateableText) {
        if (translateableText != null) {
            translateableText.setDoNotTranslate(true);
        }
    }

    private void deleteStructure(DtStructure structureToBeDeleted) {
        try {
            this.mImportLog.addInfoMessage("[ Delete ] : [ Structure ] : [ " + structureToBeDeleted.getName() + " ]");
            if (this.mShouldApply) {
                structureToBeDeleted.delete();
            }
        }
        catch (DeleteException e) {
            this.mImportLog.addErrorMessage(e.getMessage());
        }
    }

    private DtStructure compareAndUpdateStructure(DtStructure structureToBeUpdated, DtStructure referenceStructure) {
        CompareResult result = structureToBeUpdated.compareTo((DevelopmentObject)referenceStructure);
        MetamodelDelta[] deltas = result.getDeltas();
        if (deltas.length > 0) {
            if (this.mGetDeltas) {
                this.mDeltas.add(structureToBeUpdated);
            }
            this.mImportLog.addInfoMessage("[ Modified ] : [ Structure ] : [ " + structureToBeUpdated.getName() + " ]");
        }
        int i = 0;
        while (i < deltas.length) {
            try {
                if (this.mGetDeltas) {
                    this.mDeltas.add(deltas[i]);
                }
                if (this.mShouldApply) {
                    deltas[i].apply();
                }
            }
            catch (MetamodelException e) {
                this.mImportLog.addErrorMessage(e.getMessage());
            }
            ++i;
        }
        return structureToBeUpdated;
    }

    public ArrayList getDeltas() {
        this.mGetDeltas = true;
        this.mDeltas = new ArrayList();
        this.reImport(false);
        this.mGetDeltas = false;
        return this.mDeltas;
    }

    public void handleTextPoolReimport(boolean shouldApply) {
        try {
            int numberOfTypes = this.mFirstDictionaryRoot.getStructures(this.mDictionaryPackage).length;
            int i = 0;
            while (i < numberOfTypes) {
                DtGeneralStructure newStructure;
                DtGeneralStructure structure = this.mFirstDictionaryRoot.getStructures(this.mDictionaryPackage)[i];
                if (TextPoolReimportHandler.checkTexts((MainDevelopmentObject)structure) && null != (newStructure = this.mSecondDictionaryRoot.getStructure(this.mDictionaryPackage, structure.getName()))) {
                    TextPoolReimportHandler.reimport((DevelopmentObject)structure, (DevelopmentObject)newStructure, shouldApply, this.mImportLog);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.mImportLog.addErrorMessage(e.getMessage());
        }
    }
}

