/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.rfcmodel.reimport;

import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtDbProperty;
import com.sap.ide.metamodel.dictionary.datatype.DtEnumerationValue;
import com.sap.ide.metamodel.dictionary.datatype.DtExternalRepresentation;
import com.sap.ide.metamodel.dictionary.datatype.DtSchemaType;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtTechnicalInfo;
import com.sap.ide.metamodel.dictionary.datatype.DtTextObject;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.compare.CompareResult;
import com.sap.ide.metamodel.general.compare.MetamodelDelta;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.DeleteException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.general.i18n.TranslatableText;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.importers.rfcmodel.reimport.TextPoolReimportHandler;
import java.util.ArrayList;

public class SimpleTypeReimportHandler {
    private DtDictionaryRoot mFirstDictionaryRoot;
    private DtDictionaryRoot mSecondDictionaryRoot;
    private String mDictionaryPackage;
    private String mLogicalDicationaryName;
    private ImportLog mImportLog;
    private boolean mShouldApply;
    private boolean mGetDeltas;
    private ArrayList mDeltas;

    public SimpleTypeReimportHandler(DtDictionaryRoot firstDictionaryRoot, DtDictionaryRoot secondDictionaryRoot, String dictionaryPackage, String logicalDicationaryName, ImportLog importLog) {
        this.mFirstDictionaryRoot = firstDictionaryRoot;
        this.mSecondDictionaryRoot = secondDictionaryRoot;
        this.mDictionaryPackage = dictionaryPackage;
        this.mLogicalDicationaryName = logicalDicationaryName;
        this.mImportLog = importLog;
    }

    public boolean reImport(boolean shouldApply) {
        this.mShouldApply = shouldApply;
        if (null == this.mFirstDictionaryRoot || null == this.mSecondDictionaryRoot) {
            return false;
        }
        this.HandleTypesFrom1in2();
        this.HandleTypesFrom2in1();
        this.handleTextPoolReimport(this.mShouldApply);
        return true;
    }

    private void HandleTypesFrom2in1() {
        int numberOfTypes = 0;
        DtSimpleType[] simpleTypes = null;
        try {
            numberOfTypes = this.mSecondDictionaryRoot.getSimpleTypes(this.mDictionaryPackage).length;
            simpleTypes = new DtSimpleType[numberOfTypes];
            System.arraycopy(this.mSecondDictionaryRoot.getSimpleTypes(this.mDictionaryPackage), 0, simpleTypes, 0, numberOfTypes);
        }
        catch (LoadException e) {
            this.mImportLog.addErrorMessage(e.getMessage());
            return;
        }
        int i = 0;
        while (i < numberOfTypes) {
            try {
                DtSimpleType newType = simpleTypes[i];
                if (null != this.mSecondDictionaryRoot.getSimpleType(this.mDictionaryPackage, simpleTypes[i].getName())) {
                    DtSimpleType oldType = this.mFirstDictionaryRoot.getSimpleType(newType.getPackage(), newType.getName());
                    if (null == oldType) {
                        this.createSimpleType(newType);
                    } else {
                        this.compareAndUpdateSimpleType(oldType, newType);
                    }
                }
            }
            catch (LoadException e) {
                this.mImportLog.addErrorMessage(e.getMessage());
                return;
            }
            ++i;
        }
    }

    private void HandleTypesFrom1in2() {
        int numberOfTypes = 0;
        DtSimpleType[] simpleTypes = null;
        try {
            numberOfTypes = this.mFirstDictionaryRoot.getSimpleTypes(this.mDictionaryPackage).length;
            simpleTypes = new DtSimpleType[numberOfTypes];
            System.arraycopy(this.mFirstDictionaryRoot.getSimpleTypes(this.mDictionaryPackage), 0, simpleTypes, 0, numberOfTypes);
        }
        catch (LoadException e) {
            this.mImportLog.addErrorMessage(e.getMessage());
            return;
        }
        int i = 0;
        while (i < numberOfTypes) {
            try {
                DtSimpleType newType;
                DtSimpleType oldType = simpleTypes[i];
                if (null != this.mFirstDictionaryRoot.getSimpleType(this.mDictionaryPackage, simpleTypes[i].getName()) && null == (newType = this.mSecondDictionaryRoot.getSimpleType(oldType.getPackage(), oldType.getName()))) {
                    if (this.mGetDeltas) {
                        this.mDeltas.add(oldType);
                    }
                    this.deleteSimpleType(oldType);
                }
            }
            catch (LoadException e) {
                this.mImportLog.addErrorMessage(e.getMessage());
            }
            ++i;
        }
    }

    private DtSimpleType createSimpleType(DtSimpleType referenceType) {
        try {
            this.mImportLog.addInfoMessage("[ New ] : [ SimpleType ] : [ " + referenceType.getName() + " ]");
            if (!this.mShouldApply) {
                return null;
            }
            DtSimpleType newType = this.mFirstDictionaryRoot.createSimpleType(referenceType.getPackage(), referenceType.getName());
            newType.setTypeName(referenceType.getTypeName());
            try {
                newType.setLogicalDictionary(this.mFirstDictionaryRoot.getLogicalDictionary(this.mDictionaryPackage, this.mLogicalDicationaryName));
            }
            catch (LoadException e) {
                this.mImportLog.addErrorMessage(e.getMessage());
            }
            newType.setBuiltInType(referenceType.getBuiltInType());
            newType.setToDeploy(referenceType.getToDeploy());
            newType.setBackendName(referenceType.getBackendName());
            DtSchemaType referenceSchemaType = referenceType.getSchemaType();
            if (referenceSchemaType != null) {
                DtSchemaType newSchemaType = newType.createSchemaType();
                newSchemaType.setFractionDigits(referenceSchemaType.getFractionDigits());
                newSchemaType.setLength(referenceSchemaType.getLength());
                newSchemaType.setMaxExclusive(referenceSchemaType.getMaxExclusive());
                newSchemaType.setMaxInclusive(referenceSchemaType.getMaxInclusive());
                newSchemaType.setMaxLength(referenceSchemaType.getMaxLength());
                newSchemaType.setMinInclusive(referenceSchemaType.getMinInclusive());
                newSchemaType.setMinExclusive(referenceSchemaType.getMinExclusive());
                newSchemaType.setMinLength(referenceSchemaType.getMinLength());
                newSchemaType.setPattern(referenceSchemaType.getPattern());
                newSchemaType.setTotalDigits(referenceSchemaType.getTotalDigits());
                if (referenceSchemaType.getEnumerationValueCount() > 0) {
                    DtEnumerationValue[] enumerations = referenceSchemaType.getEnumerationValues();
                    int i = 0;
                    while (i < enumerations.length) {
                        DtEnumerationValue value = newSchemaType.createEnumerationValue(Integer.toString(i));
                        value.setDescription(enumerations[i].getDescription());
                        value.setValue(enumerations[i].getValue());
                        this.setDoNotTranslate(value.getDescriptionAsTranslatableText());
                        ++i;
                    }
                }
            }
            DtTextObject textObject = newType.createTexts();
            textObject.setDescription(referenceType.getTexts().getDescription());
            this.setDoNotTranslate(textObject.getDescriptionAsTranslatableText());
            textObject.setColumnLabel(referenceType.getTexts().getColumnLabel());
            this.setDoNotTranslate(textObject.getColumnLabelAsTranslatableText());
            textObject.setFieldLabel(referenceType.getTexts().getFieldLabel());
            this.setDoNotTranslate(textObject.getFieldLabelAsTranslatableText());
            textObject.setQuickInfo(referenceType.getTexts().getQuickInfo());
            this.setDoNotTranslate(textObject.getQuickInfoAsTranslatableText());
            DtExternalRepresentation er = newType.createExternalRepresentation();
            er.setDefaultValue(referenceType.getExternalRepresentation().getDefaultValue());
            er.setFormat(referenceType.getExternalRepresentation().getFormat());
            er.setMaxExternalLength(referenceType.getExternalRepresentation().getMaxExternalLength());
            er.setReadOnly(referenceType.getExternalRepresentation().getReadOnly());
            er.setTranslateFlag(referenceType.getExternalRepresentation().getTranslateFlag());
            er.setUppercase(referenceType.getExternalRepresentation().getUppercase());
            this.createDbProperty(newType);
            this.createTechnicalInfo(newType);
            return newType;
        }
        catch (CreateException e) {
            this.mImportLog.addErrorMessage(e.getMessage());
            return null;
        }
    }

    private void setDoNotTranslate(TranslatableText translateableText) {
        if (translateableText != null) {
            translateableText.setDoNotTranslate(true);
        }
    }

    private DtSimpleType compareAndUpdateSimpleType(DtSimpleType typeToBeUpdated, DtSimpleType referenceType) {
        CompareResult result = typeToBeUpdated.compareTo((DevelopmentObject)referenceType);
        MetamodelDelta[] deltas = result.getDeltas();
        if (deltas.length > 0) {
            if (this.mGetDeltas) {
                this.mDeltas.add(typeToBeUpdated);
            }
            this.mImportLog.addInfoMessage("[ Modified ] : [ SimpleType ] : [ " + typeToBeUpdated.getName() + " ]");
        }
        int i = 0;
        while (i < deltas.length) {
            try {
                if (this.mGetDeltas) {
                    this.mDeltas.add(deltas[i]);
                }
                if (this.mShouldApply) {
                    deltas[i].apply();
                }
            }
            catch (MetamodelException e) {
                this.mImportLog.addErrorMessage(e.getMessage());
            }
            ++i;
        }
        return typeToBeUpdated;
    }

    private void deleteSimpleType(DtSimpleType typeToBeDeleted) {
        try {
            this.mImportLog.addInfoMessage("[ Deleted ] : [ SimpleType ] : [ " + typeToBeDeleted.getName() + " ]");
            if (this.mShouldApply) {
                typeToBeDeleted.delete();
            }
        }
        catch (DeleteException e) {
            this.mImportLog.addErrorMessage(e.getMessage());
        }
    }

    private void createTechnicalInfo(DtSimpleType simpleType) throws CreateException {
        DtTechnicalInfo technicalInfo = simpleType.createTechnicalInfo();
        technicalInfo.setWithClass(simpleType.getTechnicalInfo().getWithClass());
    }

    private void createDbProperty(DtSimpleType simpleType) throws CreateException {
        DtDbProperty dbProp = simpleType.createDbProperty();
        dbProp.setDbDefault(simpleType.getDbProperty().getDbDefault());
        dbProp.setJdbcTypeName(simpleType.getDbProperty().getJdbcTypeName());
        dbProp.setNotNull(simpleType.getDbProperty().getNotNull());
    }

    public ArrayList getDeltas() {
        this.mGetDeltas = true;
        this.mDeltas = new ArrayList();
        this.reImport(false);
        this.mGetDeltas = false;
        return this.mDeltas;
    }

    public void handleTextPoolReimport(boolean shouldApply) {
        try {
            int numberOfTypes = this.mFirstDictionaryRoot.getSimpleTypes(this.mDictionaryPackage).length;
            int i = 0;
            while (i < numberOfTypes) {
                DtSimpleType newType;
                DtSimpleType simpleType = this.mFirstDictionaryRoot.getSimpleTypes(this.mDictionaryPackage)[i];
                if (TextPoolReimportHandler.checkTexts((MainDevelopmentObject)simpleType) && null != (newType = this.mSecondDictionaryRoot.getSimpleType(simpleType.getPackage(), simpleType.getName()))) {
                    TextPoolReimportHandler.reimport((MainDevelopmentObject)simpleType, (MainDevelopmentObject)newType, shouldApply, this.mImportLog);
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.mImportLog.addErrorMessage(e.getMessage());
        }
    }
}

