/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.rfcmodel.reimport;

import com.sap.dictionary.types.mdi2metamodel.R3ToMetamodelDictionaryConverterWithNestedStructures;
import com.sap.ide.jcb.core.service.internal.R3Service;
import com.sap.ide.jcb.core.wizardpages.SAPLogonPage;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.common.CommonRoot;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtLogicalDictionary;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.general.compare.AggregationNegativeDelta;
import com.sap.ide.metamodel.general.compare.CompareResult;
import com.sap.ide.metamodel.general.compare.MetamodelDelta;
import com.sap.ide.metamodel.general.compare.PropertyDelta;
import com.sap.ide.metamodel.general.exception.CreateException;
import com.sap.ide.metamodel.general.exception.LoadException;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ide.metamodel.general.exception.ObjectNotModifiableException;
import com.sap.ide.metamodel.general.exception.ReflectionException;
import com.sap.ide.metamodel.general.metainfo.Aggregation;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.importers.rfcmodel.DynamicRFCModelImporter;
import com.sap.ide.metamodel.importers.rfcmodel.reimport.DTRIntegrator;
import com.sap.ide.metamodel.importers.rfcmodel.reimport.DictionaryReimportHandler;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.model.AbstractModelSetting;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.services.GenerationPathManager;
import com.sap.ide.webdynpro.service.core.projectproperties.WDProjectPropertiesUtil;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;
import com.sap.ide.webdynpro.service.modeleditor.TextPool;
import com.sap.mdi.MetaDataAccessException;
import com.sap.mdi.ObjectFactory;
import com.sap.mdi.ObjectFactoryException;
import com.sap.mdi.Rfm;
import com.sap.mw.jco.JCO;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DynamicRFCModelReimporter {
    private Metamodel mNewMetamodel;
    private CommonRoot mCommonRoot;
    private WebDynproRoot mOldWebDynproRoot;
    private DtDictionaryRoot mOldDictionaryRoot;
    private DtDictionaryRoot mNewDictionaryRoot;
    private IPackageFragmentRoot mSelectedRoot;
    private Model mModel;
    private Metamodel mOldMetamodel;
    private DictionaryReimportHandler mDictionaryReimportHandler;
    private SAPLogonPage mSAPLogonPage;
    private MetamodelDelta[] mDeltas;
    private Object[] mOverallDeltas;
    private DynamicRFCModelImporter mImporter = null;
    private Model mNewModel = null;
    private boolean mReimportCanContinue;
    private String[] mRFCsToBeImported = null;
    private String mLogicalDictionaryName = null;
    private String mModelDefaultLogicalSystem = null;
    private String mMetadataDefaultLogicalSystem = null;
    private ImportLog mLog = new ImportLog();
    private int ADAPTIVE_RFC_MODEL_TYPE = 0;
    private static final String RFC_PART_TYPE = "rfcPartType";
    private static final String RFC_PART_TYPE_INPUT = "input";
    private static final String ABAP_NAME = "abapName";
    public static final String MODEL_INSTANCE_DEFAULT_LOGICAL_SYSTEM = "modelInstance_defaultLogicalSystem";
    public static final String RFC_METADATA_DEFAULT_LOGICAL_SYSTEM = "rfcMetadata_defaultLogicalSystem";
    static /* synthetic */ Class class$com$sap$ide$metamodel$common$CommonRoot;
    static /* synthetic */ Class class$com$sap$ide$metamodel$webdynpro$WebDynproRoot;
    static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot;

    public DynamicRFCModelReimporter(WebDynproRoot webDynproRoot, DtDictionaryRoot dictionaryRoot, Model theModel) {
        this.mOldWebDynproRoot = webDynproRoot;
        this.mOldDictionaryRoot = dictionaryRoot;
        this.mModel = theModel;
        this.mOldMetamodel = theModel.getMetamodel();
    }

    public Model reImport() {
        this.mReimportCanContinue = true;
        this.checkWritability();
        if (!this.mReimportCanContinue) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TextPool.getInstance().getText(358), (String)TextPool.getInstance().getText(505));
            this.rollbackNewMetaModel();
            return null;
        }
        this.applyDeltas(true);
        this.addJCOReference();
        this.rollbackNewMetaModel();
        return this.mModel;
    }

    public String[][] getRfcNameDescImported() {
        try {
            int numberOfClasses = this.mModel.getModelClassCount();
            String[][] rfcNames = new String[this.getRfcNamesImported().length][2];
            int rfcNameCounter = 0;
            int i = 0;
            while (i < numberOfClasses) {
                ModelClass theModelClass = this.mModel.getModelClasses()[i];
                if (theModelClass.getSetting(RFC_PART_TYPE).getValue().equals(RFC_PART_TYPE_INPUT)) {
                    String modelClassName;
                    rfcNames[rfcNameCounter][0] = modelClassName = theModelClass.getSetting(ABAP_NAME).getValue();
                    rfcNames[rfcNameCounter][1] = "";
                    ++rfcNameCounter;
                }
                ++i;
            }
            return rfcNames;
        }
        catch (Exception e) {
            return new String[0][0];
        }
    }

    public String[] getRfcNamesImported() {
        try {
            Vector<String> rfcNames = new Vector<String>();
            int numberOfClasses = this.mModel.getModelClassCount();
            int i = 0;
            while (i < numberOfClasses) {
                ModelClass theModelClass = this.mModel.getModelClasses()[i];
                if (theModelClass.getSetting(RFC_PART_TYPE).getValue().equals(RFC_PART_TYPE_INPUT)) {
                    rfcNames.add(theModelClass.getSetting(ABAP_NAME).getValue());
                }
                ++i;
            }
            String[] rfcNamesArray = new String[rfcNames.size()];
            int i2 = 0;
            while (i2 < rfcNamesArray.length) {
                rfcNamesArray[i2] = (String)rfcNames.get(i2);
                ++i2;
            }
            return rfcNamesArray;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public String[] getRfcNamesImportedFromModel() {
        try {
            Vector<String> rfcNames = new Vector<String>();
            int numberOfClasses = this.mModel.getModelClassCount();
            int i = 0;
            while (i < numberOfClasses) {
                ModelClass theModelClass = this.mModel.getModelClasses()[i];
                if (this.doesInputOutputClassExists(theModelClass, this.mModel)) {
                    rfcNames.add(this.getRFCNameFromModelClassName(theModelClass.getName()));
                }
                ++i;
            }
            String[] rfcNamesArray = new String[rfcNames.size()];
            int i2 = 0;
            while (i2 < rfcNamesArray.length) {
                rfcNamesArray[i2] = (String)rfcNames.elementAt(i2);
                ++i2;
            }
            return rfcNamesArray;
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public Rfm[] getRfmsImported() {
        JCO.Client theJCOConnection = R3Service.getInstance().getConnectionManager().getJCOClient();
        ObjectFactory theJCOObjectFactory = null;
        try {
            theJCOObjectFactory = new ObjectFactory(theJCOConnection);
        }
        catch (ObjectFactoryException e) {
            this.mLog.addException(e);
        }
        Rfm[] rfms = new Rfm[this.getRfcNamesImported().length];
        int i = 0;
        while (i < this.getRfcNamesImported().length) {
            try {
                rfms[i] = theJCOObjectFactory.getRfm(this.getRfcNamesImported()[i]);
            }
            catch (MetaDataAccessException e) {
                this.mLog.addException(e);
            }
            ++i;
        }
        return rfms;
    }

    private boolean isLocalModelObject(DevelopmentObject object) {
        Aggregation lAggregation = object.getMetaClass().getAggregation("Settings");
        if (null == lAggregation) {
            return false;
        }
        AbstractModelSetting setting = null;
        try {
            setting = (AbstractModelSetting)object.getAggregatedObject(lAggregation, "isLocal");
            if (null == setting) {
                return false;
            }
            return setting.getValue().equals("true");
        }
        catch (ReflectionException e) {
            this.mLog.addException(e);
            return false;
        }
    }

    public SourcePathIdentifier getSourcePathIdentifier() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String projectName = ((WebDynproRoot)this.mModel.getRoot()).getMetamodel().getName();
        IProject project = workspaceRoot.getProject(projectName);
        IPackageFragmentRoot[] allValidRoots = GenerationPathManager.getValidSourceRoots((IProject)project);
        this.mSelectedRoot = allValidRoots[0];
        MetamodelManager manager = MetamodelManager.getMetamodelManager((String)project.getName());
        return manager.getSourcePathIdentifier(manager.makePathAbsolute(this.mSelectedRoot.getPath()));
    }

    public ImportLog getImportLog(String[] rfcNames, IProgressMonitor monitor) {
        this.mRFCsToBeImported = rfcNames;
        this.initialize();
        this.mNewModel = this.doImport(monitor);
        if (null == this.mNewModel) {
            return null;
        }
        this.getDeltas();
        this.applyDeltas(false);
        return this.mLog;
    }

    public void doRollBack() {
        this.rollbackNewMetaModel();
    }

    private void initialize() {
        try {
            String metaModelName = "Reimport" + System.currentTimeMillis();
            this.mNewMetamodel = new Metamodel(metaModelName, System.getProperty("java.io.tmpdir"));
            this.mCommonRoot = (CommonRoot)this.mNewMetamodel.createRoot(class$com$sap$ide$metamodel$common$CommonRoot == null ? (class$com$sap$ide$metamodel$common$CommonRoot = DynamicRFCModelReimporter.class$("com.sap.ide.metamodel.common.CommonRoot")) : class$com$sap$ide$metamodel$common$CommonRoot);
            WebDynproRoot theWebDynproRoot = (WebDynproRoot)this.mNewMetamodel.createRoot(class$com$sap$ide$metamodel$webdynpro$WebDynproRoot == null ? (class$com$sap$ide$metamodel$webdynpro$WebDynproRoot = DynamicRFCModelReimporter.class$("com.sap.ide.metamodel.webdynpro.WebDynproRoot")) : class$com$sap$ide$metamodel$webdynpro$WebDynproRoot);
            this.mNewDictionaryRoot = (DtDictionaryRoot)this.mNewMetamodel.createRoot(class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot == null ? (class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot = DynamicRFCModelReimporter.class$("com.sap.ide.metamodel.dictionary.DtDictionaryRoot")) : class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot);
            String[] archives = this.mOldMetamodel.getArchives();
            int i = 0;
            while (i < archives.length) {
                this.mNewMetamodel.addArchive(archives[i]);
                ++i;
            }
            this.mImporter = new DynamicRFCModelImporter(this.mNewDictionaryRoot, theWebDynproRoot);
        }
        catch (Exception e) {
            this.mLog.addException(e);
        }
    }

    private Model doImport(IProgressMonitor monitor) {
        String modelInstanceDLS = null;
        String dictionaryPackage = null;
        String metaDataDLS = null;
        if (null == this.mLogicalDictionaryName) {
            modelInstanceDLS = this.mModel.getSetting(MODEL_INSTANCE_DEFAULT_LOGICAL_SYSTEM).getValue();
            dictionaryPackage = this.getDictionaryPackageName(this.mModel);
            DtLogicalDictionary logicalDictionary = this.getLogicalDictionary();
            this.mLogicalDictionaryName = logicalDictionary.getName();
            if (null == logicalDictionary) {
                return null;
            }
            metaDataDLS = logicalDictionary.getLogicalSystemName();
        } else {
            modelInstanceDLS = this.mModelDefaultLogicalSystem;
            dictionaryPackage = this.getDictionaryPackageName(this.mModel);
            metaDataDLS = this.mMetadataDefaultLogicalSystem;
        }
        this.mImporter.setImportStatusTitle("Calculating Deltas");
        this.mImporter.setSubTaskStatusTitle("Comparing with");
        this.setDictionaryRelatedInfo(this.mLogicalDictionaryName, modelInstanceDLS, metaDataDLS);
        Model newModel = this.mImporter.doImport(this.mModel.getPackage(), this.mModel.getName(), this.getSourcePathIdentifier(), this.mLogicalDictionaryName, modelInstanceDLS, metaDataDLS, dictionaryPackage, this.mRFCsToBeImported, monitor);
        try {
            R3ToMetamodelDictionaryConverterWithNestedStructures mDictionaryConverter = new R3ToMetamodelDictionaryConverterWithNestedStructures(this.mNewDictionaryRoot, dictionaryPackage, this.mLogicalDictionaryName, metaDataDLS, R3Service.getInstance().getConnectionManager().getJCOClient());
            R3ToMetamodelDictionaryConverterWithNestedStructures mOldDictionaryConverter = new R3ToMetamodelDictionaryConverterWithNestedStructures(this.mOldDictionaryRoot, dictionaryPackage, this.mLogicalDictionaryName, metaDataDLS, R3Service.getInstance().getConnectionManager().getJCOClient());
            if (null == this.mModel.getLogicalDictionary()) {
                this.mModel.setLogicalDictionary((DevelopmentObject)mOldDictionaryConverter.getLogicalDictionary());
            }
        }
        catch (CreateException e) {
            this.mLog.addException(e);
        }
        catch (LoadException e) {
            this.mLog.addException(e);
        }
        catch (ObjectFactoryException e) {
            this.mLog.addException(e);
        }
        return newModel;
    }

    private void getDeltas() {
        CompareResult compareResult = this.mModel.compareTo((DevelopmentObject)this.mNewModel);
        this.mDeltas = compareResult.getDeltas();
        String dictionaryPackage = this.getDictionaryPackageName(this.mModel);
        this.mDictionaryReimportHandler = new DictionaryReimportHandler(this.mOldDictionaryRoot, this.mNewDictionaryRoot, dictionaryPackage, this.mLogicalDictionaryName, this.mLog);
    }

    private void checkWritability() {
        ArrayList dictionaryDeltas = this.mDictionaryReimportHandler.getDeltasAsList();
        int totalDeltas = this.mDeltas.length + dictionaryDeltas.size();
        this.mOverallDeltas = new Object[totalDeltas];
        int i = 0;
        while (i < this.mDeltas.length) {
            this.mOverallDeltas[i] = this.mDeltas[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < dictionaryDeltas.size()) {
            this.mOverallDeltas[i2 + this.mDeltas.length] = dictionaryDeltas.get(i2);
            ++i2;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    DynamicRFCModelReimporter.this.mReimportCanContinue = DTRIntegrator.checkWritability(DynamicRFCModelReimporter.this.mOverallDeltas, DynamicRFCModelReimporter.this.mModel);
                }
                catch (ObjectNotModifiableException e) {
                    DynamicRFCModelReimporter.this.mReimportCanContinue = false;
                    DynamicRFCModelReimporter.this.mLog.addException(e);
                }
                catch (Exception e) {
                    DynamicRFCModelReimporter.this.mReimportCanContinue = false;
                    DynamicRFCModelReimporter.this.mLog.addException(e);
                }
            }
        });
    }

    private void rollbackNewMetaModel() {
        try {
            if (null != this.mNewMetamodel) {
                this.mNewMetamodel.rollbackChanges();
                this.mNewMetamodel.shutDown();
            }
        }
        catch (MetamodelException e) {
            this.mLog.addException(e);
        }
    }

    private void rollbackOldMetaModel() {
        try {
            if (null != this.mOldMetamodel) {
                this.mOldMetamodel.rollbackChanges();
            }
        }
        catch (MetamodelException e) {
            this.mLog.addException(e);
        }
    }

    private void applyDeltas(boolean shouldApply) {
        try {
            this.mLog.clear();
            this.mLog.addInfoMessage("Deltas, if any: ");
            this.mDictionaryReimportHandler.reImport(shouldApply);
            CompareResult compareResult = this.mModel.compareTo((DevelopmentObject)this.mNewModel);
            this.mDeltas = compareResult.getDeltas();
            int localMethodImplmentationsCount = 0;
            int i = 0;
            while (i < this.mDeltas.length) {
                block10: {
                    try {
                        MetamodelDelta delta = this.mDeltas[i];
                        if (delta instanceof PropertyDelta && ((PropertyDelta)delta).getProperty().getName().equals("codeBody")) {
                            ++localMethodImplmentationsCount;
                            break block10;
                        }
                        if (delta instanceof AggregationNegativeDelta && this.isLocalModelObject(((AggregationNegativeDelta)delta).getObjectToDelete())) break block10;
                        if (shouldApply) {
                            try {
                                delta.apply();
                            }
                            catch (MetamodelException e) {
                                this.mLog.addException(e);
                            }
                        }
                        String typeOfObject = DTRIntegrator.getTypeOfObject(this.mDeltas[i]);
                        String modificationType = DTRIntegrator.getModificationType(delta);
                        String objectName = DTRIntegrator.getObjectName(delta);
                        this.mLog.addInfoMessage("[ " + modificationType + " ] : [ " + typeOfObject + " ] : [ " + objectName + " ]");
                    }
                    catch (Exception e) {
                        this.mLog.addException(e);
                    }
                }
                ++i;
            }
            if (localMethodImplmentationsCount > 0) {
                this.mLog.addInfoMessage("Local method implementations are different.");
            }
        }
        catch (Exception e) {
            this.mLog.addInfoMessage("Error while applying deltas");
        }
    }

    private String getDictionaryPackageName(Model model) {
        return model.getPackage() + ".types";
    }

    private DtLogicalDictionary getLogicalDictionary() {
        DtLogicalDictionary logicalDictionary = null;
        try {
            logicalDictionary = this.mOldDictionaryRoot.getLogicalDictionary(this.getDictionaryPackageName(this.mModel), this.mModel.getLogicalDictionary().getName());
        }
        catch (LoadException e) {
            this.mLog.addException(e);
        }
        return logicalDictionary;
    }

    private boolean doesInputOutputClassExists(ModelClass modelClass, Model model) {
        if (modelClass.getName().endsWith("_Input")) {
            int i = 0;
            while (i < model.getModelClassCount()) {
                if (model.getModelClasses()[i].getName().endsWith("_Output")) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private String getRFCNameFromModelClassName(String modelClassName) {
        int pos = 0;
        pos = modelClassName.endsWith("_Input") ? modelClassName.lastIndexOf("_Input") : modelClassName.lastIndexOf("_Output");
        if (pos <= 0) {
            return "";
        }
        return modelClassName.substring(0, pos);
    }

    public void setDictionaryRelatedInfo(String logicalDictionaryName, String modelDefaultLogicalSystem, String metadataDefaultLogicalSystem) {
        this.mLogicalDictionaryName = logicalDictionaryName;
        this.mModelDefaultLogicalSystem = modelDefaultLogicalSystem;
        this.mMetadataDefaultLogicalSystem = metadataDefaultLogicalSystem;
    }

    public ImportLog getImportLog() {
        return this.mLog;
    }

    private void addJCOReference() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.mOldWebDynproRoot.getMetamodel().getName());
        if (project != null) {
            try {
                WDProjectPropertiesUtil.addJcoReference((IProject)project, (String)this.mMetadataDefaultLogicalSystem);
                WDProjectPropertiesUtil.addJcoReference((IProject)project, (String)this.mModelDefaultLogicalSystem);
            }
            catch (CreateException e) {
                ServiceModelEditorPlugin.internalError(this.getClass(), "addJCOReference()", "Failed to create entries in project properties file for logical system names: " + this.mMetadataDefaultLogicalSystem + ", " + this.mModelDefaultLogicalSystem, e, false);
            }
        } else {
            ServiceModelEditorPlugin.internalError(this.getClass(), "addJCOReference()", "Failed to retrieve project reference for project " + this.mOldWebDynproRoot.getMetamodel().getName(), null, false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

