/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.rfcmodel.reimport;

import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.compare.MetamodelDelta;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.importers.rfcmodel.reimport.SimpleTypeReimportHandler;
import com.sap.ide.metamodel.importers.rfcmodel.reimport.StructureReimportHandler;
import java.util.ArrayList;

public class DictionaryReimportHandler {
    private DtDictionaryRoot mFirstDictionaryRoot;
    private DtDictionaryRoot mSecondDictionaryRoot;
    private String mDictionaryPackage;
    private String mLogicalDicationaryName;
    private SimpleTypeReimportHandler mSimpleTypeReimportHandler;
    private StructureReimportHandler mStructureReimportHandler;
    private ImportLog mImportLog;

    public DictionaryReimportHandler(DtDictionaryRoot firstDictionaryRoot, DtDictionaryRoot secondDictionaryRoot, String dictionaryPackage, String logicalDicationaryName, ImportLog importLog) {
        this.mFirstDictionaryRoot = firstDictionaryRoot;
        this.mSecondDictionaryRoot = secondDictionaryRoot;
        this.mDictionaryPackage = dictionaryPackage;
        this.mLogicalDicationaryName = logicalDicationaryName;
        this.mSimpleTypeReimportHandler = new SimpleTypeReimportHandler(firstDictionaryRoot, secondDictionaryRoot, dictionaryPackage, this.mLogicalDicationaryName, importLog);
        this.mStructureReimportHandler = new StructureReimportHandler(firstDictionaryRoot, secondDictionaryRoot, dictionaryPackage, this.mLogicalDicationaryName, importLog);
        this.mImportLog = importLog;
    }

    public boolean reImport(boolean shouldApply) {
        this.mSimpleTypeReimportHandler.reImport(shouldApply);
        this.mStructureReimportHandler.reImport(shouldApply);
        return true;
    }

    public MetamodelDelta[] getDeltas() {
        ArrayList simpleTypeDeltas = this.mSimpleTypeReimportHandler.getDeltas();
        ArrayList structureDeltas = this.mStructureReimportHandler.getDeltas();
        ArrayList dictionaryDeltas = new ArrayList();
        int i = 0;
        while (i < simpleTypeDeltas.size()) {
            dictionaryDeltas.add(simpleTypeDeltas.get(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < structureDeltas.size()) {
            dictionaryDeltas.add(structureDeltas.get(i2));
            ++i2;
        }
        if (dictionaryDeltas.size() > 0) {
            return (MetamodelDelta[])dictionaryDeltas.toArray();
        }
        return new MetamodelDelta[0];
    }

    public ArrayList getDeltasAsList() {
        ArrayList simpleTypeDeltas = this.mSimpleTypeReimportHandler.getDeltas();
        ArrayList structureDeltas = this.mStructureReimportHandler.getDeltas();
        ArrayList dictionaryDeltas = new ArrayList();
        int i = 0;
        while (i < simpleTypeDeltas.size()) {
            dictionaryDeltas.add(simpleTypeDeltas.get(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < structureDeltas.size()) {
            dictionaryDeltas.add(structureDeltas.get(i2));
            ++i2;
        }
        return dictionaryDeltas;
    }
}

