/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.rfcmodel.reimport;

import com.sap.ide.metamodel.core.repository.MMRepositoryObject;
import com.sap.ide.metamodel.core.repository.MMRepositoryObjectList;
import com.sap.ide.metamodel.core.repository.RepositoryServices;
import com.sap.ide.metamodel.dictionary.datatype.DtGeneralStructure;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.ide.metamodel.dictionary.datatype.DtStructure;
import com.sap.ide.metamodel.dictionary.repository.SimpleTypeRepositoryManager;
import com.sap.ide.metamodel.dictionary.repository.StructureRepositoryManager;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.MainDevelopmentObject;
import com.sap.ide.metamodel.general.compare.AggregationDelta;
import com.sap.ide.metamodel.general.compare.AggregationNegativeDelta;
import com.sap.ide.metamodel.general.compare.AggregationPositiveDelta;
import com.sap.ide.metamodel.general.compare.AssociationDelta;
import com.sap.ide.metamodel.general.compare.AssociationNegativeDelta;
import com.sap.ide.metamodel.general.compare.AssociationPositiveDelta;
import com.sap.ide.metamodel.general.compare.MetamodelDelta;
import com.sap.ide.metamodel.general.compare.PropertyDelta;
import com.sap.ide.metamodel.general.compare.RelationOrderingDelta;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.repository.ModelClassRepositoryManager;
import com.sap.ide.metamodel.webdynpro.repository.ModelRepositoryManager;
import com.sap.ide.webdynpro.service.modeleditor.ServiceModelEditorPlugin;

public class DTRIntegrator {
    private static MMRepositoryObjectList mRepositoryObjectList = null;
    static /* synthetic */ Class class$com$sap$ide$metamodel$importers$rfcmodel$reimport$DTRIntegrator;

    public static boolean checkWritability(Object[] deltas, Model model) {
        mRepositoryObjectList = new MMRepositoryObjectList();
        DTRIntegrator.checkWritabilityForModel(model);
        int i = 0;
        while (i < deltas.length) {
            block6: {
                try {
                    DTRIntegrator.checkWritability(deltas[i]);
                }
                catch (Exception e) {
                    if (null == deltas[i]) break block6;
                    MetamodelDelta metamodelDelta = (MetamodelDelta)deltas[i];
                    ServiceModelEditorPlugin.internalError(class$com$sap$ide$metamodel$importers$rfcmodel$reimport$DTRIntegrator == null ? DTRIntegrator.class$("com.sap.ide.metamodel.importers.rfcmodel.reimport.DTRIntegrator") : class$com$sap$ide$metamodel$importers$rfcmodel$reimport$DTRIntegrator, "checkWritability", "Failed to check-out object" + metamodelDelta.getSourceObject().getMDO().getName(), e, false);
                }
            }
            ++i;
        }
        try {
            if (!RepositoryServices.checkWriteability((MMRepositoryObject[])mRepositoryObjectList.getRepositoryObjects())) {
                return false;
            }
        }
        catch (Exception e) {
            ServiceModelEditorPlugin.internalError(class$com$sap$ide$metamodel$importers$rfcmodel$reimport$DTRIntegrator == null ? (class$com$sap$ide$metamodel$importers$rfcmodel$reimport$DTRIntegrator = DTRIntegrator.class$("com.sap.ide.metamodel.importers.rfcmodel.reimport.DTRIntegrator")) : class$com$sap$ide$metamodel$importers$rfcmodel$reimport$DTRIntegrator, "checkWritability", "Failed to check-out object" + e.getMessage(), e, false);
        }
        return true;
    }

    public static void checkWritability(Object objectToBeChecked) {
        try {
            if (null == objectToBeChecked) {
                return;
            }
            if (objectToBeChecked instanceof DtSimpleType) {
                DTRIntegrator.checkWritabilityForSimpleTypes((DtSimpleType)objectToBeChecked);
            } else if (objectToBeChecked instanceof DtStructure) {
                DTRIntegrator.checkWritabilityForStructures((DtStructure)objectToBeChecked);
            } else if (objectToBeChecked instanceof Model) {
                DTRIntegrator.checkWritabilityForModel((Model)objectToBeChecked);
            } else if (objectToBeChecked instanceof ModelClass) {
                DTRIntegrator.checkWritabilityForModelClass((ModelClass)objectToBeChecked);
            } else if (objectToBeChecked instanceof MetamodelDelta) {
                MetamodelDelta delta = (MetamodelDelta)objectToBeChecked;
                Object[] objects = DTRIntegrator.getObjectsToBeCheckedOut(delta);
                DTRIntegrator.addToObjectsToBeCheckedOut(objects[0]);
                DTRIntegrator.addToObjectsToBeCheckedOut(objects[1]);
            }
        }
        catch (Exception e) {
            DTRIntegrator.LogError();
        }
    }

    public static boolean checkWritabilityForModel(Model model) {
        MMRepositoryObject ro = ModelRepositoryManager.getRepositioryObject((Model)model, (boolean)true);
        if (null != ro) {
            DTRIntegrator.addToObjectsToBeModified(ro);
        }
        return true;
    }

    public static boolean checkWritabilityForModelClass(ModelClass modelClass) {
        MMRepositoryObject ro = ModelClassRepositoryManager.getRepositioryObject((ModelClass)modelClass, (boolean)true);
        if (null != ro) {
            DTRIntegrator.addToObjectsToBeModified(ro);
        }
        return true;
    }

    public static boolean checkWritabilityForSimpleTypes(DtSimpleType simpleType) {
        MMRepositoryObject ro = null;
        MainDevelopmentObject owner = simpleType.getTextPool().getOwner();
        if (null != owner) {
            try {
                ro = ModelRepositoryManager.getRepositioryObject((DevelopmentObject)owner, (boolean)true);
            }
            catch (Exception e) {
                ro = null;
            }
            if (null != ro) {
                DTRIntegrator.addToObjectsToBeModified(ro);
            }
        }
        if (null != (ro = SimpleTypeRepositoryManager.getRepositoryObject((DtSimpleType)simpleType, (boolean)true))) {
            DTRIntegrator.addToObjectsToBeModified(ro);
        }
        return true;
    }

    public static boolean checkWritabilityForStructures(DtStructure structure) {
        MainDevelopmentObject parent = structure.getMDO();
        MMRepositoryObject ro = null;
        if (null != parent) {
            try {
                ro = ModelRepositoryManager.getRepositioryObject((DevelopmentObject)parent, (boolean)true);
            }
            catch (Exception e) {
                ro = null;
            }
            if (null != ro) {
                DTRIntegrator.addToObjectsToBeModified(ro);
            }
        }
        if (null != (ro = StructureRepositoryManager.getRepositoryObject((DtGeneralStructure)((DtGeneralStructure)structure), (boolean)true))) {
            DTRIntegrator.addToObjectsToBeModified(ro);
        }
        return true;
    }

    public static boolean checkWritabilityForDO(DevelopmentObject developmentObject, boolean includeAllLanguageFiles) {
        try {
            MMRepositoryObject[] repositoryObjects = new MMRepositoryObject[]{ModelRepositoryManager.getRepositioryObject((DevelopmentObject)developmentObject, (boolean)includeAllLanguageFiles)};
            return RepositoryServices.checkWriteability((MMRepositoryObject[])repositoryObjects);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getTypeOfObject(MetamodelDelta delta) {
        if (delta instanceof AggregationNegativeDelta) {
            return ((AggregationNegativeDelta)delta).getObjectToDelete().getDevelopmentObjectEnum().toString();
        }
        if (delta instanceof AggregationPositiveDelta) {
            return ((AggregationPositiveDelta)delta).getObjectToCreate().getDevelopmentObjectEnum().toString();
        }
        if (delta instanceof AssociationNegativeDelta) {
            return ((AssociationNegativeDelta)delta).getObjectToRemove().getDevelopmentObjectEnum().toString();
        }
        if (delta instanceof AssociationPositiveDelta) {
            return ((AssociationPositiveDelta)delta).getObjectToReference().getDevelopmentObjectEnum().toString();
        }
        if (delta instanceof PropertyDelta) {
            return delta.getSourceObject().getDevelopmentObjectEnum().toString();
        }
        if (delta instanceof RelationOrderingDelta) {
            return delta.getSourceObject().getDevelopmentObjectEnum().toString();
        }
        if (delta instanceof MetamodelDelta) {
            return delta.getSourceObject().getDevelopmentObjectEnum().toString();
        }
        return delta.getSourceObject().getDevelopmentObjectEnum().toString();
    }

    public static String getObjectName(MetamodelDelta delta) {
        if (delta instanceof AggregationNegativeDelta) {
            return ((AggregationNegativeDelta)delta).getObjectToDelete().getName();
        }
        if (delta instanceof AggregationPositiveDelta) {
            return ((AggregationPositiveDelta)delta).getObjectToCreate().getName();
        }
        if (delta instanceof AssociationNegativeDelta) {
            return ((AssociationNegativeDelta)delta).getObjectToRemove().getName();
        }
        if (delta instanceof AssociationPositiveDelta) {
            return ((AssociationPositiveDelta)delta).getObjectToReference().getName();
        }
        if (delta instanceof PropertyDelta) {
            return ((PropertyDelta)delta).getSourceObject().getName();
        }
        if (delta instanceof RelationOrderingDelta) {
            return ((RelationOrderingDelta)delta).getSourceObject().getName();
        }
        if (delta instanceof MetamodelDelta) {
            return delta.getSourceObject().getName();
        }
        return delta.getSourceObject().getName();
    }

    public static String getModificationType(MetamodelDelta delta) {
        if (delta instanceof AggregationNegativeDelta) {
            return "Deleted";
        }
        if (delta instanceof AggregationPositiveDelta) {
            return "New";
        }
        if (delta instanceof AssociationNegativeDelta) {
            return "Removed reference";
        }
        if (delta instanceof AssociationPositiveDelta) {
            return "New reference";
        }
        if (delta instanceof PropertyDelta) {
            return "Modified";
        }
        if (delta instanceof AssociationDelta) {
            return "Modified";
        }
        if (delta instanceof MetamodelDelta) {
            return "Modified";
        }
        if (delta instanceof RelationOrderingDelta) {
            return "Modified";
        }
        return "Modified";
    }

    public static void addToObjectsToBeModified(MMRepositoryObject objToBeAdded) {
        if (null == mRepositoryObjectList) {
            return;
        }
        mRepositoryObjectList.addRepositoryObject(objToBeAdded);
    }

    public void addCheckOutMessageToLog(MetamodelDelta delta) {
    }

    private static Object[] getObjectsToBeCheckedOut(MetamodelDelta delta) {
        if (null == delta) {
            return null;
        }
        Object[] objectsToBeCheckedOut = new Object[2];
        try {
            objectsToBeCheckedOut[0] = delta.getSourceObject().getMDO();
        }
        catch (Exception e) {
            ServiceModelEditorPlugin.internalError(class$com$sap$ide$metamodel$importers$rfcmodel$reimport$DTRIntegrator == null ? (class$com$sap$ide$metamodel$importers$rfcmodel$reimport$DTRIntegrator = DTRIntegrator.class$("com.sap.ide.metamodel.importers.rfcmodel.reimport.DTRIntegrator")) : class$com$sap$ide$metamodel$importers$rfcmodel$reimport$DTRIntegrator, "getObjectsToBeCheckedOut", e.getMessage(), e, false);
        }
        if (delta instanceof AggregationNegativeDelta && ((AggregationNegativeDelta)delta).getObjectToDelete() instanceof MainDevelopmentObject) {
            objectsToBeCheckedOut[1] = ((AggregationNegativeDelta)delta).getObjectToDelete();
        }
        if (delta instanceof AggregationDelta && ((AggregationDelta)delta).getObjectToDelete() instanceof MainDevelopmentObject) {
            objectsToBeCheckedOut[1] = ((AggregationDelta)delta).getObjectToDelete();
        }
        return objectsToBeCheckedOut;
    }

    private static void LogError() {
    }

    private static void addToObjectsToBeCheckedOut(Object objectToBeAdded) {
        if (null != objectToBeAdded) {
            if (objectToBeAdded instanceof Model) {
                DTRIntegrator.checkWritabilityForModel((Model)objectToBeAdded);
            } else if (objectToBeAdded instanceof ModelClass) {
                DTRIntegrator.checkWritabilityForModelClass((ModelClass)objectToBeAdded);
            } else if (objectToBeAdded instanceof DtSimpleType) {
                DTRIntegrator.checkWritabilityForSimpleTypes((DtSimpleType)objectToBeAdded);
            } else if (objectToBeAdded instanceof DtStructure) {
                DTRIntegrator.checkWritabilityForStructures((DtStructure)objectToBeAdded);
            } else {
                System.out.println("Source object not found" + objectToBeAdded.toString());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

