/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ide.metamodel.importers.rfcmodel;

import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.DevelopmentObject;
import com.sap.ide.metamodel.general.SourcePathIdentifier;
import com.sap.ide.metamodel.importers.ImportLog;
import com.sap.ide.metamodel.webdynpro.WebDynproRoot;
import com.sap.ide.metamodel.webdynpro.enum.CardinalityEnum;
import com.sap.ide.metamodel.webdynpro.framework.ModelType;
import com.sap.ide.metamodel.webdynpro.model.Model;
import com.sap.ide.metamodel.webdynpro.model.ModelClass;
import com.sap.ide.metamodel.webdynpro.model.ModelClassProperty;
import com.sap.ide.metamodel.webdynpro.model.ModelClassSetting;
import com.sap.ide.metamodel.webdynpro.model.ModelRelation;
import com.sap.ide.metamodel.webdynpro.model.ModelRelationRole;
import com.sap.ide.metamodel.webdynpro.model.ModelSetting;
import com.sap.ide.metamodel.webdynpro.type.JavaNativeType;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class RFCModelImporter {
    private static final String DICTIONARY_PACKAGE = "com.sap.dictionary";
    private static final String MODELTYPE_PACKAGE = "com.sap.ide.webdynpro.modeltypes";
    private static final String MODELTYPE_NAME = "RFCAdapter";
    private WebDynproRoot mWebDynpro = null;
    private DtDictionaryRoot mDictionary = null;
    private ModelType mModelType = null;
    private String mLanguage = "";
    private String mModelPackage = "";
    private String mModelName = "";
    private Model mModel = null;
    private HashSet mClasses = new HashSet();
    private HashMap mInputOutput = new HashMap();
    private HashMap mRelations = new HashMap();
    private HashMap mProperties = new HashMap();
    private Class mProxyClass = null;
    private SourcePathIdentifier mSourcePathId = null;
    private ImportLog mLog = new ImportLog();
    static /* synthetic */ Class class$com$sap$aii$proxy$framework$core$AbstractProxy;
    static /* synthetic */ Class class$com$sap$aii$proxy$framework$core$AbstractType;

    public RFCModelImporter(DtDictionaryRoot dictionary, WebDynproRoot webdynpro) throws Exception {
        this(dictionary, webdynpro, "en");
    }

    public RFCModelImporter(DtDictionaryRoot dictionary, WebDynproRoot webdynpro, String language) throws Exception {
        this.mDictionary = dictionary;
        this.mWebDynpro = webdynpro;
        this.mLanguage = language;
        this.mModelType = webdynpro.getModelType(MODELTYPE_PACKAGE, MODELTYPE_NAME);
    }

    private RFCModelImporter() {
    }

    public Model doImport(String modelPackage, String modelName, SourcePathIdentifier sourcePathId, Class proxyClass) {
        this.mLog.clear();
        try {
            this.mModelPackage = modelPackage;
            this.mSourcePathId = sourcePathId;
            if (modelPackage == null) {
                this.mLog.addErrorMessage("\"" + modelPackage + "\" is not a valid model package!");
                return null;
            }
            this.mModelName = modelName;
            if (modelName == null || modelName.length() == 0) {
                this.mLog.addErrorMessage("\"" + modelName + "\" is not a valid model name!");
                return null;
            }
            this.mProxyClass = proxyClass;
            if (proxyClass.getSuperclass() != (class$com$sap$aii$proxy$framework$core$AbstractProxy == null ? (class$com$sap$aii$proxy$framework$core$AbstractProxy = RFCModelImporter.class$("com.sap.aii.proxy.framework.core.AbstractProxy")) : class$com$sap$aii$proxy$framework$core$AbstractProxy)) {
                this.mLog.addErrorMessage(proxyClass + " is not a valid proxy class (subclass of AbstractProxy)!");
                return null;
            }
            Method[] lMethods = proxyClass.getDeclaredMethods();
            int i = 0;
            while (i < lMethods.length) {
                Method lMethod = lMethods[i];
                Class<?> lOutputClass = lMethod.getReturnType();
                Class<?> lInputClass = lMethod.getParameterTypes()[0];
                this.processClass(lOutputClass);
                this.processClass(lInputClass);
                this.mInputOutput.put(lInputClass, lOutputClass);
                ++i;
            }
            return this.renderModel();
        }
        catch (Exception ex) {
            this.mLog.addException(ex);
            return null;
        }
    }

    public ImportLog getImportLog() {
        return this.mLog;
    }

    private void processClass(Class clazz) throws Exception {
        if (this.mClasses.contains(clazz)) {
            return;
        }
        this.mClasses.add(clazz);
        this.mProperties.put(clazz, new Vector());
        this.mRelations.put(clazz, new Vector());
        Method[] lMethods = clazz.getDeclaredMethods();
        int i = 0;
        while (i < lMethods.length) {
            Method lMethod = lMethods[i];
            if (lMethod.getModifiers() == 1 && !lMethod.getName().equals("metadata") && lMethod.getName().startsWith("get") && !lMethod.getName().startsWith("get_as_list")) {
                String lType;
                Class<?> lReturnType = lMethod.getReturnType();
                if (lReturnType.getSuperclass() == (class$com$sap$aii$proxy$framework$core$AbstractType == null ? RFCModelImporter.class$("com.sap.aii.proxy.framework.core.AbstractType") : class$com$sap$aii$proxy$framework$core$AbstractType)) {
                    ((Vector)this.mRelations.get(clazz)).add(new _Relation(lMethod.getName().substring(3), lReturnType, false));
                    this.processClass(lReturnType);
                } else if (lReturnType.isArray()) {
                    if (lReturnType.getComponentType().getSuperclass() == (class$com$sap$aii$proxy$framework$core$AbstractType == null ? RFCModelImporter.class$("com.sap.aii.proxy.framework.core.AbstractType") : class$com$sap$aii$proxy$framework$core$AbstractType)) {
                        ((Vector)this.mRelations.get(clazz)).add(new _Relation(lMethod.getName().substring(3), lReturnType.getComponentType(), true));
                        this.processClass(lReturnType.getComponentType());
                    } else {
                        lType = lReturnType.getComponentType().getName() + "[]";
                        ((Vector)this.mProperties.get(clazz)).add(new _Property(lMethod.getName().substring(3), lType));
                    }
                } else {
                    lType = lReturnType.getName();
                    ((Vector)this.mProperties.get(clazz)).add(new _Property(lMethod.getName().substring(3), lType));
                }
            }
            ++i;
        }
    }

    private Model renderModel() throws Exception {
        if (this.mClasses.isEmpty()) {
            this.mLog.addWarningMessage("the RFC model contains no classes");
            return null;
        }
        int classCount = 0;
        int relationCount = 0;
        this.mModel = this.mWebDynpro.createModel(this.mModelPackage, this.mModelName, this.mSourcePathId);
        this.mModel.setModelType(this.mModelType);
        ModelSetting lModelSetting = this.mModel.createSetting("proxyClassName");
        lModelSetting.setValue(this.mProxyClass.getName());
        lModelSetting.setSettingDefinition(this.mModelType.getModelSettingDefinition("proxyClassName"));
        lModelSetting = this.mModel.createSetting("requiresCodeGeneration");
        lModelSetting.setValue("true");
        lModelSetting.setSettingDefinition(this.mModelType.getModelSettingDefinition("requiresCodeGeneration"));
        Iterator it = this.mClasses.iterator();
        while (it.hasNext()) {
            Class lClass = (Class)it.next();
            ModelClass lModelClass = this.mModel.createModelClass(this.getModelClassName(lClass), this.mSourcePathId);
            lModelClass.setIsRootObject(true);
            ModelClassSetting lModelClassSetting = lModelClass.createSetting("proxyClassName");
            lModelClassSetting.setValue(lClass.getName());
            lModelClassSetting.setSettingDefinition(this.mModelType.getModelClassSettingDefinition("proxyClassName"));
            ++classCount;
        }
        Iterator it2 = this.mClasses.iterator();
        while (it2.hasNext()) {
            Class lClass = (Class)it2.next();
            ModelClass lModelClass = this.mModel.getModelClass(this.getModelClassName(lClass));
            this.mLog.addInfoMessage("adding class \"" + lModelClass.getName() + "\"");
            Vector lVector = (Vector)this.mProperties.get(lClass);
            if (lVector == null) continue;
            int i = 0;
            while (i < lVector.size()) {
                _Property lProperty = (_Property)lVector.get(i);
                ModelClassProperty lProp = lModelClass.createProperty(lProperty.mName);
                DevelopmentObject lType = this.builtInType(lProperty.mType);
                if (lType != null) {
                    lProp.setType(lType);
                } else if (lProperty.mType.indexOf(46) != -1) {
                    String lName = lProperty.mType.substring(lProperty.mType.lastIndexOf(46) + 1);
                    String lPackage = lProperty.mType.substring(0, lProperty.mType.lastIndexOf(46));
                    JavaNativeType lNativeType = lProp.createNativeTypeAsJavaNativeType(lName);
                    lNativeType.setJavaPackage(lPackage);
                    lProp.setType((DevelopmentObject)lNativeType);
                } else {
                    lProp.setType((DevelopmentObject)lProp.createNativeTypeAsJavaNativeType(lProperty.mType));
                }
                this.mLog.addInfoMessage("  adding property \"" + lProperty.mName + "\", type: " + (lProp.getType() != null ? lProp.getType().getName() : "<not set>"));
                ++i;
            }
        }
        Iterator it3 = this.mClasses.iterator();
        while (it3.hasNext()) {
            Class lOutputClass;
            Class lClass = (Class)it3.next();
            ModelClass lModelClass = this.mModel.getModelClass(this.getModelClassName(lClass));
            Vector lVector = (Vector)this.mRelations.get(lClass);
            if (lVector != null) {
                int i = 0;
                while (i < lVector.size()) {
                    _Relation lRelation = (_Relation)lVector.get(i);
                    String lRelationName = this.getModelClassName(lClass) + ":" + lRelation.mRoleName;
                    ModelRelation lModelRelation = this.mModel.createModelRelation(lRelationName);
                    ModelRelationRole lRoleA = lModelRelation.createModelRelationRole("Source");
                    lRoleA.setNavigable(false);
                    lRoleA.setModelClass(lModelClass);
                    ModelRelationRole lRoleB = lModelRelation.createModelRelationRole(lRelation.mRoleName);
                    lRoleB.setModelClass(this.mModel.getModelClass(this.getModelClassName(lRelation.mTo)));
                    if (lRelation.mMultiple) {
                        lRoleB.setCardinality(CardinalityEnum._0_N);
                    }
                    this.mLog.addInfoMessage("adding relation \"" + lModelRelation.getName() + "\" between classes \"" + lRoleA.getModelClass().getName() + "\" and \"" + lRoleB.getModelClass().getName() + "\":\n" + "            role \"" + lRoleA.getName() + "\": modelclass=" + lRoleA.getModelClass().getName() + ", aggregate=" + lRoleA.getAggregate() + ", cardinality=" + lRoleA.getCardinality() + ", navigable=" + lRoleA.getNavigable() + "\n" + "            role \"" + lRoleB.getName() + "\": modelclass=" + lRoleB.getModelClass().getName() + ", aggregate=" + lRoleB.getAggregate() + ", cardinality=" + lRoleB.getCardinality() + ", navigable=" + lRoleB.getNavigable());
                    ++relationCount;
                    ++i;
                }
            }
            if ((lOutputClass = (Class)this.mInputOutput.get(lClass)) == null) continue;
            ModelClass lInputClass = this.mModel.getModelClass(this.getModelClassName(lClass));
            ModelClassSetting lModelClassSetting = lInputClass.createSetting("isExecutable");
            lModelClassSetting.setValue("true");
            lModelClassSetting.setSettingDefinition(this.mModelType.getModelClassSettingDefinition("isExecutable"));
            String lRelationName = this.getModelClassName(lClass) + ":Output:" + this.getModelClassName(lOutputClass);
            ModelRelation lRelation = this.mModel.createModelRelation(lRelationName);
            ModelRelationRole lRoleA = lRelation.createModelRelationRole("Source");
            lRoleA.setNavigable(false);
            lRoleA.setModelClass(lInputClass);
            ModelRelationRole lRoleB = lRelation.createModelRelationRole("Output");
            lRoleB.setCardinality(CardinalityEnum._0_1);
            lRoleB.setModelClass(this.mModel.getModelClass(this.getModelClassName(lOutputClass)));
            this.mLog.addInfoMessage("adding relation \"" + lRelation.getName() + "\" between classes \"" + lRoleA.getModelClass().getName() + "\" and \"" + lRoleB.getModelClass().getName() + "\":\n" + "            role \"" + lRoleA.getName() + "\": modelclass=" + lRoleA.getModelClass().getName() + ", aggregate=" + lRoleA.getAggregate() + ", cardinality=" + lRoleA.getCardinality() + ", navigable=" + lRoleA.getNavigable() + "\n" + "            role \"" + lRoleB.getName() + "\": modelclass=" + lRoleB.getModelClass().getName() + ", aggregate=" + lRoleB.getAggregate() + ", cardinality=" + lRoleB.getCardinality() + ", navigable=" + lRoleB.getNavigable());
            ++relationCount;
        }
        this.mLog.addInfoMessage("Summary: " + classCount + " class(es) and " + relationCount + " relation(s) were added");
        this.mModel.validate();
        return this.mModel;
    }

    private String getModelClassName(Class clazz) {
        String lClassName = clazz.getName();
        lClassName = lClassName.substring(lClassName.lastIndexOf(46) + 1);
        if (clazz.getSuperclass() == (class$com$sap$aii$proxy$framework$core$AbstractType == null ? (class$com$sap$aii$proxy$framework$core$AbstractType = RFCModelImporter.class$("com.sap.aii.proxy.framework.core.AbstractType")) : class$com$sap$aii$proxy$framework$core$AbstractType) && !clazz.getName().endsWith("_Input") && !clazz.getName().endsWith("_Output")) {
            return lClassName.substring(0, lClassName.length() - 4);
        }
        return lClassName;
    }

    private DevelopmentObject builtInType(String typeName) throws Exception {
        if (typeName.equals("String") || typeName.equals("java.lang.String")) {
            typeName = "string";
        } else if (typeName.equals("Date") || typeName.equals("java.sql.Date")) {
            typeName = "date";
        } else if (typeName.equals("double")) {
            typeName = "double";
        } else if (typeName.equals("Double") || typeName.equals("java.lang.Double")) {
            typeName = "doubleObject";
        } else if (typeName.equals("boolean")) {
            typeName = "boolean";
        } else if (typeName.equals("Boolean") || typeName.equals("java.lang.Boolean")) {
            typeName = "booleanObject";
        } else if (typeName.equals("Time") || typeName.equals("java.sql.Time")) {
            typeName = "time";
        } else if (typeName.equals("Timestamp") || typeName.equals("java.sql.Timestamp")) {
            typeName = "timestamp";
        } else if (typeName.equals("short")) {
            typeName = "short";
        } else if (typeName.equals("Short") || typeName.equals("java.lang.Short")) {
            typeName = "shortObject";
        } else if (typeName.equals("long")) {
            typeName = "long";
        } else if (typeName.equals("Long") || typeName.equals("java.lang.Long")) {
            typeName = "longObject";
        } else if (typeName.equals("float")) {
            typeName = "float";
        } else if (typeName.equals("Float") || typeName.equals("java.lang.Float")) {
            typeName = "floatObject";
        } else if (typeName.equals("int")) {
            typeName = "integer";
        } else if (typeName.equals("Integer") || typeName.equals("java.lang.Integer")) {
            typeName = "integerObject";
        } else if (typeName.equals("BigDecimal") || typeName.equals("java.math.BigDecimal")) {
            typeName = "decimal";
        } else if (typeName.equals("byte[]")) {
            typeName = "binary";
        }
        return this.mDictionary.getSimpleType(DICTIONARY_PACKAGE, typeName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class _Relation {
        public String mRoleName = "";
        public Class mTo;
        public boolean mMultiple = false;

        _Relation(String roleName, Class to, boolean multiple) {
            this.mRoleName = roleName;
            this.mTo = to;
            this.mMultiple = multiple;
        }
    }

    private class _Property {
        public String mName;
        public String mType;
        public boolean mIsArray;

        _Property(String name, String type) {
            this.mName = name;
            this.mType = type;
        }
    }
}

